<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotFuncionarioBeneficio as RepoOrcLotFuncionarioBeneficio;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Excel;

class OrcLotFuncionarioBeneficioController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcLotFuncionarioBeneficio());
        $this->setCodTela('OBLF');
        parent::__construct();
    }

    public function inserirr(Request $request, $id) {

        $this->podeAcessar('inserir',true,$this->getCodTela());
        
        $form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$id);
        //dd($form_data);
        // if($form_data['tipo_meses']==0){
        //     $retorno['status']='warning';
        //     $retorno['submsg']='Selecione um Tipo.';
        //     $retorno['msg']='Atenção';
        //     goto saida;
        // }
        // if(!mesesValidacao(convertDecimalEn($form_data['meses_orcado']))){
        //     $retorno['status']='error';
        //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
        //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 200320201458';
        //     goto saida;
        // }
        
        if(! $this->getRepositoryOrModel()->createOrcLotFuncionarioBeneficio($form_data)){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);        
    }    

    public function list($orcamento_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(700);
        $this->podeAcessar('listar',true,$this->getCodTela());

        $form_data = [
            'orcamento_id'=> $orcamento_id
        ];

        $dados = $this->getRepositoryOrModel()->listar($form_data, $periodo, $tipo_table);
        //dd("nckjdcksjdncksjdn",$dados);
        return $this->renderTreeTableList($dados);
    } 

    public function listarIndices($orc_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(700);
        $this->podeAcessar('listar',true,$this->getCodTela());

        $dados = $this->getRepositoryOrModel()->listarIndice($orc_id, $periodo, $tipo_table);
        return $this->treeTableIndice($dados);
    }

    public function listEvent(){

        $this->podeAcessar('listar',true,$this->getCodTela());

        return $this->getRepositoryOrModel()->listaEventos();
    }
    
    public function deletar(Request $request, $id) {
        
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $form_data=$request->all();
        if($form_data['identificador']==1){
            if(! $this->getRepositoryOrModel()->deleteIndice($form_data)){
                $retorno['status']='error';
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:060420201053';
                goto saida;
            }
        }
        else{
            if(! $this->getRepositoryOrModel()->deleteOrcLotFuncionarioBeneficio($form_data)){
                $retorno['status']='error';
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:141220191400';
                goto saida;
            }
        }
        
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }

    public function updateOrcLotFuncionarioBenef(Request $request, $id) {
        
        $this->podeAcessar('editar',true,$this->getCodTela());

        $form_data=$request->all();
        
        /*$meses=Arr::only($form_data,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);*/

        // $meses_indice = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);

        if($form_data['identificador'] == 1){
            // if(!validacaoIndice(convertDecimalEn($meses_indice))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os índices inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os índices inseridos não podem diminuir ao longo dos meses. Erro: 060420201221';
            //     goto saida;
            // }
            // else{
                if(!$this->getRepositoryOrModel()->updateIndice($form_data)){
                    $retorno['status']='error';
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao deletar o registro. Erro:060420201047';
                    goto saida;
                }
            // }
        }
        else{
            // if(!mesesValidacao(convertDecimalEn($meses))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 230320201010';
            //     goto saida;
            // }
            // else{
                if(! $this->getRepositoryOrModel()->updateOrcLotFuncionarioBeneficio($form_data)){
                    $retorno['status']='error';
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao deletar o registro. Erro:161220191635';
                    goto saida;
                }
            // }
        }
        
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }


    function renderTreeTableList($dados){
        
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],//
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],//
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"],
            ["field_out"=>"description", "from"=>"description"],
            ["field_out"=>"description_lotacao", "from"=>"description"],
            ["field_out"=>"funcionario_id", "from"=>"funcionario_id"],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id"], 
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id"], 
            ["field_out"=>"orc_beneficio_id", "from"=>"orc_beneficio_id"], 
            ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
            ["field_out"=>"vlr_movto", "from"=>"vlr_movto","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
            ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
            ["field_out"=>"empresa_id", "from"=>"empresa_id"], 
            ["field_out"=>"formula", "from"=>"formula"], 
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"], 
            ["field_out"=>"calc_id", "from"=>"calc_id"],

            ["field_out"=>"event_id", "from"=>"evento_id"], 
            ["field_out"=>"cdn_event", "from"=>"cdn_event"], 
            ["field_out"=>"des_event", "from"=>"des_event"], 
            ["field_out"=>"cdn_funcionario", "from"=>"cdn_funcionario"], 
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario"], 
            ["field_out"=>"num_reg_func", "from"=>"num_reg_func"], 
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"], 
            ["field_out"=>"des_ccusto", "from"=>"des_ccusto"], 
            ["field_out"=>"identificador", "from"=>"identificador"],
            ["field_out"=>"description_func", "from"=>"description_func"],
            ["field_out"=>"description_ben", "from"=>"description_ben"],

            ["field_out"=>"cod_cta_ctbl", "from"=>"cod_cta_ctbl"],
            ["field_out"=>"desc_cta_ctbl", "from"=>"desc_cta_ctbl"],
            ["field_out"=>"description_cta_ctb", "from"=>"description_cta_ctb"],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"criado_em", "from"=>"criado_em"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],

            ["field_out"=>"des_tipo_calc", "from"=>"des_tipo_calc"],
            ["field_out"=>"vlr_maximo", "from"=>"vlr_maximo","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],

           ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],
           ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],
           ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }], 
           ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
           ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
           ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
           ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }
    function treeTableIndice($dados){
        
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"],
            ["field_out"=>"description", "from"=>"description"],
            ["field_out"=>"description_lotacao", "from"=>"description"],
            ["field_out"=>"funcionario_id", "from"=>"funcionario_id"],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id"], 
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id"], 
            ["field_out"=>"orc_beneficio_id", "from"=>"orc_beneficio_id"], 
            ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
            ["field_out"=>"vlr_movto", "from"=>"vlr_movto","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
            ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
            ["field_out"=>"empresa_id", "from"=>"empresa_id"], 
            ["field_out"=>"formula", "from"=>"formula"], 
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"],
            ["field_out"=>"description_func", "from"=>"description_func"],
            ["field_out"=>"description_ben", "from"=>"description_ben"],
            ["field_out"=>"event_id", "from"=>"evento_id"], 
            ["field_out"=>"cdn_event", "from"=>"cdn_event"], 
            ["field_out"=>"des_event", "from"=>"des_event"], 
            ["field_out"=>"cdn_funcionario", "from"=>"cdn_funcionario"], 
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario"], 
            ["field_out"=>"num_reg_func", "from"=>"num_reg_func"], 
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"], 
            ["field_out"=>"des_ccusto", "from"=>"des_ccusto"], 
            ["field_out"=>"identificador", "from"=>"identificador"],
            ["field_out"=>"calc_ind_id", "from"=>"calc_ind_id"],

            ["field_out"=>"cod_cta_ctbl", "from"=>"cod_cta_ctbl"],
            ["field_out"=>"desc_cta_ctbl", "from"=>"desc_cta_ctbl"],
            ["field_out"=>"description_cta_ctb", "from"=>"description_cta_ctb"],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"criado_em", "from"=>"criado_em"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],

            ["field_out"=>"des_tipo_calc", "from"=>"des_tipo_calc"],
            ["field_out"=>"vlr_maximo", "from"=>"vlr_maximo","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
            
            ["field_out"=>"jan_indice", "from"=>"jan_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
               ["field_out"=>"fev_indice", "from"=>"fev_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
               ["field_out"=>"marc_indice", "from"=>"marc_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"abril_indice", "from"=>"abril_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
               ["field_out"=>"maio_indice", "from"=>"maio_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"jun_indice", "from"=>"jun_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"jul_indice", "from"=>"jul_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"agost_indice", "from"=>"agost_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"set_indice", "from"=>"set_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
               ["field_out"=>"out_indice", "from"=>"out_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
               ["field_out"=>"nov_indice", "from"=>"nov_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
               ["field_out"=>"dez_indice", "from"=>"dez_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }

    public function downloadExcelSalarioFuncionarioAbsoluto($type, $orc_id, $fieldsDeleteModel = []){
        $form_data = [
            'orcamento_id'=> $orc_id
        ];
        $this->dados = $this->getRepositoryOrModel()->listar($form_data);
        return parent::downloadExcel($type, 'BeneficioFuncionarioAbsoluto', ['des_unid_lotac','unid_lotac','calc_id','orc_lotacao_id','orc_beneficio_id','event_id','cdn_funcionario','desc_cta_ctbl','cdn_event','num_reg_func','cod_cta_ctbl','nome_funcionario','tbl_origem','cod_ccusto','des_ccusto','orc_sal_func_id','calc_orcamento_id','ccusto_id','cargo_id', 'cargo_id','identificador','salario','funcionario_id', 'orc_cargo_id', 'orc_id','exclusivo_admissao','origem_beneficio','orcamento_id','beneficio_id','evento_id','cta_ctb_id','tipo_calc','vlr_depend','des_event','formula','origem_id']);
    }
    public function downloadExcelSalarioFuncionarioIndice($type, $orc_id, $fieldsDeleteModel = []){
        $this->dados = $this->getRepositoryOrModel()->listarIndice($orc_id);
        return parent::downloadExcel($type, 'BeneficioFuncionarioIndice', ['unid_lotac','orc_lotacao_id','orc_beneficio_id','event_id','cdn_event','cdn_funcionario','num_reg_func','calc_ind_id','cod_cta_ctbl','desc_cta_ctbl','des_unid_lotac','nome_funcionario','calc_indice_id','tbl_origem','cod_ccusto','des_ccusto','orc_sal_func_id','calc_orcamento_id','ccusto_id','cargo_id', 'cargo_id','identificador','salario','funcionario_id', 'orc_cargo_id', 'orc_id','exclusivo_admissao','origem_beneficio','orcamento_id','beneficio_id','evento_id','cta_ctb_id','tipo_calc','vlr_depend','des_event','formula','origem_id']);
    }

    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            // dd(json_decode($_POST['array_imprimir']));
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("description cta ctb", "Conta contábil", $colunas[$i]);
            //$colunas[$i] = str_replace("description", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("nome funcionario", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("cdn funcionario", "Cód. funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("des cargo basic", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("cod cargo basic", "Cód. Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("salario corte", "Salário de corte", $colunas[$i]);
            $colunas[$i] = str_replace("vlr maximo", "Valor máximo", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo calc", "Tipo de cálculo", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo acesso", "Tipo acesso", $colunas[$i]); 
            $colunas[$i] = str_replace("des exclusivo admissao", "Exclusivo admissão", $colunas[$i]);
            $colunas[$i] = str_replace("vlr movto", "Valor movimento", $colunas[$i]);
            $colunas[$i] = str_replace("des origem beneficio", "Origem do beneficio", $colunas[$i]);
            $colunas[$i] = str_replace("description func", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("description lotacao", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("description ben", "Benefício", $colunas[$i]);

            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);

            $colunas[$i] = str_replace("jan indice", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev indice", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("marc indice", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abril indice", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("maio indice", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun indice", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul indice", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("agost indice", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set indice", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out indice", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov indice", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez indice", "Dezembro", $colunas[$i]);
            $colunas[$i] = str_replace("description", "Lotação", $colunas[$i]);

        }
        return $colunas;
    }
}