<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotacaoCargoSal as RepoOrcLotacaoCargoSal;
use Illuminate\Http\Request;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr; 

class OrcLotacaoCargoSalController extends OrcamentoController
{
     
    public function __construct(){
        $this->setRepository(new RepoOrcLotacaoCargoSal());
        $this->setCodTela('OSLC');
        parent::__construct();
    }
    public function listarAll($orc_id, $lotac_id = null){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $result = $this->getRepository()->listAll($orc_id, $lotac_id);
       
        if($result === false){
            $retorno = $this->getArrayRetornoDefault();
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao listar o registro. Erro: 051220191552.';
            
            return $this->retornoJsonDefault($retorno);
        }
        $dados = $result->toArray();
        // for($i = 0; $i < count($dados); $i++){
        //     $dados[$i]['atualizado_data'] = formataData($dados[$i]['updated_at']);
        //     $dados[$i]['criado_data'] = formataData($dados[$i]['created_at']);
        // }
        
        return new \Illuminate\Http\Response(json_encode($this->renderTreeTableList($dados)));        
    }

    public function listarAllForecast($orc_id, $periodo = null, $tipo_table = 'F', $lotac_id = null){
        $this->podeAcessar('listar', true, $this->getCodTela());
        $result = $this->getRepository()->listAll($orc_id, $lotac_id, $periodo, $tipo_table);
       
        if($result === false){
            $retorno = $this->getArrayRetornoDefault();
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao listar o registro. Erro: 171220201609.';
            
            return $this->retornoJsonDefault($retorno);
        }
        $dados = $result->toArray();
        
        return new \Illuminate\Http\Response(json_encode($this->renderTreeTableList($dados)));        
    }

    public function listarIndice($orc_id){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $dados = $this->getRepository()->indiceListar($orc_id);
        
        return new \Illuminate\Http\Response(json_encode($this->treeTableIndice($dados)));
    }
    public function inserirCargo(\Illuminate\Http\Request $request, $orc_id) {
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $form_data = $this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$orc_id);
		
        $form_data['ccusto_id'] = $form_data['centro_custo_id'];
        //$retorno=$this->getArrayRetornoDefault();
        if($form_data['tipo_meses'] == 0){
            $retorno['status']='warning';
            $retorno['submsg']='Selecione um Tipo.';
            $retorno['msg']='Atenção';
            goto saida;
        }
        if(!mesesValidacao(($form_data['meses_orcado']))){
            $retorno['status']='error';
            $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses.';
            $retorno['msg']='Erro!';
            goto saida;
        } 
        

        if(!$this->getRepositoryOrModel()->createOrcLotCargo($form_data, $this->fillCodEmpresa())){
            $retorno['status']='error';
            $retorno['submsg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['msg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["submsg"]="Sucesso";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
        
    }
    public function editar(\Illuminate\Http\Request $request, $orc_id){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $id = $request->all()['origem_id'];
        $form_data = Arr::except($request->all(),['origem_id','_token']);
        
        $meses=Arr::only($form_data,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
        
        //$meses_indice = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);

        if($form_data['identificador']==1){
            // if(!validacaoIndice(convertDecimalEn($meses_indice))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os índices inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os índices inseridos não podem diminuir ao longo dos meses. Erro: 060420201229';
            //     goto saida;
            // }
            // else{
                if(!$this->getRepository()->updateOrcIndice($form_data,$id)){
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg'] = 'Falha ao atualizar o registro. Erro:030420201029';
                    goto saida;
                }
            // }
        }
        else{
            if(!mesesValidacao(convertDecimalEn($meses))){
                $retorno['status']='error';
                $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
                $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 230320201156';
                goto saida;
            }else{
                if(!$this->getRepository()->updateOrc($form_data,$id)){
                    $retorno['status']='error';
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizar o registro. Erro:301120191630';
                    goto saida;
                }
            }
        }
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    } 

    public function deletar(\Illuminate\Http\Request $request, $orc_id){
        $this->podeAcessar('deletar',true,$this->getCodTela());
        // dd("delete", $orc_id);
        $id = $request->all()['origem_id'];
        $form_data = Arr::except($request->all(),['origem_id','_token']);
        if($form_data['identificador']==1){
            if(!$this->getRepository()->deleteOrcIndice($form_data,$id)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:030420201042';
                goto saida;
            }
        }
        else{
            if(!$this->getRepository()->deleteOrc($form_data,$id)){
                $retorno['status']='error';
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:301120191630';
                goto saida;
            }
        }
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    

    function renderTreeTableList($dados){
        
         $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"origem_id", "from"=>"origem_id"],
            ["field_out"=>"cargo_id", "from"=>"cargo_id"],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"sal_base", "from"=>"sal_med", "render_value"=>function($row_data, $value){
                return number_format($value,4,',','.');
            },],
            ["field_out"=>"sal_max", "from"=>"sal_max", "render_value"=>function($row_data, $value){
                return number_format($value,4,',','.');
            },],
            ["field_out"=>"sal_med", "from"=>"sal_med", "render_value"=>function($row_data, $value){
                return number_format($value,4,',','.');
            }],
            ["field_out"=>"sal_min", "from"=>"sal_min", function($row_data, $value){
                return number_format($value,4,',', '.');
            } ],
            ["field_out"=>"sal_menor", "from"=>"sal_menor","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            } ],
            ["field_out"=>"sal_maior", "from"=>"sal_maior","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            } ],
            ["field_out"=>"data_calc", "from"=>"data_calc",],     
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac",],     
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic",],   
            ["field_out"=>"cargo_description", "from"=>"cargo_description",],     
            ["field_out"=>"lotac_description", "from"=>"lotac_description",],   
            ["field_out"=>"identificador", "from"=>"identificador",],

            ["field_out"=>"criado_por", "from"=>"criado_por",],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por",],

            ["field_out"=>"atualizado_data", "from"=>"atualizado_data",],
            ["field_out"=>"criado_data", "from"=>"criado_data",],

            ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],     
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }], 
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],     
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],     
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],     
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],     
            ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],    
            ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],    
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],    
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }]  ,
            ["field_out"=>"insalubridade", "from"=>"insalubridade","render_value"=>function($row_data, $value){
                return $value;
            }],  
            ["field_out"=>"periculosidade", "from"=>"periculosidade","render_value"=>function($row_data, $value){
                return $value;
            }]
        ];
         
         
        $settings=["columns"=>$columns_base,
                "keys"=>['id' ] 
            ];    
            
        $controller=new AtmTreeTable($settings, $dados);
        
      return $controller->render();
    }

    function treeTableIndice($dados){

        $columns_base=[ 
           ["field_out"=>"id", "from"=>"id"],
           ["field_out"=>"origem_id", "from"=>"origem_id"],
           ["field_out"=>"calc_id", "from"=>"calc_id"],
           ["field_out"=>"cargo_id", "from"=>"cargo_id"],
           ["field_out"=>"lotacao_id", "from"=>"lotacao_id"],
           ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
           ["field_out"=>"sal_base", "from"=>"sal_base", "render_value"=>function($row_data, $value){
               return number_format($value,2,',','.');
           },],
           ["field_out"=>"sal_max", "from"=>"sal_max", "render_value"=>null,],
           ["field_out"=>"sal_med", "from"=>"sal_med"],
           ["field_out"=>"sal_min", "from"=>"sal_min" ],
           ["field_out"=>"sal_menor", "from"=>"sal_menor" ],
           ["field_out"=>"sal_maior", "from"=>"sal_maior" ],
           ["field_out"=>"data_calc", "from"=>"data_calc",],     
           ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac",],     
           ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic",],     
           ["field_out"=>"identificador", "from"=>"identificador",],  

           ["field_out"=>"jan_indice", "from"=>"jan_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],
           ["field_out"=>"fev_indice", "from"=>"fev_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],
           ["field_out"=>"marc_indice", "from"=>"marc_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"abril_indice", "from"=>"abril_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }], 
           ["field_out"=>"maio_indice", "from"=>"maio_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"jun_indice", "from"=>"jun_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"jul_indice", "from"=>"jul_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"agost_indice", "from"=>"agost_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"set_indice", "from"=>"set_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"out_indice", "from"=>"out_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"nov_indice", "from"=>"nov_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"dez_indice", "from"=>"dez_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id' ] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
   }
    public function populaLotCargo(Request $request){
        // $this->podeAcessar('atualizar',true,$this->getCodTela());
        
        $dados = $request->all();
        
        $orc_id = $dados['orc_id'];
        if($dados['tipo'] == 0){
            $ret = $this->getRepositoryOrModel()->atualizaLotCargo($orc_id, $dados['periodo'], $dados['tipo_table']);
            if($ret === false){
                $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Erro';
                goto saida;
            }
            if($ret === 'warning'){
                $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'warning';
                $retorno['msg'] = 'Atenção';
                goto saida;
            }
        }
        else if($dados['tipo'] == 2){
            if(! $this->getRepositoryOrModel()->atualizaSalario($orc_id, $dados['periodo'], $dados['tipo_table'])){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro:011220191559';
                goto saida;
            }
        }
        else{
            if(! $this->getRepositoryOrModel()->populaLotCargo($orc_id, $dados['periodo'], $dados['tipo_table'])){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro:301120191630';
                goto saida;
            }
        }
        
        $retorno["status"] = "success";
        $retorno["msg"] = "Sucesso";
        $retorno["submsg"] = "Atualização realizada com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
       
    } 

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
       

        return parent::downloadExcel($type, 'SalarioLotacaoCargo',['des_unid_lotac','des_cargo_basic','sal_min','id_calc','origem_id', 'cargo_id', 'lotacao_id', 'orcamento_id', 'sal_med', 'sal_maior','data_calc', 'identificador']);
    
    }
  

    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
    //         dd(json_decode($_POST['array_imprimir']));
     


            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cargo description", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("lotac description", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("sal base", "Salário médio", $colunas[$i]);
            $colunas[$i] = str_replace("sal menor", "Salário ini.", $colunas[$i]);
            $colunas[$i] = str_replace("sal max", "Salário fim", $colunas[$i]);

            $colunas[$i] = str_replace("insalubridade", "Insalubridade", $colunas[$i]);
            $colunas[$i] = str_replace("periculosidade", "Periculosidade", $colunas[$i]);

            $colunas[$i] = str_replace("criado por", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("criado data", "Data criação", $colunas[$i]);
            $colunas[$i] = str_replace("atualizado por", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("atualizado data", "Data atualização", $colunas[$i]);

            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);

        }
        return $colunas;
    }
    public function deleteAll($orc_id, $periodo = null, $tipo_table = 'O'){
        $resp = $this->getRepository()->deleteAll($orc_id, $periodo, $tipo_table);
        if($resp === false){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        
        if($resp === 'warning'){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'warning';
            $retorno['submsg'] = 'Atenção';
            goto saida;
        }

        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Registros deletados com successo!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
}
 