<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotacao as RepoOrcLotacao;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacaoNaturezaEvento;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Facades\DB;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
// use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use App\Modules\Natureza51\Repositories\RepoOrcLotacaoCargoSal;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use App\Modules\Natureza51\Repositories\RepoFuncionario;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Repositories\RepoNotify;
use Carbon\Carbon;
use App\Jobs\CalculateLotacao;

class OrcLotacaoController extends OrcamentoController
{
    private $lotacoes=null;
    private $orc_id;
    private $calc_in_background = true;

    public function __construct(){
        $token = null;

        if($this->getUserFromCurrentGuard()){
            $token = $this->getUserFromCurrentGuard()->api_token;
            $decrypted = json_decode(safeDecrypt($token));
            $id = $decrypted->id;
            $this->setRepository(new RepoOrcLotacao(strval($id)));
        }
        else{
            $token = request()->bearerToken();
            $decrypted = json_decode(safeDecrypt($token));
            $this->setRepository(new RepoOrcLotacao($decrypted->token->id));
        }

        $this->setCodTela('LT');
        parent::__construct();


    }

    public function listarLot($orc_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(240);
        $this->repopulateOrcLotacao($orc_id, $periodo, $tipo_table);
        $this->repopulateOrcPPR($orc_id, $periodo, $tipo_table);
        $this->repopulateOrcBonus($orc_id, $periodo, $tipo_table);
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepositoryOrModel()->listar($orc_id, $periodo, $tipo_table);
    }

    public function listarLotAll($orc_id, $tipo_table = 'O', $periodo = null){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepositoryOrModel()->listar($orc_id, $periodo, $tipo_table, true);
    }

    public function listarDesciption($orc_id){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepositoryOrModel()->listarDescription($orc_id);
    }
    public function listarLotAtiva($orc_id, $periodo = null, $tipo_table = 'O'){
        return $this->getRepositoryOrModel()->listarLotAtiva($orc_id, $periodo, $tipo_table);
    }

    /**
     * Enviar para o Gerente aprovar
     */
    public function sendManager($orc_id, $orc_lotacao_id, $tipo_table, Request $request){

        if( $this->isSuspenso($orc_id) == true ){
            $retorno['submsg'] = $this->getRepository()->getErrosFlatted();
            $retorno['msg'] = 'Orçamento Suspenso. Erro: 151020201709';
            $retorno['status'] = 'error';
            goto saida;
        }
        set_time_limit(60);
        $retorno=$this->getArrayRetornoDefault();


        if(!$this->getRepository()->sendManager($request->all(), null, null, $tipo_table)){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Operação indisponível. Tente novamente mais tarde.<br/> Erro: 210920201835.';
            goto saida;
        }
        if(!$this->getParamValue($this->getCodPassaRH())){
            if($this->calc_in_background){

                $user = $this->getUserFromCurrentGuard();

                if($user){
                    $myJob = new CalculateLotacao($orc_id, $user->id, $user->id_empresa, $orc_lotacao_id, $tipo_table);
                    dispatch($myJob);
                }
            }
            else{
                $this->getRepository()->calculate($orc_lotacao_id, false, [], $tipo_table);
            }
        }

        $retorno['msg']='Headcount enviado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';

        saida:
         return $this->retornoJsonDefault($retorno);
    }

    public function sendManagerForecast($orc_id, $orc_lotacao_id, $tipo_table,Request $request){

        $periodo = "";
        if(array_key_exists('periodo_', $request->all())){
            $periodo = $request->all()['periodo_'];
        }
        else{
            $periodo = $request->all()['periodo'];
        }
        if( $this->isSuspenso($orc_id) == true ){
            $retorno['submsg'] = $this->getRepository()->getErrosFlatted();
            $retorno['msg'] = 'Orçamento Suspenso. Erro: 151020201709';
            $retorno['status'] = 'error';
            goto saida;
        }
        set_time_limit(60);
        $retorno=$this->getArrayRetornoDefault();
        $periodo = array_key_exists('periodo_', $request->all()) ? $request->all()['periodo_'] : $request->all()['periodo'];

        if(!$this->getRepository()->sendManagerForecast($request->all(), null, null, $tipo_table)){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Operação indisponível. Tente novamente mais tarde.<br/> Erro: 210920201835.';
            goto saida;
        }

        //atualiza na orc_movto
        $select = DB::select("SELECT * FROM tbl_orc_movto_status_ccusto where orc_lotacao_id = $orc_lotacao_id and tipo_table = 'F' and periodo = '$periodo'");
        if(count($select) > 0){
            DB::update("UPDATE tbl_orc_movto_status_ccusto set status_atual = 11, status_anterior = {$select[0]->status_atual} where orc_lotacao_id = $orc_lotacao_id and tipo_table = 'F' and periodo = '$periodo'");
        }
        

        $aprovacao_pendente = DB::select("select top 1 * from tbl_notificacao where orc_lotacao_id = $orc_lotacao_id and periodo = '$periodo' order by id desc");


        if(!$this->getParamValue($this->getCodPassaRHForecast()) && (count($aprovacao_pendente) == 0 || (count($aprovacao_pendente) > 0 && $aprovacao_pendente[0]->situacao == 5) )){
            if($this->calc_in_background){

                $user = $this->getUserFromCurrentGuard();

                if($user){
                    $myJob = new CalculateLotacao($orc_id, $user->id, $user->id_empresa, $orc_lotacao_id, $tipo_table, '$periodo');
                    dispatch($myJob);
                }
            }
            else{
                $this->getRepository()->calculate($orc_lotacao_id, false, [], $tipo_table, null, '$periodo');
            }
        }

        $retorno['msg']='Forecast enviado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    /*public function sendManagerAll($orc_id, $tipo_table, Request $request){
        $data = array("lotacao_id"=>123);

        if( $this->isSuspenso($orc_id) == true ){
            $retorno['submsg'] = $this->getRepository()->getErrosFlatted();
            $retorno['msg'] = 'Orçamento Suspenso. Erro: 151020201709';
            $retorno['status'] = 'error';
            goto saida;
        }
        set_time_limit(60);
        $retorno=$this->getArrayRetornoDefault();

        if(!$this->getRepository()->sendManager($request->all(), null, null, $tipo_table)){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Operação indisponível. Tente novamente mais tarde.<br/> Erro: 210920201835.';
            goto saida;
        }
            $retorno['msg']='Headcount enviado com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';

        saida:
         return $this->retornoJsonDefault($retorno);
    }*/

    /**
     * Enviar para o RH aprovar
     */
    public function sendRh($orc_id,Request $request){
        set_time_limit(60);
        $retorno=$this->getArrayRetornoDefault();

        if(!$this->getRepository()->sendRh($request->all()[0])){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao calcular a lotação. Erro: 290620201351';
            goto saida;
        }
            $retorno['msg']='Headcount enviado com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';

        saida:
         return $this->retornoJsonDefault($retorno);


    }


    /**
     * Reabrir lotação
     * 29/06
     */
    public function reopen($orc_id, $lotacao_id, $tipo_table, Request $request){

        $data_request = $request->all();
        $periodo = array_key_exists('periodo', $data_request) ? $data_request['periodo'] : null;
        $tipo_aprovacao = $data_request['tipo_aprovacao'];

        $a = $this->getRepository()->reopen($lotacao_id, $data_request, $tipo_table, null, $periodo, $tipo_aprovacao);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }

    public function reopenAllHeadcountHome($orc_id, $tipo_table, Request $request){
        $data_request = $request->all();
        unset($data_request['_token']);

        $tipo_aprovacao = $data_request['tipo_aprovacao'];
        if(array_key_exists('lotacoes', $data_request) == false){
            $cont = 0;
            $msg = '';
            for($i = 0; $i < count($data_request); $i = $i+2){
                $periodo = array_key_exists('periodo', $data_request) ? $data_request['periodo'] : null;

                $a = $this->getRepository()->reopen($data_request[$i], array('justificativa'=>array_key_exists('justificativa', $data_request) == true ? $data_request['justificativa'] : null, $tipo_table), substr($data_request[$i+1], 0, 8), $periodo, $tipo_aprovacao);
                if($a['status'] == 'error'){
                    $cont++;
                    $msg = $msg.'<br>'.$a['msg'];
                }
            }
            if($cont != 0){
                $a = array('status'=>'error', 'msg'=>$msg, array('msg'=>'Sucesso!', 'submsg'=>'Recalculado(s) com sucesso!', 'status'=>'success'));
            }
            return $cont > 0 ? $this->retornoJsonDefault($a,500) : $a;
        }
        else{
           $cont = 0;
           $msg = '';
           for($i = 0; $i < count($data_request['lotacoes']); $i = $i+2){
                $periodo = array_key_exists('periodo', $data_request) ? $data_request['periodo'] : null;
                $dado = array('justificativa'=>array_key_exists('justificativa', $data_request) == true ? $data_request['justificativa'] : null, 'reopen'=>$data_request['reopen']);
                $a = $this->getRepository()->reopen($data_request['lotacoes'][$i], $dado, $tipo_table, substr($data_request['lotacoes'][$i+1], 0, 8), $periodo, $tipo_aprovacao);
                if($a['status'] == 'error'){
                    $cont++;
                    $msg = $msg.'<br>'.$a['msg'];
                }
            }
            if($cont != 0){
                $a = array('status'=>'error', 'msg'=>$msg, 'submsg'=>'Erro');
            }
            return $cont > 0 ? $this->retornoJsonDefault($a,500) : array('submsg'=>'Sucesso!', 'msg'=>'Rejeitado(s) com sucesso!', 'status'=>'success');
        }

    }

    public function prepareApproveHeadcount($orc_id, $lotacao_id, $tipo_table, Request $request){
        $data_request = $request->all();

        $a = $this->getRepository()->prepareApproveHeadcount($orc_id, $data_request, $tipo_table);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }

    public function approveHeadcountFullLot($orc_id, $tipo_table = 'O'){

        $a = $this->getRepository()->approveHeadcountFullLot($orc_id, $tipo_table);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }

    /**
     * Marcar lotação como conferida
     */
    public function confer($orc_id,$lotacao_id, $tipo_table, Request $request){
        set_time_limit(700);
        $data_request = $request->all();
        $a = $this->getRepository()->confer($lotacao_id, $data_request['justificativa'], $tipo_table, '', $data_request['periodo']);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }
    public function conferAll($orc_id, $tipo_table, Request $request){
        set_time_limit(700);
        $data_request = $request->all();
        $data = $data_request['lotacoes'];
        $msg = '';
        $status = 200;

        for($i = 0; $i < count($data); $i = $i + 2){
            $a = $this->getRepository()->confer( $data[$i], $data_request['justificativa'], $tipo_table, " para a lotação ".substr($data[$i+1], 0, 8));
            if($a['status'] == 'error'){
                $msg = $msg.'<br>'.$a['msg'];
                $status = 500;
            }
        }
        $a['msg'] = $msg == '' ? 'Lotações Aprovadas com sucesso!' : $msg;
        $a['status'] = $msg == '' ? 'success' : 'error';
        $a['submsg'] = $msg == '' ? 'Erro' : 'Sucesso';
        return $this->retornoJsonDefault($a, $status);
    }

    /**
     * Calcular lotação
     */
    public function calculate($orc_id, $lotacao_id, $tipo_table, $periodo = null, Request $request){


        $data_request = $request->all();
        //dd("request", $data_request,$orc_id,$lotacao_id, $tipo_table, $periodo);
        $this->podeAcessar('calc',true,'HOME');
        $retorno=$this->getArrayRetornoDefault();
        $user = $this->getUserFromCurrentGuard();

        $hashs = array_key_exists('hashs',$data_request) ? $data_request['hashs']:[] ;


        if(!$user){
            $retorno['msg']='Não foi possível encontrar seu usuário. Faça o login novamente.';
            $retorno['submsg']='Falha ao calcular a lotação. Erro: 260620201206';
            goto saida;
        }

        if($user->tipo != 3){
            $retorno['msg']='Você não possui permissão para realizar o cálculo.';
            $retorno['submsg']='Falha ao calcular a lotação. Erro: 260620201207';
            goto saida;
        }


        if($this->calc_in_background){


            $myJob = new CalculateLotacao($orc_id, $user->id, $user->id_empresa, $lotacao_id, $tipo_table, $periodo, $hashs);
            dispatch($myJob);

            // file_put_contents('teste_escreve_isso_porfavooooor.txt', 'olha que loucura, olha que legal');

            $retorno['msg']="O cálculo da lotação foi iniciado, você receberá uma notificação quando concluído!";
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';

            return $this->retornoJsonDefault($retorno);
        }


        if(!$this->getRepository()->calculate($lotacao_id, false, $hashs, $tipo_table, null, $periodo)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao calcular a lotação. Erro: 250620201229';
            goto saida;
        }
            $retorno['msg']='Lotação calculada com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function calculateAll($orc_id, $tipo_table, $periodo = null, Request $request){
        //dd($orc_id, $tipo_table, $periodo);
        $this->podeAcessar('calc',true,'HOME');

        $data_request = $request->all();
        unset($data_request['_token']);

        $retorno=$this->getArrayRetornoDefault();
        $user = $this->getUserFromCurrentGuard();

        $hashs = array_key_exists('hashs',$data_request) ? $data_request['hashs'] : [] ;


        if(!$user){
            $retorno['msg'] = 'Não foi possível encontrar seu usuário. Faça o login novamente.';
            $retorno['submsg'] = 'Falha ao calcular a lotação. Erro: 260620201206';
            goto saida;
        }

        if($user->tipo != 3){
            $retorno['msg'] = 'Você não possui permissão para realizar o cálculo.';
            $retorno['submsg'] = 'Falha ao calcular a lotação. Erro: 260620201207';
            goto saida;
        }
        $msg = '';
        $cont = 0;
        for($i = 0; $i < count($data_request); $i = $i + 2){
            $lotacao_id = $data_request[$i];
            $desc = $data_request[$i+1];

            $var_periodo = $tipo_table == 'F' ? $periodo : null;
            $resp = $this->getRepository()->calculate($lotacao_id, false, $hashs, $tipo_table, substr($desc, 0, 8), $var_periodo);
            if($resp === false && $this->getRepositoryOrModel()->getErrosFlatted() == ''){
                $cont++;
                $msg = $msg.'Falha ao Recalcular a lotação '.$desc.' Erro: 121120201439<br>';
            }
            else if($this->getRepositoryOrModel()->getErrosFlatted() != ''){
                $msg = $msg.'<br>'.$this->getRepositoryOrModel()->getErrosFlatted();
            }
        }

        $retorno['msg'] = $msg != '' ? $msg : 'Recalculado com sucesso!';
        $retorno['status'] = $msg != '' ? 'error' : 'success';
        $retorno['submsg'] = $msg != '' ? 'Erro' : 'Sucesso';
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    /**
     * Liberar lotação
     * 29/06
     */
    public function release($orc_id, $lotacao_id, $tipo_table, Request $request){
        $data_request = $request->all();

        $a = $this->getRepository()->release($data_request['event_valores'], $data_request['data_envio_valores']['justificativa'], $tipo_table);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }

    public function releaseFullLotacao($orc_id, $tipo_table = "O"){
        $data_request = [
            'orc_id' => $orc_id
        ];

        $a = $this->getRepository()->releaseFullLotacao($orc_id, 'Não informada.', $tipo_table);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }

    public function approveValoresFullLot($orc_id, $tipo_table = "O"){

        $a = $this->getRepository()->approveValoresFullLot($orc_id, $tipo_table);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }

    /**
     * Gestor da área aprovar
     * 29/06
     */
    public function approveManager($orc_id,$lotacao_id, $tipo_table, Request $request){
        $data_request = $request->all();

        $a = $this->getRepository()->approveManager($data_request['event_valores'], $data_request['data_envio_valores']['justificativa'], $tipo_table);

        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }


    /**
     * Diretor da área aprovar
     * 29/06
     */
    public function approveDirector($orc_id,$lotacao_id, Request $request){
        $data_request = $request->all();
        $a = $this->getRepository()->approveDirector($lotacao_id, $data_request['justificativa']);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }
    public function implodeLotacoes($lotacoes, $lotacao_id){
        $lotacoes_string = null;

        foreach($lotacoes as $dados){
            $lotacoes_ = (array) $dados;
            $lotacoes_string = $lotacoes_string == null ? implode(',',$lotacoes_) : $lotacoes_string.','.implode(',',$lotacoes_);
        }
        if(is_array($lotacao_id) == false){
            return $lotacoes_string.','.$lotacao_id;
        }
        else{
            return $lotacoes_string.','.implode(',', $lotacao_id);
        }
    }
    public function confereCentroCusto($orc_id, $tipo_table = 'O', $periodo = NULL){
        $dados = $this->makeEstrutura($orc_id, null, 'N');
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );

        $user = $this->getUserFromCurrentGuard();

        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $where_lotacao = $user->tipo == 3 ? '' : "lotacao_id in ($lotacoes_string) and ";
        $where_periodo = $tipo_table == 'O' ? '' : "AND ol.periodo = '$periodo'";



        $select = DB::select("
            select distinct concat(cc.cod_ccusto, ' - ', cc.des_ccusto) as descricao_ccusto
            from tbl_lotacao_ccusto as lotcc
            join tbl_ccusto as cc on cc.id = lotcc.ccusto_id
            join tbl_orc_lotacao ol on ol.lotacao_id = lotcc.lotacao_id and ol.cc_custo_id = lotcc.ccusto_id
            where $where_lotacao (cc.dat_fim_valid < GETDATE()) $where_periodo AND ol.orcamento_id = $orc_id and ol.tipo_table = '$tipo_table' and ol.ativo = 1
        ");
        $msg = '';
        if(count($select) > 0){

            for($i = 0; $i < count($select); $i++){
                $msg = $msg == '' ? '<br>'.$select[$i]->descricao_ccusto : $msg.', <br>'.$select[$i]->descricao_ccusto;
            }
            // preciso da lotacao: - pego a lotacao do usuario, porque vai mostrar todos os centros de custo que ele tem acesso(-)
            $lotacao_id = null;
            $user_id = null;
            if($this->getUserFromCurrentGuard()->api_token){
                $token = $this->getUserFromCurrentGuard()->api_token;
                $decrypted = json_decode(safeDecrypt($token));
                $lotacao_id = $decrypted->func_data->lotacao_id;
                $user_id = $decrypted->id;
            }
            else{
                $token = request()->bearerToken();
                $decrypted = json_decode(safeDecrypt($token));
                $lotacao_id = $decrypted->token->func_data->lotacao_id;
                $user_id = $decrypted->token->id;
            }

            $conferir = DB::select("
                select * from tbl_orc_notificacoes
                where mensagem = 'Centro de Custo Invalido' and user_id = $user_id and orc_id = $orc_id
            ");

            if(count($conferir) == 0){

                $lot = DB::select("
                    select lot.unid_lotac, lot.des_unid_lotac, opar.valor_parametro, orclot.status, orclot.lotacao_id, orcm.ano, orcm.descricao_orc, orcm.id from tbl_orc_lotacao orclot
                    join tbl_orcamento as orcm on orcm.id = orclot.orcamento_id
                    join tbl_lotacao as lot on lot.id = orclot.lotacao_id
                    join tbl_orc_parametros as opar on opar.orcamento_id = orcm.id
                    join tblg_parametros as par on par.id = opar.parametro_id
                    where lot.id = $lotacao_id and par.cod_parametro = 'HIER' and orcm.id = $orc_id
                ");
                $descricao = $msg;// ver o tamanho do campo de mensagem na tbl
                $hierarquia = $lot[0]->valor_parametro + 1;

                $repo_notify = new RepoNotify();
                $retorno = $repo_notify->notifyCcustoVencido($lot[0]->lotacao_id, $hierarquia, $lot[0]->ano, $lot[0]->descricao_orc, $lot[0]->id, 'O(s) seguinte(s) Centro(s) de Custo está(ão) vencido(s) '.str_replace('<br>', '', $descricao), 'Centro de Custo Invalido');
            }

            if($user->tipo == 3){
                $msg .= "<br><br> Certifique-se de que a(s) lotação(ões) ligada(s) a ele(s) está(ão) inativa(s) em: 'Parametrizações/Parâmetros do Orçamento/Lotações'.";
            }

            $ret['status'] = 'warning';
            $ret['msg'] = 'O(s) seguinte(s) Centro(s) de Custo está(ão) vencido(s): '.$msg;
            $ret['submsg'] = 'Atenção!';
            return $this->retornoJsonDefault($ret);
        }
        else{
            $ret['status'] = 'success';
            $ret['msg'] = 'Nenhum centro de custo vencido';
            $ret['submsg'] = 'Atenção!';
            return $this->retornoJsonDefault($ret);
        }
    }

    // public function newMakeEstrutura($orc_id){
    //     $user = $this->getUserFromCurrentGuard();

    //     $token = $this->getUserFromCurrentGuard()->api_token;
    //     $decrypted = json_decode(safeDecrypt($token));


    //     /* SE USUÁRIO FOR IGUAL A TÉCNICO ou seu nivel hierarquico for PRESIDENTE*/
    //     if($user->tipo_user == 3 || $decrypted->func_data->nivel_hier == 1){
    //         $lotacao = $this->getRepository()->listar($orc_id);
    //         $this->lotacoes = $lotacao;
    //         goto saida;
    //     }

    //     $lotacoes = DB::select("");

    //     saida:
    //     return $this->lotacoes;
    // }
    public function makeEstrutura($orc_id, $periodo = null, $tipo_table = 'O', $preencher_periodo_ultimo_headcount = false){
        set_time_limit(120);
        // a variavel $preencher_periodo_ultimo_headcount serve para determinar se o sistema deve preencher o periodo da lotação (caso não encontre) com o ultimo período do headcount
		
		if($tipo_table == 'R'){
			$tipo_table = 'O';
		}
        
        //newMakeEstrutura busca as lotações de acordo com a substring da unid_lotac de acordo com o nivel hierarquico
        // return $this->newMakeEstrutura($orc_id);
        // $this->repopulateOrcLotacao($orc_id);

        // $decrypted = json_decode(safeDecrypt(request()->bearerToken()));

        /******* Fazer isso quando montar o doQuery() *******/
        //1- conferir na tabela de alternancia, se existe com o usuario que veio no bearerToken()
        //2- vai precisar pegar o func_id do bearerToken()
        //3- modificar o doQuery(), pois vira 2 lotacoes(gestor1 e gestor2). Usar where in [n1,n2]
        
        $decrypted = null;
        $lotacao_id = null;
        $tipo_user = null;
        $cdn_func = null;
        
        if($tipo_table == 'F' && ($periodo == null || $periodo == "null")){
           
            $res = DB::select("SELECT max(periodo) periodo from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'F' ");
            $periodo = count($res) > 0 ? $res[0]->periodo : null;
            
            if($periodo == null){
                // $retorno['msg'] = "Último período não encontrado. Erro: 050220211541";
                // $retorno['submsg'] = "Erro";
                // $retorno['status'] = "error";
                return $this->makeEstrutura($orc_id, null, 'O', false);
                // return $this->retornoJsonDefault($retorno);
            }
        }
        else if($tipo_table == 'F' && $periodo != null){
            $validacao = DB::select("SELECT id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}'");
            //$periodo_02 = DB::select("SELECT cast(DATEADD(month, -1, '{$periodo}') as date) as periodo");
            
            if(count($validacao) == 0){
                return $this->makeEstrutura($orc_id, $periodo, 'O', false);
            }
        }
        

        if($this->getUserFromCurrentGuard()->api_token){
            $token = $this->getUserFromCurrentGuard()->api_token;
            $decrypted = json_decode(safeDecrypt($token));
            
            $tipo_user = $decrypted->tipo_user;
            $lotacao_id = $decrypted->func_data->lotacao_id;
            $cdn_func = $decrypted->func_data->cdn_funcionario;
        }
        else{
            $token = request()->bearerToken();
            $decrypted = json_decode(safeDecrypt($token));
            
            $tipo_user = $decrypted->token->tipo_user;
            $lotacao_id = $decrypted->token->func_data->lotacao_id;
            $cdn_func = $decrypted->token->func_data->cdn_funcionario;
        }
        $where[0] = $tipo_table == 'F' ? " and ga.tipo_table = 'F' and ga.periodo = '{$periodo}' " : " and ga.tipo_table = 'O' ";
        
        $select = [];
        if($tipo_table == 'O' || $tipo_table == 'F'){
            $select = DB::select("SELECT
                olot.lotacao_id as lot1 from tbl_orc_gestor_alternativo as ga
                join tbl_funcionario as func on func.id = ga.funcionario_id
                join tbl_orc_lotacao as olot on olot.id = ga.lotacao_id
                
                where func.cdn_funcionario = $cdn_func and ga.orcamento_id = $orc_id {$where[0]} and ga.data_inicial <= getdate() and ga.data_final >= getdate()
            ");
        }
        
        
        if(count($select) == 0){
            $lotacoes_string = $lotacao_id;
        }
        else{
            $lotacoes_string = $this->implodeLotacoes($select, $lotacao_id);
        }

        /* SE USUÁRIO FOR IGUAL A TÉCNICO */
        if($tipo_user == 3){

            $cod_param_plano_lotac = $this->getCodPlanLotac();

            $cod_plano_lotac = DB::select("SELECT op.valor_parametro from tbl_orc_parametros op
            join tblg_parametros p on p.id = op.parametro_id
            where op.orcamento_id = $orc_id and p.cod_parametro = '$cod_param_plano_lotac'
            ");

            $cod_plano_lotac = (count($cod_plano_lotac) > 0) ? $cod_plano_lotac[0]->valor_parametro : 13;

            // $lotacao = $this->getRepository()->listar($orc_id, $cod_plano_lotac);
            $lotacao = $this->getRepository()->listarExistemPlanoLotacao($orc_id, $cod_plano_lotac, $periodo, $tipo_table);
            $this->lotacoes = $lotacao; 
            goto saida;
        }
 
        $lotacao = (($lotacao_id));
        $sql = $this->doQueryVersao2($orc_id, $lotacoes_string, 'l.id', $periodo, $tipo_table);
        
        if(is_null($this->lotacoes)){
            $lot = DB::select($sql);
            $this->lotacoes = $lot;
            // mudou o campo seq
        }
        else{
            
            for($y = 0; $y < count($this->lotacoes); $y++){

                $sql = $this->doQueryVersao2($orc_id, $this->lotacoes[$y]->seq, 'epl.seq_pai', $periodo, $tipo_table); 
                $childrens =  DB::select($sql);
                // $cont_netos = [];
                foreach ($childrens as $key => $value){
                    if($this->validaPushLotacao($value)){
                        array_push($this->lotacoes, $value);
                    }
                    $sql = $this->doQuery($orc_id, $value->seq, 'epl.seq_pai', $periodo, $tipo_table);
                    $netos = DB::select($sql);
                    //  foreach ($netos as $neto) {
                    //     array_push($cont_netos, $neto);
                    //  }
                    $this->getChildrens($netos,$orc_id);
                }
            }
            goto saida;
        }
        $this->makeEstrutura($orc_id, $periodo, $tipo_table);
        saida:

        if($preencher_periodo_ultimo_headcount){
            $ultimo_periodo_headcount = DB::select("SELECT MAX(periodo) as periodo from tbl_orc_lot_carg_headcount where orc_id = $orc_id and tipo_table = 'F'");
            $ultimo_periodo_headcount = count($ultimo_periodo_headcount) > 0 ? $ultimo_periodo_headcount[0]->periodo : null;
            
            $this->lotacoes[0]['periodo'] = $ultimo_periodo_headcount;            
        }
        else if($tipo_table == 'O' && $periodo != null){
            if($this->lotacoes){
                if(gettype($this->lotacoes[0]) == 'object'){
                    $this->lotacoes[0]->periodo = $periodo;
                }
                else{
                    $this->lotacoes[0]['periodo'] = $periodo;
                }
            }
        }

        return $this->lotacoes;
        // return $aa;
    }
    /*public function passagemLotacoes($orc_id, $func_id){
        $select = DB::select("
            SELECT usu.email, usu.tipo, func.lotacao_id FROM institb_usuario usu
            inner join tbl_funcionario func on func.id = usu.funcionario_id
            where usu.funcionario_id = $func_id
        ");
        if(count($select) > 0){
            return $this->gestorAlternativo($orc_id, $select[0]->tipo, $select[0]->lotacao_id);
        }
    }
    public function gestorAlternativo($orc_id, $lotacao_func, $tipo_user){

        // na tbl_usuario tem o funcionario_id, dá para pegar a lotacao_id e o tipo_user
        // vai sobre escrever o metodo #makeEstrutura
        if($tipo_user == 3){
            $lotacao = $this->getRepository()->listar($orc_id);
            $this->lotacoes = $lotacao;
            goto saida;
        }

        $lotacao = $lotacao_func;

        $sql = $this->doQuery($orc_id,$lotacao,'l.id');
        if(is_null($this->lotacoes)){
            $lot = DB::select($sql);
            $this->lotacoes = $lot;
        }
        else{

            $sql = $this->doQuery($orc_id,$this->lotacoes[0]->seq);
            $childrens =  DB::select($sql);

            foreach ($childrens as $key => $value){
                if($this->validaPushLotacao($value)){
                    array_push($this->lotacoes, $value);
                }

                $sql = $this->doQuery($orc_id,$value->seq);
                $netos = DB::select($sql);
                $this->getChildrens($netos,$orc_id);
            }
            goto saida;
        }
        $this->gestorAlternativo($orc_id, $lotacao_func, $tipo_user);
        saida:
        return $this->lotacoes;
    }*/
    public function validaPushLotacao($element){
        foreach ($this->lotacoes as $lotacao) {
            if($lotacao->id == $element->id){
                return false;
            }
        }
        return true;
    }
    
    public function getChildrens($netos, $orc_id, $periodo = null, $tipo_table = 'O'){
        
        if(count($netos) > 0){
            for ($i=0; $i < count($netos); $i++) {
                if($this->validaPushLotacao($netos[$i])){
                    array_push($this->lotacoes,$netos[$i]);
                }     
                // dd($this->lotacoes);
                $sql = $this->doQuery($orc_id, $netos[$i]->seq, 'epl.seq_pai', $periodo, $tipo_table);
                
                $z =  DB::select($sql);
                
                if(!empty($z) && $i<30){
                    for ($j=0; $j < count($z); $j++) {
                        
                        if($this->validaPushLotacao($z[$j])){
                            array_push($this->lotacoes,$z[$j]);
                            
                            $sql = $this->doQuery($orc_id, $z[$j]->seq, 'epl.seq_pai', $periodo, $tipo_table);
                            $x =  DB::select($sql);
                            
                            if(!empty($x)){
                                $this->getChildrens($x, $orc_id);
                            }
                        }
                    }
                }

            }
        }
    }


    public function doQuery($orc_id, $value, $form_field='epl.seq_pai', $periodo = null, $tipo_table = 'O'){
        $cod_param_plano_lotac = $this->getCodPlanLotac();

        $where[0] = $tipo_table == 'F' ? " and ol.periodo = '{$periodo}' and ol.tipo_table = 'F' " : " and ol.tipo_table = 'O'";

        $cod_plano_lotac = DB::select("
        select op.valor_parametro from tbl_orc_parametros op
        join tblg_parametros p on p.id = op.parametro_id
        where op.orcamento_id = $orc_id and p.cod_parametro = '$cod_param_plano_lotac'
        ");

        $cod_plano_lotac = (count($cod_plano_lotac) > 0) ? $cod_plano_lotac[0]->valor_parametro : 13;
        // $cod_plano_lotac = 13;
        $str_status = " ol.status as status_atual, ol.status as status_orc_lotacao,";

        $sql = "SELECT
        ol.id,
        ol.cc_custo_id,
        cc.cod_ccusto,
        cc.des_ccusto,
        l.des_unid_lotac,
        l.empresa_id,
        cc.cod_ccusto+' - '+ l.unid_lotac +' - '+l.des_unid_lotac description,
        plu.lotacao_id,
        ol.orcamento_id,
        l.quadro_atual,
        ol.responder_orc,
        ol.status,
        {$str_status}
        l.unid_lotac,
        l.user_id,
        plu.seq_ud,
        plu.limite,
        epl.seq,
        epl.seq_pai,
        plt.cod_tipo,
        plt.des_tipo,
        ol.periodo

       FROM
       (


        SELECT id FROM tbl_plano_lotac WHERE cdn_plano_lotac = $cod_plano_lotac ) pl
       --JOIN TABELA PLANO LOTACAO X PLANO LOTACAO TIPO
       INNER JOIN
       tbl_plano_lotac_tipo plt ON pl.id=plt.plano_lotac_id

       --JOIN TABELA PLANO LOTAÇÃO TIPO X PLANO LOTAÇÃO UNID
       INNER JOIN
           tbl_plano_lotac_unid plu
       ON plt.id=plu.plano_lotac_tipo_id

       --JOIN TABELA LOTACAO X PLANO LOTACAO UNID
       INNER JOIN
           tbl_lotacao l ON l.id=plu.lotacao_id

       --JOIN TABELA LOTACAO X ESTRUTURA_PLANO_LOTAC AND  ESTRUTURA_PLANO_LOTAC X PLANO_LOTAC.
       INNER JOIN
       tbl_estrutura_plano_lotac epl ON l.id =epl.lotacao_id and epl.plano_lotacao_id = pl.id

       --TBL ORC LOTACAO X LOTACAO COM ORCAMENTO

       INNER JOIN
           tbl_orc_lotacao ol ON ol.lotacao_id = l.id and ol.orcamento_id = $orc_id and ol.ativo = 1 $where[0]

       INNER JOIN tbl_ccusto cc ON ol.cc_custo_id = CC.id
        where $form_field=$value";

        return $sql;

    }


    public function doQueryVersao2($orc_id, $value, $form_field = 'epl.seq_pai', $periodo = null, $tipo_table = 'O'){
        $cod_param_plano_lotac = $this->getCodPlanLotac();

        $where[0] = $tipo_table == 'F' ? " ol.periodo = '{$periodo}' and ol.tipo_table = '{$tipo_table}' " : " ol.tipo_table = '{$tipo_table}' ";
        $cod_plano_lotac = DB::select("
        select op.valor_parametro from tbl_orc_parametros op
        join tblg_parametros p on p.id = op.parametro_id
        where op.orcamento_id = $orc_id and p.cod_parametro = '$cod_param_plano_lotac'
        ");

        $cod_plano_lotac = (count($cod_plano_lotac) > 0) ? $cod_plano_lotac[0]->valor_parametro : 13;
        $str_status = " ol.status as status_atual, ol.status as status_orc_lotacao,";

        $sql = "SELECT
        ol.id,
        ol.cc_custo_id,
        cc.cod_ccusto,
        cc.des_ccusto,
        l.des_unid_lotac,
        l.empresa_id,
        cc.cod_ccusto+' - '+ l.unid_lotac +' - '+l.des_unid_lotac description,
        plu.lotacao_id,
        ol.orcamento_id,
        l.quadro_atual,
        ol.responder_orc,
        ol.status,
        {$str_status}
        l.unid_lotac,
        l.user_id,
        plu.seq_ud,
        plu.limite,
        epl.seq,
        epl.seq_pai,
        plt.cod_tipo,
        plt.des_tipo,
        ol.periodo

        FROM
        (

        SELECT id FROM tbl_plano_lotac WHERE cdn_plano_lotac = $cod_plano_lotac ) pl
        --JOIN TABELA PLANO LOTACAO X PLANO LOTACAO TIPO
        INNER JOIN
        tbl_plano_lotac_tipo plt ON pl.id=plt.plano_lotac_id

       --JOIN TABELA PLANO LOTAÇÃO TIPO X PLANO LOTAÇÃO UNID
        INNER JOIN
            tbl_plano_lotac_unid plu
        ON plt.id=plu.plano_lotac_tipo_id

        --JOIN TABELA LOTACAO X PLANO LOTACAO UNID
        INNER JOIN
           tbl_lotacao l ON l.id=plu.lotacao_id

         --JOIN TABELA LOTACAO X ESTRUTURA_PLANO_LOTAC AND  ESTRUTURA_PLANO_LOTAC X PLANO_LOTAC.
        INNER JOIN
        tbl_estrutura_plano_lotac epl ON l.id =epl.lotacao_id and epl.plano_lotacao_id = pl.id

        --TBL ORC LOTACAO X LOTACAO COM ORCAMENTO
        INNER JOIN
           tbl_orc_lotacao ol ON ol.lotacao_id = l.id and ol.orcamento_id = $orc_id and ol.ativo = 1 and $where[0]

        INNER JOIN tbl_ccusto cc ON ol.cc_custo_id = CC.id
            where $form_field in ($value)";

        return $sql;
    }

    /**
     *
     */

    public function lotacaoData($orc_id, $lotacao_id, $periodo = null, $tipo_table = 'O'){

        // $orc_lot_cargo_head = new OrcamLotCargoHeadcount();
        $orc_cargo = new OrcCargo();
        // $cargo = new Cargo();
        // $repo_cargo_area_sal = new RepoOrcLotacaoCargoSal();
        $repo_usuario = new RepoUsuario();
        $usuario = $this->getUserFromCurrentGuard();

        $user = $repo_usuario->getModelEntity()->select('funcionario_id')->with([
            'getFuncionario'=>function($query){
                return $query->with('getCargo');
            }
        ])->find($this->getUserFromCurrentGuard()->id);

        if(!$user){
            return [];
        }

        $gs_usuario = substr($user->getFuncionario->getCargo->cod_cargo_basic, 0, 2);

        $cargos = $orc_cargo
        ->with(['getCargo'=>function($query){

        }])
        ->where('orcamento_id', $orc_id)
        ->where('tipo_table', $tipo_table);

        if($tipo_table == 'F'){
            $cargos = $cargos->where('periodo', $periodo)->get()->toArray();
        }
        else{
            $cargos = $cargos->whereNull('periodo')->get()->toArray();
        }

        $data_cargo = [];
        foreach ($cargos as $cargo) {
            if($usuario->tipo != 3 && substr($cargo['get_cargo']['cod_cargo_basic'], 0, 2) > $gs_usuario){
                continue;
            }
            array_push($data_cargo, [
                'description_cargo'=>$cargo['get_cargo']['cod_cargo_basic'] . ' - ' .$cargo['get_cargo']['des_cargo_basic'],
                'id' => $cargo['id']
            ]);
        }


        // $data_cargo = $orc_lot_cargo_head
        // ->join($orc_cargo->getTable(),$orc_lot_cargo_head->getColunaAlias('orc_cargo_id'),$orc_cargo->getColunaAlias('id'))
        // ->join($cargo->getTable(),$orc_cargo->getColunaAlias('cargo_id'),$cargo->getColunaAlias('id'))
        // ->select(
        //     DB::raw("CONCAT({$cargo->getColunaAlias('cod_cargo_basic')}, ' - ', {$cargo->getColunaAlias('des_cargo_basic')}) as description_cargo")
        //     ,$orc_cargo->getColunaAlias('id')
        //     )
        // ->where($orc_lot_cargo_head->getColunaAlias('orc_id'), '=' ,$orc_id)
        // ->where($orc_lot_cargo_head->getColunaAlias('lotacao_id') ,'=' ,$lotacao_id)
        // ->distinct()->get()->toArray();

        $orc_turma = new OrcTurma();

        $turmas = $orc_turma
        ->with(['getTurno'=>function($query){

        }])
        ->where('orc_id', $orc_id)
        ->where('tipo_table', $tipo_table);

        if($tipo_table == 'F'){
            $turmas = $turmas->where('periodo', $periodo)->get()->toArray();
        }
        else{
            $turmas = $turmas->whereNull('periodo')->get()->toArray();
        }

        // dd($turmas);

        $data_turma = [];
        foreach ($turmas as $turma) {
            array_push($data_turma, [
                'description_turma'=>$turma['cdn_turma_trab'] . ' - ' .$turma['des_turma_trab'] . ' - ' .$turma['get_turno']['cdn_turno_trab'] . ' - ' .$turma['get_turno']['des_turno_trab'],
                'id' => $turma['id']
            ]);
        }

        // $turma = new Turma();
        // $turno = new Turno();

        // $data_turma = $orc_lot_cargo_head
        // ->join($orc_turma->getTable(),$orc_lot_cargo_head->getColunaAlias('orc_turma_id'),$orc_turma->getColunaAlias('id'))
        // ->join($turma->getTable(),$orc_turma->getColunaAlias('turma_id'),$turma->getColunaAlias('id'))
        // ->join($turno->getTable(),$orc_turma->getColunaAlias('turno_id'),$turno->getColunaAlias('id'))
        // ->select(
        //     DB::raw("CONCAT({$turma->getColunaAlias('cdn_turma_trab')}, ' - ', {$turma->getColunaAlias('des_turma_trab')} , ' - ',
        //                     {$turno->getColunaAlias('cdn_turno_trab')}, ' - ', {$turno->getColunaAlias('des_turno_trab')} ) as description_turma")
        //     ,$orc_turma->getColunaAlias('id')
        //     )
        // ->where($orc_lot_cargo_head->getColunaAlias('orc_id'), '=' ,$orc_id)
        // ->where($orc_lot_cargo_head->getColunaAlias('lotacao_id') ,'=' ,$lotacao_id)
        // ->distinct()->get()->toArray();
            // dd("data turma", $data_turma);
            $result['turmas']=$data_turma;
            $result['cargos']=$data_cargo;
        return $result;
    }

    public function repopulateOrcLotacao($orc_id, $periodo = null, $tipo_table = 'O'){

        $repo_orc_scripts_calculos = new RepoOrcScriptCalculos();
        if($tipo_table == 'O'){
            if(!$repo_orc_scripts_calculos->scriptMergeOrcLotacao($orc_id, 1)){
                $retorno['msg']="Ocorreu uma falha ao repopular!";
                $retorno['submsg']='Falha ao inserir o registro. Erro: 131220191907';
                $retorno['status']='error';
            }
        }
        else{
            if(!$repo_orc_scripts_calculos->scriptMergeOrcLotacaoForecast($orc_id, 1, $periodo, $tipo_table)){
                $retorno['msg'] = "Ocorreu uma falha ao repopular!";
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 260120211531b';
                $retorno['status'] = 'error';
            }
        }



        $retorno["status"] = "success";
        $retorno["msg"] = "Tabelas repopuladas com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function repopulateOrcPPR($orc_id, $periodo = null, $tipo_table = 'O'){

        $repo_orc_scripts_calculos = new RepoOrcScriptCalculos();

        if($tipo_table == 'F'){
            if(!$repo_orc_scripts_calculos->sp_hnd_atualiza_headcount_ppr_forecast($orc_id, $periodo, $tipo_table)){
                $retorno['msg'] = "Ocorreu uma falha ao repopular!";
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro:260120211556';
                $retorno['status'] = 'error';
            }
        }
        else{
            if(!$repo_orc_scripts_calculos->sp_hnd_atualiza_headcount_ppr($orc_id)){
                $retorno['msg'] = "Ocorreu uma falha ao repopular!";
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro:090920200859';
                $retorno['status'] = 'error';
            }
        }


        $retorno["status"] = "success";
        $retorno["msg"] = "Tabelas repopuladas com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function repopulateOrcBonus($orc_id, $periodo = null, $tipo_table = 'O'){

        $repo_orc_scripts_calculos = new RepoOrcScriptCalculos();

        if($tipo_table == 'F'){
            if(!$repo_orc_scripts_calculos->sp_hnd_atualiza_headcount_bonus_forecast($orc_id, $periodo, $tipo_table)){
                $retorno['msg']="Ocorreu uma falha ao repopular!";
                $retorno['submsg']='Falha ao inserir o registro. Erro:090920200858';
                $retorno['status']='error';
            }
        }
        else{
            if(!$repo_orc_scripts_calculos->sp_hnd_atualiza_headcount_bonus($orc_id)){
                $retorno['msg']="Ocorreu uma falha ao repopular!";
                $retorno['submsg']='Falha ao inserir o registro. Erro:090920200858';
                $retorno['status']='error';
            }
        }



        $retorno["status"]="success";
        $retorno["msg"]="Tabelas repopuladas com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function calculateMulti($orc_id, Request $request){
        $this->podeAcessar('calc',true,'HOME');
        $data_request = $request->all();
        $lotacoes = $data_request['lotacoes'];



        $retorno=$this->getArrayRetornoDefault();
        $user = $this->getUserFromCurrentGuard();

        $hashs = array_key_exists('hashs',$data_request) ? $data_request['hashs']:[] ;


        if(!$user){
            $retorno['msg']='Não foi possível encontrar seu usuário. Faça o login novamente.';
            $retorno['submsg']='Falha ao calcular a lotação. Erro: 090920202025';
            goto saida;
        }

        if($user->tipo != 3){
            $retorno['msg']='Você não possui permissão para realizar o cálculo.';
            $retorno['submsg']='Falha ao calcular a lotação. Erro: 090920202026';
            goto saida;
        }

        $hasError = false;
        // dd("lotações", $lotacoes);
         foreach ($lotacoes as $lotac) {

            if(array_key_exists('tipo_table', $data_request) && $data_request['tipo_table'] == 'F'){
                if(!$this->getRepository()->calculate($lotac, false, $hashs, 'F', null, $data_request['periodo'])){
                    $orc_lotacao = $this->getRepository()->getModelEntity()->with('getLotacao')->find($lotac);

                    // $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['msg']=$retorno['msg']."Lotação ".$orc_lotacao->getLotacao->unid_lotac.": ".$this->getRepositoryOrModel()->getError()[0].'<br>';
                    $retorno['submsg']='Falha ao calcular a lotação. Erro: 090920202027';
                    $hasError = true;
                //    $this->getRepositoryOrModel()->clearError();
                    continue;
                }
            }
            if(!$this->getRepository()->calculate($lotac, false, $hashs)){
                $orc_lotacao = $this->getRepository()->getModelEntity()->with('getLotacao')->find($lotac);

                // $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['msg']=$retorno['msg']."Lotação ".$orc_lotacao->getLotacao->unid_lotac.": ".$this->getRepositoryOrModel()->getError()[0].'<br>';
                $retorno['submsg']='Falha ao calcular a lotação. Erro: 090920202027';
                $hasError = true;
            //    $this->getRepositoryOrModel()->clearError();
                continue;
            }
        }

            $retorno['msg'] =  $hasError ? $retorno['msg'] :  'Lotações calculadas com sucesso!';
            // $retorno['submsg']='Sucesso';
            $retorno['submsg'] =  $hasError ? 'Erro' :  'Sucess';

            // $retorno['status']='success';
            $retorno['status'] =  $hasError ? 'error' :  'success';


        saida:
         return $this->retornoJsonDefault($retorno);

    }


    public function lotacaoDataHeadcount($orc_id, $lotacao_id, $tipo_table, $periodo = null){
        DB::enableQueryLog();
        $where_periodo = $tipo_table == 'F' ? " and a.periodo = '{$periodo}'" : "";
        $result = DB::select("SELECT
                        a.orc_cargo_id, a.orc_turma_id, d.turma_id, e.cdn_turma_trab,
                        e.des_turma_trab, f.cdn_turno_trab, f.des_turno_trab,
                        h.cod_cargo_basic, h.des_cargo_basic, g.cargo_id
                    from tbl_orc_lot_carg_headcount a
                    join tbl_calc_orcamento b on b.origem_id = a.id and b.tbl_origem = 'tbl_orc_lot_carg_headcount'
                    join tbl_orc_parametros c on c.orcamento_id = a.orc_id and c.parametro_id = (select id from tblg_parametros where cod_parametro = 'TPHEADCOUNT')
                    join tbl_orc_turma d on d.id = a.orc_turma_id
                    join tbl_turma e on e.id = d.turma_id
                    join tbl_turno f on f.id = e.turno_id
                    join tbl_orc_cargo g on g.id = a.orc_cargo_id
                    join tbl_cargo h on h.id = g.cargo_id
                    where lotacao_id = {$lotacao_id}
                    and a.tipo_table = '{$tipo_table}'
                    {$where_periodo}
                    and
                        ((c.valor_parametro = '0' AND qtd_func_lot <> 0) OR
                        (c.valor_parametro <> '0' AND forecast_anterior <> 0) OR
                        b.jan_orcado <> 0 OR
                        b.fev_orcado <> 0 OR
                        b.mar_orcado <> 0 OR
                        b.abr_orcado <> 0 OR
                        b.mai_orcado <> 0 OR
                        b.jun_orcado <> 0 OR
                        b.jul_orcado <> 0 OR
                        b.ago_orcado <> 0 OR
                        b.set_orcado <> 0 OR
                        b.out_orcado <> 0 OR
                        b.nov_orcado <> 0 OR
                        b.dez_orcado <> 0)
                order by orc_cargo_id
        ");

        $data_turma = [];
        $data_cargo = [];

        foreach ($result as $data) {

            if (!in_array([
                'id'=>$data->orc_cargo_id,
                'cargo_id'=>$data->cargo_id,
                'description_cargo' => $data->cod_cargo_basic . ' - ' . $data->des_cargo_basic
            ], $data_cargo, true)) {
                array_push($data_cargo,
                    [
                        'id'=>$data->orc_cargo_id,
                        'cargo_id'=>$data->cargo_id,
                        'description_cargo' => $data->cod_cargo_basic . ' - ' . $data->des_cargo_basic
                    ]
                );
            }

            if (!array_key_exists($data->orc_cargo_id, $data_turma) ) {
                $data_turma[$data->orc_cargo_id] = [[
                    'orc_turma_id'=>$data->orc_turma_id,
                    'turma_id'=>$data->turma_id,
                    'descricao'=> $data->des_turma_trab . ' - ' . $data->cdn_turno_trab . ' - ' . $data->des_turno_trab]
                ];
            }else{
                array_push($data_turma[$data->orc_cargo_id], [
                    'orc_turma_id'=>$data->orc_turma_id,
                    'turma_id'=>$data->turma_id,
                    'descricao'=> $data->des_turma_trab . ' - ' . $data->cdn_turno_trab . ' - ' . $data->des_turno_trab]
                );
            }
        }

        $return_data['turmas']=$data_turma;
        $return_data['cargos']=$data_cargo;

        return $return_data;
    }

    public function inserirOrcLotacao(Request $request, $orc_id, $tipo_table = 'O', $periodo = null){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $data = $request->all();
        $retorno=$this->getArrayRetornoDefault();

        DB::beginTransaction();

        foreach ($data['lotacoes'] as $lotacao) {
            $data_insert = [
                'orcamento_id' => $orc_id,
                'lotacao_id' => $lotacao['lotacao_id'],
                'responder_orc' => 1,
                'cc_custo_id' => $lotacao['ccusto_id'],
                'hc_iniciado' => 0,
                'status' => $tipo_table == 'O' ? 1 : 9,
                'has_error_calc' => 0,
                'tipo_table' => $tipo_table,
                'ativo' => 1
            ];

            if($tipo_table == 'F'){
                $data_insert['periodo'] = $periodo;
            }

            if(!$this->getRepository()->create($data_insert)){
                DB::rollback();
                $retorno["status"]="error";
                $retorno["msg"]=$this->getRepository()->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir. Erro 250120201053';
                goto saida;
            }
        }

        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        DB::commit();
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function atualizarLotacao(Request $dados, $orc_id){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $data = $dados->all();

        if(!$this->getRepository()->atualizaLotacaoRepositorio($orc_id, $data)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao atualizar o registro. Erro: 040320211849.';
                goto saida;
        }

        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function aprovarTodas(Request $request){
        $this->podeAcessar('aprovar_headcount_gestor',true,'HOME');
        $retorno = $this->getArrayRetornoDefault();
        $data = $request->all();

        if(!$this->getRepository()->aprovarTodas($data['orc_id'], $data['tipo_table'], $data['tipo_dados'], $data['periodo'], $this)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao aprovar as lotações. Erro: 130620211806.';
                goto saida;
        }

        $retorno["status"]="success";
        $retorno["msg"]="Lotações aprovadas com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    }

}
