<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcNaturezaEvento as RepoOrcNaturezaEvento;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;

class OrcNaturezaEventoController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository = new RepoOrcNaturezaEvento();
        //$this->setCodTela('CG');
        parent::__construct();
    }
    public function inserir(Request $request){
        $dados = $request->all();
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
        $dados['empresa_id'] = $decrypted['token']['empresa_id'];
        
        for($i = 0; $i < count($dados['evento']); $i++){
            $dados['evento_id'] = $dados['evento'][$i]['id'];
            $dados['cdn_event'] = $dados['evento'][$i]['cdn_event'];
            $dados['multiplica'] = $dados['evento'][$i]['multiplica'];

            $resp = $this->getRepository()->inserir($dados);
            if(!$resp){
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                $retorno['msg'] = "Falha ao inserir o evento ".$dados['evento'][$i]['description'].'<br>'.$this->getRepository()->getErrosFlatted();
                goto saida;
            }
        }

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $retorno['status'] = 'success';
        $retorno['submsg'] = 'Sucesso!';
        $retorno['msg'] = 'Registro inserido com sucesso!';
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function listarAll($orc_id, $periodo = null, $tipo_table = 'O'){
        $resp = $this->getRepository()->listarAll($orc_id, $periodo, $tipo_table);
        return $this->renderTreeTableList($resp);
    }
    public function update(Request $request){
        $dados = $request->all();
        $resp = $this->getRepository()->atualizar($dados);
        
        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Falha ao atualizar registro.';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro atualizado com sucesso!';
        $retorno['submsg'] = 'Sucesso!';
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function delete(Request $request){
        $dados = $request->all();
        $resp = $this->getRepository()->deletar($dados);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Falha ao deletar registro.';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }

        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro deletado com sucesso!';
        $retorno['submsg'] = 'Sucesso!';
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    function renderTreeTableList($dados){
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orc_id", "from"=>"orc_id"],
            ["field_out"=>"natureza_has_id", "from"=>"natureza_has_id"],
            ["field_out"=>"evento_id", "from"=>"evento_id"], 
            ["field_out"=>"cdn_event", "from"=>"cdn_event"], 
            ["field_out"=>"multiplica", "from"=>"multiplica", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
            ["field_out"=>"description", "from"=>"description"],
            ["field_out"=>"description_natureza", "from"=>"description_natureza"],
            ["field_out"=>"dt_base_admissao_ini", "from"=>"dt_base_admissao_ini"],
            ["field_out"=>"dt_base_admissao_fim", "from"=>"dt_base_admissao_fim"],
            ["field_out"=>"empresa_id", "from"=>"empresa_id"],

            ["field_out"=>"dt_base_admissao_ini_description", "from"=>"dt_base_admissao_ini_description"],
            ["field_out"=>"dt_base_admissao_fim_description", "from"=>"dt_base_admissao_fim_description"],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"criado_em", "from"=>"criado_em"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"]
       ];
        
        
       $settings = ["columns" => $columns_base,
                "keys" => ['id'] 
           ];    
           
       $controller = new AtmTreeTable($settings, $dados);
       
     return $controller->render();
   }
    public function listarNaturezaEventoToOrc(){
        $naturezaEvento = new NaturezaEventoController();
        $resp = $naturezaEvento->listar();
        $y = 0;
        $dados = [];
        //dd(json_decode($resp));
        for($i = 0; $i < count($resp); $i++){
            if($resp[$i]['base_calc_orcamento'] == 1){
                $dados[$y] = $resp[$i];
                $y++;
            }
        }
        return $dados;
    }
    public function listEventosBaseCalc(){
        $resp = $this->getRepository()->listToPickList();
        return $resp;
    }

    public function repopulate(Request $request){
        $dados = $request->all();
        $orc_id = $dados['orc_id'];
        $retorno = [];
        
        if($dados['tipo'] == 0){
            $resp = $this->getRepositoryOrModel()->repopulate($orc_id, $dados['periodo'], $dados['tipo_table']);
            $erro = $this->getRepository()->getErrosFlatted();
            
            if($resp == false){
                $retorno['msg'] = $erro;
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';
            }
            else if($resp === 'warning'){
                $retorno['msg'] = $erro;
                $retorno['submsg'] = 'Atenção';
                $retorno['status'] = 'warning';
            }
            else{
                $retorno['msg'] = $erro == "" ? "Registro(s) inserido(s) com sucesso!" : $retorno['msg'];
                $retorno['submsg'] =  $erro == "" ? "Sucesso!" : $retorno['submsg'];
                $retorno['status'] = $erro == "" ? 'success' : $retorno['status'];
            }

            return $retorno;
        }
        else{
            $resp2 = $this->getRepositoryOrModel()->repopulateAll($orc_id, $dados['periodo'], $dados['tipo_table']);
            $erro2 = $this->getRepository()->getErrosFlatted();

            if($resp2 == false){
                $retorno['msg'] = $erro2;
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';
            }
            else{
                $retorno['msg'] = $erro2 == "" ? "Registro(s) atualizado(s) com sucesso!" : $erro2;
                $retorno['submsg'] =  $erro2 == "" ? "Sucesso!" : $retorno['submsg'];
                $retorno['status'] = $erro2 == "" ? 'success' : $retorno['status'];
            }

            return $retorno;
        }
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'Natureza_Eventos', ['evento_id', 'id', 'orc_id', 'empresa_id', 'dt_base_admissao_fim', 'dt_base_admissao_ini', 'cdn_event', 'natureza_has_id', 'multiplica']);
    }

    public function formatHeaders($colunas){
        for ($i = 0; $i < count($colunas); $i++) {
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);

            $colunas[$i] = str_replace("dt base admissao fim description", "Admissão Final", $colunas[$i]);
            $colunas[$i] = str_replace("dt base admissao ini description", "Admissão Inicial", $colunas[$i]);
            $colunas[$i] = str_replace("description natureza", "Natureza", $colunas[$i]);
            $colunas[$i] = str_replace("description", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("multiplica2", "Multiplica", $colunas[$i]);
        }
        return $colunas;
    }
}