<?php
namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcNotificacoes as RepoOrcNotificacoes;
use Illuminate\Http\Request;
use DB;
class OrcNotificacoesController extends OrcamentoController
{
    
    public function __construct(){
        parent::__construct();
        $this->repository=new RepoOrcNotificacoes();
    } 

    public function listarNotif($orc_id){
        return $this->getRepository()->listar($orc_id);
    }

    public function marcarOK($orc_id, Request $request){              
        $retorno=$this->getArrayRetornoDefault();
        $form_data=$request->all();
       
        if(! $this->getRepositoryOrModel()->marcarOK($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao atualizar o registro. Erro: 110520202022';
            goto saida;
        }
            $retorno['msg']='Registro atualizado com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';
        
        saida:
         return $this->retornoJsonDefault($retorno); 
    }

    public function marcarOKAll($orc_id, Request $request){              
        $retorno=$this->getArrayRetornoDefault();
        $form_data=$request->all();

        DB::beginTransaction();
        unset($form_data['_token']);
        foreach ($form_data as $notif) {
            if($notif['l_ok'] == 1){
                continue;
            }
            
            if(!$this->getRepositoryOrModel()->marcarOK($notif)){
                DB::rollback();
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao atualizar o registro. Erro: 080220211043';
                goto saida;
            }
            

        }

        DB::commit();
        $retorno['msg']='Registro atualizado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
        
        saida:
         return $this->retornoJsonDefault($retorno); 
    }
    
} 