<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcParamNatureza;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;

class OrcParamNaturezaController extends Natureza51Ctrl 
{
    public function __construct(){
        $this->repository = new RepoOrcParamNatureza();
        $this->setCodTela('OPN');
        parent::__construct();
    }

    public function listarParamNatureza($orc_id){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $resp = $this->getRepository()->listarAll($orc_id);
        return $this->renderTreeTableList($resp);
    }
    public function insertAll(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $dados = $request->all();
        //dd($dados);
        $dados['created_at'] = $this->fillCriadoEm();
        $resp = $this->getRepository()->inserirParamNatureza($dados);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg'] = 'Erro!';
            goto saida;
        }

        $retorno["status"] = "success";
        $retorno["msg"] = "Registro inserido com sucesso!";
        $retorno["submsg"] = "Sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno);
    }

    public function deleteAll(Request $request){
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $dados = $request->all();
        $resp = $this->getRepository()->deletarParamNatureza($dados);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg'] = 'Erro!';
            goto saida;
        }

        $retorno["status"] = "success";
        $retorno["msg"] = "Registro deletado com sucesso!";
        $retorno["submsg"] = "Sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno);
    }
    function renderTreeTableList($dados){
        //dd($dados);
        $columns_base = [ 
            ["field_out"=>"id", "from"=>"id"],   
            ["field_out"=>"evento_principal_id", "from"=>"evento_principal_id"],
            ["field_out"=>"cta_contabil_id", "from"=>"cta_contabil_id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"hash_id", "from"=>"hash_id"],
            ["field_out"=>"ordem_execucao", "from"=>"ordem_execucao"],
            ["field_out"=>"handle_sql", "from"=>"handle_sql"],
            ["field_out"=>"handle_arguments", "from"=>"handle_arguments"],
            
            ["field_out"=>"modify_by", "from"=>"modify_by"],
            ["field_out"=>"cdn_event", "from"=>"cdn_event"],
            ["field_out"=>"des_event", "from"=>"des_event"],
            ["field_out"=>"cod_cta_ctbl", "from"=>"cod_cta_ctbl"],
            ["field_out"=>"desc_cta_ctbl", "from"=>"desc_cta_ctbl"],
            ["field_out"=>"description_evento", "from"=>"description_evento"],
            ["field_out"=>"description_cta_ctb", "from"=>"description_cta_ctb"],
            ["field_out"=>"base_recisao", "from"=>"base_recisao"],
            ["field_out"=>"des_base_recisao", "from"=>"des_base_recisao"],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"usa_eventos_adicionais", "from"=>"usa_eventos_adicionais"],
            ["field_out"=>"des_usa_eventos_adicionais", "from"=>"des_usa_eventos_adicionais"],
            // ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            // ["field_out"=>"atualizado_data", "from"=>"atualizado_data"],
            ["field_out"=>"criado_data", "from"=>"criado_data","render_value"=>function($row_data, $value){
                return formataData($value);
            }],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],
            ["field_out"=>"criado_em", "from"=>"criado_em"]
        ];
        
        
        $settings=["columns"=>$columns_base,
               "keys"=>['hash_id', 'evento_principal_id', 'cta_contabil_id', 'orcamento_id'] 
            ];    
           
        $controller = new AtmTreeTable($settings, $dados);
       
        return $controller->render();
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'ParametrosNatureza', ['criado_por','criado_data','evento_principal_id','cta_contabil_id', 'orcamento_id','hash_id','handle_sql', 'modify_by', 'cdn_event', 'des_event','desc_cta_ctbl', 'cod_cta_ctbl', 'base_recisao', 'usa_eventos_adicionais']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
        
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("description cta ctb", "Conta contábil", $colunas[$i]);
            $colunas[$i] = str_replace("description evento", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("handle arguments", "Argumento", $colunas[$i]);
            $colunas[$i] = str_replace("ordem execucao", "Ordem de execução", $colunas[$i]);
            $colunas[$i] = str_replace("des base recisao", "Base rescisão", $colunas[$i]);
            $colunas[$i] = str_replace("des usa eventos adicionais", "Usa eventos adicionais", $colunas[$i]);


        }
        return $colunas;
    }
    public function inserirSequencia(Request $request){
        $dados = $request->all(); 
        
        $resp = $this->getRepository()->inserirSequenciaExecucao($dados);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro!';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $retorno['status'] = 'success';
        $retorno['submsg'] = 'Sucesso!';
        $retorno['msg'] = 'Sequências inseridas com sucesso!';

        saida:

        return $this->retornoJsonDefault($retorno);
    }
    public function listToSequenciaExecucao($orc_id){
        $resp = $this->getRepository()->listarToSequencia($orc_id);
        return $resp;
    }
    public function updateBaseRecisao(Request $dados){
        $data = $dados->all();
        $resp = $this->getRepository()->updateBaseRecisao($data);
        $retorno = [];

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro!';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
        }
        else{
            $retorno['status'] = 'success';
            $retorno['submsg'] = 'Sucesso';
            $retorno['msg'] = 'Registro atualizado com sucesso!';
        }
        return $this->retornoJsonDefault($retorno);
    }

    public function updateEvtAdc(Request $dados){
        $data = $dados->all();
        $resp = $this->getRepository()->updateEvtAdc($data);
        $retorno = [];

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro!';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
        }
        else{
            $retorno['status'] = 'success';
            $retorno['submsg'] = 'Sucesso';
            $retorno['msg'] = 'Registro atualizado com sucesso!';
        }
        return $this->retornoJsonDefault($retorno);
    }
} 