<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcParamNaturezaEventoAd;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;

use App\Modules\Natureza51\Entities\OrcParamNatureza;


class OrcParamNaturezaEventoAdController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository=new RepoOrcParamNaturezaEventoAd();
        parent::__construct();
    }
    public function listarOrcParamNatEvtAd($orc_id){
        $resp = $this->getRepository()->listarAll($orc_id);
        return $this->renderTreeTableList($resp);
    }
    public function inserirOrcParamNatEvtAd(Request $request,$orc_id){
        $opne = new OrcParamNatureza();
       
        $dados = $request->all();
        $dados['orcamento_id'] = $orc_id;
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
        $empresa_id = $decrypted['token']['empresa_id'];
        unset($dados['_token']);
        unset($dados['orcamento_id']);
        
        $retorno['status'] = '';
        $retorno['msg'] = '';
        $retorno['submsg'] = '';

        for($i = 0; $i < count($dados); $i++){
            $dados[$i]['created_at'] = $this->fillModificadoEm();
            $dados[$i]['created_by'] = $this->fillModificadoPor();
            
            $resp = $this->getRepository()->insertDados($dados[$i], $empresa_id);
            if(!$resp){
                $retorno['status'] = 'error';
                $retorno['msg'] = $retorno['msg'].'<br>Falha ao cadastrar o Evento de código '.$dados[$i]['cod_evento'].'. <br>'.$this->getRepository()->getErrosFlatted();
                $retorno['submsg'] = 'Erro!';
                continue;
            }

        }
        if($retorno['status'] == 'error'){
            goto saida;
        }
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro inserido com sucesso!';
        $retorno['submsg'] = 'Sucesso!';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function deletarOrcParamNatEvtAd(Request $request){
        $dados = $request->all();
        unset($dados['_token']);
        
        for($i = 0; $i < count($dados); $i++){
            
            $resp = $this->getRepository()->deleteDados($dados[$i]['id_param_natureza_event_ad']);
            if(!$resp){
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Falha ao excluir o Evento <br><b>'.$dados[$i]['description'].'</b><br>'.$this->getRepository()->getErrosFlatted();
                $retorno['submsg'] = 'Erro!';
                goto saida;
            }
        }
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro deletado com sucesso!';
        $retorno['submsg'] = 'Sucesso!';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function updateOrcParamNatEvtAd(Request $request){
        $dados = $request->all();
        $resp = $this->getRepository()->updateDados($dados);
        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Erro!';
            goto saida;
        }
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro atualizado com sucesso!';
        $retorno['submsg'] = 'Sucesso!';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function listarEventoParamNatureza($orc_id){
        $resp = $this->getRepository()->listarOrcParamNatureza($orc_id);
        return $resp;
    }
    function renderTreeTableList($dados){
        //dd($dados);
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],   
            ["field_out"=>"cod_evento", "from"=>"cod_evento"],
            ["field_out"=>"description", "from"=>"description"],
            ["field_out"=>"empresa_id", "from"=>"empresa_id"],
            ["field_out"=>"evento_id", "from"=>"evento_id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"hash_id", "from"=>"hash_id"],
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orc_param_natureza_id", "from"=>"orc_param_natureza_id"],
            ["field_out"=>"desc_cta_ctbl", "from"=>"desc_cta_ctbl"],
            ["field_out"=>"cod_cta_ctbl", "from"=>"cod_cta_ctbl"],
            ["field_out"=>"description_conta", "from"=>"description_conta"]
        ];
     
        $settings = ["columns"=>$columns_base,
            "keys"=>['id','cod_evento','cod_cta_ctbl'] 
        ];    
        $controller = new AtmTreeTable($settings, $dados);
        return $controller->render();
   }
   public function listarEvento($orc_id){
       return $this->getRepository()->eventosParamNatureza($orc_id);
   }
}