<?php
namespace App\Modules\Natureza51\Http\Controllers;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoOrcParametros as RepoOrcParametros;
use DB;
use Illuminate\Http\Request as Request;

class OrcParametrosController extends OrcamentoController
{    
    public function __construct(){ 
        $this->setCodTela('PAR');
        parent::__construct();
        $this->repository=new RepoOrcParametros();
    }  

    public function getOrcParams($orc_id){
        $this->setCodTela('PAR');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->getOrcParams($orc_id);
    }

    public function salvarParametros(Request $request){
        $this->setCodTela('PAR');
        $this->podeAcessar('inserir',true,$this->getCodTela());
        
        $retorno=$this->getArrayRetornoDefault();
        $form_data = $request->all();

        
        if(!$this->getRepository()->salvarParametros($form_data)){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['subsmg']='Falha ao inserir o registro. Erro: 270320201337';
            goto saida;
        }  

        
        $retorno["status"]="success";
        $retorno["msg"]="Parâmetros salvos com sucesso!";

        saida:
         return $this->retornoJsonDefault($retorno);
    }

    public function listarParametroAuditoria($orc_id){
        $resp = $this->getRepository()->parametroAuditoria($orc_id);
        return $resp;
    }
} 
