<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcPpr as RepoOrcPpr;
use App\Modules\Natureza51\Entities\OrcPpr;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;
use \App\Core\Traits\ErrorTrait;
use DB;
use Carbon\Carbon;
use Illuminate\Http\Response;
use Excel;

class OrcPprController extends Natureza51Ctrl
{
     public function __construct(){
        
        $this->repository=new RepoOrcPpr();
        parent::__construct();
    }
    public function listAll($id){
        $data = $this->getRepository()->listar($id);
        
        $cont = count($data);
        for ($i=0; $i < $cont ; $i++) { 
            
            array_push($data,array('parent'=>$data[$i]['grade_salarial'],'grade_salarial'=>null));

            if($data[$i]['updated_at']!=null){
                $data[$i]['atualizado']='Sim';
            }else{
                $data[$i]['atualizado']='Não';
            }

        }
        $result_aux = $this->montarTreetable($data);
        $result = [];
        foreach($result_aux as $parent){
            $num_sal_iguais = true;
            $num_sal_ant = null;
            $porcentagem_iguais = true;
            $porcentagem_ant =null;

            foreach( $parent['children'] as $child){
                
                if($num_sal_ant != $child['data']['num_sal'] && !is_null($num_sal_ant)){
                    $num_sal_iguais = false;
                 
                }
                if($porcentagem_ant != $child['data']['porcentagem'] && !is_null($porcentagem_ant)){
                    $porcentagem_iguais = false;
                   
                }
                $num_sal_ant = $child['data']['num_sal'];
                $porcentagem_ant = $child['data']['porcentagem'];

               
            }
            if($num_sal_iguais){
                $parent['data']['num_sal'] = $num_sal_ant;
            }
            if($porcentagem_iguais){
                $parent['data']['porcentagem'] = $porcentagem_ant;
            }
            array_push($result,$parent);


        }
        return $result ;
    }    
    public function listarPPR($orc_id, $periodo = null, $tipo_table = 'O'){
        $data = $this->getRepository()->listar($orc_id, $periodo, $tipo_table);   
        $cont = count($data);
        for ($i=0; $i < $cont ; $i++) { 
            $data[$i] = (array) $data[$i];
            $data[(count($data))+$i] = array('parent'=>$data[$i]['grade_sal'],'grade_sal'=>null); 

        }

        return $this->montarTreetable($data);
        // dd("depoooois", $this->montarTreetable($data));
        // $result_aux = $this->montarTreetable($data);
    }
    public function insertPPR(Request $request, $orc_id){
        $this->podeAcessar('inserir',true,'PPR');
        $form_data = $request->all();
        $num_sal = str_replace(',', '.', str_replace('.', '', $form_data['num_salarial']));
        $cargos_excessoes = $form_data['cargos_excessoes'];
        $cargos_excessoes_ids = array_column($cargos_excessoes, 'cargo_id');
        $lotacoes = $form_data['lotacoes'];
        $orc_lotacao_ids = array_column($lotacoes, 'id');
        $grades = $form_data['grades'];
        $mes_base = $form_data['mes_base'];

        if(count($orc_lotacao_ids) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione as lotações para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 240520202257';
            goto saida;               
        }

        if(count($grades) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione os grades salariais para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 240520202257';
            goto saida;               
        }

        $lotacs = '';
        foreach ($orc_lotacao_ids as $orcs) {
            $lotacs = $lotacs . $orcs . ',';
        }
        $lotacs = substr($lotacs,0, strlen($lotacs)-1);

        $grades_condition = '';
        foreach ($grades as $grade) {
            $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
        }
        $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);

        if(count($cargos_excessoes_ids) > 0){
            $cargs_exc_condition = 'and c.id not in(';
            foreach ($cargos_excessoes_ids as $id) {
                $cargs_exc_condition = $cargs_exc_condition . $id . ',';
            }
            $cargs_exc_condition = substr($cargs_exc_condition,0, strlen($cargs_exc_condition)-1);
            $cargs_exc_condition = $cargs_exc_condition . ')';
        }
        else{
            $cargs_exc_condition = '';
        }

        $tipo_table = $form_data['tipo_table'];
        $periodo = $form_data['periodo'];

        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}'" : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";

        $data = DB::select("SELECT
            oc.id as cargo_id,
            ocas.lotacao_id as lotacao_id
            from tbl_orc_cargos_area_sal as ocas
            inner join tbl_orc_cargo oc on oc.id = ocas.cargo_id {$condicao[1]}
            inner join tbl_cargo c on c.id = oc.cargo_id
            where ocas.orcamento_id = $orc_id
            and ocas.lotacao_id in ($lotacs)
            $cargs_exc_condition
            and ($grades_condition)".$condicao[0]
        );

        $data_insert = [];

        foreach ($data as $item) {            
            $data_compare = [  
                'orc_id'    =>$orc_id,
                'cargo_id'  =>$item->cargo_id,
                'orc_lot_id'=>$item->lotacao_id,
                'tipo_table'=>$tipo_table
            ];
            if($tipo_table == 'F'){
                $data_compare['periodo'] = $periodo;
            }

            $existe = OrcPpr::where($data_compare)->get();
            if(count($existe) != 0){
                continue;
            }
            $data_aux = array_merge($data_compare, [
                'num_sal'   =>$num_sal,
                'mes_base'  =>$mes_base
            ]);

            array_push($data_insert, $data_aux);
        }
        
        $data_inserir =[];

    

        $has_error = false;
        //dd($data_insert);
        DB::transaction(function () use ($data_insert, $data_inserir, &$retorno) {
            $j=0;
            for($i=0; $i < count($data_insert); $i++){
                $j++;
                $data_insert[$i]['created_at'] = $this->fillCriadoEm();
                $data_insert[$i]['created_by'] = $this->fillCriadoPor();
                $data_insert[$i]['empresa_id'] = $this->fillCodEmpresa();
                $data_insert[$i]['user_id'] = $this->fillCriadoPor();
                array_push($data_inserir,$data_insert[$i]);
                
                //if($j == 10) dd($data_inserir);
                
                /*if($j==300 || $i==count($data_insert)-1){
                    if(!OrcPpr::insert($data_inserir)){ 
                        $retorno["status"]="error";
                        $retorno['msg'] = "Falha ao inserir PR";
                        $retorno['submsg']='Falha ao fazer insert do registro. Erro: 220520200031';
                        $has_error = true;
                        abort (500,"Falha ao inserir PR");            
                    }
                    $data_inserir = [];
                    $j=0;
                    
                }*/
            }

            $dados_chunk = array_chunk($data_inserir, 50);

            for($i = 0; $i < count($dados_chunk); $i++){
                if(!OrcPpr::insert($dados_chunk[$i])){ 
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao inserir PR";
                    $retorno['submsg']='Falha ao fazer insert do registro. Erro: 220520200031';
                    $has_error = true;
                    abort (500,"Falha ao inserir PR");            
                }
                // $data_inserir = [];
                // $j=0;
            }
            

        });    
        if($has_error){
            goto saida;
        }





        $retorno["status"]="success";
        $retorno["msg"]="Registro inserido com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 

    }
    public function updateBonus(Request $request, $orc_id){  
        $this->podeAcessar('editar',true,'PPR');
        $data = $request->all();
        unset($data['_token']);
        if(!$this->getRepository()->updateBonus($orc_id, $data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 210520200817';
            goto saida;                
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    }
    public function deletePpr(Request $request,$orc_id){  
        $this->podeAcessar('deletar',true,'PPR');
        $data = $request->all();

        if(!$this->getRepository()->deletePpr($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 210520200818';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 
    public function deletePprSeveral(Request $request,$orc_id){  
        $this->podeAcessar('deletar',true,'PPR');
        $data = $request->all(); 
        unset($data['_token']); 

        // dd('rasdsadknsakldj', $data);


        for($i=0; $i<count($data);$i++){
            
            if(!$this->getRepository()->deletePpr($orc_id,$data[$i])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 210520200818';
                goto saida;               
            }
        }

        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
    
        return $this->retornoJsonDefault($retorno); 
    }     
    public function dataFilterBonus($data){
        $array_orcamento=['des_cargo_basic', 'cod_cargo_basic', '_token','grade_salarial','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, $array_orcamento);  
               
        return $filtered;
    }    
    public function getCargoByGrade(Request $request, $orc_id){
        $all = $request->all();
        unset($all['_token']);

        $data = $this->repository->getCargoByGrade($all, $orc_id);
        

        for ($i=0; $i < count($all); $i++) { 
            $data[(count($data))+$i] = array('parent'=>$all[$i],'grade_salarial'=>null); 
        }
        return $this->montarTreetable($data);
    }
    public function getCargosExcessao(Request $request, $orc_id){
        $grades = $request->all()['grades'];
        $lotacoes = $request->all()['lotacoes'];
        $periodo = $request->all()['periodo'];
        $tipo_table = $request->all()['tipo_table'];
        

        $orc_lotacao_ids = array_column($lotacoes, 'id');
        $lotacs = '';
        foreach ($orc_lotacao_ids as $orcs) {
            $lotacs = $lotacs . $orcs . ',';
        }
        $lotacs = substr($lotacs,0, strlen($lotacs)-1);
        $grades_condition = '';
        foreach ($grades as $grade) {
            $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
        }
        $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);

        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}'" : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";
        
        $data = DB::select("SELECT
            DISTINCT(c.id) as cargo_id, 
            c.des_cargo_basic, 
            c.cod_cargo_basic,
            CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as description 
            from tbl_orc_cargos_area_sal as ocas
            inner join tbl_orc_cargo as oc on oc.id = ocas.cargo_id".$condicao[1]."
            inner join tbl_cargo as c on c.id = oc.cargo_id
            where ocas.orcamento_id = $orc_id
            and ocas.lotacao_id in ($lotacs)
            and ($grades_condition)".$condicao[0]
        );

        return $data;
    }
    public function montarTreetable($data){

        $column_fixeds=[ 
            ["field_out"=>"parent", "from"=>"parent","render_value"=>null],
            ["field_out"=>"grade_sal", "from"=>"parent", "render_value"=>null,],
        ];
        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            ["field_out"=>"mes_base", "from"=>"mes_base", "render_value"=>null,],
            ["field_out"=>"num_sal","from"=>"num_sal", "render_value"=>null,],
            ["field_out"=>"grade_sal","from"=>"cod_cargo", "render_value"=>null,],
            ["field_out"=>"orc_lotacao_id","from"=>"orc_lotacao_id", "render_value"=>null,],
            ["field_out"=>"lotacao","from"=>"lotacao", "render_value"=>null,],

            ["field_out"=>"criado_por","from"=>"criado_por", "render_value"=>null,],
            ["field_out"=>"criado_em","from"=>"criado_em", "render_value"=>null,],
            ["field_out"=>"atualizado_por","from"=>"atualizado_por", "render_value"=>null,],
            ["field_out"=>"atualizado_em","from"=>"atualizado_em", "render_value"=>null,],
        ];


        $settings=["columns"=>$column_fixeds,
        "keys"=>['parent'],
        "filter_data"=>['grade_sal'=>function($value){
            return is_null($value);
        }],                        
        "children"=>["columns"=>$column_fixeds_children,
                "keys"=>['grade_sal','id'],
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                 }],
                'parent_filter'=> function($value, $parent_data){      
                        return $value['grade_sal']== $parent_data['parent'] ;
                },
            ] 
        ];

        $controller=new AtmTreeTable($settings, $data);
        return $controller->render();
    }
      public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'PR', ['orc_lotacao_id']);
    }
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("grade sal", "Cód. Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("mes base", "Mês base", $colunas[$i]);
            $colunas[$i] = str_replace("num sal", "Num. Sal.", $colunas[$i]);
            $colunas[$i] = str_replace("lotacao", "Lotação", $colunas[$i]);




        }
        return $colunas;
    }

    public function populaPPRHeadcount(Request $request){
        $usuario_id = $this->fillModificadoPor();
        set_time_limit(1200);
        
        $value  = 'Falha ao inserir registros na tela PPR! Erro: 020920200931';
        $dados = $request->all();
        $orc_id = $dados['orc_id'];
        
        if($dados['tipo'] == 0){
            $resp = $this->getRepository()->atualizaPr($orc_id, $dados['periodo'], $dados['tipo_table']);
            if($resp === false){
                $retorno["status"] = "error";
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                goto saida;
            }
            if($resp === 'warning'){
                $retorno["status"] = 'warning';
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['submsg'] = "Atençãos";
                goto saida;
            }
            $retorno["status"] = $this->getRepositoryOrModel()->getErrosFlatted() != '' ? $retorno['status'] : "success";
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted() != '' ? $retorno['msg'] : "Registro(s) inserido(s) com sucesso!";
            $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted() != '' ? $retorno['submsg'] : 'Sucesso!';
            goto saida;
        }
        
        DB::beginTransaction();

        try {
            
            if($dados['tipo_table'] == 'F'){
                
                $sql="EXEC sp_hnd_atualiza_headcount_ppr_forecast :p_orcamento_id, :periodo, :tipo_table, :usuario_id";
                $stmt=DB::getPdo()->prepare($sql);
    
                $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':periodo', $dados['periodo'], \PDO::PARAM_STR );
                $stmt->bindParam(':tipo_table', $dados['tipo_table'], \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
                
                if(!$stmt->execute()){
                    
                    $retorno["status"]="error";
                    $retorno['msg'] = $this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 060120211809 | sp_hnd_atualiza_headcount_ppr_forecast';
                    goto saida;
                }
            }
            else{
                $sql="EXEC sp_hnd_atualiza_headcount_ppr :p_orcamento_id, :usuario_id";
                $stmt=DB::getPdo()->prepare($sql);

                $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
                
                if(!$stmt->execute()){
                    
                    $retorno["status"]="error";
                    $retorno['msg'] = $this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 020920200931 | sp_hnd_atualiza_headcount_ppr';
                    goto saida;
                }
            }
            

            $retorno["status"] = "success";
            $retorno["submsg"] = "Sucesso!";
            $retorno["msg"] = "Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao atualizar registro. Erro: 020920200931 - ' . 'sp_hnd_atualiza_headcount_ppr';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }



// getCargosExcessao(){
    
// }





















} 
