<?php
namespace App\Modules\Natureza51\Http\Controllers;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoOrcPremissas as RepoOrcPremissas;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\CalcOrcamento as CalcOrcamento;
use App\Modules\Natureza51\Entities\OrcPromocao as OrcPromocao;

use Illuminate\Http\Request as Request;

class OrcPremissasController extends OrcamentoController
{
    
   public function __construct(){
        $this->setCodTela('PREM');
        parent::__construct();
        $this->repository=new RepoOrcPremissas();
    } 
    // public function listar(){
    //     $this->setCodTela('PREM');
    //     $this->podeAcessar('listar',true,$this->getCodTela());
    //     return $this->repository->listar();
    // }

    public function getObservacoes($orcamento_id){        
        $this->setCodTela('PREM');
        
        $this->podeAcessar('listar',true,$this->getCodTela());
        $observacoes = $this->getRepository()->getObservacoes($orcamento_id);
        return $observacoes;
    }

    public function salvar(Request $request){
        $this->setCodTela('PREM');
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $data_request = $request->all();        

        $data_request = [
            'observacao1' => $data_request['observacao1'],
            'observacao2' => $data_request['observacao2'],
            'orcamento_id' => $data_request['orcamento_id'],
        ];

        $observacoes = $this->getRepository()->getObservacoes($data_request['orcamento_id']);

        if(!is_null($observacoes)){
            $retorno=$this->getArrayRetornoDefault();

            $id=$observacoes['id']; 

            $this->getRepository()->form_rules['orcamento_id'] = 'required|exists:tbl_orcamento,id|unique:tbl_orc_premissas,id,' . $id; 

            if(! $this->getRepositoryOrModel()->update($data_request, $id)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao atualizar o registro. Erro: 021220191843.';
                goto saida;
            }
            
            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";
            
            saida:
            return $this->retornoJsonDefault($retorno);
        }
        return parent::insert($request);
    }

} 
