<?php
namespace App\Modules\Natureza51\Http\Controllers;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoOrcPromocao as RepoOrcPromocao;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Support\TreeTable\AtmTreeTable;
use DB;
use Illuminate\Http\Request as Request;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use Illuminate\Support\Facades\DB as FacadesDB; 

class OrcPromocaoController extends OrcamentoController
{
    
    public function __construct(){
        $this->setCodTela('PROM');
        parent::__construct();
        $this->repository=new RepoOrcPromocao();
    }  
    public function listar(){
        return $this->getRepository()->listar();
    }
    public function listarByLotacao($orc_id,$lotacao_id,$tipo_table){
        $this->setCodTela('PROM');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->montaTreetable($this->getRepository()->listarByLotacao($orc_id,$lotacao_id,$tipo_table));
    }
    public function listarByLotacaoForecast($lotacao_id, $orc_id, $periodo, $tipo_table){
        $tipo_table == 'O' ? $this->setCodTela('PROM') : $this->setCodTela('FPROM');
        $this->podeAcessar('listar',true,$this->getCodTela());
        
        return $this->montaTreetable($this->getRepository()->listarByLotacao($orc_id, $lotacao_id, $tipo_table, $periodo));
    }
    public function insert(Request $request){
        set_time_limit(720);
        $this->setCodTela('PROM');
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $form_data = $request->all();
        // $meses = $this->dataFilterMesesCalcOrcamento($form_data);
        
        $data = $this->dataFilterPromocao($form_data);
        
        $retorno = $this->getRepository()->insertPromocao($data);
        
        return $this->retornoJsonDefault($retorno);
    }
    public function insertForecast(Request $request){
        
        $form_data = $request->all();
        if($form_data['tipo_table'] == 'F'){
            $this->setCodTela('FPROM');
            
            if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
                $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201532';
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';

                return $this->retornoJsonDefault($retorno);
            }
        }
        else{
            $this->setCodTela('PROM');
        }
        $this->podeAcessar('inserir',true,$this->getCodTela());
        // $meses = $this->dataFilterMesesCalcOrcamento($form_data);
        $data = $this->dataFilterPromocao($form_data);
        
        $retorno = $this->getRepository()->insertPromocaoForecast($data);
        
        return $this->retornoJsonDefault($retorno);
    }
    public function update(Request $request){  
        set_time_limit(720);                                                                                                                                                                                        
        $data = $request->all();
        
        $form_data = Arr::except($data, ['criado_em','criado_por','atualizado_por','atualizado_em']);
        if($form_data['tipo_table'] == 'F'){
            $this->setCodTela('FPROM');
            if($this->canCRUDForecast($form_data['lotacao_id_atual'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
                $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201540';
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';

                return $this->retornoJsonDefault($retorno);
            }
        }
        else{
            $this->setCodTela('PROM');
        }
        $this->podeAcessar('editar',true,$this->getCodTela());
        
        $id=$form_data['id'];
        $meses = $this->dataFilterMesesCalcOrcamento($form_data); 
        $data = $this->dataFilterPromocao($form_data);
        $meses = convertDecimalEn($meses);
        
        $dados = Arr::except($data, ['description_lotacao_origem','lotacao_mostrar']);
        FacadesDB::beginTransaction();
        try {
        
            if($form_data['mes_promocao']>12 or $form_data['mes_promocao']<1){
                $retorno["status"]="error";
                $retorno['submsg'] = 'Erro';
                $retorno['msg']='Digite números de 1 a 12(Janeiro a Dezembro)';
                goto saida;  
            }

            if(!$this->getRepository()->update($dados, ['id'=>$id])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191601';
                goto saida;               
            }
        } catch (\Exception $e) {
            FacadesDB::rollBack();
            abort(500,'Falha ao atulizar registro no orçamento. Erro: 021220181942.'.$e);
        }
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
        ($retorno['status'] == 'error')? FacadesDB::rollBack() : FacadesDB::commit();    

        return $this->retornoJsonDefault($retorno); 

    } 
    public function delete(Request $request){           
        set_time_limit(720);
        $this->setCodTela('PROM');
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $form_data = $request->all();
        $retorno = $this->getRepository()->deletePromocao($form_data['id']);
        return $this->retornoJsonDefault($retorno);
    }
    public function deleteForecast(Request $request){  
        
        $form_data = $request->all();
        if($form_data['tipo_table'] == 'F'){
            $this->setCodTela('FPROM');
            
            if($this->canCRUDForecast($form_data['lotacao_id_atual'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
                $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201545';
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';

                return $this->retornoJsonDefault($retorno);
            }
        }
        else{
            $this->setCodTela('PROM');
        }
        $this->podeAcessar('deletar',true,$this->getCodTela());
        
        $retorno = $this->getRepository()->deletePromocaoForecast($form_data['id']);
        return $this->retornoJsonDefault($retorno);
    }
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['ccusto_id','cargo_promovido_id','turma_promovida_id','turma_atual_id','cargo_atual_id','cargo_id','lotacao_id','des_cargo_basic','field','funcionario_id', 'orc_id', 'lotacao_ancestral_id','lotacao_corrente_id','cargo_ancestral_id', 'cargo_corrente_id','table','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','id','origem_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterPromocao($data){
        $array_orcamento=['field','table','des_cargo_basic','jan_orcado','cargo_id', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id', 'description_lotacao_promovida'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function montaTreetable($data){
        // dd("cvxcv",$data);
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_promovido_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"tipo_table", "from"=>"tipo_table", "render_value"=>null,],            
            ["field_out"=>"description_lotacao_origem", "from"=>"description_lotacao_origem", "render_value"=>null,],
            ["field_out"=>"description_turma","field_out"=>"description_turma", "render_value"=>function(){ return "";},],
            ["field_out"=>"description_turma_promovido","from"=>"description_turma_promovido", "render_value"=>function(){ return "-";},],

            ["field_out"=>"description_cargo", "from"=>"description_cargo", "render_value"=>null,], 
            // ["field_out"=>"description_cargo", "render_value", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_cargo_promovido", "render_value"=>function(){ return "-";},],

            ["field_out"=>"description_cargo_promo", "from"=>"description_cargo_promo", "render_value"=>null,],
            ["field_out"=>"description_lotacao", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_lotacao_promovida", "render_value"=>function(){ return "-";},],
           
            ["field_out"=>"description_ccusto", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_ccusto_promovida", "render_value"=>function(){ return "-";},],

            ["field_out"=>"mes_promocao", "render_value"=>function(){ return "-";},],
            ["field_out"=>"cargo_atual_id", "from"=>"cargo_atual_id", "render_value"=>null]
           
            // ["field_out"=>"funcionario",  "from"=>"nome_funcionario", "render_value"=>null,],
            
            
        ];

        $column_fixeds_children=[ 
            // ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            // ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            // ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            // ["field_out"=>"cargo_id", "from"=>"cargo_promovido_id", "render_value"=>null,],
            ["field_out"=>"sub_promocao_id", "from"=>"sub_promocao_id", "render_value"=>null,],           
            ["field_out"=>"funcionario_id", "from"=>"funcionario_id", "render_value"=>null,],
            ["field_out"=>"lotacao_promovida_id", "from"=>"lotacao_promovida_id", "render_value"=>null,],
            ["field_out"=>"turma_promovida_id", "from"=>"turma_promovida_id", "render_value"=>null,],
            ["field_out"=>"cargo_promovido_id", "from"=>"cargo_promovido_id", "render_value"=>null,],
            
            // ["field_out"=>"description_lotacao_origem", "from"=>"description_lotacao_origem", "render_value"=>null,],

            ["field_out"=>"description_cargo_promovido", "from"=>"description_cargo_promovido", "render_value"=>null,],
            // ["field_out"=>"description_cargo", "from"=>"description_cargo", "render_value"=>null,], 
            // ["field_out"=>"description_cargo", "render_value", "render_value"=>function(){ return "-";},],
 
            ["field_out"=>"description_turma", "from"=>"description_turma", "render_value"=>null,],
            ["field_out"=>"description_turma_promovido", "from"=>"description_turma_promovido", "render_value"=>null,],
            ["field_out"=>"description_turma_promovida", "from"=>"description_turma_promovida", "render_value"=>null,],
            ["field_out"=>"description_lotacao", "from"=>"description_lotacao", "render_value"=>null,],
            ["field_out"=>"description_lotacao_promovida", "from"=>"description_lotacao_promovida", "render_value"=>null,],
            ["field_out"=>"description_ccusto_promovida", "from"=>"description_ccusto_promovida", "render_value"=>null,],
            ["field_out"=>"description_ccusto", "from"=>"description_ccusto", "render_value"=>null,],
           
            ["field_out"=>"nome_funcionario","from"=>'nome_funcionario',"render_value"=>null],    
            
            ["field_out"=>"mes_promocao", "from"=>"mes_promocao_desc", "render_value"=>null,],
            ["field_out"=>"mes_promocao", "from"=>"mes_promocao", "render_value"=>null,],

            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null,],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null,],
            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null,],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null,],        

            ["field_out"=>"lotacao_mostrar", "from"=>"lotacao_mostrar", "render_value"=>null,],
            ["field_out"=>"tipo_table", "from"=>"tipo_table", "render_value"=>null,],
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"cargo_atual_id", "from"=>"cargo_atual_id", "render_value"=>null]
            
        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        /*$columns_base = $column_fixeds;
        $columns_children = $column_fixeds_children;*/
        $cargo = "cargo_atual_id"; // cargo_promovido_id
        $settings = [
            "columns" => $column_fixeds,
            "keys" => [$cargo],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children" => [
                "columns" => $column_fixeds_children,
                "keys" => ['id', $cargo],
                "filter_data" => [$cargo => function ($value) {
                    return !is_null($value);
                }],
                'parent_filter' => function ($value, $parent_data) use ($cargo) {

                    $result = ($value[$cargo] == $parent_data[$cargo]);
                    return $result;
                },
                // "children"=>["is_recursive"=>true]

            ]
        ];

        $controller = new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data' => $controller->render()];
        
    }
 
    public function orcFuncCargo($orcamento_id, $func_id, $periodo = null, $tipo_table = 'O'){
        $orc_func = new OrcFuncionario();
        
        $orc_func = OrcFuncionario::where('orcamento_id', $orc_func['orcamento_id'] = $orcamento_id)->where('funcionario_id', $orc_func['funcionario_id'] = $func_id)
        ->where('tipo_table', $tipo_table);

        if($tipo_table == 'F'){
            $orc_func = $orc_func->where('periodo', $periodo)->first();;
        }
        else{
            $orc_func = $orc_func->whereNull('periodo')->first();
        }
       // $cargo = $orc_func['orc_cargo_id'];
       // $turma = $orc_func['orc_turma_id'];
       // $lotacao = $orc_func['orc_lotacao_id'];
       
        $funcionario = json_encode($orc_func);

        return $funcionario;
    }

    public function loadCodCargo($orc_id, $orc_cargo_id) {
        $cod_cargo = DB::select("SELECT LEFT(cod_cargo_basic, 2) as cod_cargo from tbl_orc_cargo orc_cargo
        inner join tbl_cargo cargo on cargo.id = orc_cargo.cargo_id
        where orc_cargo.id = {$orc_cargo_id} and orc_cargo.orcamento_id = {$orc_id}");

        return json_encode($cod_cargo);
    }

    public function insertMultiplaTransferencia($orc_id, Request $request){
        set_time_limit(120);
        $data = $request->all();
       
        $funcionarios = $data['funcs'];
        $tipo_table = array_key_exists('tipo_table', $data) ? $data['tipo_table'] : 'O';
        $periodo = array_key_exists('periodo', $data) ? $data['periodo'] : null;
        $ccusto_destino = $this->getCcustoFromOrcLotacao($data['lotacao_destino_id']);
        $metodos_insert = ['O'=>'insertPromocao', 'F'=>'insertPromocaoForecast'];
        $retorno = $this->getArrayRetornoDefault();
        $erros = [];

        foreach ($funcionarios as $funcionario) {
            $data_origem = $this->getDataOrigemFuncionario($funcionario['id'], $orc_id, $tipo_table, $periodo);
            
            if(!$data_origem){
                $erros[] = [
                    'funcionario_id' => $funcionario['id'],
                    'mensagem' => 'Não encontradas informações de origem.'
                ];
                continue;
            }

            $promocao_origem = array_key_exists('promocao_id', $data_origem) ? $data_origem['promocao_id'] : null;
            if($data_origem['mes_promocao'] >= $data['mes_promocao']){
                $erros[] = [
                    'funcionario_id' => $funcionario['id'],
                    'mensagem' => 'Já existe uma promoção para o mês selecionado ou posterior.'
                ];
                continue;
            }
            $data_insert = [
                'orc_id'=> $orc_id,
                'lotacao_id'=> $data_origem['lotacao_id'],
                'ccusto_id'=> $data_origem['ccusto_id'],
                'cargo_atual_id'=> $data_origem['cargo_id'],
                'cargo_promovido_id'=> $data['cargo_destino_id'],
                'funcionario_id'=> $funcionario['id'],
                'turma_atual_id'=> $data_origem['turma_id'],
                'turma_promovida_id'=> $data['turma_destino_id'],
                'tipo_table'=> $tipo_table,
                'mes_promocao'=> $data['mes_promocao'],
                'lotacao_promovida_id'=> $data['lotacao_destino_id'],
                'lotacao_destino'=> $data['lotacao_destino_id'],
                'ccusto_promovido_id'=> $ccusto_destino,
                'is_secreto'=> 0,
                'periodo'=>$periodo,
                'sub_promocao_id' => $promocao_origem                
            ];
            if(!is_null($promocao_origem)){
                $data_insert['is_sub'] = 1;
            }
            $metodo_insert = $metodos_insert[$tipo_table];
            
            $res = $this->getRepository()->$metodo_insert($data_insert);

            if($res['status'] != 'success'){
                $erros[] = [
                    'funcionario_id' => $funcionario['id'],
                    'mensagem' => $res['msg']
                ];
            }
        }

        if(count($erros) > 0){
            $msg = "Erro ao inserir as promoções para os seguintes funcionários: <br>";
            foreach ($erros as $erro) {
                $msg .= $this->getNomeFuncionarioFromId($erro['funcionario_id']). ': '. $erro['mensagem']."<br>";
            }

            $retorno['status'] = 'error';
            $retorno['msg'] = $msg;
            $retorno['submsg'] = 'Falha ao inserir algumas promoções. Erro 220320211003';
            goto saida;
        }

        $retorno['status'] = 'success';
        $retorno['msg'] = 'Promoções inseridas com sucesso!';
        $retorno['submsg'] = 'Promoções inseridas com sucesso!';

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function getDataOrigemFuncionario($funcionario_id, $orc_id, $tipo_table, $periodo){
        $where_periodo = $tipo_table == 'F' ? " AND periodo = '$periodo' " : ' AND periodo IS NULL ';
        $ultima_promocao = DB::select("select * from tbl_orc_promocao where funcionario_id = $funcionario_id and tipo_table = '$tipo_table' $where_periodo and orc_id = $orc_id and (sub_promocao_id = 0 or sub_promocao_id is null)");
        if(count($ultima_promocao) > 0){
            return [
                'mes_promocao' =>  $ultima_promocao[0]->mes_promocao,
                'cargo_id' =>  $ultima_promocao[0]->cargo_promovido_id,
                'turma_id' =>  $ultima_promocao[0]->turma_promovida_id,
                'lotacao_id' =>  $ultima_promocao[0]->lotacao_promovida_id,
                'ccusto_id' =>  $ultima_promocao[0]->ccusto_promovido_id,
                'promocao_id' =>  $ultima_promocao[0]->id
            ];
        }

        $orc_funcionario = DB::select("select * from tbl_orc_funcionario where funcionario_id = $funcionario_id and tipo_table = '$tipo_table' $where_periodo and orcamento_id = $orc_id");
        if(count($orc_funcionario) > 0){
            return [
                'mes_promocao' =>  0,
                'cargo_id' =>  $orc_funcionario[0]->orc_cargo_id,
                'turma_id' =>  $orc_funcionario[0]->orc_turma_id,
                'lotacao_id' =>  $orc_funcionario[0]->orc_lotacao_id,
                'ccusto_id' =>  $orc_funcionario[0]->ccusto_id,
                'promocao_id' =>  null
            ];
        }

        return false;
    }

    public function getCcustoFromOrcLotacao($orc_lotacao_id){
        $orc_lotacao = DB::select("SELECT * from tbl_orc_lotacao where id = $orc_lotacao_id");
        if(count($orc_lotacao) == 0){
            return NULL;
        }
        return $orc_lotacao[0]->cc_custo_id;
    }

    public function getNomeFuncionarioFromId($func_id){
        $func = DB::select("select * from tbl_funcionario where id = $func_id");
        if(count($func) > 0){
            return $func[0]->nome_funcionario;
        }

        return 'Funcionário não encontrado';
    }

} 
