<?php
namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\OrcResultadosCalc;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoOrcResultadosCalc as RepoOrcResultadosCalc;
use App\Support\TreeTable\AtmTreeTable;
use DB;
use Illuminate\Http\Request as Request;
use Illuminate\Foundation\Http\Middleware\ValidatePostSize as ValidatePostSize;
use Rap2hpoutre\FastExcel\FastExcel;

class OrcResultadosCalcController extends OrcamentoController
{
    
    public function __construct(){
        parent::__construct();
        $this->repository = new RepoOrcResultadosCalc();
        // set_memory_limit
        // dd(ini_get('post_max_size'));
    }
    public function listarRelatorio01(Request $request, $orc_id, $ind, $qtd, $periodo = null, $tipo_table = 'F'){
        // dd("periodo 1", $periodo);
        $this->podeAcessar('listar',true,'RLCOA');
        $resp = $this->repository->relatorioO1($orc_id, $ind, true, $qtd, $this->montaClausula($request->all()), $periodo, $tipo_table);
        return $this->montaTreeTable($resp);
    }
    public function listarRelatorio01Totais(Request $request, $orc_id, $ind, $qtd, $periodo = null, $tipo_table = 'F'){
        // dd("periodo 1", $periodo);
        $this->podeAcessar('listar',true,'RLCOA');
        $resp = $this->repository->relatorioO1Totais($orc_id, $ind, true, $qtd, $this->montaClausula($request->all()), $periodo, $tipo_table);
        return $resp;
    }
    public function listarRelatorioQtd(Request $request, $orc_id, $ind, $qtd, $periodo = null, $tipo_table = 'F'){
        $this->podeAcessar('listar',true,'RLCOR');
        //dd("periodo 2", $periodo);
        $resp = $this->getRepository()->relatorioResumidoCalcQtd($orc_id, $ind, true, $qtd, $this->montaClausula($request->all()), $periodo, $tipo_table);
        return $this->montaTreeTableQtd($resp);
    }

    public function listarRelatorioQtdPais(Request $request, $orc_id, $ind, $qtd, $periodo = null, $tipo_table = 'F'){
        // dd('nfdksnfjksdbnfjds');
        $this->podeAcessar('listar',true,'RLCOR');
        $resp = $this->getRepository()->listarCalcQtdPais($orc_id, $ind, true, $qtd, $this->montaClausula($request->all()), $periodo, $tipo_table);
        return $this->montaTreeTableQtd($resp);
    }
    public function listarRelatorioQtdFilhos(Request $request, $orc_id, $periodo = null, $tipo_table = 'F'){
        $this->podeAcessar('listar',true,'RLCOR');
        $resp = $this->getRepository()->listarCalcQtdFilhos($orc_id, $request->all(), $periodo, $tipo_table);
        return $this->montaTreeTableQtdFilhos($resp);
    }

    public function listarPesquisa(Request $request, $orc_id, $ind, $qtd, $periodo = null, $tipo_table = 'F'){
        // dd("periodo 3", $periodo);
        $this->podeAcessar('listar',true,'RLCOA');
        $dados = $request->all();

        $resp = $this->repository->relatorioO1($orc_id, $ind, true, $qtd, $this->montaClausula($dados), $periodo, $tipo_table);
        return $this->montaTreeTable($resp);
    }

    public function listarPesquisaTotais(Request $request, $orc_id, $ind, $qtd, $periodo = null, $tipo_table = 'F'){
        // dd("periodo 3", $periodo);
        if($periodo == 'null'){
            $periodo = null;
        }
        $this->podeAcessar('listar',true,'RLCOA');
        $dados = $request->all();

        $resp = $this->repository->relatorioO1Totais($orc_id, $ind, true, $qtd, $this->montaClausula($dados), $periodo, $tipo_table);
        return $resp;
    }
    public function listarPesquisaQtd(Request $request, $orc_id, $ind, $qtd, $periodo = null, $tipo_table = 'F'){
        //dd("periodo 4", $periodo);
        $this->podeAcessar('listar',true,'RLCOR');
        $dados = $request->all();
        
        $resp = $this->getRepository()->relatorioResumidoCalcQtd($orc_id, $ind, true, $qtd, $this->montaClausula($dados), $periodo, $tipo_table);
        return $this->montaTreeTableQtd($resp);
    }
    public function montaClausula($dados){
        $clausula = '';
        
        if( array_key_exists('ccusto', $dados) && $dados['ccusto'] != null ){
            $clausula = $clausula.'and ( cc.cod_ccusto like(\'%'.$dados['ccusto'].'%\') or cc.des_ccusto like(\'%'.$dados['ccusto'].'%\')) ';
        }
        if( array_key_exists('lotacao', $dados) && $dados['lotacao'] != null ){
            $clausula = $clausula.'and ( lot.unid_lotac like(\'%'.$dados['lotacao'].'%\') or lot.des_unid_lotac like(\'%'.$dados['lotacao'].'%\')) ';
        }
        if( array_key_exists('natureza', $dados) && $dados['natureza'] != null ){
            $clausula = $clausula.'and ( ctactb.cod_cta_ctbl like(\'%'.$dados['natureza'].'%\') or ctactb.desc_cta_ctbl like(\'%'.$dados['natureza'].'%\')) ';
        }
        if( array_key_exists('event', $dados) && $dados['event'] != null ){
            $clausula = $clausula.'and ( evento.cdn_event like(\'%'.$dados['event'].'%\') or evento.cdn_event like(\'%'.$dados['event'].'%\')) ';
        }
        if( array_key_exists('cargo', $dados) && $dados['cargo'] != null ){
            $clausula = $clausula.'and ( carg.cod_cargo_basic like(\'%'.$dados['cargo'].'%\') or carg.des_cargo_basic like(\'%'.$dados['cargo'].'%\')) ';
        }
        return $clausula;
    }
    public function montaTreeTableQtd($data){
        set_time_limit(500);
        $column_fixeds=[ 
            ["field_out"=>"ccontabil_id", "from"=>"ccontabil_id","render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id", "render_value"=>null],
            ["field_out"=>"natureza", "from"=>"CONTA_CONTABIL", "render_value"=>null],
            ["field_out"=>"centro custo", "from"=>"CENTRO_CUSTO", "render_value"=>null],
            ["field_out"=>"lotacao", "from"=>"LOTACAO", "render_value"=>null],
            ["field_out"=>"evento", "from"=>"EVENTO", "render_value"=>function($row_data, $value){
                return "-";
            }],
            ["field_out"=>"cargo", "from"=>"CARGO", "render_value"=>function($row_data, $value){
                return "-";
            }],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],

            // jan_val_orc_total, jan_val_min_total
            ["field_out"=>"jan_val_orc", "from"=>"jan_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jan_val_min", "from"=>"jan_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jan", "from"=>"total_qtd_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jan", "from"=>"total_qtd_inicial_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jan", "from"=>"total_qtd_total_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"fev_val_orc", "from"=>"fev_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_min", "from"=>"fev_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_fev", "from"=>"total_qtd_jan_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_fev", "from"=>"total_qtd_inicial_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_fev", "from"=>"total_qtd_total_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"mar_val_orc", "from"=>"mar_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_min", "from"=>"mar_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mar", "from"=>"total_qtd_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mar", "from"=>"total_qtd_inicial_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mar", "from"=>"total_qtd_total_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"abr_val_orc", "from"=>"abr_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_min", "from"=>"abr_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_abr", "from"=>"total_qtd_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_abr", "from"=>"total_qtd_inicial_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_abr", "from"=>"total_qtd_total_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"mai_val_orc", "from"=>"mai_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mai_val_min", "from"=>"mai_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mai", "from"=>"total_qtd_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mai", "from"=>"total_qtd_inicial_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mai", "from"=>"total_qtd_total_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"jun_val_orc", "from"=>"jun_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_min", "from"=>"jun_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jun", "from"=>"total_qtd_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jun", "from"=>"total_qtd_inicial_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jun", "from"=>"total_qtd_total_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"jul_val_orc", "from"=>"jul_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_min", "from"=>"jul_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jul", "from"=>"total_qtd_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jul", "from"=>"total_qtd_inicial_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jul", "from"=>"total_qtd_total_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"ago_val_orc", "from"=>"ago_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"ago_val_min", "from"=>"ago_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_ago", "from"=>"total_qtd_ago", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_ago", "from"=>"total_qtd_inicial_ago", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_ago", "from"=>"total_qtd_total_ago", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"set_val_orc", "from"=>"set_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"set_val_min", "from"=>"set_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_set", "from"=>"total_qtd_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_set", "from"=>"total_qtd_inicial_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_set", "from"=>"total_qtd_total_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"out_val_orc", "from"=>"out_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_min", "from"=>"out_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_out", "from"=>"total_qtd_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_out", "from"=>"total_qtd_inicial_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_out", "from"=>"total_qtd_total_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"nov_val_orc", "from"=>"nov_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_min", "from"=>"nov_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_nov", "from"=>"total_qtd_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_nov", "from"=>"total_qtd_inicial_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_nov", "from"=>"total_qtd_total_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"dez_val_orc", "from"=>"dez_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_min", "from"=>"dez_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_dez", "from"=>"total_qtd_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_dez", "from"=>"total_qtd_inicial_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_dez", "from"=>"total_qtd_total_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            

            ["field_out"=>"jan_val_total", "from"=>"jan_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_total", "from"=>"fev_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_total", "from"=>"mar_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_total", "from"=>"abr_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            
            ["field_out"=>"mai_val_total", "from"=>"mai_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_total", "from"=>"jun_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_total", "from"=>"jul_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"ago_val_total", "from"=>"ago_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"set_val_total", "from"=>"set_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_total", "from"=>"out_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_total", "from"=>"nov_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_total", "from"=>"dez_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }]

        ];
        $column_fixeds_children = [ 
            ["field_out"=>"natureza_", "from"=>"CONTA_CONTABIL", "render_value"=>function($row_data, $value){
                return $value;
            }],
            ["field_out"=>"centro custo_", "from"=>"CENTRO_CUSTO", "render_value"=>function($row_data, $value){
                return $value;
            }],
            ["field_out"=>"lotacao_", "from"=>"LOTACAO", "render_value"=>function($row_data, $value){
                return $value;
            }],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null],

            ["field_out"=>"evento", "from"=>"EVENTO", "render_value"=>null],
            ["field_out"=>"event", "from"=>"EVENTO", "render_value"=>null],
            ["field_out"=>"cargo", "from"=>"CARGO", "render_value"=>null],


            ["field_out"=>"jan_val_orc", "from"=>"jan_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jan_val_min", "from"=>"jan_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jan", "from"=>"qtd_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jan", "from"=>"qtd_inicial_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jan", "from"=>"qtd_total_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"fev_val_orc", "from"=>"fev_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_min", "from"=>"fev_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_fev", "from"=>"qtd_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_fev", "from"=>"qtd_inicial_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_fev", "from"=>"qtd_total_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"mar_val_orc", "from"=>"mar_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_min", "from"=>"mar_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mar", "from"=>"qtd_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mar", "from"=>"qtd_inicial_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mar", "from"=>"qtd_total_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"abr_val_orc", "from"=>"abr_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_min", "from"=>"abr_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_abr", "from"=>"qtd_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_abr", "from"=>"qtd_inicial_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_abr", "from"=>"qtd_total_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"mai_val_orc", "from"=>"mai_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mai_val_min", "from"=>"mai_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mai", "from"=>"qtd_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mai", "from"=>"qtd_inicial_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mai", "from"=>"qtd_total_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"jun_val_orc", "from"=>"jun_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_min", "from"=>"jun_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jun", "from"=>"qtd_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jun", "from"=>"qtd_inicial_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jun", "from"=>"qtd_total_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"jul_val_orc", "from"=>"jul_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_min", "from"=>"jul_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jul", "from"=>"qtd_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jul", "from"=>"qtd_inicial_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jul", "from"=>"qtd_total_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"set_val_orc", "from"=>"set_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"set_val_min", "from"=>"set_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_set", "from"=>"qtd_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_set", "from"=>"qtd_inicial_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_set", "from"=>"qtd_total_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"out_val_orc", "from"=>"out_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_min", "from"=>"out_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_out", "from"=>"qtd_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_out", "from"=>"qtd_inicial_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_out", "from"=>"qtd_total_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"nov_val_orc", "from"=>"nov_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_min", "from"=>"nov_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_nov", "from"=>"qtd_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_nov", "from"=>"qtd_inicial_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_nov", "from"=>"qtd_total_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            
            ["field_out"=>"dez_val_orc", "from"=>"dez_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_min", "from"=>"dez_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_dez", "from"=>"qtd_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_dez", "from"=>"qtd_inicial_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_dez", "from"=>"qtd_total_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            //
            ["field_out"=>"jan_val_total", "from"=>"jan_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_total", "from"=>"fev_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_total", "from"=>"mar_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_total", "from"=>"abr_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"mai_val_total", "from"=>"mai_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_total", "from"=>"jun_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_total", "from"=>"jul_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"ago_val_total", "from"=>"ago_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"set_val_total", "from"=>"set_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_total", "from"=>"out_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_total", "from"=>"nov_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_total", "from"=>"dez_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }]
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccontabil_id','ccusto_id','orc_lotacao_id'],
        // "filter_data"=>['ccontabil_id'=>function($value){
        //         return is_null($value);
        //     },'ccusto_id'=>function($value){
        //         return is_null($value);
        //     }
        //     ,'orc_lotacao_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children"=>["columns"=>$column_fixeds_children,
        "keys"=>['ccontabil_id','ccusto_id','orc_lotacao_id'/*,'orc_cargo_id','evento_id'*/],
                "filter_data"=>[
                    'ccontabil_id'=>function($value){
                        return !is_null($value);
                    },
                    'ccusto_id'=>function($value){
                        return !is_null($value);
                    },
                    'orc_lotacao_id'=>function($value){
                        return !is_null($value);
                    }/*,
                    'orc_cargo_id'=>function($value){
                        return !is_null($value);
                    }
                    ,
                    'evento_id'=>function($value){
                        return !is_null($value);
                    }*/
                ],
                'parent_filter'=> function($value, $parent_data){                      
                        $lotacao = ( $value['orc_lotacao_id'] == $parent_data['orc_lotacao_id']);
                        $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                        $ccontabil = ( $value['ccontabil_id'] == $parent_data['ccontabil_id']);
                        return ($lotacao && $ccusto && $ccontabil);
                },
            ] 
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
    public function montaTreeTable($dados){
        set_time_limit(500);
        $columns_base = [ 
            ["field_out"=>"id", "from"=>"id","render_value"=>null],
            ["field_out"=>"ccontabil_id", "from"=>"ccontabil_id","render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id", "render_value"=>null],
            ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null],
            ["field_out"=>"desc_natureza", "from"=>"CONTA_CONTABIL", "render_value"=>null],
            ["field_out"=>"desc_ccusto", "from"=>"CENTRO_CUSTO", "render_value"=>null],
            ["field_out"=>"desc_lotacao", "from"=>"LOTACAO", "render_value"=>null],
            ["field_out"=>"des_event", "from"=>"EVENTO", "render_value"=>null],
            ["field_out"=>"des_cargo", "from"=>"CARGO", "render_value"=>null],

            ["field_out"=>"jan_val_orc", "from"=>"jan_val_orc", "render_value"=>null],
            ["field_out"=>"jan_val_min", "from"=>"jan_val_min", "render_value"=>null],
            ["field_out"=>"jan_qtd", "from"=>"jan_qtd", "render_value"=>null],
            ["field_out"=>"jan_qtd_min", "from"=>"jan_qtd_min", "render_value"=>null],
            ["field_out"=>"jan_val_total", "from"=>"jan_val_total", "render_value"=>null],

            ["field_out"=>"fev_val_orc", "from"=>"fev_val_orc", "render_value"=>null],
            ["field_out"=>"fev_val_min", "from"=>"fev_val_min", "render_value"=>null],
            ["field_out"=>"fev_qtd", "from"=>"fev_qtd", "render_value"=>null],
            ["field_out"=>"fev_qtd_min", "from"=>"fev_qtd_min", "render_value"=>null],
            ["field_out"=>"fev_val_total", "from"=>"fev_val_total", "render_value"=>null],
            
            ["field_out"=>"mar_val_orc", "from"=>"mar_val_orc", "render_value"=>null],
            ["field_out"=>"mar_val_min", "from"=>"mar_val_min", "render_value"=>null],
            ["field_out"=>"mar_qtd", "from"=>"mar_qtd", "render_value"=>null],
            ["field_out"=>"mar_qtd_min", "from"=>"mar_qtd_min", "render_value"=>null],
            ["field_out"=>"mar_val_total", "from"=>"mar_val_total", "render_value"=>null],

            ["field_out"=>"abr_val_orc", "from"=>"abr_val_orc", "render_value"=>null],
            ["field_out"=>"abr_val_min", "from"=>"abr_val_min", "render_value"=>null],
            ["field_out"=>"abr_qtd", "from"=>"abr_qtd", "render_value"=>null],
            ["field_out"=>"abr_qtd_min", "from"=>"abr_qtd_min", "render_value"=>null],
            ["field_out"=>"abr_val_total", "from"=>"abr_val_total", "render_value"=>null],

            ["field_out"=>"mai_val_orc", "from"=>"mai_val_orc", "render_value"=>null],
            ["field_out"=>"mai_val_min", "from"=>"mai_val_min", "render_value"=>null],
            ["field_out"=>"mai_qtd", "from"=>"mai_qtd", "render_value"=>null],
            ["field_out"=>"mai_qtd_min", "from"=>"mai_qtd_min", "render_value"=>null],
            ["field_out"=>"mai_val_total", "from"=>"mai_val_total", "render_value"=>null],

            ["field_out"=>"jun_val_orc", "from"=>"jun_val_orc", "render_value"=>null],
            ["field_out"=>"jun_val_min", "from"=>"jun_val_min", "render_value"=>null],
            ["field_out"=>"jun_qtd", "from"=>"jun_qtd", "render_value"=>null],
            ["field_out"=>"jun_qtd_min", "from"=>"jun_qtd_min", "render_value"=>null],
            ["field_out"=>"jun_val_total", "from"=>"jun_val_total", "render_value"=>null],

            ["field_out"=>"jul_val_orc", "from"=>"jul_val_orc", "render_value"=>null],
            ["field_out"=>"jul_val_min", "from"=>"jul_val_min", "render_value"=>null],
            ["field_out"=>"jul_qtd", "from"=>"jul_qtd", "render_value"=>null],
            ["field_out"=>"jul_qtd_min", "from"=>"jul_qtd_min", "render_value"=>null],
            ["field_out"=>"jul_val_total", "from"=>"jul_val_total", "render_value"=>null],

            ["field_out"=>"ago_val_orc", "from"=>"ago_val_orc", "render_value"=>null],
            ["field_out"=>"ago_val_min", "from"=>"ago_val_min", "render_value"=>null],
            ["field_out"=>"ago_qtd", "from"=>"ago_qtd", "render_value"=>null],
            ["field_out"=>"ago_qtd_min", "from"=>"ago_qtd_min", "render_value"=>null],
            ["field_out"=>"ago_val_total", "from"=>"ago_val_total", "render_value"=>null],

            ["field_out"=>"set_val_orc", "from"=>"set_val_orc", "render_value"=>null],
            ["field_out"=>"set_val_min", "from"=>"set_val_min", "render_value"=>null],
            ["field_out"=>"set_qtd", "from"=>"set_qtd", "render_value"=>null],
            ["field_out"=>"set_qtd_min", "from"=>"set_qtd_min", "render_value"=>null],
            ["field_out"=>"set_val_total", "from"=>"set_val_total", "render_value"=>null],

            ["field_out"=>"out_val_orc", "from"=>"out_val_orc", "render_value"=>null],
            ["field_out"=>"out_val_min", "from"=>"out_val_min", "render_value"=>null],
            ["field_out"=>"out_qtd", "from"=>"out_qtd", "render_value"=>null],
            ["field_out"=>"out_qtd_min", "from"=>"out_qtd_min", "render_value"=>null],
            ["field_out"=>"out_val_total", "from"=>"out_val_total", "render_value"=>null],

            ["field_out"=>"nov_val_orc", "from"=>"nov_val_orc", "render_value"=>null],
            ["field_out"=>"nov_val_min", "from"=>"nov_val_min", "render_value"=>null],
            ["field_out"=>"nov_qtd", "from"=>"nov_qtd", "render_value"=>null],
            ["field_out"=>"nov_qtd_min", "from"=>"nov_qtd_min", "render_value"=>null],
            ["field_out"=>"nov_val_total", "from"=>"nov_val_total", "render_value"=>null],

            ["field_out"=>"dez_val_orc", "from"=>"dez_val_orc", "render_value"=>null],
            ["field_out"=>"dez_val_min", "from"=>"dez_val_min", "render_value"=>null],
            ["field_out"=>"dez_qtd", "from"=>"dez_qtd", "render_value"=>null],
            ["field_out"=>"dez_qtd_min", "from"=>"dez_qtd_min", "render_value"=>null],
            ["field_out"=>"dez_val_total", "from"=>"dez_val_total", "render_value"=>null],

        ];
        $settings = ["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
       $controller = new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }
    public function downloadExcelAnalitico($type, $orc_id, $periodo = null, $tipo_table = 'F', $fieldsDeleteModel = []){
        set_time_limit(700);
        ini_set('memory_limit', '-1');
        $nome = $this->getUserFromCurrentGuard()->nome;
        $this->dados = $this->repository->listarExportar($orc_id, $periodo, $nome, $tipo_table);
        // dd($this->dados);
        return $this->downloadExcel($type, 'RelatorioResultadosCalcAnalitico', []);
    }

    
    public function downloadExcel($type, $filename, $fieldsDeleteModel = []) {
        set_time_limit(700);
        $this->dados = json_decode(json_encode($this->dados), true); 

        $list = collect($this->dados);
        
        $var = (new FastExcel($list))->export($filename.'.csv');
        
        // abre o arquivo colocando o ponteiro de escrita no final 
        ini_set('memory_limit', '-1');
        $arquivo = file_get_contents($filename.'.csv'); 
        $arquivo = mb_convert_encoding("sep=,\n".$arquivo, 'utf-16');

        // $arquivo = mb_convert_encoding("sep=,\n".$arquivo, mb_detect_encoding($arquivo));
        // dd($arquivo);
        file_put_contents($filename.'.csv', $arquivo);


        // $first_line = fgets($arquivo);
        // $string = '';
        // if ($arquivo) { 
        //     while(true) { 
        //         $linha = fgets($arquivo); 
        //         if ($linha==null) break; 
        //         // busca na linha atual o conteudo que vai ser alterado 
        //         // if(preg_match("/".$first_line."/", $linha)) { 
        //             $string .= str_replace($first_line, "sep=; ".$first_line, $linha); 
        //             dd($string);
        //         // } else { 
        //         //     // vai colocando tudo numa nova string 
        //         //     $string.= $linha; 
        //         // } 
        //     } 
        //     // move o ponteiro para o inicio pois o ftruncate() nao fara isso 
        //     rewind($arquivo); 
        //     // truca o arquivo apagando tudo dentro dele 
        //     ftruncate($arquivo, 0); 
        //     // reescreve o conteudo dentro do arquivo 
        //     if (!fwrite($arquivo, $string)) die('Não foi possível atualizar o arquivo.'); 
        //     echo 'Arquivo atualizado com sucesso';
        //     fclose($arquivo); 
        // }                             


        //return '<a href="https://apps2.mrn.com.br:8180/backend_natureza51/producao/public/ResultadosCalc.csv" download="'.$filename.'.csv">Baixar arquivo</a>';
        // return '<a href="https://apps2.mrn.com.br:8180/backend_natureza51/producao/public/'.$filename.'.csv">Baixar arquivo</a>';
        // trocar o href de baixo

        $env = $_ENV;
        // $base = array_key_exists('APP_BASE',$env) ? $env['APP_BASE'] : env("APP_BASE", "producao");
        // $href = $base == 'producao' ?  "https://api2.mrn.com.br:8180/backend_natureza51/public/".$filename.".csv" : "https://apps2.mrn.com.br:8180/backend_natureza51/homologacao/public/".$filename.".csv" ;

        $href_base = array_key_exists('BACKEND_URL',$env) ? $env['BACKEND_URL'] : env("BACKEND_URL", "http://191.23.83.141:9280/natureza51_atualizacao/public/")
        $href = $href_base . $filename . ".csv";

        return '
            <body onafterprint="funcao()">
                <a hidden id="tag_a" href="'.$href.'" download="'.$filename.'.csv">Baixar arquivo</a>
            </body>
            <script type="text/javascript">
                window.onload = function baixar(){
                    let tag = document.getElementById(\'tag_a\');
                    tag.click();
                    setTimeout(()=>{
                        window.close();
                    }, 3000)
                };
            </script>
        ';
        // https://apps2.mrn.com.br:8180/backend_natureza51/producao/public/
        // $collection = (new FastExcel)->configureCsv(';', '#', '\n', 'gbk')->import('file.csv');
    }

    public function formatHeaders($colunas){
        /*for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            
        //     $colunas[$i] = str_replace("desc", "", $colunas[$i]);
        //     $colunas[$i] = str_replace("des", "", $colunas[$i]);
            
            $colunas[$i] = str_replace("lotacao", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("event", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("ccusto", "Centro de Custo", $colunas[$i]);
            $colunas[$i] = str_replace("natureza", "Natureza", $colunas[$i]);

            $colunas[$i] = str_replace(" val orc", " valor unit", $colunas[$i]);
            $colunas[$i] = str_replace(" val min", " valor unit ini", $colunas[$i]);
            $colunas[$i] = str_replace(" qtd", " qtd", $colunas[$i]);
            $colunas[$i] = str_replace(" qtd min", " qtd ini", $colunas[$i]);
            $colunas[$i] = str_replace(" val total", " valor total", $colunas[$i]);
        }*/
        return $colunas;
    }
    public function downloadExcelQuantidades($type, $orc_id, $periodo = null, $tipo_table = 'F', $fieldsDeleteModel = []){
        $nome = $this->getUserFromCurrentGuard()->nome;
        $this->dados = $this->repository->listarExportarQtd($orc_id, $periodo, $nome, $tipo_table);
        $arquivo = $periodo == null ? 'RelatorioResultadosCalcResumido' : 'RelatorioResultadosCalcResumidoForecast';

        return $this->downloadExcel($type, $arquivo, []);
        //return parent::downloadExcel($type, 'RelatorioResultadosCalcResumido',['ccontabil_id','orc_lotacao_id','ccusto_id','desc_natureza','desc_ccusto','desc_lotacao','turno_id,ccusto_id','orc_cargo_id','cargo_atual_id','orc_turma_id','cargo_atual_id','turma_atual_id','orc_cargo_id','evento_id','evento']);
    }//['orc_cargo_id','cargo_atual_id','orc_turma_id','cargo_atual_id','turma_atual_id','orc_cargo_id']

    public function montaTreeTableQtdFilhos($data){
        set_time_limit(500);
        $column_fixeds=[ 
            ["field_out"=>"ccontabil_id", "from"=>"ccontabil_id","render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id", "render_value"=>null],
            ["field_out"=>"natureza", "from"=>"CONTA_CONTABIL", "render_value"=>null],
            ["field_out"=>"centro custo", "from"=>"CENTRO_CUSTO", "render_value"=>null],
            ["field_out"=>"lotacao", "from"=>"LOTACAO", "render_value"=>null],
            ["field_out"=>"evento", "from"=>"EVENTO", "render_value"=>function($row_data, $value){
                return "-";
            }],
            ["field_out"=>"cargo", "from"=>"CARGO", "render_value"=>function($row_data, $value){
                return "-";
            }],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],

            // jan_val_orc_total, jan_val_min_total
            ["field_out"=>"jan_val_orc", "from"=>"jan_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jan_val_min", "from"=>"jan_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jan", "from"=>"total_qtd_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jan", "from"=>"total_qtd_inicial_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jan", "from"=>"total_qtd_total_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"fev_val_orc", "from"=>"fev_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_min", "from"=>"fev_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_fev", "from"=>"total_qtd_jan_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_fev", "from"=>"total_qtd_inicial_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_fev", "from"=>"total_qtd_total_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"mar_val_orc", "from"=>"mar_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_min", "from"=>"mar_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mar", "from"=>"total_qtd_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mar", "from"=>"total_qtd_inicial_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mar", "from"=>"total_qtd_total_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"abr_val_orc", "from"=>"abr_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_min", "from"=>"abr_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_abr", "from"=>"total_qtd_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_abr", "from"=>"total_qtd_inicial_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_abr", "from"=>"total_qtd_total_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"mai_val_orc", "from"=>"mai_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mai_val_min", "from"=>"mai_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mai", "from"=>"total_qtd_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mai", "from"=>"total_qtd_inicial_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mai", "from"=>"total_qtd_total_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"jun_val_orc", "from"=>"jun_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_min", "from"=>"jun_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jun", "from"=>"total_qtd_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jun", "from"=>"total_qtd_inicial_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jun", "from"=>"total_qtd_total_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"jul_val_orc", "from"=>"jul_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_min", "from"=>"jul_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jul", "from"=>"total_qtd_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jul", "from"=>"total_qtd_inicial_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jul", "from"=>"total_qtd_total_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"ago_val_orc", "from"=>"ago_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"ago_val_min", "from"=>"ago_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_ago", "from"=>"total_qtd_ago", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_ago", "from"=>"total_qtd_inicial_ago", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_ago", "from"=>"total_qtd_total_ago", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"set_val_orc", "from"=>"set_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"set_val_min", "from"=>"set_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_set", "from"=>"total_qtd_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_set", "from"=>"total_qtd_inicial_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_set", "from"=>"total_qtd_total_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"out_val_orc", "from"=>"out_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_min", "from"=>"out_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_out", "from"=>"total_qtd_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_out", "from"=>"total_qtd_inicial_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_out", "from"=>"total_qtd_total_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"nov_val_orc", "from"=>"nov_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_min", "from"=>"nov_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_nov", "from"=>"total_qtd_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_nov", "from"=>"total_qtd_inicial_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_nov", "from"=>"total_qtd_total_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],


            ["field_out"=>"dez_val_orc", "from"=>"dez_val_orc_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_min", "from"=>"dez_val_min_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_dez", "from"=>"total_qtd_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_dez", "from"=>"total_qtd_inicial_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_dez", "from"=>"total_qtd_total_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            

            ["field_out"=>"jan_val_total", "from"=>"jan_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_total", "from"=>"fev_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_total", "from"=>"mar_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_total", "from"=>"abr_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            
            ["field_out"=>"mai_val_total", "from"=>"mai_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_total", "from"=>"jun_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_total", "from"=>"jul_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"ago_val_total", "from"=>"ago_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"set_val_total", "from"=>"set_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_total", "from"=>"out_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_total", "from"=>"nov_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_total", "from"=>"dez_val_total", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }]

        ];
        $column_fixeds_children = [ 
            ["field_out"=>"natureza_", "from"=>"CONTA_CONTABIL", "render_value"=>function($row_data, $value){
                return $value;
            }],
            ["field_out"=>"centro custo_", "from"=>"CENTRO_CUSTO", "render_value"=>function($row_data, $value){
                return $value;
            }],
            ["field_out"=>"lotacao_", "from"=>"LOTACAO", "render_value"=>function($row_data, $value){
                return $value;
            }],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null],

            ["field_out"=>"evento", "from"=>"EVENTO", "render_value"=>null],
            ["field_out"=>"event", "from"=>"EVENTO", "render_value"=>null],
            ["field_out"=>"cargo", "from"=>"CARGO", "render_value"=>null],


            ["field_out"=>"jan_val_orc", "from"=>"jan_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jan_val_min", "from"=>"jan_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jan", "from"=>"qtd_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jan", "from"=>"qtd_inicial_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jan", "from"=>"qtd_total_jan", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"fev_val_orc", "from"=>"fev_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_min", "from"=>"fev_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_fev", "from"=>"qtd_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_fev", "from"=>"qtd_inicial_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_fev", "from"=>"qtd_total_fev", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"mar_val_orc", "from"=>"mar_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_min", "from"=>"mar_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mar", "from"=>"qtd_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mar", "from"=>"qtd_inicial_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mar", "from"=>"qtd_total_mar", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"abr_val_orc", "from"=>"abr_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_min", "from"=>"abr_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_abr", "from"=>"qtd_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_abr", "from"=>"qtd_inicial_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_abr", "from"=>"qtd_total_abr", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"mai_val_orc", "from"=>"mai_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mai_val_min", "from"=>"mai_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_mai", "from"=>"qtd_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_mai", "from"=>"qtd_inicial_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_mai", "from"=>"qtd_total_mai", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"jun_val_orc", "from"=>"jun_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_min", "from"=>"jun_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jun", "from"=>"qtd_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jun", "from"=>"qtd_inicial_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jun", "from"=>"qtd_total_jun", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"jul_val_orc", "from"=>"jul_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_min", "from"=>"jul_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_jul", "from"=>"qtd_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_jul", "from"=>"qtd_inicial_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_jul", "from"=>"qtd_total_jul", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"set_val_orc", "from"=>"set_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"set_val_min", "from"=>"set_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_set", "from"=>"qtd_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_set", "from"=>"qtd_inicial_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_set", "from"=>"qtd_total_set", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"out_val_orc", "from"=>"out_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_min", "from"=>"out_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_out", "from"=>"qtd_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_out", "from"=>"qtd_inicial_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_out", "from"=>"qtd_total_out", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            ["field_out"=>"nov_val_orc", "from"=>"nov_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_min", "from"=>"nov_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_nov", "from"=>"qtd_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_nov", "from"=>"qtd_inicial_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_nov", "from"=>"qtd_total_nov", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            
            ["field_out"=>"dez_val_orc", "from"=>"dez_val_orc", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_min", "from"=>"dez_val_min", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"qtd_dez", "from"=>"qtd_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_inicial_dez", "from"=>"qtd_inicial_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],
            ["field_out"=>"qtd_total_dez", "from"=>"qtd_total_dez", "render_value"=>function($row_data, $value){
                return $value == 0 || $value == null ? '0' : intval($value);
            }],

            //
            ["field_out"=>"jan_val_total", "from"=>"jan_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fev_val_total", "from"=>"fev_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"mar_val_total", "from"=>"mar_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abr_val_total", "from"=>"abr_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"mai_val_total", "from"=>"mai_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jun_val_total", "from"=>"jun_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"jul_val_total", "from"=>"jul_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"ago_val_total", "from"=>"ago_val_total_", "render_value"=>function($row_data, $value){
               return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"set_val_total", "from"=>"set_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"out_val_total", "from"=>"out_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"nov_val_total", "from"=>"nov_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dez_val_total", "from"=>"dez_val_total_", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }]
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccontabil_id','ccusto_id','orc_lotacao_id'],
        // "filter_data"=>['ccontabil_id'=>function($value){
        //         return is_null($value);
        //     },'ccusto_id'=>function($value){
        //         return is_null($value);
        //     }
        //     ,'orc_lotacao_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children"=>["columns"=>$column_fixeds_children,
        "keys"=>['ccontabil_id','ccusto_id','orc_lotacao_id','orc_cargo_id','evento_id'],
                "filter_data"=>[
                    'ccontabil_id'=>function($value){
                        return !is_null($value);
                    },
                    'ccusto_id'=>function($value){
                        return !is_null($value);
                    },
                    'orc_lotacao_id'=>function($value){
                        return !is_null($value);
                    },
                    'orc_cargo_id'=>function($value){
                        return !is_null($value);
                    }
                    ,
                    'evento_id'=>function($value){
                        return !is_null($value);
                    }
                ],
                'parent_filter'=> function($value, $parent_data){                      
                        $lotacao = ( $value['orc_lotacao_id'] == $parent_data['orc_lotacao_id']);
                        $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                        $ccontabil = ( $value['ccontabil_id'] == $parent_data['ccontabil_id']);
                        return ($lotacao && $ccusto && $ccontabil);
                },
            ] 
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
}