<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepoCalcIndice;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcSalarioFuncionario as RepoOrcSalarioFuncionario;
use Excel;

class OrcSalarioFuncionarioController extends Natureza51Ctrl
{
    use \App\Core\Traits\ErrorTrait;

    public function __construct(){
        parent::__construct();
        $this->setCodTela('OSF');
        $this->repository=new RepoOrcSalarioFuncionario();
    }  

    public function listarAll($orc_id, $periodo = null, $tipo_table = 'O'){
        
        $tipo_table = $periodo != null ? 'F' : 'O';
        // dd($orc_id, $periodo, $tipo_table);
        $this->podeAcessar('listar',true,$this->getCodTela());
        $tb_orc_salario_funcionario = new OrcSalarioFuncionario();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_cargo = new OrcCargo();
        $tb_funcionario = new Funcionario(); 
        $tbl_usuario = new Usuario(); 
        
        $query = $tb_orc_salario_funcionario
        ->leftJoin($tb_calc_orcamento->getTable(), $tb_orc_salario_funcionario->getColunaAlias('id'), '=', 
            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_salario_funcionario->getTable()}'"))

        ->leftJoin($tb_orc_cargo->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))  

        ->leftJoin($tb_funcionario->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'), $tb_funcionario->getColunaAlias('id')) 

        ->leftJoin($tb_cargo->getTable(),
            $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))  

        ->leftJoin($tb_centro_custo->getTable(),
            $tb_funcionario->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id'))  

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$tb_orc_salario_funcionario->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tb_calc_orcamento->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            DB::raw("{$tb_orc_salario_funcionario->getColunaAlias('id')} 'orc_sal_func_id'"),
            DB::raw("{$tb_calc_orcamento->getColunaAlias('id')} 'calc_orcamento_id'"),
            $tb_orc_salario_funcionario->getColunaAlias('orc_id'),
            $tb_centro_custo->getColunaAlias('cod_ccusto'),
            $tb_centro_custo->getColunaAlias('des_ccusto'),
            $tb_funcionario->getColunaAlias('ccusto_id'),
            $tb_cargo->getColunaAlias('cod_cargo_basic'),
            $tb_cargo->getColunaAlias('des_cargo_basic'),
            $tb_orc_cargo->getColunaAlias('cargo_id'),
            $tb_funcionario->getColunaAlias('cdn_funcionario'),
            $tb_funcionario->getColunaAlias('nome_funcionario'),
            $tb_funcionario->getColunaAlias('salario'),
            $tb_funcionario->getColunaAlias('orc_cargo_id'),

            $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'),
            $tb_orc_salario_funcionario->getColunaAlias('created_at'),
            $tb_calc_orcamento->getColunaAlias('updated_at'),
            $tb_calc_orcamento->getColunaAlias('jan_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('fev_orcado'),                                     
            $tb_calc_orcamento->getColunaAlias('mar_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('abr_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('mai_orcado'),
            $tb_calc_orcamento->getColunaAlias('jun_orcado'), 
            $tb_calc_orcamento->getColunaAlias('jul_orcado'), 
            $tb_calc_orcamento->getColunaAlias('ago_orcado'),
            $tb_calc_orcamento->getColunaAlias('set_orcado'),  
            $tb_calc_orcamento->getColunaAlias('out_orcado'),
            $tb_calc_orcamento->getColunaAlias('nov_orcado'), 
            $tb_calc_orcamento->getColunaAlias('dez_orcado'),
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE 'Sistema' END as criado_por"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CONCAT({$tb_funcionario->getColunaAlias('cdn_funcionario')}, ' - ', {$tb_funcionario->getColunaAlias('nome_funcionario')}) as description_funcionario")
        );

        if($tipo_table == 'F'){
            $query->where([
                [$tb_orc_salario_funcionario->getColunaAlias('orc_id'), '=', $orc_id],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo_table'), '=', $tipo_table],
                [$tb_orc_salario_funcionario->getColunaAlias('periodo'), $periodo],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo'), 3]
            ])
            ->orWhere([
                [$tb_orc_salario_funcionario->getColunaAlias('orc_id'), '=', $orc_id],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo_table'), '=', $tipo_table],
                [$tb_orc_salario_funcionario->getColunaAlias('periodo'), $periodo],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo'), 1]
            ]);
        }
        else{
            $query->where([
                [$tb_orc_salario_funcionario->getColunaAlias('orc_id'), '=', $orc_id],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo_table'), '=', $tipo_table],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo'), 0],
            ])
            ->orWhere([
                [$tb_orc_salario_funcionario->getColunaAlias('orc_id'), '=', $orc_id],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo_table'), '=', $tipo_table],
                [$tb_orc_salario_funcionario->getColunaAlias('tipo'), 1]
            ])
            ->whereNull($tb_orc_salario_funcionario->getColunaAlias('periodo'));
        }
        $data = $query->get()->toArray();

        for($i = 0; $i < count($data); $i++){
            $data[$i] = array_merge($data[$i],array("description_func"=>$data[$i]['cdn_funcionario'].' - '.$data[$i]['nome_funcionario']));
            $data[$i] = array_merge($data[$i],array("description_cargo"=>$data[$i]['cod_cargo_basic'].' - '.$data[$i]['des_cargo_basic']));
            $data[$i]['identificador'] = "2";
            $data[$i]['atualizado_data'] = formataData($data[$i]['updated_at']);
            $data[$i]['criado_data'] = formataData($data[$i]['created_at']);
        }

        return json_encode($this->renderTreeTableList($data));
    }

    public function getDataFuncionario($user_id) {
        $usuario = new Usuario();
    
        $data_user = $usuario->with([
           'getFuncionario'=>function($query){
  
           }])->where('id',$user_id)->first();
     return $data_user;
    }

    public function listarByCapacity($orc_id, $lotacao_id, $tipo){
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()));
        $empresa_id = (($decrypted->token->empresa_id));
        $tb_orc_lotacao = new OrcLotacao(); 
        $tb_orc_salario_funcionario = new OrcSalarioFuncionario();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_cargo = new OrcCargo();
        $tb_funcionario = new Funcionario(); 
        $tbl_usuario = new Usuario();
        $tbl_orc_func = new OrcFuncionario();

        $data_funcionario = $this->getDataFuncionario($decrypted->token->id)->getFuncionario;

        
        $data = $tb_orc_salario_funcionario
        ->leftJoin($tb_calc_orcamento->getTable(), $tb_orc_salario_funcionario->getColunaAlias('id'), '=', 
            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_salario_funcionario->getTable()}'"))

        ->join($tb_orc_lotacao->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('lotacao_id'), $tb_orc_lotacao->getColunaAlias('id'))

        ->leftJoin($tb_orc_cargo->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))  

        ->leftJoin($tb_funcionario->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'), $tb_funcionario->getColunaAlias('id')) 

        ->leftJoin($tb_cargo->getTable(),
            $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))  

        ->leftJoin($tb_centro_custo->getTable(),
            $tb_funcionario->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id'))  

        ->leftJoin($tbl_orc_func->getTable(), $tb_funcionario->getColunaAlias('id'), '=',
            DB::raw("{$tbl_orc_func->getColunaAlias('funcionario_id')} and {$tbl_orc_func->getColunaAlias('orcamento_id')} = $orc_id
        "))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$tb_orc_salario_funcionario->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tb_calc_orcamento->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            DB::raw("{$tb_orc_salario_funcionario->getColunaAlias('id')} 'orc_sal_func_id'"),
            DB::raw("{$tb_calc_orcamento->getColunaAlias('id')} 'calc_orcamento_id'"),
            $tb_orc_salario_funcionario->getColunaAlias('orc_id'),
            $tb_centro_custo->getColunaAlias('cod_ccusto'),
            $tb_centro_custo->getColunaAlias('des_ccusto'),
            $tb_funcionario->getColunaAlias('ccusto_id'),
            $tb_cargo->getColunaAlias('cod_cargo_basic'),
            $tb_cargo->getColunaAlias('des_cargo_basic'),
            DB::raw("{$tb_cargo->getColunaAlias('salario')} as salario_atual"),
            $tb_orc_cargo->getColunaAlias('cargo_id'),
            $tb_funcionario->getColunaAlias('cdn_funcionario'),
            $tb_funcionario->getColunaAlias('nome_funcionario'),
            $tb_funcionario->getColunaAlias('salario'),
            $tb_orc_salario_funcionario->getColunaAlias('orc_cargo_id'),
            $tb_orc_salario_funcionario->getColunaAlias('id'),
            $tbl_orc_func->getColunaAlias('salario_forecast'),
           
        DB::raw("CONCAT({$tb_cargo->getColunaAlias('cod_cargo_basic')}, ' - ', 
            {$tb_cargo->getColunaAlias('des_cargo_basic')}) AS cargo"),
            DB::raw("CONCAT({$tb_funcionario->getColunaAlias('cdn_funcionario')}, ' - ', 
            {$tb_funcionario->getColunaAlias('nome_funcionario')}) AS funcionario"),

            $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'),
            $tb_calc_orcamento->getColunaAlias('jan_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('fev_orcado'),                                     
            $tb_calc_orcamento->getColunaAlias('mar_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('abr_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('mai_orcado'),
            $tb_calc_orcamento->getColunaAlias('jun_orcado'), 
            $tb_calc_orcamento->getColunaAlias('jul_orcado'), 
            $tb_calc_orcamento->getColunaAlias('ago_orcado'),
            $tb_calc_orcamento->getColunaAlias('set_orcado'), 
            $tb_calc_orcamento->getColunaAlias('out_orcado'),
            $tb_calc_orcamento->getColunaAlias('nov_orcado'), 
            $tb_calc_orcamento->getColunaAlias('dez_orcado'),

            DB::raw("CASE WHEN {$tb_orc_salario_funcionario->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orc_salario_funcionario->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_data"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_data"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->where($tb_orc_salario_funcionario->getColunaAlias('orc_id'),$orc_id)
        ->where($tb_orc_lotacao->getColunaAlias('lotacao_id'),$lotacao_id)
        ->where($tb_orc_salario_funcionario->getColunaAlias('tipo_table'), 'O');
        if($decrypted->token->tipo_user == 4){
            $data = $data->where($tb_orc_salario_funcionario->getColunaAlias('funcionario_id'), '!=', $data_funcionario->id);
        }
        // ->where($tb_orc_salario_funcionario->getColunaAlias('tipo'),$tipo)
        $data = $data->get()
        ->toArray();

        for($i = 0; $i < count($data); $i++){
            $data[$i]['identificador']="2";
            // $data[$i]['jan_orcado']=number_format($data[$i]['jan_orcado'],2,',','.');                            
            // $data[$i]['fev_orcado']=number_format($data[$i]['fev_orcado'],2,',','.');                             
            // $data[$i]['mar_orcado']=number_format($data[$i]['mar_orcado'],2,',','.');                            
            // $data[$i]['abr_orcado']=number_format($data[$i]['abr_orcado'],2,',','.');                            
            // $data[$i]['mai_orcado']=number_format($data[$i]['mai_orcado'],2,',','.');
            // $data[$i]['jun_orcado']=number_format($data[$i]['jun_orcado'],2,',','.');
            // $data[$i]['jul_orcado']=number_format($data[$i]['jul_orcado'],2,',','.');
            // $data[$i]['ago_orcado']=number_format($data[$i]['ago_orcado'],2,',','.');
            // $data[$i]['set_orcado']=number_format($data[$i]['set_orcado'],2,',','.');
            // $data[$i]['out_orcado']=number_format($data[$i]['out_orcado'],2,',','.');
            // $data[$i]['nov_orcado']=number_format($data[$i]['nov_orcado'],2,',','.');
            // $data[$i]['dez_orcado']=number_format($data[$i]['dez_orcado'],2,',','.');
        }
        // dd('ghygasgds', $data);
        return json_encode($this->renderTreeTableList($data));

    }

    public function listByOrcCapacity($orc_id, $lotacao_id, $periodo = null, $tipo_table = 'O'){        
        $tb_orc_lotacao = new OrcLotacao(); 
        $query = $tb_orc_lotacao
        ->where($tb_orc_lotacao->getColunaAlias('orcamento_id'),$orc_id)
        ->where($tb_orc_lotacao->getColunaAlias('lotacao_id'),$lotacao_id)
        ->where($tb_orc_lotacao->getColunaAlias('tipo_table'), $tipo_table);
        
        $data = null;

        if($tipo_table == 'F'){
            $data = $query->where($tb_orc_lotacao->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $data = $query->whereNull($tb_orc_lotacao->getColunaAlias('periodo'))->get()->toArray();
        }

        return json_encode($data);
    }

    public function listarIndice($orc_id){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $dados = $this->getRepository()->listarIndices($orc_id);
        return json_encode($this->treeTableIindice($dados));
    }

    function renderTreeTableList($dados){

        $columns_base=[ 
            ["field_out"=>"orc_sal_func_id", "from"=>"orc_sal_func_id"],
            ["field_out"=>"calc_orcamento_id", "from"=>"calc_orcamento_id"],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"],
            ["field_out"=>"des_ccusto", "from"=>"des_ccusto"],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id"],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],
            ["field_out"=>"cargo_id", "from"=>"cargo_id"],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],
            ["field_out"=>"orc_id", "from"=>"orc_id"],
            ["field_out"=>"cdn_funcionario", "from"=>"cdn_funcionario"],
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario"],
            ["field_out"=>"funcionario", "from"=>"funcionario"],
            ["field_out"=>"cargo", "from"=>"cargo"],
            ["field_out"=>"description_funcionario", "from"=>"description_funcionario"],
            ["field_out"=>"description_cargo", "from"=>"description_cargo"],

            ["field_out"=>"identificador", "from"=>"identificador"],
            ["field_out"=>"id", "from"=>"id"],

            ["field_out"=>"criado_por", "from"=>"criado_por",],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por",],

            ["field_out"=>"atualizado_data", "from"=>"atualizado_data",],
            ["field_out"=>"criado_data", "from"=>"criado_data",],

            ["field_out"=>"salario_forecast", "from"=>"salario_forecast",],

            ["field_out"=>"salario", "from"=>"salario","render_value"=>function($row_data, $value){
                return number_format($value,4,'.', '');
            }],
            ["field_out"=>"salario_atual", "from"=>"salario_atual","render_value"=>function($row_data, $value){
                return number_format($value,4,'.', '');
            }],
            ["field_out"=>"salario_atual___", "from"=>"salario_atual","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],

            ["field_out"=>"salario_forecast", "from"=>"salario_forecast","render_value"=>null],

            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id"],

            ["field_out"=>"salario_forecast", "from"=>"salario_forecast"],

           ["field_out"=>"funcionario_id", "from"=>"funcionario_id"],
           ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
           }],
           ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],
           ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }], 
           ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],    
           ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],    
           ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],    
           ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['orc_sal_func_id' ] 
           ];    
           
       $controller = new AtmTreeTable($settings, $dados);
       
        return $controller->render();
   }

   function treeTableIindice($dados){

    $columns_base=[ 
        ["field_out"=>"orc_sal_func_id", "from"=>"orc_sal_func_id"],
        ["field_out"=>"calc_indice_id", "from"=>"calc_indice_id"],
        ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"],
        ["field_out"=>"des_ccusto", "from"=>"des_ccusto"],
        ["field_out"=>"ccusto_id", "from"=>"ccusto_id"],
        ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],
        ["field_out"=>"cargo_id", "from"=>"cargo_id"],
        ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],
        ["field_out"=>"orc_id", "from"=>"orc_id"],
        ["field_out"=>"cdn_funcionario", "from"=>"cdn_funcionario"],
        ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario"],
        ["field_out"=>"identificador", "from"=>"identificador"],
        ["field_out"=>"salario", "from"=>"salario","render_value"=>function($row_data, $value){
            return number_format($value,2,'.', '');
        }],
        ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id"],

        ["field_out"=>"jan_indice", "from"=>"jan_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],
           ["field_out"=>"fev_indice", "from"=>"fev_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],
           ["field_out"=>"marc_indice", "from"=>"marc_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"abril_indice", "from"=>"abril_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }], 
           ["field_out"=>"maio_indice", "from"=>"maio_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"jun_indice", "from"=>"jun_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"jul_indice", "from"=>"jul_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"agost_indice", "from"=>"agost_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"set_indice", "from"=>"set_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"out_indice", "from"=>"out_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"nov_indice", "from"=>"nov_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"dez_indice", "from"=>"dez_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }]
   ];
    
    
   $settings=["columns"=>$columns_base,
           "keys"=>['orc_sal_func_id' ] 
       ];    
       
   $controller=new AtmTreeTable($settings, $dados);
   
    return $controller->render();
}

    public function insert(Request $request){

        $this->podeAcessar('inserir',true,$this->getCodTela());

        // $repo_calc_orcamento=new RepoCalcOrcamento();
        // $orc_sal_func = new OrcSalarioFuncionario();

        $form_data=$request->all();

        $decrypted = json_decode(safeDecrypt(request()->bearerToken())); 
        $empresa_id = (($decrypted->token->empresa_id));
        $form_data['empresa_id'] = $empresa_id;
        
        if($form_data['tipo_meses']==0){
            $retorno['status']='warning';
            $retorno['submsg']='Selecione um Tipo.';
            $retorno['msg']='Atenção';
            goto saida;
        }
        $meses=Arr::only($form_data,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);

        if(!mesesValidacao($meses)){
            $retorno['status']='error';
            $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
            $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 230320201204';
            goto saida;
        }

        $select = null;
        
        if($form_data['tipo_table'] == 'F'){
            $select = DB::select("SELECT * from tbl_orc_funcionario where funcionario_id = {$form_data['funcionario_id']} and orcamento_id = {$form_data['orc_id']} and tipo_table = '{$form_data['tipo_table']}' and periodo = '{$form_data['periodo']}' and orc_cargo_id <> {$form_data['orc_cargo_id']}");
        }
        else{
            //dd("SELECT * from tbl_orc_funcionario where funcionario_id = {$form_data['funcionario_id']} and orcamento_id = {$form_data['orc_id']} and tipo_table = '{$form_data['tipo_table']}'");
            $select = DB::select("SELECT * from tbl_orc_funcionario where funcionario_id = {$form_data['funcionario_id']} and orcamento_id = {$form_data['orc_id']} and tipo_table = '{$form_data['tipo_table']}' and orc_cargo_id <> {$form_data['orc_cargo_id']}");
        }
        
        if(count($select) > 0 && $select[0]->cargo_atualizado == 1){
            $retorno['status'] = 'error';
            $retorno['msg'] = "Não foi possível inserir os dados. Já ocorreu uma atualização no cargo selecionado. Erro: 241120201328";
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        
        
        if(!$this->getRepositoryOrModel()->createOrcLotFuncionario($form_data)){
            //$retorno['msg']='Falha ao inserir o registro. Erro: 080420201132';
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            goto saida;
        }
        // $where = [
        //     ['orc_id',$form_data['orc_id']],
        //     ['funcionario_id',$form_data['funcionario_id']],
        //     ['orc_cargo_id',$form_data['orc_cargo_id']]
        // ];
        // $select = $this->getRepository()->getModelEntity()->where($where)->get()->toArray();
        //     //dd($select);
        // if(!empty($select)){
        //     $retorno['status']='error';
        //     $retorno['msg']='Registro já cadastrado. Erro: 260220201157.';
        //     goto saida;
        // }
    
        // $id_orc_sal_func = $this->getRepository()->create($form_data);
        // if(! $id_orc_sal_func){
        //     $retorno['msg']=$this->getRepository()->getErrosFlatted();
        //     $retorno['submsg']='Falha ao inserir o registro. Erro: 220820191723';
        //     goto saida;
        // }

        // $meses_calc_orcamento = $this->dataFilterMesesCalcOrcamento($form_data); 
            
        // $merge_tb_calc = [
        //     'origem_id' => $id_orc_sal_func->id,
        //     'tbl_origem' => $orc_sal_func->getTable()
        // ];
            
        // if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses_calc_orcamento))){
        //     $retorno['msg']='Falha ao inserir o registro. Erro: 220820191723';
        //     $retorno['submsg']=$repo_calc_orcamento->getErrosFlatted();
        //     goto saida;
        // }
        

        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function update(Request $request){  
        $this->podeAcessar('editar',true,$this->getCodTela());
        
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $retorno=$this->getArrayRetornoDefault();
        $this->clearError();

        $form_data = $request->all();   
        $id_salario_func = $form_data['orc_sal_func_id'];

        $meses=Arr::only($form_data,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
        
        //$meses_indice = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        
        if($form_data['identificador']==1){
            // if(!validacaoIndice(convertDecimalEn($meses_indice))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os índices inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os índices inseridos não podem diminuir ao longo dos meses. Erro: 060420201232';
            //     goto saida;
            // }else{
                if(!$this->getRepository()->updateIndice($form_data)){
                    $retorno["status"]="error";
                    $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                    $retorno['submsg']='Falha ao fazer update do registro. Erro: 030420201426';
                    goto saida;  
                }
            // }
        }
        else{
            if(!mesesValidacao(convertDecimalEn($meses))){
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Os salários inseridos não podem diminuir ao longo dos meses. Erro: 230320201156';
                $retorno['submsg'] = 'Erro';
                goto saida;
            }else{
                $id=$form_data['calc_orcamento_id'];
            
                $meses_calc_orcamento = $this->dataFilterMesesCalcOrcamento($form_data); 
                $meses_calc_orcamento = convertDecimalEn($meses_calc_orcamento);
            
                if(! $repo_calc_orcamento->update($meses_calc_orcamento, $id)){                  
                    $retorno["status"]="error";
                    $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted().'<br>Falha ao atualizar o registro. Erro: 271120191600';
                    $retorno['submsg'] = 'Erro';
                    goto saida;               
                }
                DB::update("UPDATE tbl_orc_salario_funcionario set updated_at = ?, updated_by = ? where id = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $id_salario_func]);
            } 
        } 
        
        $retorno["status"] = "success";
        $retorno["msg"] = "Registro atualizado com sucesso!";
        $retorno["submsg"] = "Sucesso";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    } 
    
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_cargo_id', 'lotacao_responsavel_id','funcionario_id','salario', 'nome_funcionario', 'cdn_funcionario', 'cargo_id', 
        'des_cargo_basic', 'cod_cargo_basic' ,'ccusto_id', 'des_ccusto', 'cod_ccusto', 'orc_sal_func_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function dataFilterSalarioFuncionario($data){
        $array_orcamento=['funcionario_id','salario', 'nome_funcionario', 'cdn_funcionario', 'cargo_id', 
        'des_cargo_basic', 'cod_cargo_basic' ,'ccusto_id', 'des_ccusto', 'cod_ccusto', 'orc_sal_func_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        //fhjfghdfgdfgdf ddddddddd
        //dd("dataUpdate", $filtered);
        return $filtered;
    }

    public function deleteAll(Request $request){
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $data = $request->all(); 

        $repo_calc_orcamento = new RepoCalcOrcamento();
        $calc_indice = new CalcIndice();
        $repo_calc_ind = new RepoCalcIndice();

        $retorno=$this->getArrayRetornoDefault();
        if($data['identificador']==1){
            if(!$this->getRepositoryOrModel()->deleteIndices($data)){
                $retorno['msg']='Falha ao deletar o registro. Erro: 030420201457.';
                $retorno['status']='error';
                goto saida;
            }
        }
        else{

            DB::beginTransaction();

            try {
                $orc_sal = $this->getRepository()->findBy('id',$data['orc_sal_func_id']);
            
                if(!$orc_sal->delete()){
                    $retorno['msg']='Falha ao deletar o registro. Erro: 260220201039.';
                    $retorno['status']='error';
                    goto saida;
                }

                $calc_orc = $repo_calc_orcamento->findBy('id',$data['calc_orcamento_id']);
                if(!$calc_orc->delete()){
                    $retorno['msg']='Falha ao deletar o registro. Erro: 260220201041.';
                    $retorno['status']='error';
                    goto saida;
                }

                $select_indice = $calc_indice->select()->where([
                    [$calc_indice->getColunaAlias('origem_id'),'=',$data['orc_sal_func_id']],
                    [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getRepository()->getModelEntity()->getTable()]
                ])->get()->toArray();
    
                if(count($select_indice)>0)
                {
                    $delete_indices = $repo_calc_ind->getModelEntity()->where([
                        [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$data['orc_sal_func_id']],
                        [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getRepository()->getModelEntity()->getTable()]])
                    ->delete();
    
                    if(!$delete_indices){
                        $retorno['msg']='Falha ao deletar o registro. Erro: 090420201259.';
                        $retorno['status']='error';
                        goto saida;
                    }
                }
                $orc_controller = new OrcamentoController();
                if($orc_controller->deleteDiarioBordo($data['orc_sal_func_id'], 'tbl_orc_salario_funcionario') == false){
                    $retorno['msg'] = 'Falha ao deletar Diário de Bordo. Erro: 220320211615.';
                    $retorno['submsg'] = 'Erro';
                    $retorno['status'] = 'error';
                    goto saida;
                }
                $retorno['status'] = 'success';
                $retorno['msg'] = 'Registro deletado com sucesso!';
                
                DB::commit();  
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500,'Erro ao deletar registro. Erro: 260220201030.'.$e);
            }
        }
        $retorno['status']='success';
        $retorno['msg']='Registro deletado com sucesso!';
        saida:
        return $retorno;

    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
       

        return parent::downloadExcel($type, 'SalarioFuncionario', ['funcionario','cargo','description_funcionario','description_cargo','cod_ccusto','des_ccusto','orc_sal_func_id','calc_orcamento_id','ccusto_id','cargo_id', 'cargo_id','identificador','salario','funcionario_id', 'orc_cargo_id', 'orc_id']);
    }

    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            // dd(json_decode($_POST['array_imprimir']));
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("nome funcionario", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("cdn funcionario", "Cód. funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("des cargo basic", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("cod cargo basic", "Cód. Cargo", $colunas[$i]);




            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);


        }
        return $colunas;
    }
    public function deleteAllFuncionario($orc_id, $periodo = null, $tipo_table = 'O'){
        if($tipo_table != 'O'){
            $resp = $this->getRepository()->deleteAllForecast($orc_id, $periodo, $tipo_table);
        }
        else{
            $resp = $this->getRepository()->deleteAll($orc_id);
        }
        
        if(!$resp){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        
        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Registros deletados com successo!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function orcFuncCargo($orcamento_id, $func_id, $periodo = null, $tipo_table = 'O'){
        $orc_func = new OrcFuncionario();

        $orc_func = OrcFuncionario::where('orc_id', $orc_func['orcamento_id'] = $orcamento_id)->where('funcionario_id', $orc_func['funcionario_id'] = $func_id)
        ->where('tipo_table', $tipo_table);

        if($tipo_table == 'F'){
            $orc_func = $orc_func->where('periodo', $periodo)->first();;
        }
        else{
            $orc_func = $orc_func->whereNull('periodo')->first();
        }
       // $cargo = $orc_func['orc_cargo_id'];
       // $turma = $orc_func['orc_turma_id'];
       // $lotacao = $orc_func['orc_lotacao_id'];
       
       $funcionario = json_encode($orc_func);

        return $funcionario;
    }
}