<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcBonus as RepoOrcBonus;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use App\Modules\Natureza51\Entities\OrcBonus;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcResultadosCalc;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\OrcTurmaEvento;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\OrcDespesas;
use App\Modules\Natureza51\Entities\OrcLotacao;

use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use \App\Core\Traits\ErrorTrait;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\DB as FacadesDB;

class OrcTransfLotController extends Natureza51Ctrl
{
     public function __construct(){
        // $this->repository=new RepoOrcBonus();

        $this->setCodTela('TL');
        parent::__construct();
    }
   
    public function listAll($orc_id, $periodo = null, $tipo_table = 'O'){     
        $where = $tipo_table == 'F' ? " and ol.periodo = '{$periodo}' and ol.tipo_table = 'F' " : " and ol.tipo_table = 'O' ";
        $data = DB::select("SELECT 
                CONCAT(cc_a.cod_ccusto , ' - ' , l_a.unid_lotac , ' - ' , l_a.des_unid_lotac) 'lotacao_atual',
                CONCAT(cc_b.cod_ccusto , ' - ' , l_b.unid_lotac , ' - ' , l_b.des_unid_lotac) 'lotacao_anterior',
                ol.lotacao_id_origem,
                ol.cc_custo_id_origem,
                ol.cc_custo_id,
                ol.lotacao_id,
                ol.id
            from tbl_orc_lotacao ol
            inner join tbl_lotacao l_a on l_a.id = ol.lotacao_id
            inner join tbl_lotacao l_b on l_b.id = ol.lotacao_id_origem
            inner join tbl_ccusto cc_a on ol.cc_custo_id = cc_a.id
            inner join tbl_ccusto cc_b on ol.cc_custo_id_origem = cc_b.id
            where ol.orcamento_id = $orc_id {$where}
            and ol.has_transf = 1
        "); 

        $result =  json_decode(json_encode($data), true);
      
        return $result;
    } 

    public function insertTransfLotacao(Request $request, $orc_id){   
        /*
            A lotação destino é deletada, e depois a lotação destino assume o lugar da lotação origem atraves do update
            Ou seja, a lotação origem saiu fora, mas depois é inserida atraves do repopular
        */
        // $this->podeAcessar('inserir',true,$this->getCodTela());
        DB::beginTransaction();
        $form_data = $request->all();
        
        $periodo = $form_data['periodo'];
        $tipo_table = $form_data['tipo_table'];

        $where[0] = $tipo_table == 'F' ? " and periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " and tipo_table = '{$tipo_table}' ";
        
        $valida = $this->validaTansfLotDestino($orc_id, $form_data['orc_lotacao_destino_id'], $form_data['ccusto_destino_id'], $periodo, $tipo_table );// valida a lotação: ve se ja foi transferida ou se está sendo usada
		$lot_inativo_id = DB::select("select lotacao_id, cc_custo_id from tbl_orc_lotacao where lotacao_id_origem = {$form_data['lotacao_destino_id']} and cc_custo_id_origem = {$form_data['ccusto_destino_id']} and orcamento_id = {$orc_id} {$where[0]} "); 		
        
        if ($valida["status"] === "error") {
            $retorno["status"]="error";
            $retorno['msg'] = "Já existe transferência para esta lotação, desfaça a transferência existente para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 100920201517';
            DB::rollBack();
            goto saida;
        }
        
        if ($valida > 0) {            
            $retorno["status"]="error";
            $retorno['msg'] = "Lotação destino já existe no ".($tipo_table == 'F' ? 'Forecast' : 'Headcount');
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 030920201442';
            DB::rollBack();
            goto saida;
        }
        
        $return_transf = $this->deleteTransfDestino($orc_id, $form_data);// deleta a lotação destino caso não esteja sendo usada

        if($return_transf["status"]=="error")
        {
            $retorno["status"] = "error";
            $retorno['msg'] = $return_transf['msg'];//"Erro ao inserir lotação destino.";
            $retorno['submsg'] = $return_transf['submsg'];//'Falha ao fazer insert do registro. Erro: 080920200845';
            DB::rollBack();
            goto saida;
        }
        
        $return_recebe_transf = $this->updateRecebeTrasf($form_data, $orc_id);// atualiza a lotação origem com os dados da destino

        if($return_recebe_transf["status"]=="error")
        {
            $retorno["status"]="error";
            $retorno['msg'] = "Problemas ao transferir a Lotação!";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 080920200843';
            DB::rollBack();
            goto saida;
        }        

        $returnLot = $this->updateCcustoLotTransf($orc_id, $form_data['orc_lotacao_origem_id'], $form_data['ccusto_destino_id']);

        if($returnLot["status"]=="error")
        {
            $retorno["status"]="error";
            $retorno['msg'] = "Erro ao atualizar Centro Custo.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 080920200848';
            DB::rollBack();
            goto saida;
        }

        $this->repopulateOrcLotacao($orc_id, $form_data['periodo'], $form_data['tipo_table']);  		
		
		$this->inativaOrcLotacao($form_data, $orc_id, $lot_inativo_id);

        $this->atualizaOrcFuncionario($orc_id, $periodo);

        $retorno["status"]="success";
        $retorno["msg"]="Registro inserido com sucesso!";
        DB::commit();
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 

    public function atualizaOrcFuncionario($orc_id, $periodo){
        $res = DB::statement(DB::raw("
                EXEC	[dbo].[sp_atualiza_orc_funcionario_forecast]
                    @id_orc = $orc_id,
                    @periodo = '$periodo'   
        ")); 
    }

    public function validaTansfLotDestino($orc_id, $orc_lot_Dest_id, $cc_custo_destico_id, $periodo = null, $tipo_table = 'O'){
        $orcamLotCargoHeadcount = new OrcamLotCargoHeadcount();
        $orcLotacao = new OrcLotacao();
        
        $has_transf = $orcLotacao::where([
            ['id', '=',  $orc_lot_Dest_id],
            ['has_transf', '=', 1]
        ])->count();
       
        if($has_transf > 0) {
            $retorno["status"]="error";
            return $retorno;
        }
        
        $result = $orcamLotCargoHeadcount::where([
            ['orc_id', '=', $orc_id],
            ['lotacao_id', '=',  $orc_lot_Dest_id],
            ['ccusto_id', '=', $cc_custo_destico_id],
            ['tipo_table', '=', $tipo_table]
        ]);

        if($tipo_table == 'F'){
            $result = $result->where('periodo', $periodo)->count();
        }
        else{
            $result = $result->whereNull('periodo')->count();
        }
        
        return $result;        
    }

    public function updateCcustoLotTransf($orc_id, $orc_lot_id, $cc_custo_id)
    {
		
        $orcLotCargoBeneficio = new OrcLotCargoBeneficio();
        $orcLotFuncionatioBeneficio = new OrcLotFuncionatioBeneficio();
        $orcBonus = new OrcBonus();
        $orcCargosAreaSal = new OrcCargosAreaSal();
        $orcDespesas = new OrcDespesas();
        $orcFerias = new OrcFerias();
        $orcContratacoes = new OrcContratacoes();
        $orcHeadcountDemissoes = new OrcHeadcountDemissoes();
        $orcamLotCargoEvento = new OrcamLotCargoEvento();
        $orcamLotCargoHeadcount = new OrcamLotCargoHeadcount();
        $orcPromocao = new OrcPromocao();
        $orcResultadosCalc = new OrcResultadosCalc();
        $orcSalarioFuncionario = new OrcSalarioFuncionario();
        
        
        $cc_orc_benef_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_benef_func_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_bonus_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_cargo_area_sal_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_despesas_dados['centro_custo_id'] = $cc_custo_id;
        $cc_orc_ferias_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_contratacoes_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_demissoes_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_cargo_event_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_carg_headcount_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_promocao_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_resultados_calc_dados['ccusto_id'] = $cc_custo_id;
        $cc_orc_sal_funcionario_dados['ccusto_id'] = $cc_custo_id;
       
        DB::beginTransaction();

        try {
            $params_cargo_ben = [
                ['orcamento_id', '=', $orc_id],
                ['orc_lotacao_id', '=',  $orc_lot_id],
            ];
            $select_cargo_benef = $this->selectTransf($orcLotCargoBeneficio, $params_cargo_ben );

            if($select_cargo_benef > 0){
                if(!$orcLotCargoBeneficio->where([
                    ['orcamento_id', '=', $orc_id],
                    ['orc_lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_benef_dados)){
                   
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201645';
                    goto saida;
                }
            }  
            
            $params_func_ben = [
                ['orcamento_id', '=', $orc_id],
                ['orc_lotacao_id', '=',  $orc_lot_id],
            ];
            $select_func_benef = $this->selectTransf($orcLotFuncionatioBeneficio, $params_func_ben );
           
            if($select_func_benef > 0){            
            
                if(!$orcLotFuncionatioBeneficio->where([
                    ['orcamento_id', '=', $orc_id],
                    ['orc_lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_benef_func_dados)){
                    
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201645';
                    goto saida;
                }
            }

            $params_bonus = [
                ['orc_id', '=', $orc_id],
                ['orc_lot_id', '=',  $orc_lot_id],
            ];
            $select_bonus = $this->selectTransf($orcBonus, $params_bonus );            

            if($select_bonus > 0){  

                if(!$orcBonus->where([
                    ['orc_id', '=', $orc_id],
                    ['orc_lot_id', '=',  $orc_lot_id],
                ])->update($cc_orc_bonus_dados)){
                   
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201645';
                    goto saida;
                }
            }
            
            $params_cargo_area = [
                ['orcamento_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_cargo_area = $this->selectTransf($orcCargosAreaSal, $params_cargo_area );            
            
            if($select_cargo_area > 0){ 
            
                if(!$orcCargosAreaSal->where([
                    ['orcamento_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_cargo_area_sal_dados)){
                   
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201645';
                    goto saida;
                }
            }
           
            $params_despesas = [
                ['orc_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_despesas = $this->selectTransf($orcDespesas, $params_despesas );            

            if($select_despesas > 0){ 
            
                if(!$orcDespesas->where([
                    ['orc_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_despesas_dados)){
                    
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201645';
                    goto saida;
                }
            }
            
            $params_ferias = [
                ['orcamento_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_ferias = $this->selectTransf($orcFerias, $params_ferias );            
            
            if($select_ferias > 0){ 
            
                if(!$orcFerias->where([
                    ['orcamento_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_ferias_dados)){
                  
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201645';
                    goto saida;
                }
            }
            
            $params_contratacoes = [
                ['orcamento_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_contratacoes = $this->selectTransf($orcContratacoes, $params_contratacoes);            
            
            if($select_contratacoes > 0){ 
            
                if(!$orcContratacoes->where([
                    ['orcamento_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_contratacoes_dados)){
                  
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                    goto saida;
                }
            }
            
            $params_headcount_demissoes = [
                ['orcamento_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_headcount_demissoes = $this->selectTransf($orcHeadcountDemissoes, $params_headcount_demissoes);            
            
            if($select_headcount_demissoes > 0){ 
            
                if(!$orcHeadcountDemissoes->where([
                    ['orcamento_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_demissoes_dados)){
                   
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                    goto saida;
                }
            }
            
            $params_cargo_evento = [
                ['orc_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_cargo_evento = $this->selectTransf($orcamLotCargoEvento, $params_cargo_evento);            

            if($select_cargo_evento > 0){ 
            
                if(!$orcamLotCargoEvento->where([
                    ['orc_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_cargo_event_dados)){
                  
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                    goto saida;
                }
            }

            $params_cargo_headcount = [
                ['orc_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_cargo_headcount = $this->selectTransf($orcamLotCargoHeadcount, $params_cargo_headcount);            

            if($select_cargo_headcount > 0){ 
            
                if(!$orcamLotCargoHeadcount->where([
                    ['orc_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_carg_headcount_dados)){
                   
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                    goto saida;
                }
            }

            $params_promocao = [
                ['orc_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_promocao = $this->selectTransf($orcPromocao, $params_promocao);            

            if($select_promocao > 0){ 
            
                if(!$orcPromocao->where([
                    ['orc_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_promocao_dados)){
               
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                    goto saida;
                }
            }

            $params_resultado_calc = [
                ['orcamento_id', '=', $orc_id],
                ['orc_lotacao_id', '=',  $orc_lot_id],
            ];
            $select_resultado_calc = $this->selectTransf($orcResultadosCalc, $params_resultado_calc);            
           
            if($select_resultado_calc > 0){ 
            
                if(!$orcResultadosCalc->where([
                    ['orcamento_id', '=', $orc_id],
                    ['orc_lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_resultados_calc_dados)){
                  
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                    goto saida;
                }
            }
           
            $params_salario_funcionario = [
                ['orc_id', '=', $orc_id],
                ['lotacao_id', '=',  $orc_lot_id],
            ];
            $select_salario_funcionario = $this->selectTransf($orcSalarioFuncionario, $params_salario_funcionario);            
            
            if($select_salario_funcionario > 0){ 
            
                if(!$orcSalarioFuncionario->where([
                    ['orc_id', '=', $orc_id],
                    ['lotacao_id', '=',  $orc_lot_id],
                ])->update($cc_orc_sal_funcionario_dados)){
            
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao atualizar registro.";
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                    goto saida;
                }
            }

            // if(!$orcSalarioFuncionario->where([
            //     ['orc_id', '=', $orc_id],
            //     ['lotacao_id', '=',  $orc_lot_id],
            // ])->update($cc_orc_sal_funcionario_dados)) {
            //    
            //     $retorno["status"]="error";
            //     $retorno['msg'] = "Falha ao atualizar registro.";
            //     $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
            //     goto saida;
            // }
            
            
            $returnUpStatusCcsto = $this->updateOrcStatusCcusto($orc_id, $orc_lot_id, $cc_custo_id);

            if($returnUpStatusCcsto["status"]=="error") {
               
                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                goto saida;
            }
/* conferir no sistema se a tabela foi inutilizada.
            $returnUpOrcBenfFunc = $this->updateOrcBeneficioFuncionarioImport($orc_id, $orc_lot_id, $cc_custo_id);
       
            if($returnUpOrcBenfFunc["status"]=="error") {
                
                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                goto saida;
            }
*/ 
            $retorno["status"]="success";
            $retorno["msg"]="Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 040920201642';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201642 - ' . $e;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;          
    }

    public function updateOrcStatusCcusto($orc_id, $orc_lot_id, $cc_custo_id){
        $params = [
            ['orcamento_id', '=', $orc_id],
            ['lotacao_id', '=',  $orc_lot_id],
        ];

        $result = DB::table('tbl_orc_status_ccusto')->where($params)->count();
        
        if($result != 0){
            $retorno["status"]="success";
            $retorno["msg"]='Falha ao atualizar registro. Erro: 040920201730';
            goto saida;
        }

        $query_exec = "UPDATE
                            tbl_orc_status_ccusto
                        SET
                            ccusto_id = $cc_custo_id                
                        WHERE orcamento_id = $orc_id and lotacao_id = $orc_lot_id";

        DB::beginTransaction();

        try {

            $pdo = DB::connection()->getPdo();

            $query = $pdo->prepare($query_exec);

            if ($query->execute()) {
                $count = $query->rowCount();
            }

            if(!$query){

                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]='Falha ao atualizar registro. Erro: 040920201730';

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 040920201730';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730' . $e;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;
    }

    public function updateOrcBeneficioFuncionarioImport($orc_id, $orc_lot_id, $cc_custo_id){

        $params = [
            ['orcamento_id', '=', $orc_id],
            ['orc_lotacao_id', '=',  $orc_lot_id],
        ];

        $result = DB::table('tbl_orc_beneficio_funcionario_import')->where($params)->count();

        if($result != 0){
            $retorno["status"]="success";
            $retorno["msg"]='Falha ao atualizar registro. Erro: 040920201730';
            goto saida;
        }

        $query_exec = "UPDATE
                            tbl_orc_beneficio_funcionario_import
                        SET
                            ccusto_id = $cc_custo_id                
                        WHERE orcamento_id = $orc_id and orc_lotacao_id = $orc_lot_id";

        DB::beginTransaction();

        try {

            $pdo = DB::connection()->getPdo();

            $query = $pdo->prepare($query_exec);

            if ($query->execute()) {
                $count = $query->rowCount();
            }

            if(!$query){

                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]='Falha ao atualizar registro. Erro: 040920201730';

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 040920201730';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730' . $e;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;
    }

    public function updateRecebeTrasf($data, $orc_id)
    { 
        $lotacao_id = $data['lotacao_destino_id'];
        $cc_custo_id = $data['ccusto_destino_id'];
        $orc_lotacao_destino_id = $data['orc_lotacao_destino_id'];
        $ccusto_id_origem = $data['ccusto_origem_id'];
        $lotacao_id_origem = $data['lotacao_origem_id'];
        $transf_origem_id = $data['orc_lotacao_origem_id'];
        $has_transf = $data['has_transf'];
        $date = date("Y-m-d H:i:s");   

		

        DB::beginTransaction();
        
        try {
            $query_exec = "UPDATE
                            tbl_orc_lotacao
                        SET
                            lotacao_id = $lotacao_id,
                            cc_custo_id = $cc_custo_id,
                            updated_at = getdate(), 
                            has_transf = $has_transf  ,
                            orc_lotacao_id_origem = $orc_lotacao_destino_id ,
                            cc_custo_id_origem = $ccusto_id_origem  ,
                            lotacao_id_origem = $lotacao_id_origem
                        WHERE id = $transf_origem_id";

            $pdo = DB::connection()->getPdo();
            
            $query = $pdo->prepare($query_exec);
            
            if ($query->execute()) {
                $count = $query->rowCount();
            }

            if(!$query){
                // dd("teste", $query);
                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]='Falha ao atualizar registro. Erro: 040920201730b';

        } catch (\Exception $e) {
            DB::rollBack();
            
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 040920201730c';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730d - ' . $e->getMessage();
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;
    }
	
	public function inativaOrcLotacao($data, $orc_id, $lot_inativo_id){
        $orcLotacao = new OrcLotacao();
		
		if($data['has_transf'] == 0){
			
			$orc_lotacao_ativo_destino['ativo'] = 1;
			$lotacao_destino_id = $data['lotacao_destino_id'];	

			$orc_lotacao_ativo_origem['ativo'] = 0;
			$lotacao_origem_id = $lot_inativo_id[0]->lotacao_id;			
            $ccusto_id_origem = $lot_inativo_id[0]->cc_custo_id;	
		}else {
			
			$orc_lotacao_ativo_origem['ativo'] = 1;
			$lotacao_origem_id = $data['lotacao_destino_id'];
			$$ccusto_id_origem = $data['ccusto_destino_id'];
			
			$orc_lotacao_ativo_destino['ativo'] = 0;
			$lotacao_destino_id = $data['lotacao_origem_id'];	
			
		}		        

        $this->inativaOrcLotacaoDestino($orc_lotacao_ativo_destino, $orc_id, $lotacao_destino_id, $data['periodo'], $data['tipo_table']);
		$this->inativaOrcLotacaoOrigem($orc_lotacao_ativo_origem, $orc_id, $lotacao_origem_id,$ccusto_id_origem , $data['periodo'], $data['tipo_table']);

        return $this;
    }
	
	public function inativaOrcLotacaoDestino($orc_lotacao_ativo_destino, $orc_id, $lotacao_id, $periodo = null, $tipo_table = 'O'){
        $orcLotacao = new OrcLotacao();			        

        DB::beginTransaction();
        
        try {
            $result = $orcLotacao->where([   
				['orcamento_id', '=',  $orc_id],
                ['lotacao_id', '=',  $lotacao_id],
                ['tipo_table', '=',  $tipo_table]
            ]);

            if($tipo_table == 'F'){
                $result = $result->where('periodo', $periodo)->update($orc_lotacao_ativo_destino);
            }
            else{
                $result = $result->whereNull('periodo')->update($orc_lotacao_ativo_destino);
            }

            if(!$result){
		
                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 021220201513';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]='Registro atualizado com sucesso. Erro: 021220201514';

        } catch (\Exception $e) {
            DB::rollBack();
            
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 040920201730';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730' . $e;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;
    }
	
	public function inativaOrcLotacaoOrigem($orc_lotacao_ativo_origem, $orc_id, $lotacao_id, $cc_custo_id, $periodo = null, $tipo_table = 'O'){
        $orcLotacao = new OrcLotacao();

        DB::beginTransaction();
        
        try {

            $result = $orcLotacao->where([   
				['orcamento_id', '=',  $orc_id],
                ['lotacao_id', '=',  $lotacao_id],
                ['cc_custo_id', '=',  $cc_custo_id],
                ['tipo_table', '=',  $tipo_table]
            ]);
            if($tipo_table == 'F'){
                $result = $result->where('periodo', $periodo)->update($orc_lotacao_ativo_origem);
            }
            else{
                $result = $result->whereNull('periodo')->update($orc_lotacao_ativo_origem);
            }
            if(!$result){
		
                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 021220201513';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]='Registro atualizado com sucesso. Erro: 021220201514';

        } catch (\Exception $e) {
            DB::rollBack();
            
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 040920201730';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730' . $e;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;
    }

    public function deleteTransfDestino($orc_id, $data)
    {
		$where_periodo = $data['tipo_table'] == 'F' ? " and periodo = '{$data['periodo']}' and tipo_table = 'F' " : " and tipo_table = 'O' ";
        $lotacao_id = $data['lotacao_destino_id'];
        $cc_custo_id = $data['ccusto_destino_id'];
        $orc_lotacao_destino_id = $data['orc_lotacao_destino_id'];
        
        $query_exec = "DELETE tbl_orc_lotacao WHERE id = $orc_lotacao_destino_id";
        $query_exec_loc_cc = "DELETE tbl_orc_lotacao WHERE lotacao_id = $lotacao_id and cc_custo_id = $cc_custo_id and orcamento_id = $orc_id {$where_periodo}";

        $where = "";

        if($orc_lotacao_destino_id == 0){
            $where_periodo_lot = $data['tipo_table'] == 'F' ? " and olot.periodo = '{$data['periodo']}' and olot.tipo_table = 'F' " : " and olot.tipo_table = 'O' ";
            $where = " olot.lotacao_id = $lotacao_id and olot.cc_custo_id = $cc_custo_id and olot.orcamento_id = $orc_id {$where_periodo_lot} ";
        }
        else{
            $where = " olot.id =  {$orc_lotacao_destino_id} ";
        }

        $pode_deletar = DB::select("SELECT olot.* from tbl_orc_lotacao as olot

            left join tbl_orc_lot_carg_headcount as hd on hd.lotacao_id = olot.id
            -- left join tbl_orc_cargos_area_sal as oca on oca.lotacao_id = olot.id
            -- left join tbl_orc_salario_funcionario as sal on sal.lotacao_id = olot.id
            -- left join tbl_orc_benef_lot_carg as blc on blc.orc_lotacao_id = olot.id
            -- left join tbl_orc_beneficio_funcionario as bf on bf.orc_lotacao_id = olot.id
            -- left join tbl_orc_ppr as ppr on ppr.orc_lot_id = olot.id
            -- left join tbl_orc_bonus as b on b.orc_lot_id = olot.id
            -- left join tbl_orc_despesas as desp on desp.lotacao_id = olot.id
            -- left join tbl_orc_lot_carg_event as ce on ce.lotacao_id = olot.id
            -- left join tbl_lotacao_status_calculo as lsc on lsc.orc_lotacao_id = olot.id
            where {$where} and hd.id is null 
            -- and oca.id is null
            -- and sal.id is null and blc.orc_lotacao_id is null and bf.id is null and ppr.id is null and b.id is null and desp.id is null
            -- and ce.lotacao_id is null and lsc.id is null
        ");
        
        if($orc_lotacao_destino_id != 0){
            DB::table('tbl_orc_cargos_area_sal')->where('lotacao_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_orc_salario_funcionario ')->where('lotacao_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_orc_benef_lot_carg')->where('orc_lotacao_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_orc_beneficio_funcionario')->where('orc_lotacao_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_orc_ppr')->where('orc_lot_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_orc_bonus')->where('orc_lot_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_orc_despesas')->where('lotacao_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_orc_lot_carg_event')->where('lotacao_id', $orc_lotacao_destino_id)->delete();
            DB::table('tbl_lotacao_status_calculo')->where('orc_lotacao_id', $orc_lotacao_destino_id)->delete();
        }


        // if(count($pode_deletar) == 0){
        //     $retorno["status"] = "error";
        //     $retorno['msg'] = "Falha ao fazer operação. A lotação <b>{$this->getDesLotacaoByOrcId($where)}</b> está sendo usada. Erro: 120220211535";
        //     $retorno['submsg'] = 'Erro';
        //     goto saida;
        // }

        
        if(count($pode_deletar) == 0){ // ESTAVA (>=). MAS NA VERDADE, O SELECT RETORNA O REGISTRO CASO NÃO TENHA EM NENHUMA DAS TABELAS, E SE FOR ZERO QUER DIZER QUE EXISTE EM ALGUMA TABELA
            $retorno["status"] = "error";
            $retorno['msg'] = "Falha ao fazer operação. A lotação <b>{$this->getDesLotacaoByOrcId($where)}</b> está sendo usada. Erro: 120220211535";
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        DB::beginTransaction();

        try {

            $pdo = DB::connection()->getPdo();

            $query = ($orc_lotacao_destino_id == 0) ? $pdo->prepare($query_exec_loc_cc) : $pdo->prepare($query_exec);
            
            if ($query->execute()) {
                $count = $query->rowCount();
            }

            if(!$query){

                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao atualizar registro.";
                $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]='Falha ao atualizar registro. Erro: 040920201730b';

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 040920201730c';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 040920201730d' . $e;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;
    }

    public function selectTransf($entite, $params){
        $result = $entite::where($params)->count();
        return $result;
    }

    public function getDesLotacaoByOrcId($condicao){
        $lotacao = DB::select("SELECT CONCAT(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'desc' FROM tbl_orc_lotacao as olot
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            where {$condicao}
        ");

        return count($lotacao) > 0 ? $lotacao[0]->desc : null;
    }

    public function insertOrcLotacao(Request $request){        
        
        $orcLotacao = new OrcLotacao();
        $date = date("Y-m-d H:i:s");

        $data = $request->all();

        $orcLotacao->orcamento_id = $data['orcamento_id'];
        $orcLotacao->lotacao_id = $data['lotacao_id'];
        $orcLotacao->cc_custo_id = $data['cc_custo_id'];
        $orcLotacao->empresa_id = $data['empresa_id'];
        $orcLotacao->has_transf = $data['has_transf'];  
        $orcLotacao->responder_orc = 1; 
        $orcLotacao->status = 1;
        $orcLotacao->hc_iniciado = 0;
        $orcLotacao->created_at = $date;
       
        DB::beginTransaction();

        try {
            $result = $orcLotacao->save();

            if(!$result){
                $retorno["status"]="error";
                $retorno['msg'] = $table_entitie->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer inserir registro. Erro: 090920201553';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";  
            
        } catch (\Exception $e) {
            DB::rollBack();
            // dd("asdfasdfasdfasdfasdf". $e);
            abort(500,'Falha ao inserir registro. Erro: 090920201553.'.$e);   
        }
        saida:
         
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
          
        return $retorno;   
    }

    public function repopulateOrcLotacao($orc_id, $periodo = null, $tipo_table = 'O'){
        
        $repo_orc_scripts_calculos = new RepoOrcScriptCalculos();
        
        if($tipo_table == 'F'){
            if(!$repo_orc_scripts_calculos->scriptMergeOrcLotacaoForecast($orc_id, 1, $periodo, $tipo_table)){
                $retorno['msg'] = "Ocorreu uma falha ao repopular!";
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro:050220211435';
                $retorno['status'] = 'error';
            }
        }
        else{
            if(!$repo_orc_scripts_calculos->scriptMergeOrcLotacao($orc_id, 1)){
                $retorno['msg']="Ocorreu uma falha ao repopular!";
                $retorno['submsg']='Falha ao inserir o registro. Erro:131220191907';
                $retorno['status']='error';
            }
        }

                
        $retorno["status"]="success";
        $retorno["msg"]="Tabelas repopuladas com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);  
    }

    // public function updateBonus(Request $request,$orc_id){  
        
    //     $this->podeAcessar('editar',true,$this->getCodTela());

    //     $data = $request->all();
    //     unset($data['_token']);
    //     
    //     if(!$this->getRepository()->updateBonus($orc_id,$data)){                  
    //         $retorno["status"]="error";
    //         $retorno['msg'] = $this->getRepository()->getErrosFlatted();
    //         $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
    //         goto saida;               
    //     }
        
    //     $retorno["status"]="success";
    //     $retorno["msg"]="Registro atualizado com sucesso!";
    //     saida:       
     
    //     return $this->retornoJsonDefault($retorno); 
    // } 
 
    // public function deleteBonus(Request $request,$orc_id){  
        
    //     $this->podeAcessar('deletar',true,$this->getCodTela());

    //     $data = $request->all();

    //     if(!$this->getRepository()->deleteBonus($orc_id,$data)){                  
    //         $retorno["status"]="error";
    //         $retorno['msg'] = $this->getRepository()->getErrosFlatted();
    //         $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
    //         goto saida;               
    //     }
        
    //     $retorno["status"]="success";
    //     $retorno["msg"]="Registro deletado com sucesso!";
    //     saida:       
      
    //     return $this->retornoJsonDefault($retorno); 
    // }     
} 
