<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoForecast;
use App\Modules\Natureza51\Repositories\RepoOrcTurma as RepoOrcTurma;
use App\Modules\Natureza51\Repositories\RepoOrcTurmaEvento as RepoOrcTurmaEvento;
use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Repositories\RepoOrcEventos;
use App\Modules\Natureza51\Repositories\RepoOrcSalarioFuncionario;
use App\Modules\Natureza51\Repositories\RepoTurmaEvento;
use Illuminate\Http\Request;
use DB;
class OrcTurmaController extends OrcamentoController {

    private $retorno_deletar;
    private $type_retorno_deletar;
 
     public function __construct(){ 
        parent::__construct();
        $this->repository=new RepoOrcTurma();
        $this->setCodTela('OTT');
    }

    public function listOrcTurma($orc_id, $periodo = null, $tipo_table = 'O'){  
        $this->podeAcessar('listar',true,$this->getCodTela());      
        return $this->getRepository()->listOrcTurma($orc_id, $periodo, $tipo_table);
    }

    public function listOrcGroupTurma($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->listOrcGroupTurma($orc_id, $periodo, $tipo_table);
    }

    public function inserirOrcTurma(Request $request, $orc_id, $periodo = null, $tipo_table = 'O'){ 

        $this->podeAcessar('inserir',true,$this->getCodTela());
        set_time_limit(720);
        $data_insert = [];
        $request_data=$request->all();
        
        foreach($request_data['items'] as $key => $data){
            $array_turma_id[$key]=$data['id'];
            $data_insert[$key]=[
                'turma_id'=>$data['id'],
                'orc_id'=>$orc_id,
                'des_turma_trab' =>$data['des_turma_trab'],
                'cdn_turma_trab' =>$data['cdn_turma_trab'],
                'turno_id' =>$data['turno_id'],
                'evento_adc_id' =>$data['evento_adc_id'],
                'evento_ext_id' =>$data['evento_ext_id'],
                // 'user_id' =>$data['user_id'],
                'adic_noturno' =>$data['adic_noturno'],
                'extra_noturno' =>$data['extra_noturno'],
                'tipo_table' => $tipo_table,
                'periodo' => $periodo,
                'created_at' => $this->fillModificadoEm(),
                'created_by' => $this->fillModificadoPor()
                // 'ativo' =>$data['ativo'],
                // 'origem' =>$data['origem'],
                // 'des_turno_trab' =>$data['des_turno_trab']
            ];            
        }
 
        $array_data = collect($data_insert);
        
        $ja_existe = null;
        if($tipo_table == 'F'){
            $ja_existe=$this->getRepositoryOrModel()->getModelEntity()
            ->select("turma_id")
            ->where('orc_id',$orc_id)
            ->where('tipo_table', $tipo_table)
            ->where('periodo', $periodo)
            ->whereIn('turma_id', $array_turma_id)
            ->get()
            ->pluck("turma_id")->toArray();
        }
        else{
            $ja_existe=$this->getRepositoryOrModel()->getModelEntity()
            ->select("turma_id")
            ->where('orc_id',$orc_id)
            ->where('tipo_table', $tipo_table)
            ->whereNull('periodo')
            ->whereIn('turma_id', $array_turma_id)
            ->get()
            ->pluck("turma_id")->toArray();
        }
        
        
        $insert_data = $array_data->filter( function ($item) use($ja_existe) {                       
            return !in_array($item['turma_id'], $ja_existe)  ;
        });
        //dd($insert_data, $ja_existe);
		if($insert_data->count() - count($ja_existe) == 0){
            
			$retorno["status"]="error";
			$retorno["msg"]='A opção selecionada já existe.';
			$retorno['submsg']='Falha ao inserir. Erro 240220202004';
			goto saida;
		} 
        
        $orcamento=$this->getRepositoryOrModel()->getOrcInstanceNew()->find($orc_id);
        
		if($this->getRepositoryOrModel()->setOrcamento($orcamento)->canEdit()==false){//Se o usuario não tiver a pemissão
			$retorno["status"]="error";
			$retorno["msg"]='Não é possível cadastrar esta turma/turno pois o mesmo não permite.';
			$retorno['submsg']='Falha ao inserir. Erro 240220202006';
			goto saida;
        }
        // $array_orcamento=['id', 'display', 'value'];
        
        // $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] )); 
        
        
        foreach($insert_data as $data){
            
            $created = $this->getRepositoryOrModel()->create($data);
            if(!$created){
                $retorno["status"]="error";
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro:111220191024';
                goto saida;
            }
            if(!$this->insertTurmaEvento($created)){
                $retorno["status"]="error";
                $retorno['msg']=$this->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro:030820202028';
                goto saida;
            }



        }

        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);  
        
    } 

    public function insertTurmaEvento($orc_turma, $periodo = null, $tipo_table = 'O'){
        $repo_turma_evento = new RepoTurmaEvento();
        $repo_orc_turma_evento = new RepoOrcTurmaEvento();
        $repo_orc_eventos = new RepoOrcEventos();
        $turma_eventos = $repo_turma_evento->getModelEntity()->where('turma_id', $orc_turma['turma_id'])->get()->toArray();
        // dd($turma_eventos);
        foreach ($turma_eventos as $evento) {
            $orc_evento = null;
            $query = $repo_orc_eventos->getModelEntity()->where('orcamento_id', $orc_turma['orc_id'])
            ->where('evento_id',$evento['evento_id']);

            if($tipo_table == 'F'){
                $orc_evento = $query->where('periodo', $periodo)->first();
            }
            else{
                $orc_evento = $query->whereNull('periodo')->first();
            }

            if(!$orc_evento){
                continue;
            }
            $data_insert = [
                'turma_evento_id' => $evento['id'],
                'orc_id' => $orc_turma['orc_id'],
                'turma_id' => $orc_turma['id'],
                'evento_id' => $orc_evento->id,
                'qtd_hrs' => $evento['qtd_hrs'],
                'tipo_table' => $tipo_table,
                'periodo' => $periodo,
                'created_at' => $this->fillModificadoEm(),
                'created_by' => $this->fillModificadoPor()
            ];
            
            if(!$repo_orc_turma_evento->create($data_insert)){
                $this->setError($repo_orc_turma_evento->getErrosFlatted());
                return false;
            }
        }

        $retorno = $this->sp_insert_calc_orc_turma_evento($orc_turma['orc_id'], $tipo_table, $periodo);
    
        if ($retorno['status'] == 'error'){
            return false;
        }

        return true;
    }

    private function podeDeletar($orc_id, $periodo, $tipo_table, $records){
        $where[0] = $tipo_table == 'F' ? " and t.periodo = '{$periodo}' and t.tipo_table = '{$tipo_table}' " : " and t.tipo_table = '{$tipo_table}' ";
        $where[1] = $tipo_table == 'F' ? " and f.periodo = '{$periodo}' and f.tipo_table = '{$tipo_table}' " : " and f.tipo_table = '{$tipo_table}' ";

        $select = DB::select("SELECT distinct t.id from tbl_orc_turma as t
            left join tbl_orc_salario_funcionario as f on f.orc_turma_id = t.id {$where[1]}
            --left join tbl_orc_turma_evento as te on te.turma_id = t.id --or te.id is not null
            where t.orc_id = $orc_id {$where[0]} and (f.id is not null ) and t.id in(".implode(',', array_column($records, 'id')).")
        ");
        
        $all_records = [];
        foreach($records as $record){
            $aux = true;
            foreach($select as $id){
                if($record['id'] == $id->id){
                    $aux = false;
                    break;
                }
                else{
                    $aux = true;
                    continue;
                }
            }
            if($aux == true){
                $all_records[] = $record;
            }
        }
        return $all_records;
    }
	public function deletar(Request $request, $orc_id, $periodo = null, $tipo_table = 'O'){
        $this->podeAcessar('deletar',true,$this->getCodTela());
        set_time_limit(720);
        
        $request_data=$request->all();
        $hasError = false;
        $retorno = $this->getArrayRetornoDefault();
        
        $turma_ids = array_column($request_data['items'], 'id');
        DB::transaction(function()use($request_data, $orc_id, &$hasError, &$retorno, $turma_ids, $tipo_table, $periodo){
            // foreach($request_data['items'] as $key => $data){

            //     $array_turma_id[$key]=$data['id'];
            
            $query = $this->getRepository()->getModelEntity()
                ->where('orc_id',$orc_id)
                ->where('tipo_table', $tipo_table)
                ->whereIn('turma_id',$turma_ids);

            $all_records = [];
            $ids_excluir = null;
            if($tipo_table == 'F'){
                $all_records1 = $query->where('periodo', $periodo)->get()->toArray();
                $all_records = $this->podeDeletar($orc_id, $periodo, $tipo_table, $all_records1);
                if(count($all_records) == 0){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210848';
                    $retorno['submsg'] = 'Erro';
                    $hasError = true;
                    abort(500, 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210848');
                }
                $ids_excluir = $this->validaDeletarForecast($all_records, true, $periodo);
                if($ids_excluir == 0){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210903';
                    $retorno['submsg'] = 'Erro';
                    $hasError = true;
                    abort(500, 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210903');
                }
            }
            else{
                $all_records1 = $query->whereNull('periodo')->get()->toArray();
                $all_records = $this->podeDeletar($orc_id, null, $tipo_table, $all_records1);
                if(count($all_records) == 0){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210848b';
                    $retorno['submsg'] = 'Erro';
                    $hasError = true;
                    abort(500, 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210848b');
                }
                $ids_excluir = $this->validaDeletar($all_records);
                // dd($all_records);
                if($ids_excluir == 0){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210904';
                    $retorno['submsg'] = 'Erro';
                    $hasError = true;
                    abort(500, 'Falha ao deletar. O(s) registro(s) selecionado(s) está(ão) sendo utilizado(s). Erro: 230220210904');
                }
            } 
            // dd('b', $ids_excluir);

            $records = $this->getRepository()->getModelEntity()->whereIn('id',$ids_excluir);
            
            if(count($records->get()) > 0 && !$records->delete()){
                $retorno['status']='error';
                // $retorno['msg']='Falha ao deletar o registro'.$data['display'].'Erro: 170220200946.';
                $retorno['msg']='Falha ao deletar o registro. Erro: 170220200946.';
                $hasError=true;
                abort(500,'Falha ao remover registro de turma. Erro: 280420201843.');				
                // break;
            }           	   

            // }
        });
			
        if($hasError){
            $retorno['status'] = 'error';
            goto saida;
        }		

        $retorno['status']=$this->getTypeRetornoDeletar();
        $retorno['msg']=$this->getRetornoDeletar();

        saida:   
        return $retorno;

    }

    public function populaOrcTurma($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->podeAcessar('atualizar',true,$this->getCodTela());
        if(! $this->getRepositoryOrModel()->populaOrcTurma($orc_id, $periodo, $tipo_table)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
        
        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
       
    }

    public function validaDeletar($items, $deletar_turma_evento = true){
        $repo_turma_evento = new RepoOrcTurmaEvento();
        $repo_headcount = new RepoHeadcount();
        $qtd_items = count($items);
        
        $this->setRetornoDeletar($qtd_items == 1 ? 'Registro deletado com sucesso!' : 'Registros deletados com sucesso!');
        $this->setTypeRetornoDeletar('success');
        
       
        $headcount_records = $repo_headcount->getModelEntity()->where('tipo_table', 'O')->whereNull('periodo')->whereIn('orc_turma_id', array_column($items,'id'))->get()->toArray();
        
        foreach ($headcount_records as $headcount) {
            $this->setRetornoDeletar($qtd_items == 1 ? 'Não foi possível remover esta turma pois já existem headcounts ligados a ela!' : 'Não foi possível remover algumas turmas pois já existem headcounts ligados a elas!');
            $this->setTypeRetornoDeletar('warning');
            $items = array_filter($items, function($atual)use($headcount){
                return $atual['id'] != $headcount['orc_turma_id'];
            });
        }
        $items = array_values($items);
        if(count($items) > 0){
            if($deletar_turma_evento){
           
                $retorno = $this->sp_delete_calc_orc_turma_evento($items[0]['orc_id'], $items[0]['turma_id']);
    
                if ($retorno['status'] == 'error'){
                    return false;
                }
    
                $deleteds = $repo_turma_evento->getModelEntity()->where('tipo_table', 'O')->whereNull('periodo')->whereIn('turma_id', array_column($items,'id'))->delete();
                return array_column($items, 'id');
            }
            // dd($items);
    
            $turma_eventos = $repo_turma_evento->getModelEntity()->where('tipo_table', 'O')->whereNull('periodo')->whereIn('turma_id', array_column($items,'id'))->get()->toArray();
    
            foreach ($turma_eventos as $turma_evento) {
                $this->setRetornoDeletar($qtd_items == 1 ? 'Não foi possível remover esta turma pois já existem eventos cadastrados a ela!' : 'Não foi possível remover algumas turmas pois já existem eventos cadastrados a elas!');
                $this->setTypeRetornoDeletar('warning');
                $items = array_filter($items, function($atual)use($turma_evento){
                    return $atual['id'] != $turma_evento['turma_id'];
                });
            }        
    
            return array_column($items, 'id');
        }
        return 0;
    }

    public function validaDeletarForecast($items, $deletar_turma_evento = true, $periodo){
        $repo_turma_evento = new RepoOrcTurmaEvento();
        $repo_forecast = new RepoForecast();
        $qtd_items = count($items);
        
        $this->setRetornoDeletar($qtd_items == 1 ? 'Registro deletado com sucesso!' : 'Registros deletados com sucesso!');
        $this->setTypeRetornoDeletar('success');
        
       
        $forecast_records = $repo_forecast->getModelEntity()
        /* FOI COMENTADO POR CAUSA DO REALIZADO, PARECE QUE ESTÁ PEGANDO A TURMA DA PARAMETRIZAÇÃO DO FORECAST
        ->where('tipo_table', 'F')
        ->where('periodo', $periodo) */
        ->whereIn('orc_turma_id', array_column($items,'id'))->get()->toArray();
        
        foreach ($forecast_records as $forecast) {
            $this->setRetornoDeletar($qtd_items == 1 ? 'Não foi possível remover esta turma pois já existem Forecasts ligados a ela!' : 'Não foi possível remover algumas turmas pois já existem Forecasts ligados a elas!');
            $this->setTypeRetornoDeletar('warning');
            $items = array_filter($items, function($atual)use($forecast){
                return $atual['id'] != $forecast['orc_turma_id'];
            });
        }        
        $items = array_values($items);
        
        if(count($items) > 0){
            
            if($deletar_turma_evento){
            
                $retorno = $this->sp_delete_calc_orc_turma_evento($items[0]['orc_id'], $items[0]['turma_id'], 'F', $periodo);

                if ($retorno['status'] == 'error'){
                    return false;
                }

                $deleteds = $repo_turma_evento->getModelEntity()->where('tipo_table', 'F')->where('periodo', $periodo)->whereIn('turma_id', array_column($items,'id'))->delete();
                return array_column($items, 'id');
            }

            $turma_eventos = $repo_turma_evento->getModelEntity()->where('tipo_table', 'F')->where('periodo', $periodo)->whereIn('turma_id', array_column($items,'id'))->get()->toArray();

            foreach ($turma_eventos as $turma_evento) {
                $this->setRetornoDeletar($qtd_items == 1 ? 'Não foi possível remover esta turma pois já existem eventos cadastrados a ela!' : 'Não foi possível remover algumas turmas pois já existem eventos cadastrados a elas!');
                $this->setTypeRetornoDeletar('warning');
                $items = array_filter($items, function($atual)use($turma_evento){
                    return $atual['id'] != $turma_evento['turma_id'];
                });
            }        

            return array_column($items, 'id');
        }
        return 0;
    }

    public function sp_insert_calc_orc_turma_evento($orc_id, $tipo_table = 'O', $periodo = NULL){
        $value  = 'Falha ao inserir registros na tela Salário! Erro: 240820202013';
        $sp_name = $tipo_table == 'O' ? 'sp_insert_calc_orc_turma_evento' : 'sp_insert_calc_orc_turma_evento_forecast';
        $usuario_id = $this->fillModificadoPor();

        DB::beginTransaction();

        try {

            $sql="EXEC $sp_name :orc_id";

            $sql= $tipo_table == 'O' ? "EXEC $sp_name :orc_id, :usuario_id" : "EXEC $sp_name :orc_id, :tipo_table, :periodo, :usuario_id" ;


            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            
            if($tipo_table == 'F'){
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            }
            else{
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            }
            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao inserir registro. Erro: 240820202013 | '.$sp_name;
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros inserido com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 240820202013 - ' . $sp_name;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function sp_delete_calc_orc_turma_evento($orc_id, $turma_ids, $tipo_table = 'O', $periodo = NULL){
        $value  = 'Falha ao inserir registros na tela Salário! Erro: 240820202013';
        $sp_name = $tipo_table == 'O' ? 'sp_delete_calc_orc_turma_evento' : 'sp_delete_calc_orc_turma_evento_forecast';
        DB::beginTransaction();

        try {

            $sql= $tipo_table == 'O' ? "EXEC $sp_name :orc_id, :turma_id" : "EXEC $sp_name :orc_id, :turma_id, :tipo_table, :periodo" ;

            $stmt=DB::getPdo()->prepare($sql);
            // dd("stmt", $stmt, $orc_id, $turma_ids);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':turma_id', $turma_ids, \PDO::PARAM_INT );

            if($tipo_table == 'F'){
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );                
            }

            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']="Falha ao inserir registro. Erro: 240820202013 | ".$sp_name;
                goto saida;
            }

            

            $retorno["status"]="success";
            $retorno["msg"]=" Registros inserido com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 240820202013 - ' . $sp_name;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function setRetornoDeletar($valor){
        $this->retorno_deletar = $valor;
        return $this;
    }
    public function getRetornoDeletar(){
        return $this->retorno_deletar;
    }

    public function setTypeRetornoDeletar($valor){
        $this->type_retorno_deletar = $valor;
        return $this;
    }
    public function getTypeRetornoDeletar(){
        return $this->type_retorno_deletar;
    }
    
}