<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcTurmaEvento as RepoOrcTurmaEvento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\OrcTurmaEvento;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;
use DB;
use Carbon\Carbon;

class OrcTurmaEventoController extends Natureza51Ctrl
{
     public function __construct(){
        $this->repository=new RepoOrcTurmaEvento();
        parent::__construct(); 
    }

    public function listarTurmaEvento($orc_id, $periodo = null, $tipo_table = 'O'){
        $data = $this->getRepository()->listarOrcTurmaEvento($orc_id, $periodo, $tipo_table);   
        $cont = count($data);
        for ($i=0; $i < $cont ; $i++) { 
            $data[$i] = (array) $data[$i];
        }
        return $data;

        // return $this->montarTreetable($data);
    }

    public function insertTurmaEvento(Request $request, $orc_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(120);
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $form_data = $request->all();
        
        $where_periodo = $tipo_table == 'O' ? " and tba.tipo_table = '{$tipo_table}' " :  " and tba.tipo_table = '{$tipo_table}' and tba.periodo = '{$periodo}' ";

        $orc_id = $form_data['orc_id'];
        $turmas = $form_data['turmas'];
        $eventos = $form_data['eventos'];
        $qtd_hrs = $form_data['qtd_hrs'];
        $meses = $form_data['meses'];
      
        if(count($form_data['turmas']) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione as turmas para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 150620201513';
            goto saida;               
        }

        if(count($form_data['eventos']) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione os eventos para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 150620201514';
            goto saida;               
        }

   
      
        $data_insert = [];
        $data_inserir = [];
        
        foreach($turmas as $turmas_id){
            foreach( $eventos as $eventos_id){
                $query = $this->getRepository()->getModelEntity()->where([['orc_id',$orc_id],['turma_id',$turmas_id],['evento_id',$eventos_id],['tipo_table',$tipo_table]]);
                
                if($tipo_table == 'F'){
                    $query->where('periodo', $periodo);
                }

                $existe = $query->count();
                if($existe == 0){
                    array_push($data_insert,
                    [
                        'orc_id'=>$orc_id,
                        'turma_id'=>$turmas_id,
                        'evento_id'=>$eventos_id, 
                        'qtd_hrs'=>$qtd_hrs,
                        'tipo_table'=>$tipo_table,
                        'periodo'=>$periodo,
                        'created_by'=>$this->fillCriadoPor(),
                        'created_at'=>$this->fillCriadoEm(), 
                        'empresa_id'=>$this->fillCodEmpresa(),
                    ]);
                }
            }
        }
        $has_error = false;
        DB::transaction(function () use ($data_insert, $data_inserir, $orc_id, $meses, $repo_calc_orcamento, &$retorno, $where_periodo) {
            $j=0;
            for($i=0; $i < count($data_insert); $i++){
                $j++;
                array_push($data_inserir,$data_insert[$i]);
                
    
                if($j==300 || $i==count($data_insert)-1){
                    if(!$this->getRepository()->getModelEntity()->insert($data_inserir)){ 
                        $retorno["status"]="error";
                        $retorno['msg'] = "Falha ao inserir turma por evento";
                        $retorno['submsg']='Falha ao fazer insert do registro. Erro: 150620201537';
                        $has_error = true;
                        abort (500,"Falha ao inserir turma por evento");
                        return false;
                    }
                    foreach ($data_inserir as $data) {
                        $origem_id = DB::select("SELECT tba.id origem_id  				    
                            FROM 
                                [dbo].[tbl_orc_turma_evento] tba				
                                LEFT JOIN [dbo].[tbl_calc_orcamento] c on tba.id = c.origem_id and 'tbl_orc_turma_evento' = c.tbl_origem   
                            WHERE
                                tba.[orc_id] = $orc_id {$where_periodo}
                                AND c.id is null");
                
                        $merge_tb_calc = [
                            'origem_id' =>$origem_id[0]->origem_id,
                            'tbl_origem' => $this->getRepository()->getModelEntity()->getTable()
                        ];
                        $insert = array_merge($merge_tb_calc, $meses);
                        
                        if(!$repo_calc_orcamento->create($insert)){
                            $retorno['msg']='Falha ao inserir o registro. Erro: 240820201130.';
                            $retorno['submsg']=$repo_calc_orcamento->getErrosFlatted();
                            $has_error = true;
                            abort (500,"Falha ao inserir turma por evento");
                            return false;
                        }
                    }
                    $data_inserir = [];
                    $j=0;
                    
                }
                
            }

        });    
        if($has_error){
            goto saida;
        }
        

        $retorno["status"]="success";
        $retorno["msg"]="Registro inserido com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 

    }

    public function updateTurmaEvento(Request $request,$orc_id, $periodo = null, $tipo_table = 'O'){  
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $data = $request->all();

        if(array_key_exists('jan_orcado', $data['data_up'])){
            $meses = convertDecimalEn(Arr::only($data['data_up'],['jan_orcado', 'fev_orcado', 'mar_orcado',
            'abr_orcado', 'mai_orcado', 'jun_orcado', 'jul_orcado', 'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado']));
        }
        else{
            $meses_aux = convertDecimalEn(Arr::only($data['data_up'],['jan', 'fev', 'mar',
            'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez']));
            $meses['jan_orcado'] = $meses_aux['jan'];
            $meses['fev_orcado'] = $meses_aux['fev'];
            $meses['mar_orcado'] = $meses_aux['mar'];
            $meses['abr_orcado'] = $meses_aux['abr'];
            $meses['mai_orcado'] = $meses_aux['mai'];
            $meses['jun_orcado'] = $meses_aux['jun'];
            $meses['jul_orcado'] = $meses_aux['jul'];
            $meses['ago_orcado'] = $meses_aux['ago'];
            $meses['set_orcado'] = $meses_aux['set'];
            $meses['out_orcado'] = $meses_aux['out'];
            $meses['nov_orcado'] = $meses_aux['nov'];
            $meses['dez_orcado'] = $meses_aux['dez'];
        }

        unset($data['_token']);
        unset($data['data_up']);

        // dd($meses);
        if(!$repo_calc_orcamento->update($meses,['origem_id'=>$data['id'],'tbl_origem'=>$this->getRepository()->getModelEntity()->getTable()])){                  
            $retorno["status"]="error";
            $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 240820201210';
            goto saida;               
        } 

        if(!$this->getRepository()->updateOrcTurmaEvento($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 150620201538';
            goto saida;                
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    }
    public function deleteTurmaEvento(Request $request,$orc_id, $periodo = null, $tipo_table = 'O'){  
        $data = $request->all();
        
        if(!$this->getRepository()->deleteOrcTurmaEvento($orc_id,$data, $periodo, $tipo_table)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 150620201539';
            goto saida;               
        }
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 
    public function deleteTurmaEventoSeveral(Request $request,$orc_id){  
            
        $data = $request->all(); 
        unset($data['_token']); 

        for($i=0; $i<count($data);$i++){
            
            if(!$this->getRepository()->deleteTurmaEventoSeveral($orc_id,$data[$i])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 150620201540';
                goto saida;               
            }
        }

        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
    
        return $this->retornoJsonDefault($retorno); 
    }
    public function getTurmaByEvento(Request $request, $orc_id){
        $all = $request->all();
        unset($all['_token']);

        $data = $this->repository->getTurmaByEvento($all, $orc_id);
        for ($i=0; $i < count($all); $i++) { 
            $data[(count($data))+$i] = array('parent'=>$all[$i],'evento_id'=>null); 
        }
        return $this->montarTreetable($data);
    }
    public function montarTreetable($data){

        $column_fixeds=[ 
            ["field_out"=>"parent", "from"=>"parent","render_value"=>null],
            ["field_out"=>"turma", "from"=>"parent", "render_value"=>null,],
        ];
        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"evento", "from"=>"evento", "render_value"=>null,],
            ["field_out"=>"qtd_hrs", "from"=>"qtd_hrs", "render_value"=>null,]        
        ];

        $settings=["columns"=>$column_fixeds,
        "keys"=>['parent'],
        "filter_data"=>['turma_id'=>function($value){
            return is_null($value);
        }],                        
        "children"=>["columns"=>$column_fixeds_children,
                "keys"=>['turma_id','id'],
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                 }],
                'parent_filter'=> function($value, $parent_data){      
                        return $value['turma_id']== $parent_data['parent'] ;
                },
            ] 
        ];

        $controller=new AtmTreeTable($settings, $data);
        return $controller->render();
    }


    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'EventosTurma',['turma_id','evento_id','desc_turma','evento','desc_evento','criado_por','criado_em','atualizado_por','atualizado_em']);
    }

    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("desc evento", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("des turma", "Turma", $colunas[$i]);
            $colunas[$i] = str_replace("desc ", "", $colunas[$i]);
            $colunas[$i] = str_replace("des ", "", $colunas[$i]);
            $colunas[$i] = str_replace("horas", "Horas", $colunas[$i]);

        }
        return $colunas;
    }


}