<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotCargoEvento as RepoOrcLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Repositories\RepoOrcEventos as RepoOrcEventos;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use Excel;
class OrcamLotCargoEventoController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcLotCargoEvento());
        $this->setCodTela('OLCE');
    }

    public function insertLotCargo(Request $request, $orc_id){
        set_time_limit(700);
        
        $repoCalcOrc = new RepoCalcOrcamento;
        $form_data = $request->all();
        $cargos_excessoes = $form_data['cargos_excessoes'];
        $cargos_excessoes_ids = array_column($cargos_excessoes, 'cargo_id');
        $lotacoes = $form_data['lotacoes'];
        $eventos = $form_data['eventos'];
        $orc_lotacao_ids = array_column($lotacoes, 'id');
        $orc_evento_ids = array_column($eventos, 'id');
        $grades = $form_data['grades'];
        
        $tipo_table = $form_data['tipo_table'];
        $periodo = $form_data['periodo'];
        

        if(count($orc_lotacao_ids) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione as lotações para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620200945';
            goto saida;               
        }

        if(count($orc_evento_ids) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione os eventos para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620201409';
            goto saida;               
        }
        if(count($grades) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione os grades salariais para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620200946';
            goto saida;               
        }

        $lotacs = '';
        $events = '';
        foreach ($orc_lotacao_ids as $orcs) {
            $lotacs = $lotacs . $orcs . ',';
        }
        $lotacs = substr($lotacs,0, strlen($lotacs)-1);

        foreach ($orc_evento_ids as $orcs) {
            $events = $events . $orcs . ',';
        }
        $events = substr($events,0, strlen($events)-1);

        $grades_condition = '';
        foreach ($grades as $grade) {
            $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
        }
        $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);

        if(count($cargos_excessoes_ids) > 0){
            $cargs_exc_condition = 'and c.id not in(';
            foreach ($cargos_excessoes_ids as $id) {
                $cargs_exc_condition = $cargs_exc_condition . $id . ',';
            }
            $cargs_exc_condition = substr($cargs_exc_condition,0, strlen($cargs_exc_condition)-1);
            $cargs_exc_condition = $cargs_exc_condition . ')';
        }
        else{
            $cargs_exc_condition = '';
        }
      
        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}'" : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";

        $data = DB::select("SELECT 
            oc.id as cargo_id,
            ocas.lotacao_id as lotacao_id,
            orc_l.cc_custo_id,
            c.des_cargo_basic
        from tbl_orc_cargos_area_sal as ocas
            inner join tbl_orc_lotacao as orc_l on orc_l.id = ocas.lotacao_id
            inner join tbl_orc_cargo as oc on oc.id = ocas.cargo_id {$condicao[1]}
            inner join tbl_cargo as c on c.id = oc.cargo_id
        where ocas.orcamento_id = $orc_id
            and ocas.lotacao_id in ($lotacs)
            $cargs_exc_condition
            and ($grades_condition)".$condicao[0]."
        ");
    
        $data_insert = [];

     

        foreach ($eventos as $evento) {
            $meses = $repoCalcOrc->getModelEntity()->select("I_sec", "jan_orcado","fev_orcado","mar_orcado","abr_orcado","mai_orcado","jun_orcado","jul_orcado","ago_orcado","set_orcado","out_orcado","nov_orcado","dez_orcado")
            ->where('origem_id', $evento['id'])
            ->where('tbl_origem', 'tbl_orc_eventos')->first();

            foreach ($data as $item) {            
                $data_compare = [  
                    'orc_id'    =>$orc_id,
                    'orc_cargo_id'  =>$item->cargo_id,
                    'evento_id' => $evento['evento_id'],
                    'lotacao_id' => $item->lotacao_id,
                    'ccusto_id' =>$item->cc_custo_id,
                    'tipo_table' =>$tipo_table
                ];
                if($tipo_table == 'F'){
                    $data_compare['periodo'] = $periodo;
                }
                
                $existe = OrcamLotCargoEvento::where($data_compare)->get();
                if(count($existe) != 0){
                    continue;
                }
                
                if(!$record = $this->getRepository()->create($data_compare)){ 
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao inserir evento";
                    $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620200948';
                    goto saida;               
                }
                
                $dataCalcOrc = $meses->toArray();           
                unset ($dataCalcOrc['id']);
                $dataCalcOrc['origem_id'] = $record->id;
                $dataCalcOrc['tbl_origem'] = $this->getRepository()->getModelEntity()->getTable();
                
                if(!$record =$repoCalcOrc->create($dataCalcOrc)){ 
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao inserir evento";
                    $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620200948';
                    goto saida;      
                  
         
                }
            }
        }

        
        $retorno["status"]="success";
        $retorno["msg"]="Registro inserido com sucesso!";
        saida:       
    
        return $this->retornoJsonDefault($retorno); 

    }
    public function updateLotCargo(Request $request,$orc_id){  
            
        $data = $request->all();
        unset($data['_token']);
        if(!$this->getRepository()->updateLotCargo($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 090620200950';
            goto saida;                
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
    
        return $this->retornoJsonDefault($retorno); 
    }
    public function deleteLotCargo(Request $request,$orc_id){  
            
        $data = $request->all();

        if(!$this->getRepository()->deleteLotCargo($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 090620200951';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
    
        return $this->retornoJsonDefault($retorno); 
    } 
    public function deleteLotCargoSeveral(Request $request,$orc_id){  
                
        $data = $request->all(); 
        unset($data['_token']); 
   
        for($i = 0; $i<count($data);$i++){
            
            if(!$this->getRepository()->deleteLotCargo($orc_id, $data[$i])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 090620200957';
                goto saida;               
            }
        }

        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       

        return $this->retornoJsonDefault($retorno); 
    }  
    public function listarLotCargo($orc_id, $periodo = null, $tipo_table = 'O'){
        $data = $this->getRepository()->listarEventoLotCargo($orc_id, $periodo, $tipo_table);   
        $cont = count($data);
        for ($i=0; $i < $cont ; $i++) { 
            $data[$i] = (array) $data[$i];
            $data[(count($data))+$i] = array('parent'=>$data[$i]['grade_sal'],'grade_sal'=>null); 

        }

        return $this->montarTreetable($data);
    }  
    public function getCargoByGrade(Request $request, $orc_id){
        $all = $request->all();
        unset($all['_token']);

        $data = $this->repository->getCargoByGrade($all, $orc_id);
        

        for ($i=0; $i < count($all); $i++) { 
            $data[(count($data))+$i] = array('parent'=>$all[$i],'grade_salarial'=>null); 
        }
        return $this->montarTreetable($data);
    }
    public function getCargosExcessao(Request $request, $orc_id){
        $grades = $request->all()['grades'];
        $lotacoes = $request->all()['lotacoes'];
        $tipo_table = $request->all()['tipo_table'];
        $periodo = $request->all()['periodo'];
        
        $orc_lotacao_ids = array_column($lotacoes, 'id');
        $lotacs = '';
        foreach ($orc_lotacao_ids as $orcs) {
            $lotacs = $lotacs . $orcs . ',';
        }
        $lotacs = substr($lotacs,0, strlen($lotacs)-1);
        $grades_condition = '';
        foreach ($grades as $grade) {
            $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
        }
        $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);

        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}'" : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";

        $data = DB::select("SELECT
            DISTINCT(c.id) as cargo_id, 
            c.des_cargo_basic, 
            c.cod_cargo_basic,
            CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as description
            from tbl_orc_cargos_area_sal as ocas
            inner join tbl_orc_cargo as oc on oc.id = ocas.cargo_id {$condicao[1]}
            inner join tbl_cargo as c on c.id = oc.cargo_id
            where ocas.orcamento_id = $orc_id
            and ocas.lotacao_id in ($lotacs)
            and ($grades_condition)".$condicao[0]."
        ");
        
        return $data;
    }
    public function montarTreetable($data){

        $column_fixeds=[ 
            ["field_out"=>"parent", "from"=>"parent","render_value"=>null],
            ["field_out"=>"grade_sal", "from"=>"parent", "render_value"=>null,],
        ];
        $column_fixeds_children=[  
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            ["field_out"=>"description_cargo", "from"=>"description_cargo", "render_value"=>null,],
            ["field_out"=>"des_event", "from"=>"des_event", "render_value"=>null,],
            ["field_out"=>"grade_sal","from"=>"cod_cargo", "render_value"=>null,],
            ["field_out"=>"orc_lotacao_id","from"=>"orc_lotacao_id", "render_value"=>null,],
            ["field_out"=>"lotacao","from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"evento","from"=>"evento", "render_value"=>null,],
            ["field_out"=>"jan","from"=>"jan", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"fev","from"=>"fev", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"mar","from"=>"mar", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"abr","from"=>"abr", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"mai","from"=>"mai", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"jun","from"=>"jun", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"jul","from"=>"jul", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"ago","from"=>"ago", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"set","from"=>"set", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"out","from"=>"out", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"nov","from"=>"nov", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],
            ["field_out"=>"dez","from"=>"dez", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value,6,',', '.'));
            },],

            ["field_out"=>"criado_por","from"=>"criado_por", "render_value"=>null,],
            ["field_out"=>"criado_em","from"=>"criado_em", "render_value"=>null,],
            ["field_out"=>"atualizado_por","from"=>"atualizado_por", "render_value"=>null,],
            ["field_out"=>"atualizado_em","from"=>"atualizado_em", "render_value"=>null,],

        ];


        $settings=["columns"=>$column_fixeds,
        "keys"=>['parent'],
        "filter_data"=>['grade_sal'=>function($value){
            return is_null($value);
        }],                        
        "children"=>["columns"=>$column_fixeds_children,
                "keys"=>['grade_sal','id'],
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                 }],
                'parent_filter'=> function($value, $parent_data){      
                        return $value['grade_sal']== $parent_data['parent'] ;
                },
            ] 
        ];

        $controller=new AtmTreeTable($settings, $data);
        return $controller->render();
    }

    public function ListarOrcEventosTp2($orc_id, $periodo = null, $tipo_table = 'O'){
        $repoOrcEventos = new RepoOrcEventos(); 
        $query = $repoOrcEventos->getModelEntity()->where('orcamento_id', $orc_id)
        ->where('tipo_table', $tipo_table)
        ->where('tipo_acesso', 2);

        $data = null;
        if($tipo_table == 'F'){
            $data = $query->where('periodo', $periodo)->get();
        }
        else{
            $data = $query->whereNull('periodo')->get();
        }

        foreach ($data as $item) {
            $item->description = $item->cdn_event . ' - ' . $item->des_event;
        }

    

        return $data;
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        // dd(json_decode($_POST['array_imprimir']));

        ini_set('memory_limit', '-1');
        return parent::downloadExcel($type, 'EventoCargoLotacao',['des_event','cargo','turma_id','evento_id', 'orc_lotacao_id','criado_por','criado_em','atualizado_por','atualizado_em']);
    }
    
    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
    //         dd(json_decode($_POST['array_imprimir']));
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("des event", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("grade sal", "GS", $colunas[$i]);
            $colunas[$i] = str_replace("lotacao", "Lotação", $colunas[$i]);

              
            $colunas[$i] = str_replace("jan", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez", "Dezembro", $colunas[$i]);
            $colunas[$i] = str_replace("description Cargo", "Cargo", $colunas[$i]);
        }
        return $colunas;
    }

    public function repopulate($orc_id, Request $request){
        $dados = $request->all();
        $retorno = [];
        
        if($dados['tipo'] == 0){
            
            $res = DB::statement(DB::raw("
                SET NOCOUNT ON ;
                EXEC delete_eventos_lotacao_cargo_sem_meses
                    @orcamento_id = $orc_id,
                    @tipo_table = '".$dados['tipo_table']."',
                    @periodo = '".$dados['periodo']."';        
                ")); 
            $resp = $this->getRepositoryOrModel()->repopulate($orc_id, $dados['tipo_table'], $dados['periodo']);
            if($resp === false){
                $retorno['status'] = 'error';
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
            }
            else if($resp === 'warning'){
                $retorno['status'] = 'warning';
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Atenção';
            }
            else{
                $retorno['status'] = $this->getRepositoryOrModel()->getErrosFlatted() == "" ? 'success' : $retorno['status'];
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted() == "" ? "Registro(s) inserido(s) com sucesso!" : $retorno['msg'];
                $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted() == "" ? 'Sucesso' : $retorno['submsg'];
            }
            return $retorno;
        }
        else{
            $resp = $this->getRepositoryOrModel()->repopulateAll($orc_id, $dados['periodo'], $dados['tipo_table']);
            if($resp === false){
                $retorno['status'] = 'error';
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
            }
            else{
                $retorno['status'] = $this->getRepositoryOrModel()->getErrosFlatted() == "" ? 'success' : $retorno['status'];
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted() == "" ? "Registro atualizado com sucesso!" : $retorno['msg'];
                $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted() == "" ? 'Sucesso' : $retorno['submsg'];
            }
            return $retorno;
        }
    }
}