<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcamento as RepoOrcamento;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Modules\Natureza51\Repositories\RepoCargoAreaSal;
use App\Modules\Natureza51\Repositories\RepoHoraExtra;
use App\Modules\Natureza51\Repositories\RepoLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcBeneficio;
use App\Modules\Natureza51\Repositories\RepoOrcBonus;
use App\Modules\Natureza51\Repositories\RepoOrcCargo; 
use App\Modules\Natureza51\Repositories\RepoOrcTurma;
use App\Modules\Natureza51\Repositories\RepoOrcLotacaoNaturezaEvento;
use App\Modules\Natureza51\Repositories\RepoOrcHoraExtra;
use App\Modules\Natureza51\Repositories\RepoOrcInsertForecast;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCloneOrc;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use App\Modules\Natureza51\Repositories\RepoNotify;
use App\Modules\Natureza51\Repositories\RepoRealizado;
use App\Modules\Natureza51\Repositories\RepoLotacaoStatusCalculo;
use App\Modules\Natureza51\Repositories\RepoOrcParamNatureza;
use Illuminate\Http\Response;
use Carbon\Carbon;

use App\Jobs\CalculateAllLotacoes;
use App\Jobs\CalculateRealizado;

class OrcamentoController extends Natureza51Ctrl
{
    use \App\Core\Traits\ParamTrait;

    protected $repository_orc;
    protected $repo_send_email;
    protected $repo_notify;
    private $time_set_timeout = 120;

    public function setTimeOut($segundos){
        $this->time_set_timeout = $segundos;
    }
    public function getTimeOut(){
        return $this->time_set_timeout;
    }
    private function setRepositoryOrc(){
        $this->repository_orc=new RepoOrcamento();
        return $this;
    }
    public function __construct(){
        $this->setRepositoryOrc();
        $this->setCodTela('ORC');
        parent::__construct();
        $this->repo_send_email = new RepoEnviarEmail();
        $this->repo_notify = new RepoNotify();
        if(!$this->hasRepository()){
            $this->setRepository($this->getRepositoryOrc());
        }
    }

    public function getRepoSendEmail(){
        return $this->repo_send_email;
    }

    public function getRepoNotify(){
        return $this->repo_notify;
    }

    public function listar(){
        // $this->podeAcessar('listar',true,$this->getCodTela());
        $data_user = $this->getUserFromCurrentGuard();

        $query = $this->getRepository()->getModelEntity()
           ->where([
                ['status_orc', '!=', $this->getRepository()->getStatusExcluido()]
            ])->orderBy('id','DESC');

        if ($data_user->tipo != 3) {
            $query->where([                
                ['mostrar_orcamento', '=', 0]
            ]);
        }
        
        return $query->get()->toArray();
    }

    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all(); 
        
        $id=$form_data['id'];
        if( $this->isSuspenso($id) == true ){
            $retorno['status'] = "error";
            $retorno["msg"] = "Orçamento Suspenso. Erro: 151020201550!";
            $retorno['submsg'] = "Erro";
            goto saida;
        }
        else{
            return parent::update($request);
        }
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function listarPerm($cod_tela = null){
        
        $data_user = $this->getUserFromCurrentGuard();         
        
        if(!is_null($cod_tela)){
            $this->podeAcessar('listar',true,$cod_tela);
        }
        $query = $this->getRepository()->getModelEntity()
           ->where([                
                ['status_orc', '!=', $this->getRepository()->getStatusExcluido()]
            ])->orderBy('id','DESC');

        if ($data_user->tipo != 3) {
            $query->where([                
                ['mostrar_orcamento', '=', 0]
            ]);
        }
        
        return $query->get()->toArray();
    }

    public function listForHeadcount(){
        set_time_limit(700);
        $data_user = $this->getUserFromCurrentGuard(); 
        $this->setCodTela('ORCHDCT');
        $this->podeAcessar('listar',true,$this->getCodTela());

        $query = $this->getRepository()->getModelEntity()
        ->where([
            // ['status_aprovacao',$this->getRepository()->getStatusFinal()],
            ['status_orc', '!=', $this->getRepository()->getStatusExcluido()],
            ['is_suspended', '!=', 1]
        ])->orderBy('id','DESC');

        if ($data_user->tipo != 3) {
            $query->where([                
                ['mostrar_orcamento', '=', 0]
            ]);
        }
        
        return $query->get()->toArray();
    }

    public function getRepositoryOrc(){ return $this->repository_orc; }
    public function isValid(){
        return true;
    }
    public function canEdit(){
        return true;
    }
    public function canDelete(){
        return true;
    }

    public function getOrcamentoByID($orc_id){
        $orc = $this->getRepository()
        ->getModelEntity()
        ::with([
            'getOrcPremissas'=>function($query){

            }
        ])
        ->find($orc_id);
        if(!$orc){
            return  $this->retornoJsonDefault(array('status'=>'error','msg'=>"Orçamento não encontrado. 061220190943"),500);
        }
        $orc->observacao2 = (!is_null($orc->getOrcPremissas)) ? $orc->getOrcPremissas->observacao2 : 'Não informada' ;
        return $orc;
    }
    public function isOwn(){
        return true;
    }
    public function inserir(Request $request) {

        $retorno=$this->getArrayRetornoDefault();
        if(! $this->getRepositoryOrModel()->createOrc($request->all())){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191345';
            goto saida;
        }

        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";

        saida:
         return $this->retornoJsonDefault($retorno);

    }

    public function isSuspenso($orc_id){
        $orc = DB::select("select * from tbl_orcamento where id = ?", [$orc_id]);
        if(count($orc) > 0 && $orc[0]->is_suspended == 1){
            return true;
        }
        return false;
    }
    /**
     * ======================= VERIFICAR AS VALIDAÇÕES DOS STATUS E O FLUXO ==================================
     * @author Samuel Domingos de Lima
     * @todo Function for to release budget. Check the commented validations in the future.
     */
    public function releaseOrc(Request $request){
        set_time_limit(1200);
        $id_orc = $request->all()[0];
        if( $this->isSuspenso($id_orc) == true){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento Suspenso. Erro: 15102021515'));
        }

        $repo_script = new RepoOrcScriptCalculos();
        $cargo_sal = new RepoOrcCargo();
        // $beneficio = new RepoOrcBeneficio();
        $bonus = new RepoOrcBonus();
        $turma = new RepoOrcTurma();
        // $lot_nat_event = new RepoOrcLotacaoNaturezaEvento();
        $hora_extra = new RepoHoraExtra();
        $orc = $this->getRepository()->getModelEntity()->with([
            'getOrcParametros'=>function($query){
                return $query->where('parametro_id', '19')->first();
            }
        ])->find($id_orc);


        if(!$orc){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 280120201027'));
        }

        if($orc->status_orc != $this->getRepository()->getStatusPendente() && $orc->status_orc != $this->getRepository()->getStatusReaberto()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 280120200930.'),500);
        }

        if($orc->status_aprovacao != $this->getRepository()->getStatusPendente()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 280120200931.'),500);
        }

        if(!$cargo_sal->findBy('orcamento_id',$id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento, cargos e salários inexistentes. Erro: 280120200942.'),500);
        }

        // if(!$beneficio->findBy('orcamento_id',$id_orc)){
        //     return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento. Benefícios inexistentes. Erro: 280120200947.'),500);
        // }
        if(!$bonus->findBy('orc_id',$id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento. Bonus inexistentes. Erro: 103528012020.'),500);
        }
        if(!$turma->findBy('orc_id',$id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento. Turmas inexistentes. Erro: 100320210818.'),500);
        }
        // if(!$lot_nat_event->findBy('orcamento_id',$id_orc)){
        //     return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento. Lotação x Natureza x Eventos inexistentes. Erro: 280120200948.'),500);
        // }
        if(!$hora_extra->findBy('orcamento_id',$id_orc)){
            return $this->retornoJsonDefault(array('error','msg'=>'Preencha os parâmetros do orçamento. Horas extras inexistentes. Erro: 280120201037.'),500);
        }

        $popula_headcount = $repo_script->scriptInsertOrcHeadCount($id_orc);

        if($popula_headcount['status']=='error'){
            return $popula_headcount;
        }

        $result = $repo_script->scriptInsertOrcFuncionario($id_orc);

        if($result["status"]=="error"){                
            return $result;
        }

        // $this->getRepoSendEmail()->notifyManagersRelease($id_orc);

        // if(!$this->getRepoNotify()->notifyReleaseBudget(null, $orc->getOrcParametros[0]->valor_parametro, $orc->ano, $orc->descricao_orc, $id_orc)){
        //     return $this->getRepoNotify()->getErrosFlatted();
        // }
        $result = $this->enviarEmailLiberar($id_orc, $orc->getOrcParametros[0]->valor_parametro+1, $orc->ano, $orc->descricao_orc);
        return $this->getRepository()->releasedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');

    }


    public function enviarEmailLiberar($orc_id, $hierarquia, $ano, $descricao){
        $select = DB::select("SELECT olot.lotacao_id, format(c.start_date, 'dd/MM/yyyy') as data_inicial, format(c.end_date, 'dd/MM/yyyy') as data_final from tbl_orc_cronograma as c
            inner join tbl_activities as a on a.id = c.activity_id
            inner join tbl_orc_lotacao as olot on olot.id = c.orc_lotacao_id
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            
            where c.orcamento_id = $orc_id
            and (c.start_date <= getdate() and c.end_date >= GETDATE())
            and (a.title like('%reenchimento%') and a.title like('%eadcount%'))"
        );

        if(count($select) == 0){
            return 'errorr !-!';
        }
        $lotacoes = [];

        foreach($select as $value){
            $result = $this->existeEmail($lotacoes, $value->lotacao_id);

            if($result === true){
                continue;
            }
            else{
                $this->getRepoSendEmail()->notifyManagersReleaseComData($value->lotacao_id, $hierarquia, $ano, $descricao, 'a partir de '.$value->data_inicial.' até '.$value->data_final);
            }
            $lotacoes[] = $value->lotacao_id;
        }
        return true;
    }
    
    public function existeEmail($dados, $lotacao){
        
        foreach($dados as $value){
            if($value == $lotacao){
                return true;
            }
        }
        return false;
    }
    /**
     * MÉTODO INUTILIZAVÉL NO MOMENTO 19/02/2019
     */
    public function approveOrc(Request $request){
        $id_orc = $request->all()[0];


        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 280120201840'));
        }
        // if($orc->status_orc != $this->getRepository()->getStatusEmAndamento()){
        //     return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 280120201841.'),500);
        // }
        $lotacoes = $this->headcountIsFinished($id_orc);
        if($lotacoes !== true){
            $var = "Para aprovar o orçamento, as seguintes lotações devem estar finalizadas: <br>";
            foreach($lotacoes as $lot){
                $var = $var . $lot->desc_lot . "<br>";
            }
            return $this->retornoJsonDefault(array('status'=>'error','msg'=> $var));
        }

        return $this->getRepository()->completedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');
    }

    public function reopenOrc(Request $request){
        $id_orc = $request->all()[0];
        
        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 280120201840'));
        }

        if( $this->isSuspenso($id_orc) == true ){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento Suspenso. Erro: 151020201517'));
        }
        // $lotacoes = $this->headcountIsFinished($id_orc);
        // if($lotacoes !== true){
        //     $var = "Para reabrir o orçamento, as seguintes lotações devem estar finalizadas: <br>";
        //     foreach($lotacoes as $lot){
        //         $var = $var . $lot->desc_lot . "<br>";
        //     }
        //     return $this->retornoJsonDefault(array('status'=>'error','msg'=> $var));
        // }

        return $this->getRepository()->reopenedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');
    }
    /**
     * Quando o ALMER REJEITAR o ORÇAMENTO
     */
    public function rejectOrc(Request $request){
        $id_orc = $request->all()[0];

        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 060220200928.'));
        }

        if( $this->isSuspenso($id_orc) == true ){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento Suspenso. Erro: 151020201521.'));
        }

        // dd($orc->status_orc, $this->getRepository()->getStatusFinalizado());
        if($orc->status_orc != $this->getRepository()->getStatusFinalizado()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indísponivel. Erro: 060220200928.'));
        }

        $retorno = $this->getRepository()->completedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_aprovacao');

        $retorno = $this->getRepository()->rejectStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');

        return $retorno;
    }

    public function excluirOrc(Request $request){
        $all = $request->all();

        if(!$orc = $this->getRepository()->find($all)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 110320201046.'));
        }

        if($orc[0]->status_orc != $this->getRepository()->getStatusPendente()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indísponivel. Erro: 110320201047.'));
        }

        DB::beginTransaction();
        try {

            $data_request = [
                "status_orc" => $this->getRepository()->getStatusExcluido()
            ];

            $resp = $this->getRepository()->updateParent($data_request, $all[0]);
            if(!$resp){
                abort(500,'Erro ao excluir o orçamento. Erro: 110320201103. '. $e);
            }

        DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao excluir o orçamento. Erro: 110320201103. '. $e);
        }

        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";

        return $retorno;
    }

    /**
     * Quando o ALMER APROVAR O ORÇAMENTO
     */
    public function acceptOrc(Request $request){
        $id_orc = $request->all()[0];
        $insert_orc_forecast = new RepoOrcInsertForecast();

        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 060220200928.'));
        }

        if( $this->isSuspenso($id_orc) == true ){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento Suspenso. Erro: 151020201523.'));
        }
        $outro_aprovado = DB::select("SELECT * from tbl_orcamento where status_orc >= 8 and status_orc <= 9 and ano = $orc->ano and id <> $orc->id");
        // aprovado e em execucao
        if(count($outro_aprovado) > 0){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Há outro Orçamento aprovado neste mesmo ano. Erro: 040120201537.'));
        }
        $lotacoes = $this->headcountIsFinished($id_orc);
        if($lotacoes !== true){
            
            $var = "Para aprovar o orçamento, as seguintes lotações devem estar finalizadas: <br>";
            foreach($lotacoes as $lot){
                $var = $var . $lot->desc_lot . "<br>";
            }
            return $this->retornoJsonDefault(array('status'=>'error','msg'=> $var));
        }

        // OBS: Verificar com André se essa validação pode mesmo ser removida. todo.
        // if($orc->status_orc != $this->getRepository()->getStatusLiberado()){
        //     return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indísponivel. Erro: 180220201206.'));
        // }

        DB::beginTransaction();
        try {
            $retorno = $this->getRepository()->approvedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');
            if($retorno['status']!='success'){
                return false;
            }

            // $retorno2 = $this->getRepository()->completedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_aprovacao');
            // if($retorno2['status']!='success'){
            //     return false;
            // }

            // $insrt_forecast = $insert_orc_forecast->createForecast($id_orc);

            // if($insrt_forecast['status'] != 'success'){
            //     return false;
            // }

            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao liberar o orçamento. Erro: 190220201749. '. $e);
        }


        return $retorno;
    }

    public function headcountIsFinished($id_orc){
        $select = DB::select("
        select distinct orc_lot.id, CONCAT(lot.unid_lotac, ' - ', lot.des_unid_lotac) desc_lot
        from tbl_orc_lot_carg_headcount head 
                inner join tbl_orc_lotacao orc_lot on orc_lot.id = head.lotacao_id
                inner join tbl_lotacao lot on lot.id = orc_lot.lotacao_id
                where status < 7  and orcamento_id = {$id_orc} and lot.ativo = 1 and head.tipo_table = 'O' 
        ");

        if(count($select) > 0) {
            return $select;
        }
        
        return true;
    }

    public function suspendedOrc(Request $request){
        $all = $request->all();
        // dd($all);
        if(!$orc = $this->getRepository()->find($all['id'])){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 290120201020.'),500);
        }

        $orc->is_suspended = $all['is_suspended'];
        $orc->update();

        return $this->retornoJsonDefault(array('status'=>'success','msg'=>'Orçamento suspenso com sucesso.'),200);

    }

    public function visivelGestor(Request $request){
        $all = $request->all();
        
        if(!$orc = $this->getRepository()->find($all['id'])){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 101220201506.'),500);
        }

        $orc->mostrar_orcamento = $all['mostrar_orcamento'];
        $orc->update();

        return $this->retornoJsonDefault(array('status'=>'success','msg'=>'Orçamento suspenso com sucesso.'),200);

    }

    public function getEventOfHour(){
        return $this->getRepository()->getEventsOfHour();
    }

    public function getTipoOrcamento($orc_id){

        if(!is_numeric($orc_id)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento não encontrado. Tente novamente mais tarde. Erro: 040520201155.'));
        }
        $value = $this->getParamByOrc($orc_id, $this->getCodTipoHeadcount(), 'getCodOptionTPHC');

        return new Response(json_encode($value) , 200);

    }

    public function clonarOrcamentoOld(Request $request, $orc_id){
        $data_form =$request->all();
        set_time_limit(1000);
        $repo_orc_script_caculos = new RepoOrcScriptCloneOrc();
        return $repo_orc_script_caculos->createCloneOrc($data_form, $orc_id);
    }

    public function clonarOrcamento(Request $request, $orc_id){
        $retorno=$this->getArrayRetornoDefault();
        $data_form =$request->all();
        set_time_limit(1000);
        $repo_orc_script_caculos = new RepoOrcScriptCloneOrc();

        if( $this->isSuspenso($orc_id) == true ){
            $retorno['msg'] = "Orçamento Suspenso! Erro: 151020201612";
            $retorno['submsg'] = "Erro";
            goto saida;
        }

        if(!$repo_orc_script_caculos->createCloneOrc($data_form, $orc_id)){
            $retorno['msg']=$repo_orc_script_caculos->getErrosFlatted();
            $retorno['submsg']=$repo_orc_script_caculos->getSubErrosFlatted();
            goto saida;
        }

        $retorno['msg']='Orçamento clonado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
            
        saida:
        return $this->retornoJsonDefault($retorno); 
        
    }

    public function reiniciarOrc($orc_id){
        $repo_orc_script_caculos = new RepoOrcScriptCalculos();

        $confere_orc = $this->getRepository()->getModelEntity()
            ->select('status_orc')->where('id',$orc_id)
        ->get()->toArray();
        
        if( count($confere_orc) > 0 && $this->isSuspenso($orc_id) == true ){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Orçamento Suspenso. Erro: 151020201526';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        $status = count($confere_orc) > 0 ? $confere_orc[0]['status_orc'] : null;
    
        if($status < 4){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Libere o Orçamento para continuar. Erro: 240720201437';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        $retorno = $repo_orc_script_caculos->reiniciarOrcScript($orc_id);

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function getPeriodoFechar($orc_id){

        $to_test = false;       
       
        $retorno=$this->getArrayRetornoDefault();
        $orcamento = $this->getRepository()->getModelEntity()->find($orc_id);
        $array_meses = [1=>'Janeiro', 2=>'Fevereiro', 3=>'Março', 4=>'Abril', 5=>'Maio', 6=>'Junho', 
                        7=>'Julho', 8=>'Agosto', 9=>'Setembro', 10=>'Outubro', 11=>'Novembro', 12=>'Dezembro'];

        if(!$orcamento){
            $retorno['msg'] = 'Falha ao buscar informações do período corrente.';
            $retorno['submsg'] = 'Orçamento não encontrado. Erro: 191020201930';
            goto saida;
        }

        $ano = $to_test ? 2020 : $orcamento->ano;

        $is_reaberto = !$orcamento->ultimo_periodo_is_reaberto ? false : true;
        $periodo = !$orcamento->ultimo_periodo_enviado ? Carbon::parse('01010101')->year($ano) 
                                                       : ($is_reaberto ? Carbon::parse($orcamento->ultimo_periodo_enviado) 
                                                                       : Carbon::parse($orcamento->ultimo_periodo_enviado)->addMonth());
        
        $periodo_reabrir = Carbon::parse($orcamento->ultimo_periodo_enviado);

        $pode_reabrir = (!$orcamento->ultimo_periodo_enviado || $is_reaberto) ? false : true;
        $periodo_format = $periodo->copy()->format('d/m/Y');
        $mes_periodo = $array_meses[$periodo->copy()->month];
        $mes_periodo_reabrir = $array_meses[$periodo_reabrir->copy()->month];


        $current_month = Carbon::now()->day(1);

        $diferenca = $periodo->diffInDays($current_month, false);
        $pode_fechar = $diferenca >= 0 ? true : false;

       return [
            "periodo_format" => $periodo_format,
            "mes_periodo" => $mes_periodo,
            "mes_periodo_reabrir" => $mes_periodo_reabrir,
            "is_reaberto" => $is_reaberto,
            "pode_fechar" => $pode_fechar,
            "pode_reabrir" => $pode_reabrir,
            "periodo" => $periodo->format('Y-m-d'),
            // "periodo_reabrir" => $$periodo_reabrir->format('Y-m-d')
        ];
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function fecharPeriodo($orc_id, $periodo){
        $this->podeAcessar('fechar_periodo',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $repo_orc_lotacao = new RepoRealizado();

        // if(!$this->validaForecastsAbertos($orc_id, $periodo)){
        //     $retorno['msg']='Ainda existem lotações em aberto.';
        //     $retorno['submsg']='Falha ao fechar o período. Erro: 201020201807';
        //     goto saida;
        // }


        $user = $this->getUserFromCurrentGuard();

        // $myJob = new CalculateRealizado($orc_id, $user->id, $periodo);
        // dispatch($myJob); 
        
         
        $repo_realizado = new RepoRealizado();
        $repo_orc = new RepoOrcamento();

    
        set_time_limit(0);
        DB::beginTransaction();

        $orcamento = $repo_orc->getModelEntity()->find($orc_id);

        $orcamento->ultimo_periodo_enviado = $periodo;
        $orcamento->ultimo_periodo_is_reaberto = 0;
        $orcamento->save();

        if(!$repo_orc->calculateRealizado($orc_id, $periodo)){
            $retorno['msg']=$repo_orc->getErrosFlatted();
            $retorno['submsg']=$repo_orc->getSubErrosFlatted();
            DB::rollback(); 
            goto saida;
        }    

        // DB::beginTransaction();

        // $orcamento = $this->getRepository()->getModelEntity()->find($orc_id);

        // $orcamento->ultimo_periodo_enviado = $periodo;
        // $orcamento->ultimo_periodo_is_reaberto = 0;
        // $orcamento->save();


        // if(!$repo_orc_lotacao->execSpsFolha($orc_id, $periodo)){
        //     $retorno['msg']=$repo_orc_lotacao->getErrosFlatted();
        //     $retorno['submsg']=$repo_orc_lotacao->getSubErrosFlatted();
        //     DB::rollback();
        //     goto saida;
        // }



        // if(!$this->getRepository()->calculateRealizado($orc_id, $periodo)){
        //     $retorno['msg']=$this->getRepository()->getErrosFlatted();
        //     $retorno['submsg']=$this->getRepository()->getSubErrosFlatted();
        //     DB::rollback(); 
        //     goto saida;
        // }        

        DB::commit();
        $retorno["status"]="success";
        // $retorno["msg"]="Cálculo de realizado iniciado com sucesso! Você receberá um e-mail quando for concluído.";
        $retorno["msg"]="Cálculo de realizado concluído!";
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function validaForecastsAbertos($orc_id, $periodo){
        $repo_orc_lotacao = new RepoOrcLotacao();
        $lotacoes_nao_concluidas = $repo_orc_lotacao->getModelEntity()->where([
            ['status', '<>', $repo_orc_lotacao->getStatusLotAprovadoFCST()], 
            ['orcamento_id', $orc_id],
            ['responder_orc', 1],
            ['periodo', $periodo],
            ['tipo_table', 'F']
        ])->get()->count();
        return $lotacoes_nao_concluidas > 0 ? false : true;        
    }

    public function reabrirPeriodo($orc_id){
        $this->podeAcessar('reabrir_periodo',true,$this->getCodTela());        
        $retorno = $this->getArrayRetornoDefault();
        

        $orcamento = $this->getRepository()->getModelEntity()->find($orc_id);
        
        $orcamento->ultimo_periodo_is_reaberto = 1;
        $orcamento->save();

        $retorno["status"]="success";
        $retorno["msg"]="Período reaberto com sucesso!";
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function calcularLotacoes($orc_id, $tipo_table = 'O', $periodo = NULL, Request $request){        
        $calculate_multi_queues = true;
        $user = $this->getUserFromCurrentGuard();
        $retorno = $this->getArrayRetornoDefault();

        $hashs = !$request ? [] : $request->all()['hashs'];
        
        if(!$user){
            $retorno['submsg']='Usuário não encontrado. Faça o login e tente novamente. Erro: 221120201027';
            $retorno['msg']='Usuário não encontrado. Faça o login e tente novamente.';   
            goto saida;         
        }        
        $where = $tipo_table == 'F' ? " and tipo_table = 'F' and periodo = '{$periodo}' " : " and tipo_table = 'O' ";
        $select = DB::select("SELECT * from tbl_orc_lotacao where orcamento_id = {$orc_id} {$where} and status < 15");
        if(count($select) == 0){
            $retorno['submsg'] = 'Atenção!';
            $retorno['msg'] = 'Impossível realizar o cálculo, pois o Forecast já foi Aprovado. 020320211013';
            $retorno['status'] = 'warning';
            goto saida;
        }
        
        
        if($calculate_multi_queues){  
            
            $existe_calculo = DB::select("select * from jobs where queue like 'myJobQueue%'");

            foreach ($existe_calculo as $fila) {
                $item = json_decode($fila->payload, true);
                $itens = unserialize($item['data']['command']);
                if($itens->orc_id == $orc_id && $itens->tipo_table == $tipo_table && $itens->periodo == $periodo){
                    $retorno['submsg'] = 'Atenção!';
                    $retorno['msg'] = 'Já existe um cálculo pendente, aguarde o mesmo concluir e tente novamente. 020820211430';
                    $retorno['status'] = 'warning';
                    goto saida;
                }
            } 
            
            
            $repo_status_calculo = new RepoLotacaoStatusCalculo();
            $tbl_status_calc = $repo_status_calculo->getModelEntity()->getTable();
            DB::update("UPDATE {$tbl_status_calc} SET is_historico = 1 WHERE orcamento_id = {$orc_id} ");
       

            $repoOrcLotacao = new RepoOrcLotacao();
    
            if($tipo_table == 'O'){            
                $lotacoes_calc = $repoOrcLotacao->getModelEntity()->select("id")->where('orcamento_id', $orc_id)->whereIn('status', [$repoOrcLotacao->getStatusLotPendenteDigitacao(), $repoOrcLotacao->getStatusLotReaberto(), $repoOrcLotacao->getStatusEnviado(), $repoOrcLotacao->getStatusLotConferido(), $repoOrcLotacao->getStatusLotCalculado()])->get()->toArray();
            } else {
                $lotacoes_calc = $repoOrcLotacao->getModelEntity()->select("id")->where('orcamento_id', $orc_id)->whereIn('status', [$repoOrcLotacao->getStatusLotPendenteDigitacaoFCST(), $repoOrcLotacao->getStatusLotReabertoFCST(), $repoOrcLotacao->getStatusLotEnviadoFCST(), $repoOrcLotacao->getStatusLotConferidoFCST(), $repoOrcLotacao->getStatusLotCalculadoFCST()])->get()->toArray();
            }
            $lotacoes_calc = array_column($lotacoes_calc, 'id');
    
            
            // $size = round(count($lotacoes_calc) / 5);
            
            // shuffle($lotacoes_calc);
            
            // $lotacoes = array_chunk($lotacoes_calc, $size);
            $lotacoes[0] = [];
            $lotacoes[1] = [];
            $lotacoes[2] = [];
            $lotacoes[3] = [];
            $lotacoes[4] = [];
            // $lotacoes[5] = [];
            $cont = 0;
            foreach ($lotacoes_calc as $lot_calc) {
                array_push($lotacoes[$cont], $lot_calc);
                if($cont == 4){
                    $cont = 0;
                }
                else{ 
                    $cont++;
                }
            }

            // dd($lotacoes);
            
            if(count($lotacoes[0]) > 0){
                $myJob = new CalculateAllLotacoes($orc_id, $user->id, $user->id_empresa, $tipo_table, $periodo, $hashs, $lotacoes[0]);
                dispatch($myJob->onQueue('myJobQueue'));
            }            
            if(count($lotacoes[1]) > 0){
                $myJob1 = new CalculateAllLotacoes($orc_id, $user->id, $user->id_empresa, $tipo_table, $periodo, $hashs, $lotacoes[1]);
                dispatch($myJob1->onQueue('myJobQueue1'));
            }            
            if(count($lotacoes[2]) > 0){
                $myJob2 = new CalculateAllLotacoes($orc_id, $user->id, $user->id_empresa, $tipo_table, $periodo, $hashs, $lotacoes[2]);
                dispatch($myJob2->onQueue('myJobQueue2'));
            }            
            if(count($lotacoes[3]) > 0){
                $myJob3 = new CalculateAllLotacoes($orc_id, $user->id, $user->id_empresa, $tipo_table, $periodo, $hashs, $lotacoes[3]);
                dispatch($myJob3->onQueue('myJobQueue3'));
            }            
            if(count($lotacoes[4]) > 0){
                $myJob4 = new CalculateAllLotacoes($orc_id, $user->id, $user->id_empresa, $tipo_table, $periodo, $hashs, $lotacoes[4]);
                dispatch($myJob4->onQueue('myJobQueue4'));
            }
        }
        else{
            CalculateAllLotacoes::dispatch($orc_id, $user->id, $user->id_empresa, $tipo_table, $periodo, $hashs);
        }
        // CalculateAllLotacoes::dispatch($orc_id, $user->id, $user->id_empresa, $tipo_table, $periodo);
        
        // file_put_contents('teste_escreve_isso_porfavooooor.txt', 'olha que loucura, olha que legal');

        $retorno['msg']="O cálculo das lotações foi iniciado, você pode acompanhar o processo através do botão 'Acompanhar cálculo'!";
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
    
        saida:
        return $this->retornoJsonDefault($retorno); 

    }

    public function getStatusCalculo($orc_id){
        $repo_status_lotacao = new RepoLotacaoStatusCalculo();
        // $user = $this->getUserFromCurrentGuard();
        $retorno = $this->getArrayRetornoDefault();

        // if(!$user){
        //     $retorno['submsg']='Usuário não encontrado. Faça o login e tente novamente. Erro: 231120201538';
        //     $retorno['msg']='Usuário não encontrado. Faça o login e tente novamente.';   
        //     return $this->retornoJsonDefault($retorno);      
        // }      


        $data = $repo_status_lotacao->getModelEntity()->where([
            ['is_historico', 0],
            ['orcamento_id', $orc_id]
            // ['usuario_calculou', $user->id],
            // ['is_historico', 0]
        ])->get()->toArray();

        return $data;
    }
    
    /*
     * @TODO ALUISIO FERREIRA DE SOUSA 16/12/2019
     * Tentativa de criar um metodo generico para listar os dados das abas do orcamento mas é necessario
     * Mais estudo
     *
    public function listarAll($orc_id){
        $result=$this->getRepository()->listAll($orc_id);
        if($result===false){
            $retorno=$this->getArrayRetornoDefault();
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao carregar registros. Erro: 051220190952.';

            return $this->retornoJsonDefault($retorno);
        }
        return new Response(json_encode($this->renderTreeTable($result->toArray() )));
    }
    protected function renderTreeTable($dados){

        return ['data'=>$this->setTreeTableSetting(['columns'=>[
                    ["field_out"=>"id"],
                    ["field_out"=>"orcamento_id"],
                    ["field_out"=>"lotacao_id"],
                    ["field_out"=>"ccontabil_id"],
                    ["field_out"=>"evento_id"],
                    ["field_out"=>"total"],
                    ["field_out"=>"formula"],
                    ["field_out"=>"ccontabil"], //'C. Contabíl'
                    ["field_out"=>"codigo"], //C. Custo'
                    ["field_out"=>"lotacao"], //Lotação'
                    ["field_out"=>"jan_orcado"],
                    ["field_out"=>"fev_orcado"],
                    ["field_out"=>"mar_orcado"],
                    ["field_out"=>"abr_orcado"],
                    ["field_out"=>"mai_orcado"],
                    ["field_out"=>"jun_orcado"],
                    ["field_out"=>"jul_orcado"],
                    ["field_out"=>"ago_orcado"],
                    ["field_out"=>"set_orcado"],
                    ["field_out"=>"out_orcado"],
                    ["field_out"=>"nov_orcado"],
                    ["field_out"=>"dez_orcado"],
                    ],
                'keys'=>'id',

            ])
              ->newTreeTable($dados)
              ->getTreeTable()
              ->render()];
    }
    */

    /* VALIDA SE A LOTAÇÃO PODE SER USADA NO FORECAST */
    public function canCRUDForecast($lotacao_id, $orc_id, $periodo, $tipo_table){

        $validacao = DB::select("SELECT * from tbl_orc_lotacao where id = {$lotacao_id} and tipo_table = '{$tipo_table}' and periodo = '{$periodo}' ");
        if(count($validacao) > 0){
            if( $validacao[0]->status < 11 && $validacao[0]->status >= 9 ){
                return true;
            }
            else{
                return false;
            }
        }
        else{
            $select = DB::select("SELECT movto.status_atual, olot.status
                from tbl_orc_lotacao as olot
                inner join tbl_orc_movto_status_ccusto as movto on movto.orc_lotacao_id = ?
                where orcamento_id = ? and olot.id = ? and movto.periodo = '{$periodo}' and movto.tipo_table = ?", [$lotacao_id, $orc_id, $lotacao_id, $tipo_table]);
            
            if(count($select) > 0 && ($select[0]->status_atual < 11 && $select[0]->status_atual >= 9) && ($select[0]->status < 11 && $select[0]->status >= 9) ){
                return true;
            }
            else{
                return false;
            }
        }
    }

    public function checkIsCalculando($orc_id){
        $repo_lotacao_status_calculo = new RepoLotacaoStatusCalculo();
        $retorno = $this->getArrayRetornoDefault();
        $data = $repo_lotacao_status_calculo->checkIsCalculando($orc_id);

        $retorno['res']=$data;
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
    
    
        return $this->retornoJsonDefault($retorno); 
    }

    public function validaValoresNegativos($orc_id, $lotacao_id, $periodo = null, $tipo_table = 'O'){
        /*$where = $tipo_table == 'F' ? " AND hd.periodo = '{$periodo}' and hd.tipo_table = '{$tipo_table}' " : " AND hd.tipo_table = '{$tipo_table}' ";

        $select = DB::select("SELECT * from tbl_orc_lot_carg_headcount as hd
        inner join tbl_calc_orcamento as calc on calc.origem_id = hd.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
        
        where hd.orc_id = {$orc_id} and hd.lotacao_id = $lotacao_id {$where} and (calc.jan_orcado < 0 or calc.fev_orcado < 0 or calc.mar_orcado < 0 or calc.abr_orcado < 0 or calc.mai_orcado < 0 or calc.jun_orcado < 0 or
        calc.jul_orcado < 0 or calc.ago_orcado < 0 or calc.set_orcado < 0 or calc.out_orcado < 0 or calc.nov_orcado < 0 or calc.dez_orcado < 0)");

        return $select;*/
        $repo = new RepoOrcamento();
        return $repo->validaValoresNegativos($orc_id, $lotacao_id, $periodo, $tipo_table);
    }
    public function deleteDiarioBordo($id, $tbl_origem){
        return $this->getRepository()->deleteDiarioBordo($id, $tbl_origem);
    }
}
