<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoPerfilPermUser as RepoPerfilPermUser;
use App\Modules\Natureza51\Entities\PerfilPermUser;
use Illuminate\Http\Request as Request;
use DB;
class PerfilPermUserController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('USU');
        $this->repository=new RepoPerfilPermUser();
        parent::__construct();
    }

    public function insert(Request $request){
        $this->podeAcessar('atribuir_perfil',true,$this->getCodTela());
         $perfil = new RepoPerfilPermUser();

        $retorno=$this->getArrayRetornoDefault();
        $data_envio=$request->all();
        $form_data = array();
        DB::transaction(function()use(&$retorno, $data_envio, $perfil){

            $perfil->deleteByUser($data_envio['usuario_id']); 
           
            $retorno["status"]="success";
            $retorno["msg"]="Perfil(is) atribuído(s) com sucesso!";

       
            for($i = 0; $i <count($data_envio['perfis']); $i++){

                $form_data['usuario_id'] = $data_envio['usuario_id'];
                $form_data['perfil_perm_id'] = $data_envio['perfis'][$i]['id'];
             
                if(!$this->getRepositoryOrModel()->create($form_data)){
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['subsmg']='Falha ao inserir o registro. Erro: 230420201021';
                    
                    abort(500,'Falha ao inserir o registro. Erro: 230420201055.'. $this->getRepositoryOrModel()->getErrosFlatted());
                    return false;
                }


            }

         

        });         

        return $retorno;
}
   public function getPerfisSelecionados ($usuario_id){
        return $this->getRepository()->getPerfisSelecionados($usuario_id);
   }
   


}