<?php
namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepoPerfilRegras as RepoPerfilRegras;
use Illuminate\Http\Response;
use Excel;
use Illuminate\Support\Facades\DB;

class PerfilRegrasController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('PR'); 
        $this->repository=new RepoPerfilRegras();
        parent::__construct();
    }

    public function getPerfis(){
        $perfis = new RepoPerfilRegras();
        return $perfis->getPerfil();
    }

    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $tbl_usuario = new Usuario();
        $entity = $this->getRepositoryOrModel()->getModelEntity();

        $data = $this->getRepositoryOrModel()->getModelEntity()->with([
            'getEmpresa'=>function($query){

            }
        ])
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$entity->getColunaAlias('created_by')}")
         )
         ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $entity->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
         )
        ->select('institb_perfil_permissoes.*',
            DB::raw("CASE WHEN {$entity->getColunaAlias('created_at')} IS NOT NULL THEN format({$entity->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$entity->getColunaAlias('updated_at')} IS NOT NULL THEN format({$entity->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->get()->toArray();

        $result = [];

        foreach ($data as $perfil) {
            $perfil['des_empresa'] = $perfil['get_empresa']['razao'];
            unset($perfil['get_empresa']);
            array_push($result,$perfil);            
        }

       return new Response(json_encode($result), 200);
    }
   
    public function downloadExcelAux($type)
    {
        $this->podeAcessar('exportar',true,$this->getCodTela());
        $filename="Perfil";
        $array = json_decode($_POST['array_imprimir']);    

        for ($i=0; $i < count($array) ; $i++) { 
            
            //geral
            unset($array[$i]->grupo_empresarial_id);
            unset($array[$i]->usuario_dominio);
            unset($array[$i]->numero_dias_senha);
            unset($array[$i]->api_token);
            
            //comum a todos os cadastros
            unset($array[$i]->id);
            unset($array[$i]->id_empresa);
            unset($array[$i]->empresa_id);
            unset($array[$i]->id_grupo);
            unset($array[$i]->id_filial);
            unset($array[$i]->id_grupo_acesso);
            unset($array[$i]->id_permissao);
            unset($array[$i]->id_grupo_empresarial);
            unset($array[$i]->created_at);
            unset($array[$i]->updated_at);
            unset($array[$i]->user_id);
            unset($array[$i]->created_by);
            unset($array[$i]->updated_by);

            //funcionario
            unset($array[$i]->status);
            // unset($array[$i]->funcionario_id);




        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
                
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;


        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];

        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }
   


}
