<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoPerfilTelaTag as RepoPerfilTelaTag;
use App\Modules\Natureza51\Repositories\RepoTela as RepoTela;
use App\Modules\Natureza51\Repositories\RepoTelaTag as RepoTelaTag;
use Illuminate\Http\Request as Request;
use DB;


class PerfilTelaTagController extends Natureza51Ctrl
{

    private $repoTela;
    private $repoTelaTag;
    public function __construct(){
        $this->repository=new RepoPerfilTelaTag();
        $this->repoTela=new RepoTela();
        $this->repoTelaTag=new RepoTelaTag();

        parent::__construct();
    }


    public function getTelas(){
        return   $this->repoTela->all();
    }

    public function getTagsByTela($tela_id){
        return $this->repoTelaTag->getTagsByTela($tela_id);


    }



    public function insert(Request $request){
     
        $tag = new RepoPerfilTelaTag();

       $retorno=$this->getArrayRetornoDefault();
       $data_envio=$request->all();
       $form_data = array();
       DB::transaction(function()use(&$retorno, $data_envio, $tag){

           $tag->deleteByPerfilTela($data_envio['perfil_id'], $data_envio['tela_id']); 
          
           $retorno["status"]="success";
           $retorno["msg"]="Permissão(ões) atribuída(s) com sucesso!";

      
           for($i = 0; $i <count($data_envio['tags']); $i++){

               $form_data['id_perfil'] = $data_envio['perfil_id'];
               $form_data['id_tela'] = $data_envio['tela_id'];
               $form_data['id_tag'] = $data_envio['tags'][$i]['get_tag']['id'];
            
            //    dd("data atag",$data_envio['tags'][$i] );
               if(!$this->getRepositoryOrModel()->create($form_data)){
                   $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                   $retorno['subsmg']='Falha ao inserir o registro. Erro: 260420201733';
                   
                   abort(500,'Falha ao inserir o registro. Erro: 260420201734.'. $this->getRepositoryOrModel()->getErrosFlatted());
                   return false;
               }
            }     
       });         

       return $retorno;
}
    
public function getTagsSelecionadas ($perfil_id, $tela_id){
    return $this->getRepository()->getTagsSelecionadas($perfil_id, $tela_id);
}

}