<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoPermissoes as RepoPermissoes;
use App\Modules\Natureza51\Entities\RegraPerfil;
use Illuminate\Http\Request as Request;
use DB;
use Excel;
class PermissaoController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository=new RepoPermissoes();
        parent::__construct();
    }

    public function getPermissaoSistema($email){
        
        return $this->getRepositoryOrModel()->getPermissao($email);
    }

    public function downloadExcelAux($type)
    {
        $filename="Usuarios";
        $array = json_decode($_POST['array_imprimir']);    

        for ($i=0; $i < count($array) ; $i++) { 
            
            //geral
            unset($array[$i]->grupo_empresarial_id);
            unset($array[$i]->usuario_dominio);
            unset($array[$i]->numero_dias_senha);
            unset($array[$i]->api_token);
            
            //comum a todos os cadastros
            unset($array[$i]->id);
            unset($array[$i]->id_empresa);
            unset($array[$i]->id_grupo);
            unset($array[$i]->id_filial);
            unset($array[$i]->id_grupo_acesso);
            unset($array[$i]->id_permissao);
            unset($array[$i]->id_grupo_empresarial);
            // unset($array[$i]->created_at);
            // unset($array[$i]->updated_at);
            // unset($array[$i]->user_id);
            // unset($array[$i]->created_by);
            // unset($array[$i]->updated_by);

            //funcionario
            unset($array[$i]->status);
            unset($array[$i]->funcionario_id);




        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
                
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;


        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];

        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }
}