<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoPlanoLotacao as RepoPlanoLotacao;
use Illuminate\Http\Response;

class PlanoLotacaoController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('PL');
        $this->repository=new RepoPlanoLotacao();
        parent::__construct();
    }
    public function listarToFuncionario(){
        return $this->getRepository()->listarAtivo();
    }

    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $data = $this->getRepositoryOrModel()->all();
        foreach ($data as $dt) {
            $dt['des_ativo'] = $dt['ativo'] == 1 ? 'Sim' : 'Não';
            $dt['des_origem'] = $dt['origem'] == 1 ? 'Sistema' : 'ERP';

            $dt['description_plano_lotac'] = $dt['cdn_plano_lotac'].' - '.$dt['des_plano_lotac'];


            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
        }
       return new Response(json_encode($data), 200);
    }  

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Planos de lotacao', ['ativo', 'origem']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("des_origem", "Origem", $colunas[$i]);
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cdn plano lotac", "Código", $colunas[$i]);
            $colunas[$i] = str_replace("des plano lotac", "Descrição", $colunas[$i]);
            $colunas[$i] = str_replace("des ativo", "Ativo", $colunas[$i]);
          
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
        }
        return $colunas;
    }
}