<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoPlanoLotacaoTipo as RepoPlanoLotacaoTipo;
use Illuminate\Http\Response;
use Excel;


class PlanoLotacaoTipoController extends Natureza51Ctrl
{
    public function __construct()
    {
        $this->setCodTela('PLT');
        $this->repository=new RepoPlanoLotacaoTipo();
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        // $data = $this->getRepositoryOrModel()->all();
        $data = $this->getRepositoryOrModel()->listar();
        $retorno = [];


// dd("data", $data);
        foreach ($data as $dt) {
            // $dt['des_ativo'] = $dt['ativo'] == 1 ? 'Sim' : 'Não';
            $dt['des_origem'] = $dt['origem'] == 1 ? 'Sistema' : 'ERP'; 
            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($retorno, $dt);

        }
        // dd("data", $data);
       return new Response(json_encode($retorno), 200);

        // return $this->getRepository()->listar();
    }

    public function downloadExcelAux($type)
    {
        $this->podeAcessar('exportar',true,$this->getCodTela());
        $filename="Plano-Lotac-Tipo";
        $array = json_decode($_POST['array_imprimir']);    

        for ($i=0; $i < count($array) ; $i++) { 
            
            //geral
            unset($array[$i]->grupo_empresarial_id);
            unset($array[$i]->usuario_dominio);
            unset($array[$i]->numero_dias_senha);
            unset($array[$i]->api_token);
            
            //comum a todos os cadastros
            unset($array[$i]->id);
            unset($array[$i]->empresa_id);
            unset($array[$i]->created_at);
            unset($array[$i]->updated_at);
            unset($array[$i]->user_id);
            unset($array[$i]->created_by);
            unset($array[$i]->updated_by);

            //plano lotacao tipo
            unset($array[$i]->plano_lotac_id);
            // unset($array[$i]->ativo);
            // unset($array[$i]->origem);




        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
                
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;


        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];

        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }



    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Plano-Lotac-Tipo', ['ativo', 'origem', 'plano_lotac_id']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("des_origem", "Origem", $colunas[$i]);
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cod tipo", "Código", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo", "Descrição", $colunas[$i]);
            $colunas[$i] = str_replace("limite", "Limite", $colunas[$i]);

            $colunas[$i] = str_replace("des ativo", "Ativo", $colunas[$i]);
            $colunas[$i] = str_replace("desc plano lotac", "Plano de lotação", $colunas[$i]);

            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
        }
        return $colunas;
    }
}