<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRealizadoAumento as RepoRealizadoAumento;
use Carbon\Carbon;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;

class RealizadoAumentoController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRealizadoAumento();
        parent::__construct();
    } 

    public function listarAll($orc_id, $orc_lotacao_id, $mes, $filtro){
        $this->setCodTela('REALAS');      
        $this->podeAcessar('listar',true,$this->getCodTela());
        // $dados= $this->getRepository()->listarAll($orc_id, $orc_lotacao_id, $mes, $filtro);
        // return new Response(json_encode($this->montaTreetable($dados)) , 200);
        return $this->getRepository()->listarAll($orc_id, $orc_lotacao_id, $mes, $filtro);
    }


    public function montaTreetable($data){
        
        $column_fixeds=[  
            
            ["field_out"=>"description_cargo","from"=>"description_cargo", "render_value"=>null,],
            ["field_out"=>"description_func",  "from"=>"description_func", "render_value"=>null,],
            ["field_out"=>"mes",  "from"=>"mes", "render_value"=>null,],

            // ["field_out"=>"description_func", "render_value"=>function(){ return "-";},],

            // ["field_out"=>"jan_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"fev_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mar_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"abr_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mai_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jun_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jul_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"ago_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"set_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"out_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"nov_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"dez_orcado", "render_value", "render_value"=>function(){ return "-";},],





	
            ["field_out"=>"jan_orcado","from"=>"jan_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"fev_orcado","from"=>"fev_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mar_orcado","from"=>"mar_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"abr_orcado","from"=>"abr_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mai_orcado","from"=>"mai_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jun_orcado","from"=>"jun_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jul_orcado","from"=>"jul_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"ago_orcado","from"=>"ago_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"set_orcado","from"=>"set_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"out_orcado","from"=>"out_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"nov_orcado","from"=>"nov_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"dez_orcado","from"=>"dez_orcado","render_value", "render_value"=>null,],

           

          
             
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"description_cargo","from"=>"description_cargo", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_func",  "from"=>"description_func", "render_value"=>function(){ return "-";},],
            ["field_out"=>"mes",  "from"=>"mes", "render_value"=>function(){ return "-";},],

            // ["field_out"=>"jan_orcado","from"=>"jan_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value", "render_value"=>function(){ return "-";},],


            ["field_out"=>"jan_orcado","from"=>"jan_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"fev_orcado","from"=>"fev_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mar_orcado","from"=>"mar_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"abr_orcado","from"=>"abr_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mai_orcado","from"=>"mai_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jun_orcado","from"=>"jun_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jul_orcado","from"=>"jul_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"ago_orcado","from"=>"ago_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"set_orcado","from"=>"set_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"out_orcado","from"=>"out_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"nov_orcado","from"=>"nov_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"dez_orcado","from"=>"dez_orcado","render_value", "render_value"=>null,],
        ];

       
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['cdn_funcionario'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['cdn_funcionario', 'cod_cargo'],
                    "filter_data"=>['cdn_funcionario'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['cdn_funcionario']== $parent_data['cdn_funcionario']
                            // && 
                            // $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            // $value['lotacao_id']== $parent_data['lotacao_id']
                        );
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }


}