<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRealizado as RepoRealizado;
use Carbon\Carbon;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

 
class RealizadoController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRealizado();
        parent::__construct();
    }
    public function listarRealizado($orc_id, $mes, $orc_lotacao_id){
        $dados= $this->getRepository()->listar($orc_id, $mes, $orc_lotacao_id);
        // dd("dados", $dados); 
        return new Response(json_encode($this->montaTreetable($dados)) , 200);

    }
    
    public function listarRealizadoFiltro($orc_id, $mes, $orc_lotacao_id, $divergente){
        
        $this->setCodTela('REAL');      
        $this->podeAcessar('listar',true,$this->getCodTela());
        $dados= $this->getRepository()->listar($orc_id, $mes, $orc_lotacao_id, $divergente);
        // dd("dados", $dados);
        return new Response(json_encode($this->montaTreetable($dados)) , 200);

    } 
 

    function pivotColumns(){
        $meses_orcado =$this->getColumMeses();
        $eventos_meses = $this->getEventosList();        
        $retorno=[];
        
        $merge_meses_evento=[];
        $meses_orcados_clear=[];
        foreach($meses_orcado as $key => $value){
            
            $var = explode("_",$value);
            $meses_orcados_clear[]=$var[0];
            foreach($eventos_meses as $key_ev =>$value_ev){
                $merge_meses_evento[$var[0]."-".$value_ev->evento_id] = "";
                $merge_meses_evento[$var[0]."-".$value_ev->getEventos->cdn_event] = "";
            }
        }
        return  (object)['merged'=>$merge_meses_evento, 'mes_abreviado'=>$meses_orcados_clear];
    }

    public function pivo($dados){
        // $meses_orcado=$this->getColumMeses();  
        $meses_orcado= [];        
      
        // $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['ccusto_id','cargo_id', 'turma_id','lotacao_id'];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        // dd("pivooo", $retorno);
        return $retorno;
    }

    public function montaTreetable($data){
        
        // $pivot_colunas=$this->pivotColumns();
        // $col_meses=$pivot_colunas->merged;
        // $col_set_meses=[];
        // $col_meses_parent=[];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        // foreach($col_meses as $j=>$mes){
        //     $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
        //     $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
        //     "field_out_render_func"=>function($row_data,$value, $matrix){

        //     }];
        // }
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"origem_sistema", "from"=>"origem_sistema", "render_value"=>null,],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                // return ($value) ? intval($value) : $value;
                return is_null($value) ? 0 : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"divergente", "from"=>"divergente", "render_value"=>function($row_data, $value){ return false; },],

            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){

                return intval($value);
                //  number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                return intval($value);
                // number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                return intval($value);
                // return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"qtd_func_lot", "from"=>"qtd_func_lot", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],           
            ["field_out"=>"divergente", "from"=>"divergente", "render_value"=>function($row_data, $value){ return $value == 1 ? true : false;}],

            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>function($row_data, $value){
            //     return '-';
            // },],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turno_trab'].' - '.$row_data['des_turno_trab'];
            },],

            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turma_trab'].' - '.$row_data['des_turma_trab'];
            },],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return '';//($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],         
   
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"origem_sistema", "from"=>"origem_sistema", "render_value"=>null,]

        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function isSuspenso($orc_id){
        $orc = DB::select("select * from tbl_orcamento where id = ?", [$orc_id]);
        if(count($orc) > 0 && $orc[0]->is_suspended == 1){
            return true;
        }
        return false;
    }
    
    //METODO PARA CHAMAR NO BOTÃO DE LIBERAR FORECAST
    public function updateRealizadoWithForecast(Request $request,$orc_id, $periodo){
        // dd('chega aqui no realizado');
        set_time_limit(600);
        $retorno = $this->getArrayRetornoDefault(); 
        if( $this->isSuspenso($orc_id) == true ){
            $retorno['msg'] = "Orçamento Suspenso. Erro: 151020201624";
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error"; 
            goto saida;
        }



        $form_data = $request->all();
        // dd('form_data', $form_data);
        $dados= $this->getRepository()->updateRealizadoWithForecast($orc_id, $periodo);
    
       
        $retorno['msg']='Realizado atualizado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
       
        saida:
         return $this->retornoJsonDefault($retorno); 
       
        
        // return count($retorno) > 0 ? $retorno : $dados;
    }

}  