<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRealizadoFerias as RepoRealizadoFerias;
use Carbon\Carbon;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;

class RealizadoFeriasController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRealizadoFerias();
        parent::__construct();
    }

    public function listarAll($orc_id,$orc_lotacao_id, $periodo, $filtro){
        $this->setCodTela('REALFER');      
        $this->podeAcessar('listar',true,$this->getCodTela());
        $dados= $this->getRepository()->listarAll($orc_id,$orc_lotacao_id, $periodo, $filtro);
        return new Response(json_encode($this->montaTreetable($dados)) , 200);

    }

    public function montaTreetable($data){
      
        $column_fixeds=[ 

            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            ["field_out"=>"turma_turno", "from"=>"turma_turno", "render_value"=>function(){ return ' - '; },],
            ["field_out"=>"funcionario", "from"=>"funcionario", "render_value"=>function(){ return ' - '; },],
            ["field_out"=>"mes", "from"=>"mes", "render_value"=>function(){ return ' - '; },],

            // ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            // ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            // ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            
            // ["field_out"=>"cdn_turma_trab", "from"=>"cdn_turma_trab", "render_value"=>null,],
            // ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>null,],
            // ["field_out"=>"turma", "from"=>"turma", "render_value"=>null,],
            
            // ["field_out"=>"cdn_turno_trab", "from"=>"cdn_turno_trab", "render_value"=>null,],
            // ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>null,],
            // ["field_out"=>"turno", "from"=>"turno", "render_value"=>null,],

            // ["field_out"=>"turma_turno", "from"=>"turma_turno", "render_value"=>null,],

            
            // ["field_out"=>"cdn_event", "from"=>"cdn_event", "render_value"=>function(){ return ' - '; },],
            // ["field_out"=>"des_event", "from"=>"des_event", "render_value"=>function(){ return ' - '; },],
            // ["field_out"=>"evento", "from"=>"evento", "render_value"=>function(){ return ' - '; },],

            

            ["field_out"=>"jan", "from"=>"t_jan", "render_value"=>function($row_data, $value){
                 return number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"t_fev", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"t_mar","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"t_abr", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mai", "from"=>"t_mai", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jun", "from"=>"t_jun","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jul", "from"=>"t_jul", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"ago", "from"=>"t_ago", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"set", "from"=>"t_set", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"out", "from"=>"t_out", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"nov", "from"=>"t_nov", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"dez", "from"=>"t_dez","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },]
        ];

        $column_fixeds_children=[ 


            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>function(){ return ' - '; },],
            ["field_out"=>"turma_turno", "from"=>"turma_turno", "render_value"=>null,],
            ["field_out"=>"funcionario", "from"=>"funcionario", "render_value"=>null,],

            ["field_out"=>"mes", "from"=>"mes", "render_value"=>null,], 

            // ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            // ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            // ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null,],

            // ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            // ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            // ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            
            // ["field_out"=>"cdn_turma_trab", "from"=>"cdn_turma_trab", "render_value"=>null,],
            // ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>null,],
            // ["field_out"=>"turma", "from"=>"turma", "render_value"=>null,],
            
            // ["field_out"=>"cdn_turno_trab", "from"=>"cdn_turno_trab", "render_value"=>null,],
            // ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>null,],
            // ["field_out"=>"turno", "from"=>"turno", "render_value"=>null,],

            // ["field_out"=>"turma_turno", "from"=>"turma_turno", "render_value"=>null,],

            
            // ["field_out"=>"cdn_event", "from"=>"cdn_event", "render_value"=>null,],
            // ["field_out"=>"des_event", "from"=>"des_event", "render_value"=>null,],
            // ["field_out"=>"evento", "from"=>"evento", "render_value"=>null,],


            ["field_out"=>"jan", "from"=>"jan", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           },],
           ["field_out"=>"fev", "from"=>"fev", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"mar", "from"=>"mar","render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"abr", "from"=>"abr", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"mai", "from"=>"mai", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"jun", "from"=>"jun","render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"jul", "from"=>"jul", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"ago", "from"=>"ago", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"set", "from"=>"set", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"out", "from"=>"out", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"nov", "from"=>"nov", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"dez", "from"=>"dez","render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },]

        ];

        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
        "keys"=>['orc_cargo_id'],
        // "filter_data"=>['parent_id'=>function($value){
        //         return is_null($value);
        //     }    
        // ],            
        "children"=>["columns"=>$columns_children,
            "keys"=>['orc_cargo_id', 'orc_turma_id','cdn_funcionario'],
            "filter_data"=>['cdn_funcionario'=>function($value){
                return !is_null($value);
            }],
            'parent_filter'=> function($value, $parent_data){
                $result=(
                    $value['orc_cargo_id']== $parent_data['orc_cargo_id'] 
                    // && 
                    // $value['orc_turma_id']== $parent_data['orc_turma_id'] //&&
                    // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                    // $value['lotacao_id']== $parent_data['lotacao_id']
                );
            
                return $result;
            },
        ]
    ];
                 
        $controller = new AtmTreeTable($settings, $data);
        return ['data'=>$controller->render()];    
    }
}