<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRealizadoHoraExtra as RepoRealizadoHoraExtra;
use Carbon\Carbon;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;

class RealizadoHoraExtraController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRealizadoHoraExtra();
        parent::__construct();
    }

    public function listarAll($orc_id, $orc_lotacao_id, $periodo, $filtro){
        $this->setCodTela('REALHRE');      
        $this->podeAcessar('listar',true,$this->getCodTela());
        $dados= $this->getRepository()->listarAll($orc_id, $orc_lotacao_id, $periodo, $filtro);
        return new Response(json_encode($this->montaTreetable($dados)) , 200);

    }

    public function montaTreetable($data){
      
        $column_fixeds=[ 
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null,],
            ["field_out"=>"mes", "from"=>"mes", "render_value"=>function(){ return ' - '; },],


            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            
            ["field_out"=>"cdn_turma_trab", "from"=>"cdn_turma_trab", "render_value"=>null,],
            ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null,],
            
            ["field_out"=>"cdn_turno_trab", "from"=>"cdn_turno_trab", "render_value"=>null,],
            ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turno", "from"=>"turno", "render_value"=>null,],

            ["field_out"=>"turma_turno", "from"=>"turma_turno", "render_value"=>null,],

            
            ["field_out"=>"cdn_event", "from"=>"cdn_event", "render_value"=>function(){ return ' - '; },],
            ["field_out"=>"des_event", "from"=>"des_event", "render_value"=>function(){ return ' - '; },],
            ["field_out"=>"evento", "from"=>"evento", "render_value"=>function(){ return ' - '; },],

            

            ["field_out"=>"jan", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                 return number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"total_mar","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mai", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jun", "from"=>"total_jun","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jul", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"ago", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"set", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"out", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"nov", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"dez", "from"=>"total_dez","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },]
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null,],

            ["field_out"=>"mes", "from"=>"mes", "render_value"=>null,],

            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            
            ["field_out"=>"cdn_turma_trab", "from"=>"cdn_turma_trab", "render_value"=>null,],
            ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null,],
            
            ["field_out"=>"cdn_turno_trab", "from"=>"cdn_turno_trab", "render_value"=>null,],
            ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turno", "from"=>"turno", "render_value"=>null,],

            ["field_out"=>"turma_turno", "from"=>"turma_turno", "render_value"=>null,],

            
            ["field_out"=>"cdn_event", "from"=>"cdn_event", "render_value"=>null,],
            ["field_out"=>"des_event", "from"=>"des_event", "render_value"=>null,],
            ["field_out"=>"evento", "from"=>"evento", "render_value"=>null,],


            ["field_out"=>"jan", "from"=>"jan", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           },],
           ["field_out"=>"fev", "from"=>"fev", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"mar", "from"=>"mar","render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"abr", "from"=>"abr", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"mai", "from"=>"mai", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"jun", "from"=>"jun","render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"jul", "from"=>"jul", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"ago", "from"=>"ago", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"set", "from"=>"set", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"out", "from"=>"out", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"nov", "from"=>"nov", "render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },],
           ["field_out"=>"dez", "from"=>"dez","render_value"=>function($row_data, $value){
               return number_format($value,2,',', '.');
           },]

        ];

        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['orc_cargo_id', 'orc_turma_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['orc_cargo_id', 'orc_turma_id','evento_id','periodo'],
                    "filter_data"=>['evento_id'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=(
                                $value['orc_cargo_id']== $parent_data['orc_cargo_id'] && 
                                $value['orc_turma_id']== $parent_data['orc_turma_id'] //&&
                                // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                                // $value['lotacao_id']== $parent_data['lotacao_id']
                            );
                        
                            return $result;
                    },
                ]
            ];
                 
        $controller = new AtmTreeTable($settings, $data);
        return ['data'=>$controller->render()];    
    }
}