<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRealizadoPromocoesTrans as RepoRealizadoPromocoesTrans;
use Carbon\Carbon;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;

class RealizadoPromocaoTransController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRealizadoPromocoesTrans();
        parent::__construct();
    }
  
    public function listarAll($orc_id, $orc_lotacao_id, $mes, $filtro){
        $this->setCodTela('REALPROM');      
        $this->podeAcessar('listar',true,$this->getCodTela());
        // $dados= $this->getRepository()->listarAll($orc_id, $orc_lotacao_id, $mes, $filtro);
        // return new Response(json_encode($this->montaTreetable($dados)) , 200);
        return $this->getRepository()->listarAll($orc_id, $orc_lotacao_id, $mes, $filtro);

    }

    public function montaTreetable($data){
        
        $column_fixeds=[ 
            
            ["field_out"=>"description_turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_turma_promovido", "render_value"=>function(){ return "-";},],

            ["field_out"=>"description_cargo", "render_value", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_cargo_promovido", "render_value"=>function(){ return "-";},],

            ["field_out"=>"description_lotacao", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_lotacao_promovida", "render_value"=>function(){ return "-";},],
           
            ["field_out"=>"description_ccusto", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_ccusto_promovida", "render_value"=>function(){ return "-";},],

            ["field_out"=>"mes_promocao", "render_value"=>function(){ return "-";},],
           
            ["field_out"=>"funcionario",  "from"=>"description_func", "render_value"=>null,],

          
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"description_turma", "from"=>"description_turma", "render_value"=>null,],
            ["field_out"=>"description_turma_promovido", "from"=>"description_turma_promovido", "render_value"=>function($rowData, $value){
                return $rowData['promocao_turma']? $value : ' - ';
            },],

            ["field_out"=>"description_cargo", "from"=>"description_cargo","render_value", "render_value"=>null,],
            ["field_out"=>"description_cargo_promovido", "from"=>"description_cargo_promovido","render_value"=>function($rowData, $value){
                return $rowData['promocao_cargo']? $value : ' - ';
            },],

            ["field_out"=>"description_lotacao", "from"=>"description_lotacao","render_value"=>null,],
            ["field_out"=>"description_lotacao_promovida", "from"=>"description_lotacao_promovida","render_value"=>function($rowData, $value){
                return $rowData['promocao_lotacao']? $value : ' - ';
            },],
           
            ["field_out"=>"description_ccusto", "from"=>"description_ccusto","render_value"=>null,],
            ["field_out"=>"description_ccusto_promovida", "from"=>"description_ccusto_promovida","render_value"=>function($rowData, $value){
                return $rowData['promocao_ccusto']? $value : ' - ';
            },],

            ["field_out"=>"mes_promocao", "from"=>"mes_promocao", "render_value"=>null,],
           
            ["field_out"=>"funcionario",   "render_value"=>function(){ return "-";},],
        ];

       
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['cdn_funcionario'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['cdn_funcionario', 'mes_promocao'],
                    "filter_data"=>['cdn_funcionario'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['cdn_funcionario']== $parent_data['cdn_funcionario']
                            // && 
                            // $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            // $value['lotacao_id']== $parent_data['lotacao_id']
                        );
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }
}

 