<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRelatorioRealizadoAumentos as RepoRelatorioRealizadoAumentos;
use Carbon\Carbon;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
 
class RealizadoRelatorioAumentosController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRelatorioRealizadoAumentos();
        parent::__construct();
    }
    public function listarRealizado($orc_id){
        $dados= $this->getRepository()->listarRelatorioRealizadoAumentos($orc_id);
        // dd("dados", $dados); 
        // return new Response(json_encode($this->montaTreetable($dados)) , 200);
        return $dados;

    } 
    public function montaTreetable($data){
        
        $column_fixeds=[  
            
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            
            ["field_out"=>"description_cargo","from"=>"description_cargo", "render_value"=>null,],
            ["field_out"=>"description_func",  "from"=>"description_func", "render_value"=>null,],
            ["field_out"=>"mes",  "from"=>"mes", "render_value"=>null,],

            // ["field_out"=>"description_func", "render_value"=>function(){ return "-";},],

            // ["field_out"=>"jan_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"fev_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mar_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"abr_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mai_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jun_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jul_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"ago_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"set_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"out_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"nov_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"dez_orcado", "render_value", "render_value"=>function(){ return "-";},],





	
            ["field_out"=>"jan_orcado","from"=>"jan_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"fev_orcado","from"=>"fev_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mar_orcado","from"=>"mar_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"abr_orcado","from"=>"abr_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mai_orcado","from"=>"mai_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jun_orcado","from"=>"jun_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jul_orcado","from"=>"jul_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"ago_orcado","from"=>"ago_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"set_orcado","from"=>"set_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"out_orcado","from"=>"out_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"nov_orcado","from"=>"nov_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"dez_orcado","from"=>"dez_orcado","render_value", "render_value"=>null,],

           

          
             
        ];

        $column_fixeds_children=[ 
            
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"description_cargo","from"=>"description_cargo", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_func",  "from"=>"description_func", "render_value"=>function(){ return "-";},],
            ["field_out"=>"mes",  "from"=>"mes", "render_value"=>function(){ return "-";},],

            // ["field_out"=>"jan_orcado","from"=>"jan_orcado", "render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value", "render_value"=>function(){ return "-";},],
            // ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value", "render_value"=>function(){ return "-";},],
 
            ["field_out"=>"fev", "from"=>"fev", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            },],



            ["field_out"=>"jan_orcado","from"=>"jan_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"fev_orcado","from"=>"fev_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mar_orcado","from"=>"mar_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"abr_orcado","from"=>"abr_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"mai_orcado","from"=>"mai_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jun_orcado","from"=>"jun_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"jul_orcado","from"=>"jul_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"ago_orcado","from"=>"ago_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"set_orcado","from"=>"set_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"out_orcado","from"=>"out_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"nov_orcado","from"=>"nov_orcado","render_value", "render_value"=>null,],
            ["field_out"=>"dez_orcado","from"=>"dez_orcado","render_value", "render_value"=>null,],
        ];

       
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['lotacao', 'description_cargo'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['lotacao', 'description_cargo', 'cdn_funcionario'],
                    "filter_data"=>['cdn_funcionario'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['lotacao']== $parent_data['lotacao']
                            && 
                            // $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['description_cargo']== $parent_data['description_cargo']
                        );
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioRealizadoAumento', ['cdn_funcionario']);
    }
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("description cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("description func", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("mes", "Mês", $colunas[$i]);

            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);

        }
        return $colunas;
    }
}