<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRelatorioRealizado as RepoRelatorioRealizado;
use Carbon\Carbon;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
 
class RealizadoRelatorioController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRelatorioRealizado();
        parent::__construct();
    }
    public function listarRealizado($orc_id){
        $dados= $this->getRepository()->listarRelatorioRealizado($orc_id);
        // dd("dados", $dados); 
        return new Response(json_encode($this->montaTreetable($dados)) , 200);

    } 

    public function montaTreetable($data){
     
        $column_fixeds=[ 
            
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
           
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"cargo", "from"=>"des_cargo_basic", "render_value"=>function($row_data, $value){
                return $row_data['cod_cargo_basic'].' - '.$row_data['des_cargo_basic'];
            },],

            // ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
            //     // return ($value) ? intval($value) : $value;
            //     return is_null($value) ? 0 : $value;
            // },],
            // ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
            //     return ($value != '-') ? intval($value) : $value;
            // },],

            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){

                return intval($value);
                //  number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                return intval($value);
                // number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                return intval($value);
                // return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"qtd_func_lot", "from"=>"qtd_func_lot", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],           
            ["field_out"=>"divergente", "from"=>"divergente", "render_value"=>function($row_data, $value){ return $value == 1 ? true : false;}],

            ["field_out"=>"cargo", "from"=>"des_cargo_basic", "render_value"=>function($row_data, $value){
                return $row_data['cod_cargo_basic'].' - '.$row_data['des_cargo_basic'];
            },],

            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>function($row_data, $value){
            //     return '-';
            // },],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turno_trab'].' - '.$row_data['des_turno_trab'];
            },],

            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turma_trab'].' - '.$row_data['des_turma_trab'];
            },],
            // ["field_out"=>"cargo", "from"=>"des_cargo_basic", "render_value"=>function($row_data, $value){
            //     return $row_data['cod_cargo_basic'].' - '.$row_data['des_cargo_basic'];
            // },],

            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return '';//($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],         
   
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"origem_sistema", "from"=>"origem_sistema", "render_value"=>null,]

        ];


        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }     
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioRealizado',['id', 'id_princ','cod_cargo_basic','des_cargo_basic', 'atual', 'qtd_func_lot', 'divergente', 'orcado_anterior', 'forecast_anterior', 'orc_turma_id', 'ccusto_id', 'cargo_id', 'lotacao_id', 'origem_sistema']);
    }
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("orc id", "Orçamento", $colunas[$i]);
            $colunas[$i] = str_replace("turno", "Turno", $colunas[$i]);
            $colunas[$i] = str_replace("turma", "Turma", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("cod ccusto", "Centro de custo", $colunas[$i]);
            
            $colunas[$i] = str_replace("jan", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez", "Dezembro", $colunas[$i]);




        }
        return $colunas;
    }
} 