<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRelatorioRealizadoDemissoes as RepoRelatorioRealizadoDemissoes;
use Carbon\Carbon;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
 
class RealizadoRelatorioDemissoesController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRelatorioRealizadoDemissoes();
        parent::__construct();
    }
    public function listarRealizado($orc_id){
        $dados= $this->getRepository()->listarRelatorioRealizadoDemissoes($orc_id);
        // dd("dados", $dados); 
        return new Response(json_encode($this->montaTreetable($dados)) , 200);
    }
    public function montaTreetable($data){
        
        $column_fixeds=[ 
            
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"mes", "render_value"=>function(){ return "-";},],
            ["field_out"=>"funcionario",  "render_value"=>function(){ return "-";},],

          
            
        ];

        $column_fixeds_children=[ 
            
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"turno", "from"=>"cdn_turno_trab", "render_value"=>function($row_data, $value){ 
                return $row_data['cdn_turno_trab'].' - '.$row_data['des_turno_trab'];
            },],
            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turma_trab'].' - '.$row_data['des_turma_trab'];
            },],
            ["field_out"=>"mes", "from"=>"mes", "render_value"=>null,],
            ["field_out"=>"funcionario", "from"=>"cdn_funcionario",  "render_value"=>function($row_data, $value){ 
                return $row_data['cdn_funcionario'].' - '.$row_data['nome_funcionario'];
            },],

            
        ];

       
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['lotacao_id', 'cargo_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['lotacao_id', 'cargo_id','orc_turma_id', 'cdn_funcionario'],
                    "filter_data"=>['cargo_id'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['cargo_id']== $parent_data['cargo_id'] && 
                            // $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']
                        );
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioRealizadoDemissoes');
    }
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cod cargo basic", "Código Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("des cargo basic", "Descrição Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("turno", "Turno", $colunas[$i]);
            $colunas[$i] = str_replace("turma", "turma", $colunas[$i]);
            $colunas[$i] = str_replace("mes", "Mês", $colunas[$i]);
            $colunas[$i] = str_replace("funcionario", "Funcionário", $colunas[$i]);

        }
        return $colunas;
    }
}