<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoRelatorioRealizadoPromocoes as RepoRelatorioRealizadoPromocoes;
use Carbon\Carbon;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
 
class RealizadoRelatorioPromocaoController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoRelatorioRealizadoPromocoes();
        parent::__construct();
    }
    public function listarRealizado($orc_id){
        $dados= $this->getRepository()->listarRelatorioRealizadoPromocoes($orc_id);
        // dd("dados", $dados); 
        // return new Response(json_encode($this->montaTreetable($dados)) , 200);]
        return $dados;

    }

    public function montaTreetable($data){
        
        $column_fixeds=[ 
            
            ["field_out"=>"description_turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_turma_promovido", "render_value"=>function(){ return "-";},],

            ["field_out"=>"description_cargo", "render_value", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_cargo_promovido", "render_value"=>function(){ return "-";},],

            ["field_out"=>"description_lotacao", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_lotacao_promovida", "render_value"=>function(){ return "-";},],
           
            ["field_out"=>"description_ccusto", "render_value"=>function(){ return "-";},],
            ["field_out"=>"description_ccusto_promovida", "render_value"=>function(){ return "-";},],

            ["field_out"=>"mes_promocao", "render_value"=>function(){ return "-";},],
           
            ["field_out"=>"funcionario",  "from"=>"description_func", "render_value"=>null,],

          
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"description_turma", "from"=>"description_turma", "render_value"=>null,],
            ["field_out"=>"description_turma_promovido", "from"=>"description_turma_promovido", "render_value"=>function($rowData, $value){
                return $rowData['promocao_turma']? $value : ' - ';
            },],

            ["field_out"=>"description_cargo", "from"=>"description_cargo","render_value", "render_value"=>null,],
            ["field_out"=>"description_cargo_promovido", "from"=>"description_cargo_promovido","render_value"=>function($rowData, $value){
                return $rowData['promocao_cargo']? $value : ' - ';
            },],

            ["field_out"=>"description_lotacao", "from"=>"description_lotacao","render_value"=>null,],
            ["field_out"=>"description_lotacao_promovida", "from"=>"description_lotacao_promovida","render_value"=>function($rowData, $value){
                return $rowData['promocao_lotacao']? $value : ' - ';
            },],
           
            ["field_out"=>"description_ccusto", "from"=>"description_ccusto","render_value"=>null,],
            ["field_out"=>"description_ccusto_promovida", "from"=>"description_ccusto_promovida","render_value"=>function($rowData, $value){
                return $rowData['promocao_ccusto']? $value : ' - ';
            },],

            ["field_out"=>"mes_promocao", "from"=>"mes_promocao", "render_value"=>null,],
           
            ["field_out"=>"funcionario",   "render_value"=>function(){ return "-";},],
        ];

       
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['cdn_funcionario'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['cdn_funcionario', 'mes_promocao'],
                    "filter_data"=>['cdn_funcionario'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['cdn_funcionario']== $parent_data['cdn_funcionario']
                            // && 
                            // $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            // $value['lotacao_id']== $parent_data['lotacao_id']
                        );
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
                // dd(json_decode($_POST['array_imprimir']));
        return parent::downloadExcel($type, 'RelatorioRealizadoPromocoes', ['promocao_cargo','cdn_funcionario', 'nome_funcionario', 'cargo_cod_atual', 'cargo_atual', 'cargo_atual_id', 'cargo_promovido_cod', 'cargo_promovido', 'cargo_promovido_id', 'turma_id', 'turma', 'turma_atual_id', 'turma_promovida_cdn', 'turma_promovida', 'turma_promovida_id', 'lotacao_cod', 'lotacao', 'lotacao_id', 'lotacao_promovida_cod', 'lotacao_promovida', 'lotacao_promovida_id', 'ccusto_id', 'ccusto_promovido_id', 'promocao Cargo', 'promocao_turma','promocao_lotacao', 'promocao_ccusto', 'ccusto_id']);
    }
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) {   
            $colunas[$i] = str_replace("description_cargo_promovido", "Cargo Promovido", $colunas[$i]);
            $colunas[$i] = str_replace("description_turma_promovido", "Turma Promovida", $colunas[$i]);
            $colunas[$i] = str_replace("description_lotacao_promovida", "Lotação Promovida", $colunas[$i]);

            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("description ccusto promovida", "C. custo Promovido", $colunas[$i]);

            $colunas[$i] = str_replace("description func", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("description cargo", "Cargo Origem", $colunas[$i]);
            $colunas[$i] = str_replace("description turma", "Turma Origem", $colunas[$i]);
            $colunas[$i] = str_replace("description lotacao", "Lotação Origem", $colunas[$i]);
            $colunas[$i] = str_replace("description ccusto", "C. custo Origem", $colunas[$i]);
            $colunas[$i] = str_replace("mes promocao", "Mês Promoção", $colunas[$i]);
            $colunas[$i] = str_replace("funcionario", "Funcionário", $colunas[$i]);
        }
        return $colunas;
    }

}