<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoRelatorioAumentoSalarial;
use App\Modules\Natureza51\Repositories\RepoRelatorioContratacoes;
use App\Modules\Natureza51\Repositories\RepoRelatorioDemissoes;
use App\Modules\Natureza51\Repositories\RepoRelatorioFerias;
use App\Modules\Natureza51\Repositories\RepoRelatorioHeadcount;
use App\Modules\Natureza51\Repositories\RepoRelatorioHoraExtra;
use App\Modules\Natureza51\Repositories\RepoRelatorioPCDJA;
use App\Modules\Natureza51\Repositories\RepoRelatorioPromocao;
use App\Support\TreeTable\AtmTreeTable;

class RelatoriosController extends OrcamentoController
{
    public function __construct(){
        $this->repository = new RepoRelatorioDemissoes();
        parent::__construct();
    }
    public function listarRelatorioDemissoes($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLDEM');
        $resp = $this->getRepository()->listarRelatorioDemissoes($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTable($resp);
    }
    public function listarRelatorioDemissoesIndividual($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLDEM');
        $resp = $this->getRepository()->listarRelatorioDemissoesIndividual($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableIndividual($resp);
    }
    public function listarRelatorioContratacoes($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLCONT');
        $contratacoes = new RepoRelatorioContratacoes();
        $resp = $contratacoes->listarRelatorioContratacao($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableContratacao($resp);
    }
    public function listarRelatorioPromocoes($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLPROM');
        $promocao = new RepoRelatorioPromocao();
        $resp = $promocao->listarRelatorioPromocao($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTablePromocao($resp);
    }
    public function listarRelatorioAumentosSalariais($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLAS');
        $aumento_salarial = new RepoRelatorioAumentoSalarial();
        $resp = $aumento_salarial->listarRelatorioAumentoSalarial($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableAumentoSalarial($resp);
    }
    public function listarRelatorioHorasExtras($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLHE');
        $he = new RepoRelatorioHoraExtra();
        $resp = $he->listarRelatorioHoraExtra($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableHoraExtra($resp);
    }
    public function listarRelatorioFeriasPorTurma($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLFET');
        $ferias = new RepoRelatorioFerias();
        $resp = $ferias->listarRelatorioFeriasTurma($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableFerias($resp);
    }
    public function listarRelatorioFeriasPorFuncionario($orc_id, $tipo_table = null, $periodo = null){
        $this->podeAcessar('listar',true,'RLFEF');
        $ferias = new RepoRelatorioFerias();
        $resp = $ferias->listarRelatorioFeriasFuncionario($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableFeriasFuncionario($resp);
    }
    public function listarRelatorioHeadcount($orc_id, $tipo_table = null, $periodo = null){
		set_time_limit(600);
        $this->podeAcessar('listar',true,'RLHD');
        $hd = new RepoRelatorioHeadcount();
        $resp = $hd->listarRelatorioHeadcount($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableHeadcount($resp);
    }
    public function listarRelatorioHeadcountSintetico($orc_id, $tipo_table = null, $periodo = null){
		set_time_limit(600);
        $this->podeAcessar('listar',true,'RLHD');
        $hd = new RepoRelatorioHeadcount();
        $resp = $hd->listarRelatorioHeadcountSintetico($orc_id, $tipo_table, $periodo);
        return $this->montaTreeTableHeadcountSintetico($resp);
    }
    public function listarRelatorioPCD($orc_id, $periodo, $tipo_table){
        $nivel_hier = json_decode(safeDecrypt(request()->bearerToken()),true)['token']['func_data']['nivel_hier'];
        $tipo = json_decode(safeDecrypt(request()->bearerToken()),true)['token']['tipo_user'];

        $repo = new RepoRelatorioPCDJA();
        $dados = $repo->listarPCDRelatorio($orc_id, $tipo_table, $periodo, $nivel_hier, $tipo);
        foreach($dados as $value){
            $value->jan = formataMonetarioQuatro( number_format($value->jan, 4, ',', '.') );
            $value->fev = formataMonetarioQuatro( number_format($value->fev, 4, ',', '.') );
            $value->mar = formataMonetarioQuatro( number_format($value->mar, 4, ',', '.') );
            $value->abr = formataMonetarioQuatro( number_format($value->abr, 4, ',', '.') );

            $value->mai = formataMonetarioQuatro( number_format($value->mai, 4, ',', '.') );
            $value->jun = formataMonetarioQuatro( number_format($value->jun, 4, ',', '.') );
            $value->jul = formataMonetarioQuatro( number_format($value->jul, 4, ',', '.') );
            $value->ago = formataMonetarioQuatro( number_format($value->ago, 4, ',', '.') );

            $value->set = formataMonetarioQuatro( number_format($value->set, 4, ',', '.') );
            $value->out = formataMonetarioQuatro( number_format($value->out, 4, ',', '.') );
            $value->nov = formataMonetarioQuatro( number_format($value->nov, 4, ',', '.') );
            $value->dez = formataMonetarioQuatro( number_format($value->dez, 4, ',', '.') );

            $value->diferenca_jan = formataMonetarioQuatro( number_format($value->diferenca_jan, 4, ',', '.') );
            $value->diferenca_fev = formataMonetarioQuatro( number_format($value->diferenca_fev, 4, ',', '.') );
            $value->diferenca_mar = formataMonetarioQuatro( number_format($value->diferenca_mar, 4, ',', '.') );
            $value->diferenca_abr = formataMonetarioQuatro( number_format($value->diferenca_abr, 4, ',', '.') );

            $value->diferenca_mai = formataMonetarioQuatro( number_format($value->diferenca_mai, 4, ',', '.') );
            $value->diferenca_jun = formataMonetarioQuatro( number_format($value->diferenca_jun, 4, ',', '.') );
            $value->diferenca_jul = formataMonetarioQuatro( number_format($value->diferenca_jul, 4, ',', '.') );
            $value->diferenca_ago = formataMonetarioQuatro( number_format($value->diferenca_ago, 4, ',', '.') );

            $value->diferenca_set = formataMonetarioQuatro( number_format($value->diferenca_set, 4, ',', '.') );
            $value->diferenca_out = formataMonetarioQuatro( number_format($value->diferenca_out, 4, ',', '.') );
            $value->diferenca_nov = formataMonetarioQuatro( number_format($value->diferenca_nov, 4, ',', '.') );
            $value->diferenca_dez = formataMonetarioQuatro( number_format($value->diferenca_dez, 4, ',', '.') );
        }
        return $dados;
    }
    public function listarRelatorioJA($orc_id, $periodo, $tipo_table){
        $nivel_hier = json_decode(safeDecrypt(request()->bearerToken()),true)['token']['func_data']['nivel_hier'];
        $tipo = json_decode(safeDecrypt(request()->bearerToken()),true)['token']['tipo_user'];

        $repo = new RepoRelatorioPCDJA();
        $dados = $repo->listarJARelatorio($orc_id, $tipo_table, $periodo, $nivel_hier, $tipo);
        foreach($dados as $value){
            $value->jan = formataMonetarioQuatro( number_format($value->jan, 4, ',', '.') );
            $value->fev = formataMonetarioQuatro( number_format($value->fev, 4, ',', '.') );
            $value->mar = formataMonetarioQuatro( number_format($value->mar, 4, ',', '.') );
            $value->abr = formataMonetarioQuatro( number_format($value->abr, 4, ',', '.') );

            $value->mai = formataMonetarioQuatro( number_format($value->mai, 4, ',', '.') );
            $value->jun = formataMonetarioQuatro( number_format($value->jun, 4, ',', '.') );
            $value->jul = formataMonetarioQuatro( number_format($value->jul, 4, ',', '.') );
            $value->ago = formataMonetarioQuatro( number_format($value->ago, 4, ',', '.') );

            $value->set = formataMonetarioQuatro( number_format($value->set, 4, ',', '.') );
            $value->out = formataMonetarioQuatro( number_format($value->out, 4, ',', '.') );
            $value->nov = formataMonetarioQuatro( number_format($value->nov, 4, ',', '.') );
            $value->dez = formataMonetarioQuatro( number_format($value->dez, 4, ',', '.') );

            $value->diferenca_jan = formataMonetarioQuatro( number_format($value->diferenca_jan, 4, ',', '.') );
            $value->diferenca_fev = formataMonetarioQuatro( number_format($value->diferenca_fev, 4, ',', '.') );
            $value->diferenca_mar = formataMonetarioQuatro( number_format($value->diferenca_mar, 4, ',', '.') );
            $value->diferenca_abr = formataMonetarioQuatro( number_format($value->diferenca_abr, 4, ',', '.') );

            $value->diferenca_mai = formataMonetarioQuatro( number_format($value->diferenca_mai, 4, ',', '.') );
            $value->diferenca_jun = formataMonetarioQuatro( number_format($value->diferenca_jun, 4, ',', '.') );
            $value->diferenca_jul = formataMonetarioQuatro( number_format($value->diferenca_jul, 4, ',', '.') );
            $value->diferenca_ago = formataMonetarioQuatro( number_format($value->diferenca_ago, 4, ',', '.') );

            $value->diferenca_set = formataMonetarioQuatro( number_format($value->diferenca_set, 4, ',', '.') );
            $value->diferenca_out = formataMonetarioQuatro( number_format($value->diferenca_out, 4, ',', '.') );
            $value->diferenca_nov = formataMonetarioQuatro( number_format($value->diferenca_nov, 4, ',', '.') );
            $value->diferenca_dez = formataMonetarioQuatro( number_format($value->diferenca_dez, 4, ',', '.') );
        }
        return $dados;
    }
    public function treeTablePcd(){
        $column_fixeds=[
            ["field_out"=>"unidade_lotacao", "from"=>"unidade_lotacao","render_value"=>null],
            
            ["field_out"=>"jan", "from"=>"jan","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"diferenca_jan", "from"=>"diferenca_jan","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"fev", "from"=>"fev","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"diferenca_fev", "from"=>"diferenca_fev","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"mar", "from"=>"mar","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"diferenca_mar", "from"=>"diferenca_mar","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"abr", "from"=>"abr","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"diferenca_abr", "from"=>"diferenca_abr","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"mai", "from"=>"mai","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"atual", "from"=>"atual","render_value"=>null],
            ["field_out"=>"diferenca_mai", "from"=>"diferenca_mai","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"jun", "from"=>"jun","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"diferenca_jun", "from"=>"diferenca_jun","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"jul", "from"=>"jul","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"diferenca_jul", "from"=>"diferenca_jul","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"ago", "from"=>"ago","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"diferenca_ago", "from"=>"diferenca_ago","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"set", "from"=>"set","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"diferenca_set", "from"=>"diferenca_set","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"out", "from"=>"out","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"diferenca_out", "from"=>"diferenca_out","render_value"=>function($row_data, $value){
                return number_format($value);
            }],

            ["field_out"=>"nov", "from"=>"nov","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"diferenca_nov", "from"=>"diferenca_nov","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"dez", "from"=>"dez","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            ["field_out"=>"diferenca_dez", "from"=>"diferenca_dez","render_value"=>function($row_data, $value){
                return number_format($value);
            }],
            
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"atual", "from"=>"atual","render_value"=>null],
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>[],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>[],
                        "filter_data"=>[]
            ]
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
    public function montaTreeTableHeadcount($data){
        $column_fixeds=[
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"realizado", "from"=>"total_realizado", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            // ["field_out"=>"Fcst_out", "from"=>"total_Fsct_out", "render_value"=>function($row_data, $value){
            //     return intval($value) == 0 ? '0' : intval($value);
            // }],
            ["field_out"=>"Fcst_dez", "from"=>"total_Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"Fcst", "from"=>"total_Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"orcado_anterior", "from"=>"total_orcado_anterior", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"orcado", "from"=>"total_headcount_dez_A", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"variacao_fcst", "from"=>"total_variacao_1", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"variacao_orcado", "from"=>"total_variacao_2", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"pcd_realizado", "from"=>"total_pcd", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"projecao_pcd", "from"=>"total_projecao", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : number_format(0, 2, ',', '.');
            }],
            ["field_out"=>"projecao_jovem_aprendiz", "from"=>"total_projecao_jovem_aprendiz", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : number_format(0, 2, ',', '.');
            }],

            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"informativo", "from"=>"informativo", "render_value"=>null]
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"realizado", "from"=>"realizado", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            // ["field_out"=>"Fcst_out", "from"=>"Fcst_out", "render_value"=>function($row_data, $value){
            //     return intval($value) == 0 ? '0' : intval($value);
            // }],
            ["field_out"=>"Fcst_dez", "from"=>"Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"Fcst", "from"=>"Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                if($value === '-'){
                    return '-';
                }
                else{
                    return intval($value) == 0 ? '0' : intval($value);
                }
            }],
            ["field_out"=>"orcado", "from"=>"headcount_dez_A", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"variacao_fcst", "from"=>"variacao_1", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"variacao_orcado", "from"=>"variacao_2", "render_value"=>function($row_data, $value){
                if($value === '-'){
                    return '-';
                }
                else{
                    return intval($value) == 0 ? '0' : intval($value);
                }
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"pcd_realizado", "from"=>"pcd", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"projecao_pcd", "from"=>"projecao", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : number_format(0, 2, ',', '.');
            }],
            ["field_out"=>"projecao_jovem_aprendiz", "from"=>"projecao_jovem_aprendiz", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : 0;
            }],
            ["field_out"=>"informativo", "from"=>"informativo", "render_value"=>null]

        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['orc_cargo_id','ccusto_id','lotacao_id','orc_turma_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_cargo_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_turma_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['orc_cargo_id'] == $parent_data['orc_cargo_id']);
                                return ($lotacao && $ccusto);
                        }
            ]
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
    public function montaTreeTableHeadcountSintetico($data){
        $column_fixeds=[
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],            
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"realizado", "from"=>"total_realizado", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            // ["field_out"=>"Fcst_out", "from"=>"total_Fsct_out", "render_value"=>function($row_data, $value){
            //     return intval($value) == 0 ? '0' : intval($value);
            // }],
            ["field_out"=>"Fcst_dez", "from"=>"total_Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"Fcst", "from"=>"total_Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"orcado_anterior", "from"=>"total_orcado_anterior", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"orcado", "from"=>"total_headcount_dez_A", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"variacao_fcst", "from"=>"total_variacao_1", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"variacao_orcado", "from"=>"total_variacao_2", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"pcd_realizado", "from"=>"total_pcd", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"projecao_pcd", "from"=>"total_projecao", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : number_format(0, 2, ',', '.');
            }],
            ["field_out"=>"projecao_jovem_aprendiz", "from"=>"total_projecao_jovem_aprendiz", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : number_format(0, 2, ',', '.');
            }],

            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"informativo", "from"=>"informativo", "render_value"=>null]
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            
            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"realizado", "from"=>"realizado", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            // ["field_out"=>"Fcst_out", "from"=>"Fcst_out", "render_value"=>function($row_data, $value){
            //     return intval($value) == 0 ? '0' : intval($value);
            // }],
            ["field_out"=>"Fcst_dez", "from"=>"Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"Fcst", "from"=>"Fsct_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"orcado", "from"=>"headcount_dez_A", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"variacao_fcst", "from"=>"variacao_1", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"variacao_orcado", "from"=>"variacao_2", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"pcd_realizado", "from"=>"pcd", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"projecao_pcd", "from"=>"projecao", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : number_format(0, 2, ',', '.');
            }],
            ["field_out"=>"projecao_jovem_aprendiz", "from"=>"projecao_jovem_aprendiz", "render_value"=>function($row_data, $value){
                return $value ? number_format($value, 2, ',', '.') : number_format(0, 2, ',', '.');
            }],
            ["field_out"=>"informativo", "from"=>"informativo", "render_value"=>null]

        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['ccusto_id','lotacao_id','orc_cargo_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_cargo_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['orc_cargo_id'] == $parent_data['orc_cargo_id']);
                                return ($lotacao && $ccusto);
                        }
            ]
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
    public function montaTreeTableFerias($data){
        $column_fixeds=[
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }]
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],

            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['cargo_id','ccusto_id','lotacao_id','orc_turma_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'cargo_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_turma_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['cargo_id'] == $parent_data['cargo_id']);
                                return ($lotacao && $ccusto);
                        }
            ]
      ];
      $controller = new AtmTreeTable($settings, $data);
      return $controller->render();
    }
    public function montaTreeTableAumentoSalarial($data){
        $column_fixeds=[
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"turno_id", "from"=>"turno_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return number_format($value, 2,',','.');
            }],

        ];
        $column_fixeds_children = [ 
            /*["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],*/
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],

            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],
            ["field_out"=>"turno_id", "from"=>"turno_id", "render_value"=>null],

            ["field_out"=>"funcionario_id", "from"=>"funcionario_id", "render_value"=>null],
            ["field_out"=>"funcionario", "from"=>"funcionario", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return number_format($value, 4,',','.');
            }]
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['ccusto_id','lotacao_id','orc_cargo_id','orc_turma_id','funcionario_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_cargo_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_turma_id'=>function($value){
                                return !is_null($value);
                            },
                            'funcionario_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['cargo_atual_id'] == $parent_data['cargo_atual_id']);
                                return ($lotacao && $ccusto);
                        }
            ]
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
    public function montaTreeTablePromocao($data){
        $column_fixeds=[
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],
            ["field_out"=>"cargo_atual_id", "from"=>"cargo_atual_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"turma_atual_id", "from"=>"turma_atual_id", "render_value"=>null],
            ["field_out"=>"quantidade", "from"=>"total_qtd", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],
            ["field_out"=>"mes_promocao", "render_value"=>function(){ return "-";},],
            ["field_out"=>"funcionario_id", "from"=>"funcionario_id", "render_value"=>null,]

        ];
        $column_fixeds_children = [ 
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"cargo_destino", "from"=>"cargo_destino", "render_value"=>null],
            ["field_out"=>"cargo_atual_id", "from"=>"cargo_atual_id", "render_value"=>null],

            ["field_out"=>"turma_atual_id", "from"=>"turma_atual_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],
            ["field_out"=>"turma_destino", "from"=>"turma_destino", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"lotacao_destino", "from"=>"lotacao_destino","render_value"=>null],
            ["field_out"=>"centro_custo_destino", "from"=>"centro_custo_destino", "render_value"=>null],

            ["field_out"=>"quantidade", "from"=>"qtd", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"mes_promocao", "from"=>"mes_promocao", "render_value"=>null,],
            ["field_out"=>"funcionario_id", "from"=>"funcionario_id", "render_value"=>null,],
            ["field_out"=>"funcionario", "from"=>"funcionario", "render_value"=>null,]

        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['ccusto_id','lotacao_id','cargo_atual_id','turma_atual_id','cargo_promovido_id', 'turma_promovida_id', 'lotacao_promovida_id', 'ccusto_promovido_id','funcionario_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'cargo_atual_id'=>function($value){
                                return !is_null($value);
                            },
                            'turma_atual_id'=>function($value){
                                return !is_null($value);
                            },
                            'cargo_promovido_id'=>function($value){
                                return !is_null($value);
                            },
                            'turma_promovida_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_promovida_id'=>function($value){
                                return !is_null($value);
                            },
                            'ccusto_promovido_id'=>function($value){
                                return !is_null($value);
                            },
                            'funcionario_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['cargo_atual_id'] == $parent_data['cargo_atual_id']);
                                return ($ccusto && $lotacao);
                        }
            ]
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
    public function montaTreeTable($data){
        
        $column_fixeds=[
            ["field_out"=>"id", "from"=>"id", "render_value"=>null],
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"turno_id", "from"=>"turno_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"turno_id", "from"=>"turno_id", "render_value"=>null],

            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['ccusto_id','lotacao_id','orc_cargo_id','orc_turma_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_cargo_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_turma_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['orc_cargo_id'] == $parent_data['orc_cargo_id']);
                                return ($ccusto && $lotacao);
                        }
            ]
      ];
      $controller = new AtmTreeTable($settings, $data);
      return $controller->render();
    }

    public function montaTreeTableIndividual($data){
        
        $column_fixeds=[
            ["field_out"=>"id", "from"=>"id", "render_value"=>null],
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"mes", "from"=>"mes", "render_value"=>null],
            ["field_out"=>"acordo", "from"=>"acordo", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"funcionario", "from"=>"funcionario", "render_value"=>null],
            ["field_out"=>"func_id", "from"=>"func_id", "render_value"=>null]
        ];
        $settings=["columns"=>$column_fixeds,
                "keys"=>['id' ] 
        ];
      
      $controller = new AtmTreeTable($settings, $data);
      return $controller->render();
    }

    public function montaTreeTableHoraExtra($data){
        
        $column_fixeds = [
            ["field_out"=>"id", "from"=>"id", "render_value"=>null],
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }]
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],
            ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null],
            ["field_out"=>"evento", "from"=>"evento", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return number_format($value, 2, ',', '.');
            }],
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccusto_id'=>function($value){
        //         return !is_null($value);
        //     },
        //     'lotacao_id'=>function($value){
        //         return !is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['ccusto_id','lotacao_id','orc_cargo_id','orc_turma_id','evento_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_cargo_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_turma_id'=>function($value){
                                return !is_null($value);
                            },
                            'evento_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['orc_cargo_id'] == $parent_data['orc_cargo_id']);
                                return ($lotacao && $ccusto);
                        }
            ]
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }

    public function montaTreeTableContratacao($data){
        
        $column_fixeds = [
            ["field_out"=>"id", "from"=>"id", "render_value"=>null],
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }]
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],

            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],
            ["field_out"=>"evento_id", "from"=>"evento_id", "render_value"=>null],
            ["field_out"=>"evento", "from"=>"evento", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return number_format($value, 0, ',', '.');
            }],
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccusto_id'=>function($value){
        //         return !is_null($value);
        //     },
        //     'lotacao_id'=>function($value){
        //         return !is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['ccusto_id','lotacao_id','orc_cargo_id','orc_turma_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_cargo_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_turma_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['orc_cargo_id'] == $parent_data['orc_cargo_id']);
                                return ($lotacao && $ccusto);
                        }
            ]
        ];
        $controller = new AtmTreeTable($settings, $data);
        return $controller->render();
    }
    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioDemissoes',['func_id','lotacao_id','turno_id','ccusto_id','orc_cargo_id','cargo_atual_id','orc_turma_id','cargo_atual_id','turma_atual_id','orc_cargo_id','periodo']);
    }//['orc_cargo_id','cargo_atual_id','orc_turma_id','cargo_atual_id','turma_atual_id','orc_cargo_id']
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            
            $colunas[$i] = str_replace("lotacao", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("centro custo", "Centro de Custo", $colunas[$i]);
            $colunas[$i] = str_replace("pcd realizado", "PCD Realizado", $colunas[$i]);
        }
        return $colunas;
    }
    public function downloadExcelDemissoesIndividual($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioDemissoesIndividual',['func_id','lotacao_id','turno_id','ccusto_id','orc_cargo_id','cargo_atual_id','orc_turma_id','cargo_atual_id','turma_atual_id','orc_cargo_id','periodo']);
    }
    public function downloadExcelContratacoes($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioContratacao',['evento_id','evento','orc_cargo_id','lotacao_id','ccusto_id','orc_turma_id','periodo']);
    }
    public function downloadExcelPromocoes($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioPromocoes',['funcionario_id', 'orc_cargo_id','lotacao_id','ccusto_id','cargo_atual_id','turma_atual_id','periodo']);
    }
    public function downloadExcelAumentoSalarial($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioAumentoSalarialSintetico',['funcionario_id','orc_cargo_id','lotacao_id','ccusto_id','orc_turma_id','periodo','turno_id']);
    }
    public function downloadExcelAumentoSalarialAnalitico($type, $orc_id, $fieldsDeleteModel = []){
        $aumento_salarial = new RepoRelatorioAumentoSalarial();
        $this->dados = $aumento_salarial->listarAumentoSalarialAnalitico($orc_id);
        return parent::downloadExcel($type, 'RelatorioAumentoSalarialAnalitico',['orc_cargo_id','lotacao_id','ccusto_id','orc_turma_id','periodo','turno_id']);
    }
    public function downloadExcelHoraExtra($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioHoraExtra',['evento_id','lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id','periodo']);
    }
    public function downloadExcelFeriasTurma($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioFeriasTurma',['lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id','periodo']);
    }
    public function downloadExcelFeriasFuncionario($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioFeriasFuncionario',['func_id','lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id','periodo']);
    }
    public function downloadExcelHeadcount($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, $filename,['lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id','Fcst_dez','periodo']);
    }
    public function downloadExcelPCD($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, $filename,[]);
    }
    public function downloadExcelJA($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, $filename,[]);
    }
    /* ========== FORECAST ===========*/
    public function downloadExcelDemissoesForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioDemissoesForecast',['lotacao_id','turno_id','ccusto_id','orc_cargo_id','cargo_atual_id','orc_turma_id','cargo_atual_id','turma_atual_id','orc_cargo_id']);
    }
    public function downloadExcelDemissoesForecastIndividual($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioDemissoesForecastIndividual',['lotacao_id','turno_id','ccusto_id','orc_cargo_id','cargo_atual_id','orc_turma_id','cargo_atual_id','turma_atual_id','orc_cargo_id','func_id']);
    }
    public function downloadExcelContratacoesForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioContratacaoForecast',['evento_id','evento','orc_cargo_id','lotacao_id','ccusto_id','orc_turma_id']);
    }
    public function downloadExcelPromocoesForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioPromocoesForecast',['funcionario_id','orc_cargo_id','lotacao_id','ccusto_id','cargo_atual_id','turma_atual_id']);
    }
    public function downloadExcelAumentoSalarialForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioAumentoSalarialForecast',['orc_cargo_id','lotacao_id','ccusto_id','orc_turma_id']);
    }
    public function downloadExcelFeriasTurmaForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioFeriasTurmaForecast',['lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id']);
    }
    public function downloadExcelFeriasFuncionarioForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioFeriasFuncionarioForecast',['func_id','lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id']);
    }
    public function downloadExcelHoraExtraForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioHoraExtraForecast',['evento_id','lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id']);
    }
    public function downloadExcelHeadcountForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'RelatorioHeadcountForecast',['lotacao_id','ccusto_id','orc_cargo_id','orc_turma_id','Fcst_dez']);
    }


    public function montaTreeTableFeriasFuncionario($data){
        $column_fixeds=[
            ["field_out"=>"lotacao", "from"=>"lotacao","render_value"=>null],
            ["field_out"=>"centro_custo", "from"=>"centro_custo", "render_value"=>null],

            ["field_out"=>"func_id", "from"=>"func_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],

            ["field_out"=>"total_count", "from"=>"total_count", "render_value"=>null],
            ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
                return intval($value,10);//$row_data['qtd_func_'].'/'.
            }],
            // ["field_out"=>"janeiro", "from"=>"total_jan", "render_value"=>function($row_data, $value){
            //     return intval($value) == 0 ? '0' : intval($value);
            // }],
            ["field_out"=>"fevereiro", "from"=>"total_fev", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"total_mar", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"total_abr", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"total_mai", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"total_jun", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"total_jul", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"total_ago", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"total_set", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"total_out", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"total_nov", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"total_dez", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],
        ];
        $column_fixeds_children = [ 
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null],

            ["field_out"=>"funcionario", "from"=>"funcionario", "render_value"=>null],
            ["field_out"=>"func_id", "from"=>"func_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>function($row_data, $value){
                return $value != null ? formataData($value) : '-';
            }],

            ["field_out"=>"janeiro", "from"=>"janeiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"fevereiro", "from"=>"fevereiro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"março", "from"=>"março", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"abril", "from"=>"abril", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"maio", "from"=>"maio", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"junho", "from"=>"junho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"julho", "from"=>"julho", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"agosto", "from"=>"agosto", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],

            ["field_out"=>"setembro", "from"=>"setembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"outubro", "from"=>"outubro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"novembro", "from"=>"novembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
            ["field_out"=>"dezembro", "from"=>"dezembro", "render_value"=>function($row_data, $value){
                return intval($value) == 0 ? '0' : intval($value);
            }],
        ];
        $settings = ["columns"=>$column_fixeds,
        "keys"=>['ccusto_id','lotacao_id'],
        // "filter_data"=>[
        //     'ccontabil_id'=>function($value){
        //         return is_null($value);
        //     }
        // ],
        "children" => ["columns"=>$column_fixeds_children,
                        "keys"=>['cargo_id','ccusto_id','lotacao_id','func_id','orc_turma_id'],
                        "filter_data"=>[
                            'ccusto_id'=>function($value){
                                return !is_null($value);
                            },
                            'lotacao_id'=>function($value){
                                return !is_null($value);
                            },
                            'cargo_id'=>function($value){
                                return !is_null($value);
                            },
                            'func_id'=>function($value){
                                return !is_null($value);
                            },
                            'orc_turma_id'=>function($value){
                                return !is_null($value);
                            }
                        ],
                        'parent_filter'=> function($value, $parent_data){
                                $lotacao = ( $value['lotacao_id'] == $parent_data['lotacao_id']);
                                $ccusto = ( $value['ccusto_id'] == $parent_data['ccusto_id']);
                                //$cargo = ( $value['cargo_id'] == $parent_data['cargo_id']);
                                return ($lotacao && $ccusto);
                        }
            ]
      ];
      $controller = new AtmTreeTable($settings, $data);
      return $controller->render();
    }
}
