<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoTurma as RepoTurma;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;

class TurmaController extends Natureza51Ctrl
{
     public function __construct(){
        $this->setCodTela('TM');
        $this->repository=new RepoTurma();
        parent::__construct();
    }
    public function listaTurmaTurno(){
        return $this->getRepository()->listaTurmaTurno();
    }
    public function listGroupTurma(){
        return $this->getRepository()->listGroupTurma();
    }
    public function listOrcTurma($orc_id){        
        return $this->getRepository()->listOrcTurma($orc_id);
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $data = $this->getRepositoryOrModel()->listaTurmas();

        for ($i=0; $i < count($data) ; $i++) { 
            $data[$i]->des_ativo = $data[$i]->ativo == 1 ? 'Sim' : 'Não';
            $data[$i]->des_origem = $data[$i]->origem == 0 ? 'ERP' : 'Sistema';
            $data[$i]->adic_noturno = number_format ($data[$i]->adic_noturno, 4, '.', ',');
            $data[$i]->extra_noturno = number_format ($data[$i]->extra_noturno, 4, '.', ',');
            $data[$i]->adic_noturno_ext = number_format ($data[$i]->adic_noturno_ext, 4, '.', ',');
            $data_aux = (array)$data[$i];
            $des_data = !is_null($data[$i]->created_at) ? $this->formataData($data_aux, 'created_at') : '-';
            $data[$i]->created_at = $des_data;
            $des_data_up = !is_null($data[$i]->updated_at) ? $this->formataData($data_aux, 'updated_at') : '-';
            $data[$i]->updated_at = $des_data_up;

            $data[$i]->created_by = !is_null($data[$i]->created_by) ? $this->getNomeByUsuario($data_aux['created_by']) : '-';
            $data[$i]->updated_by = !is_null($data[$i]->updated_by) ? $this->getNomeByUsuario($data_aux['updated_by']) : '-';
            $data[$i]->des_tip_horario_turno = ($data[$i]->des_tip_horario_turno) == null ? ' - ' :   $data[$i]->des_tip_horario_turno;


        } 


            // $record['created_by_nome'] = $this->getNomeByUsuario($record['created_by']);
            // $record['updated_by_nome'] = $this->getNomeByUsuario($record['updated_by']);
            // $record['description_created_at'] = $record['created_at'] != null ? $this->formataData($record, 'created_at') : '-';
            // $record['description_updated_at'] = $record['updated_at'] != null ? $this->formataData($record, 'updated_at') : '-';

       
        return new Response(json_encode($data), 200);
    }
    // public function insert(Request $request){
    //     $data_envio=$request->all();
    //     dd("aquiiii", $request);
    //     return 'nada';
    // }
  




    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Turmas', ['des_evento_ext','des_evento_adc','des_turno_trab','cdn_turno_trab','description','tip_horario_turno','id', 'empresa_id', 'turno_id', 'cdn_event_adc', 'cdn_event_ext','evento_adc_id', 'evento_ext_id', 'user_id', 'ativo', 'origem']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 

            $colunas[$i] = str_replace("created_by", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("created_at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated_by", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("updated_at", "Atualizado em", $colunas[$i]);

            $colunas[$i] = str_replace("cdn_turma_trab", "Código turma trab.", $colunas[$i]);
            $colunas[$i] = str_replace("des_turma_trab", "Descrição turma", $colunas[$i]);

            $colunas[$i] = str_replace("med_dias_trab", "Média dias trab.", $colunas[$i]);

            $colunas[$i] = str_replace("adic_noturno", "Adicional noturno", $colunas[$i]);
            $colunas[$i] = str_replace("adic_noturno", "Extra noturno", $colunas[$i]);

            $colunas[$i] = str_replace("adic_noturno_ext", "Adicional noturno extra", $colunas[$i]);
            $colunas[$i] = str_replace("des_ativo", "Ativo", $colunas[$i]);
            $colunas[$i] = str_replace("des_origem", "Origem", $colunas[$i]);
            $colunas[$i] = str_replace("extra_noturno", "Extra noturno", $colunas[$i]);

            // $colunas[$i] = str_replace("des_evento_adc", "Evento adicional", $colunas[$i]);
            // $colunas[$i] = str_replace("des_evento_ext", "Evento extra", $colunas[$i]);

            $colunas[$i] = str_replace("des_tip_horario_turno", "Tipo de turno", $colunas[$i]);
            $colunas[$i] = str_replace("description_turno", "Turno", $colunas[$i]);
            $colunas[$i] = str_replace("description_evento_ext", "Evento extra", $colunas[$i]);
            $colunas[$i] = str_replace("description_evento_adc", "Evento adicional", $colunas[$i]);


            // $colunas[$i] = str_replace("_", " ", $colunas[$i]);
        }
        return $colunas;
    }
    
    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }  
}