<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoTurmaEvento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\Turma;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;

class TurmaEventoController extends Natureza51Ctrl
{ 
     public function __construct(){
        $this->setCodTela('TMEVT');
        $this->repository=new RepoTurmaEvento();
        parent::__construct();
    }
 
    public function listar(){
      

    //   $data = $this->getRepositoryOrModel()->all()-toArray();
        $data =   $this->getRepository()->listar();
        $data = json_decode(json_encode($data), true);
        // dd('dbshdbhsadbhsa', $data);
        $dados = [];
        foreach ($data as $record) {
            $record['created_by_nome'] = $record['created_by'] != null ? $this->getNomeByUsuario($record['created_by']): ' - ';
            $record['updated_by_nome'] = $record['updated_by'] != null ? $this->getNomeByUsuario($record['updated_by']): ' - ';
            $record['description_created_at'] = $record['created_at'] != null ? $this->formataData($record, 'created_at') : '-';
            $record['description_updated_at'] = $record['updated_at'] != null ? $this->formataData($record, 'updated_at') : '-';

            array_push($dados, $record);
        }

        return new Response(json_encode($dados), 200);
    }



    

    public function insert(Request $request){        
        $dados_turma = new Turma();
        $dados = $request->all();
        $dados['user_id'] = $this->obtIdUsuario();
        $turno_id = $dados_turma->select("turno_id")->where("id",$dados['turma_id'] )->get()->toArray();
        $dados["turno_id"] = $turno_id[0]['turno_id'];
        $resp = $this->getRepository()->inserir($dados);
        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Erro!';
            goto saida;
        }
        $retorno['status'] = 'success';
        $retorno['msg'] = "Registro inserido com sucesso";
        $retorno['submsg'] = 'Sucesso!';
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    // public function insert(Request $request){
    //     $this->podeAcessar('inserir',true,$this->getCodTela());
    //     $retorno = $this->getArrayRetornoDefault();
    //     $form_data = $request->all();
    //     $form_data['user_id'] = $this->obtIdUsuario();
    //     if(! $this->getRepositoryOrModel()->create($form_data)){
    //         $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
    //         $retorno['submsg']='Falha ao inserir o registro. Erro: 220820191723';
    //         goto saida;
    //     }
    //         $retorno['msg']='Registro inserido com sucesso!';
    //         $retorno['submsg']='Sucesso';
    //         $retorno['status']='success';
    //     saida:
    //      return $this->retornoJsonDefault($retorno); 
    // }




    public function update(Request $request){  
        $this->podeAcessar('editar',true,$this->getCodTela());
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $form_data = $request->all();  
        $meses = $form_data['meses'];
        unset($form_data['meses']);
        unset($form_data['_token']);
          
        $id=$form_data['id'];
        unset($form_data['id']);
      
        if(!$repo_calc_orcamento->update($meses,['origem_id'=>$id,'tbl_origem'=>$this->getRepository()->getModelEntity()->getTable()])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 250820202025';
                goto saida;               
        } 

        if(!$this->getRepository()->update($form_data, ['id'=>$id])){                  
            $retorno["status"]="error";
            $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 250820202026';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    }     

    public function delete(Request $request){  
        // $this->setCodTela('CONT');
        
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $form_data = $request->all();    
       
        $calcOrcamento = $repo_calc_orcamento->getModelInstance()->where('id',$form_data['calc_orc_id'])->first();
        
        if(!$calcOrcamento->delete()){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191601';
                goto saida;               
        } 

        if(!$this->getRepository()->delete($form_data['id'])){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191602';
            goto saida;               
        }        
               
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 
    

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Turmas X Eventos', ['qtd_hrs', 'empresa_id','evento_id','id','turma_id', 'turno_id', 'calc_orc_id', 'created', 'updated']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);

            $colunas[$i] = str_replace("descricao evento", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("descricao turma", "Turma", $colunas[$i]);
            $colunas[$i] = str_replace("descricao turno", "Turno", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);

            
            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);

        }
        return $colunas;
    }

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }   
} 