<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoTurno as RepoTurno;
use Illuminate\Http\Response;

class TurnoController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('TN');
        $this->repository=new RepoTurno();
        parent::__construct();
    }  

    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $data = $this->getRepositoryOrModel()->all();
        foreach ($data as $dt) {
            $dt['des_ativo'] = $dt['ativo'] == 1 ? 'Sim' : 'Não';
            $dt['des_origem'] = $dt['origem'] == 1 ? 'Sistema' : 'ERP';

            if($dt['tip_horario_turno'] == 1){
                $dt['tipo_horario'] = 'Adminitrativo';
            }
            else if($dt['tip_horario_turno'] == 2){
                $dt['tipo_horario'] = 'Fixo';
            }
            else if($dt['tip_horario_turno'] == 3){
                $dt['tipo_horario'] = 'Revezamento';
            }
            else{
                $dt['tipo_horario'] = NULL;
            }


            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            $dt['description_turno'] = $dt['cdn_turno_trab'] . ' - '. $dt['des_turno_trab'] ;

        }
       return new Response(json_encode($data), 200);
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Turnos', ['ativo', 'origem', 'tip_horario_turno','med_dias_trab','tipo_horario','description_turno']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cdn turno trab", "Código", $colunas[$i]);
            $colunas[$i] = str_replace("des turno trab", "Descrição", $colunas[$i]);
            $colunas[$i] = str_replace("des ativo", "Ativo", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
            $colunas[$i] = str_replace("des origem", "Origem", $colunas[$i]);


        }
        return $colunas;
    }

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }   
    
}