<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoUsuario as RepoUsuario;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class UsuarioController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('USU');
        $this->repository=new RepoUsuario();
        parent::__construct();
    } 
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());

        $data = $this->getRepository()->listar();
        
        $retorno = [];

        foreach ($data as $dt) {

            $dt['created_by_nome'] = $dt['criado_por']; // != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['atualizado_por'];// $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['criado_em'];// $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['atualizado_em'];// $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($retorno, $dt);

            }
            // dd("data", $data);

            return new Response(json_encode($retorno) , 200);
        // return $this->getRepository()->listar();
    } 

    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $retorno=$this->getArrayRetornoDefault();
        $form_data=$request->all();
    

        
        // dd(is_null($form_data['data_validade']), Carbon::now()->addCentury()->format('Ymd H:i:s'));
        // $form_data['senha'] =  Hash::make($this->getRepository()->getModelEntity()->getDefaultPassword());
        $form_data['senha'] =  safeEncrypt($this->getRepository()->getPassord($form_data['funcionario_id']));
        $form_data['data_validade'] = !is_null($form_data['data_validade']) ? $form_data['data_validade'] : Carbon::now()->addCentury()->format('Ymd H:i:s');
        // $form_data['tipo'] = 4; //Tipo padrão é usuário comum(4)
        $form_data['status'] = 1; //Tipo padrão é usuário comum
        $form_data['id_empresa'] = $this->fillCodEmpresa();
        
    //    dd($form_data);
        if(! $this->getRepositoryOrModel()->create($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 220820191723';
            goto saida;
        }
            $retorno['msg']='Registro inserido com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';
        
        saida:
         return $this->retornoJsonDefault($retorno); 
    }
    
    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Usuarios', ['status', 'funcionario_id','id_grupo_empresarial','id_empresa',
                                                        'id_permissao', 'id_grupo_acesso','id_filial','id_grupo','senha', 
                                                        'data_validade','data_alt_senha', 'tipo' ]);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("num reg func", "matricula", $colunas[$i]);
            $colunas[$i] = str_replace("Usuario", "tipo", $colunas[$i]);
        }
        return $colunas;
    }

    public function alteraSenha(){
        
        
        $existe = DB::select("SELECT cpf, u.id from institb_usuario as u
            inner join tbl_funcionario as f on f.id = u.funcionario_id"
        );
        $cont = 0;
        if(count($existe) > 0){
            foreach($existe as $value){
                try{
                    $resultado = DB::update("UPDATE institb_usuario set senha = ? where id = $value->id", [safeEncrypt($value->cpf)]);
                    if($resultado !== false){
                        $cont++;
                    }
                }
                catch(\Exception $e){
                    return $this->retornoJsonDefault(array('submsg'=>'Erro', 'msg'=>'CT. '.$e->getMessage(), 'status'=>'error'));
                }
            }
            if(count($existe) == $cont){
                return $this->retornoJsonDefault(array('submsg'=>'Sucesso!', 'msg'=>'Senha redefinida com sucesso!', 'status'=>'success'));
            }
        }
        return $this->retornoJsonDefault(array('submsg'=>'Erro', 'msg'=>'Falha ao atualizar senhas', 'status'=>'error'));
    }
}