<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoAjustesSalariais as RepoAjustesSalariais;
use App\Modules\Natureza51\Repositories\RepoLotacaoCCusto as RepoLotacaoCCusto;
use App\Modules\Natureza51\Repositories\RepoCargoArea as RepoCargoArea;
use App\Modules\Natureza51\Entities\CargosArea;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcLotacao;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Excel;

class CargoAreaController extends Natureza51Ctrl
{
     public function __construct(){
        $this->setCodTela('CL');
        $this->repository=new RepoCargoArea();
        parent::__construct();
    }

    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $tb_cargo_area = new CargosArea(); 
        $tb_cargo = new Cargo();
        $tb_centroCusto = new CentroCusto();
        $tb_lotacao = new Lotacao();

        $data = $tb_cargo_area->join($tb_cargo->getTable(),$tb_cargo_area->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))
                                ->join($tb_lotacao->getTable(),$tb_cargo_area->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))
                                ->join($tb_centroCusto->getTable(),$tb_cargo_area->getColunaAlias('ccusto_id'), $tb_centroCusto->getColunaAlias('id'))
                                ->select(  $tb_cargo_area->getColunaAlias('id'),   
                                            DB::raw("{$tb_centroCusto->getColunaAlias('id')} as ccusto_id"),  
                                            DB::raw("{$tb_centroCusto->getColunaAlias('des_ccusto')} as des_ccusto"),
                                            DB::raw("{$tb_centroCusto->getColunaAlias('cod_ccusto')} as cod_ccusto"),
                                            DB::raw("{$tb_lotacao->getColunaAlias('id')} as lotacao_id"),                          
                                            DB::raw("CONCAT({$tb_lotacao->getColunaAlias('unid_lotac')}, ' - ', 
                                                {$tb_lotacao->getColunaAlias('des_unid_lotac')}) AS unid_lotac"),
                                            DB::raw("CONCAT({$tb_cargo->getColunaAlias('cod_cargo_basic')}, ' - ', 
                                                {$tb_cargo->getColunaAlias('des_cargo_basic')}) AS cargo"),
                                            DB::raw("{$tb_cargo->getColunaAlias('cod_cargo_basic')} as cod_cargo"),
                                            DB::raw("{$tb_cargo->getColunaAlias('des_cargo_basic')} as des_cargo"),
                                            $tb_cargo_area->getColunaAlias('created_at'),   
                                            $tb_cargo_area->getColunaAlias('created_by'),   
                                            $tb_cargo_area->getColunaAlias('updated_at'),   
                                            $tb_cargo_area->getColunaAlias('updated_by'),   
                                            DB::raw("IIF({$tb_cargo->getColunaAlias('periculosidade')} = 1, 'Sim', 'Não') as periculosidade_"),
                                            DB::raw("IIF({$tb_cargo->getColunaAlias('insalubridade')} = 1, 'Sim', 'Não') as insalubridade_"),
                                            DB::raw("CONCAT({$tb_centroCusto->getColunaAlias('cod_ccusto')}, ' - ', 
                                            {$tb_centroCusto->getColunaAlias('des_ccusto')}) AS cod_des_ccusto")

                                            )
                                     ->orderBy($tb_lotacao->getColunaAlias('unid_lotac'))
                                     ->get();


        // dd("data", $data);
        foreach ($data as $dt) {
        
        $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
        $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
        $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
        $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
        }
         
        return new Response(json_encode($data) , 200);
    }

    public function listarCargosLotacaoSeleted($id_lotac, $id_ccusto){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $tb_cargo_area = new CargosArea();
        $tb_cargo = new Cargo();
        $tb_lotacao = new Lotacao();

        $data = $tb_cargo_area->join($tb_cargo->getTable(),$tb_cargo_area->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))
                                ->where($tb_cargo_area->getColunaAlias('lotacao_id'), $id_lotac)
                                ->where($tb_cargo_area->getColunaAlias('ccusto_id'), $id_ccusto)
                                ->select($tb_cargo->getColunaAlias('id'), $tb_cargo->getColunaAlias('cod_cargo_basic'), $tb_cargo->getColunaAlias('des_cargo_basic'),
                                $tb_cargo_area->getColunaAlias('insalubridade'),$tb_cargo_area->getColunaAlias('periculosidade') )
                                     ->get();
         
        return new Response(json_encode($data) , 200);
    }

    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $data = $request->all();
 
        $retorno=$this->getArrayRetornoDefault();
        $hasErro = false;


        DB::transaction(function()use(&$retorno, &$hasErro, $data){
            $this->getRepository()->getModelEntity()->where('lotacao_id', $data['lotacao'])->where('ccusto_id', $data['ccusto'])->delete();
            foreach ($data['cargos'] as $cargo) {
                $data_insert = [
                    'cargo_id' => $cargo['id'],
                    'lotacao_id' => $data['lotacao'],
                    'ccusto_id' => $data['ccusto'],
                    'insalubridade' => $cargo['insalubridade'],
                    'periculosidade' => $cargo['periculosidade']
                ];
                if(!$this->getRepository()->create($data_insert)){
                    $hasErro = true;
                    $retorno['msg']=$this->getRepository()->getErrosFlatted();
                    $retorno['submsg']='Falha ao inserir o registro. Erro: 260520201200';
                }
            }           
        });

        if($hasErro){
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);      

    }

    public function getLotacaoID($data){       
        $lotacao = explode(" - ", $data);

        return Lotacao::where('unid_lotac', $lotacao)->value('id');
    }

    public function getCargoID($data){        
        
        return Cargo::select('id')->whereIn('cod_cargo_basic', $data)->get();
    }
    
   public function listarLotacCc(){
        $repo_lotacao_ccusto = new RepoLotacaoCCusto;
        if(!$data=$repo_lotacao_ccusto->listarLotacaoCc()){
            $retorno['msg']=$repo_lotacao_ccusto->getErrosFlatted();
            $retorno['submsg']='Falha ao buscar registro. Erro: 250520202308';
            goto saida;
        }

        return new Response(json_encode($data) , 200);
        saida:
        return $this->retornoJsonDefault($retorno);      

    }
    
   public function listarLotacCcSelected($lotacao_id,$ccusto_id){
        $repo_lotacao_ccusto = new RepoLotacaoCCusto;
        if(!$data=$repo_lotacao_ccusto->listarLotacaoCc($lotacao_id,$ccusto_id)){
            $retorno['msg']=$repo_lotacao_ccusto->getErrosFlatted();
            $retorno['submsg']='Falha ao buscar registro. Erro: 260520201248';
            goto saida;
        }

        return new Response(json_encode($data) , 200);
        saida:
        return $this->retornoJsonDefault($retorno);      

    }    

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
       
        return parent::downloadExcel($type, 'Cargos X Lotação X C custo',['description_updated_at','updated_by_nome','des_ccusto','cod_cargo', 'des_cargo', 'ccusto_id', 'lotacao_id', 'centro_de_custo', 'cod_ccusto']);
    }
    
    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
    //         dd(json_decode($_POST['array_imprimir']));
            $colunas[$i] = str_replace("cod_des_ccusto", "Centro de custo", $colunas[$i]);
            $colunas[$i] = str_replace("unid_lotac", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("periculosidade", "Periculosidade", $colunas[$i]);
            $colunas[$i] = str_replace("insalubridade", "Insalubridade", $colunas[$i]);
            $colunas[$i] = str_replace("created_by_nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description_created_at", "Criado em", $colunas[$i]);

            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
        }
        return $colunas;
    }


}