<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcFuncionario;


class RepoAumentosSalariaisForecast extends RepositoryNat51
{
     protected $model_name_space='App\Modules\Natureza51\Entities\OrcSalarioFuncionario';
     protected $form_rules=[];
     protected $rules_msg=[]; 
      
     public function createOrcLotFuncionario(array $dados){
        
        // $tbl_calc_orc = new CalcOrcamento();
        // $tbl_calc_ind = new CalcIndice();
        
        
        $salario_funcionario = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orc_id'),'=',$dados['orc_id']],
            [$this->getModelEntity()->getColunaAlias('funcionario_id'),'=',$dados['funcionario_id']],
            [$this->getModelEntity()->getColunaAlias('orc_cargo_id'),'=',$dados['orc_cargo_id']],
            [$this->getModelEntity()->getColunaAlias('orc_turma_id'),'=',$dados['orc_turma_id']],
            [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$dados['lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'),'=',$dados['tipo_table']],
            [$this->getModelEntity()->getColunaAlias('periodo'),'=',$dados['periodo']]

        ])->get()->toArray();
        
        if(count($salario_funcionario) > 0){
            $this->setError("Registro já existente!");
            return false;
        }
        
        else{
              
            if(!$this->insereCalcFuncionarioSalario($dados)){
                $this->setError('Não foi possível inserir o registro. Erro: 160920200958');
                return false;
            }
            return true;
        }
        
        saida:
        $retorno['status'] = "success";
        $retorno['msg'] = 'Sucesso';
        $retorno['submsg'] = 'Inserido com sucesso';

        return $retorno;
      }

      public function insereCalcFuncionarioSalario(array $form_data){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $orc_sal_func = new OrcSalarioFuncionario();

        //$orc_func = new OrcFuncionario();
        DB::beginTransaction();
        try{

        
            /*=============== ver se vai precisar desse código no forecast =============*/
            $func = OrcFuncionario::where('orcamento_id',$form_data['orc_id'])
            ->where('funcionario_id',$form_data['funcionario_id'])
            ->where('tipo_table', $form_data['tipo_table'])
            ->where('periodo', $form_data['periodo'])
            ->first();

            if($func){
                if($func->cargo_atualizado == 0){
                    $func->orc_cargo_id = $form_data['orc_cargo_id'];
                    $func->orc_turma_id = $form_data['orc_turma_id'];
                    $func->cargo_atualizado = 1;
                    $func->updated_by = $this->fillModificadoPor();
                    $func->updated_at = $this->fillModificadoEm();
                    
                    $func->save();
                }
            }

            $id_orc_sal_func = $this->create($form_data);
            if(! $id_orc_sal_func){
                $this->setError('Falha ao inserir o registro. Erro: 160920201000');
                return false;
            }

            $meses_calc_orcamento = Arr::only($form_data['meses_orcado'], ['jan_orcado', 'fev_orcado', 'mar_orcado', 'abr_orcado', 'mai_orcado', 'jun_orcado', 'jul_orcado', 'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado']); 
                
            $merge_tb_calc = [
                'origem_id' => $id_orc_sal_func->id,
                'tbl_origem' => $orc_sal_func->getTable()
            ];
            
            if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses_calc_orcamento))){
                $this->setError('Falha ao inserir o registro. Erro: 160920201001');
                return false;
            }
            DB::commit();
            return true;
        }
        catch(\Exception $e){
            DB::rollBack();
            $this->setError('Falha. '.$e);
            return false;
        }
        return true;
    }

      public function createOrcSalarioFuncionarioInidice(array $dados){
          $this->clearError();
  
          $tb_calc_indice=new CalcIndice();
          
          //dd($dados);

          $dados_env=Arr::only($dados,['orc_id','funcionario_id','orc_cargo_id','lotacao_responsavel_id']);
          
          DB::beginTransaction();
          try{
              $salvou = $this->create($dados_env);

              if(!$salvou){
                  return false;
              }
              //dd($salvou);
              $dados_indice=array(
              'origem_id'=>$salvou->id,
              'tbl_origem'=>$this->getModelEntity()->getTable(),
              'jan_indice'=>$dados['jan_orcado'],
              'fev_indice'=>$dados['fev_orcado'],
              'marc_indice'=>$dados['mar_orcado'],
              'abril_indice'=>$dados['abr_orcado'],
              'maio_indice'=>$dados['mai_orcado'],
              'jun_indice'=>$dados['jun_orcado'],
              'jul_indice'=>$dados['jul_orcado'],
              'agost_indice'=>$dados['ago_orcado'],
              'set_indice'=>$dados['set_orcado'],
              'out_indice'=>$dados['out_orcado'],
              'nov_indice'=>$dados['nov_orcado'],
              'dez_indice'=>$dados['dez_orcado'],
          );
              //dd($dados_indice);
              $salvar_indice=$tb_calc_indice->create($dados_indice);
               
              if(!$salvar_indice){
                  $this->setError('Falha ao inserir indices. Erro: 010420201109');
                  DB::rollBack();
                  return false;
              }
              
              DB::commit();
              
          } catch (Exception $ex) {
               DB::rollBack();
               abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 010420201109.'.$ex);
         }
         return true;
      }

      public function insereIndice($id,$dados){
        $tbl_calc_indice=new CalcIndice();

        $dados_indice=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['jan_orcado'],
            'fev_indice'=>$dados['fev_orcado'],
            'marc_indice'=>$dados['mar_orcado'],
            'abril_indice'=>$dados['abr_orcado'],
            'maio_indice'=>$dados['mai_orcado'],
            'jun_indice'=>$dados['jun_orcado'],
            'jul_indice'=>$dados['jul_orcado'],
            'agost_indice'=>$dados['ago_orcado'],
            'set_indice'=>$dados['set_orcado'],
            'out_indice'=>$dados['out_orcado'],
            'nov_indice'=>$dados['nov_orcado'],
            'dez_indice'=>$dados['dez_orcado']
        );
        $dados_indice=convertDecimalEn($dados_indice);
        
        if(!$tbl_calc_indice->create($dados_indice)){
            $this->setError('Erro ao inserir índices.');
            return false;
        }
        return true;
    }

      public function insereCalcOrc($id,$data){
        $calc_orcamento = new CalcOrcamento();
       
        
        $orcamento=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_orcado'=>$data['jan_orcado'], 'fev_orcado'=>$data['fev_orcado'],
            'mar_orcado'=>$data['mar_orcado'], 'abr_orcado'=>$data['abr_orcado'], 
            'mai_orcado'=>$data['mai_orcado'], 'jun_orcado'=>$data['jun_orcado'], 
            'jul_orcado'=>$data['jul_orcado'], 'ago_orcado'=>$data['ago_orcado'],
            'set_orcado'=>$data['set_orcado'], 'out_orcado'=>$data['out_orcado'], 
            'nov_orcado'=>$data['nov_orcado'], 'dez_orcado'=>$data['dez_orcado'],
        );
        
       
        
        $inseriu=$calc_orcamento->create($orcamento);
        //dd($inseriu);
        if(!$inseriu)
        {
            $this->setError('Erro ao inserir valores absolutos.');
            return false;
        }
        return true;
      }

      public function listarIndices($orc_id){
        $tbl_calc_indice = new CalcIndice();
        $tbl_orc_sal_func = $this->getModelEntity();
        $tbl_funcionario = new Funcionario();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_cargo = new Cargo();
        $tbl_centro_custo = new CentroCusto();
        
        $dados = $this->getModelEntity()
        ->join($tbl_calc_indice->getTable(), $tbl_orc_sal_func->getColunaAlias('id'), $tbl_calc_indice->getColunaAlias('origem_id'))
        ->join($tbl_funcionario->getTable(), $tbl_orc_sal_func->getColunaAlias('funcionario_id'), $tbl_funcionario->getColunaAlias('id'))
        ->join($tbl_orc_cargo->getTable(), $tbl_orc_sal_func->getColunaAlias('orc_cargo_id'), $tbl_orc_cargo->getColunaAlias('id'))
        ->join($tbl_cargo->getTable(), $tbl_orc_cargo->getColunaAlias('cargo_id'), $tbl_cargo->getColunaAlias('id'))
        ->join($tbl_centro_custo->getTable(), $tbl_funcionario->getColunaAlias('ccusto_id'), $tbl_centro_custo->getColunaAlias('id'))

        ->select(
            DB::raw("{$tbl_orc_sal_func->getColunaAlias('id')} 'orc_sal_func_id'"),
            DB::raw("{$tbl_calc_indice->getColunaAlias('id')} 'calc_indice_id'"),
            $tbl_orc_sal_func->getColunaAlias('orc_id'),
            $tbl_centro_custo->getColunaAlias('cod_ccusto'),
            $tbl_centro_custo->getColunaAlias('des_ccusto'),
            $tbl_funcionario->getColunaAlias('ccusto_id'),
            $tbl_cargo->getColunaAlias('cod_cargo_basic'),
            $tbl_cargo->getColunaAlias('des_cargo_basic'),
            $tbl_orc_cargo->getColunaAlias('cargo_id'),
            $tbl_funcionario->getColunaAlias('cdn_funcionario'),
            $tbl_funcionario->getColunaAlias('nome_funcionario'),
            $tbl_funcionario->getColunaAlias('salario'),
            $tbl_funcionario->getColunaAlias('orc_cargo_id'),

            $tbl_calc_indice->getColunaAlias('jan_indice'),
            $tbl_calc_indice->getColunaAlias('fev_indice'),
            $tbl_calc_indice->getColunaAlias('marc_indice'),
            $tbl_calc_indice->getColunaAlias('abril_indice'),
            $tbl_calc_indice->getColunaAlias('maio_indice'),
            $tbl_calc_indice->getColunaAlias('jun_indice'),
            $tbl_calc_indice->getColunaAlias('jul_indice'),
            $tbl_calc_indice->getColunaAlias('agost_indice'),
            $tbl_calc_indice->getColunaAlias('set_indice'),
            $tbl_calc_indice->getColunaAlias('out_indice'),
            $tbl_calc_indice->getColunaAlias('nov_indice'),
            $tbl_calc_indice->getColunaAlias('dez_indice')
        )

        ->where([
            [$tbl_orc_sal_func->getColunaAlias('orc_id'),'=',$orc_id],
            [$tbl_calc_indice->getColunaAlias('tbl_origem'),'=',$tbl_orc_sal_func->getTable()]
        ])
        ->get()->toArray();

        for($i=0;$i<count($dados);$i++){
            $dados[$i]['identificador']="1";
        }

        return $dados;
      }

    public function updateIndice($form_data){
        $tbl_calc_indice = new RepoCalcIndice();
        $meses = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        $meses = convertDecimalEn($meses);
        
        $id = $form_data['calc_indice_id'];

        $update = $tbl_calc_indice->update($meses,$id);
        if(!$update){
            $this->setError('Erro ao atualizar registro. Erro:030420201427');
            return false;
        }
        return true;
    }

    public function deleteIndices($form_data){
        $repo_calc_ind = new RepoCalcIndice();

        $calc_orcamento = new CalcOrcamento();
        
        $select = $calc_orcamento->select()->where([
            [$calc_orcamento->getColunaAlias('origem_id'),'=',$form_data['orc_sal_func_id']],
            [$calc_orcamento->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        
        if(count($select)>0){
            $indices_excluir = $repo_calc_ind->getModelEntity()->where([
                [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$form_data['orc_sal_func_id']],
                [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->delete();
                
            if(!$indices_excluir){
                $this->setError("Erro ao excluir registro. erro:090420201247");
                return false;
            }
        }
        else{
        
            DB::beginTransaction();
            try {
                if(!$this->delete($form_data['orc_sal_func_id'])){
                    return false;
                }    
                
                if(!$repo_calc_ind->delete($form_data['calc_indice_id'])){
                    return false;
                }    
                
                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 030420201043.'.$e);
                return false;
            }
        }
        return true;
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_cargo_id', 'lotacao_responsavel_id','funcionario_id','salario', 'nome_funcionario', 'cdn_funcionario', 'cargo_id', 
        'des_cargo_basic', 'cod_cargo_basic' ,'ccusto_id', 'des_ccusto', 'cod_ccusto', 'orc_sal_func_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function deleteAll($orc_id){
        try{
            $delete_calc = DB::delete("
                DELETE FROM tbl_calc_orcamento where tbl_origem = 'tbl_orc_salario_funcionario' and origem_id in (
                    SELECT id FROM tbl_orc_salario_funcionario where orc_id = $orc_id
                )
            ");
            if($delete_calc === false){
                $this->setError("Falha ao excluir registros. Erro: 100820201427");
                return false;
            }

            $delete = DB::delete("
                DELETE FROM tbl_orc_salario_funcionario where orc_id = $orc_id
            ");
            if($delete === false){
                $this->setError("Falha ao excluir registros.");
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            $this->setError("Falha ao excluir registros.");
            return false;
        }
        return true;
    }
    public function deleteForecast($dados){
        //$repo_calc_orcamento = new RepoCalcOrcamento();
        
        DB::beginTransaction();

        try {
            $repo = new RepoOrcamento();
            if($repo->deleteDiarioBordo($dados['id'], 'tbl_orc_salario_funcionario') === false){
                $this->setError('Falha ao deletar Diário de Bordo. Erro: 230320211029');
                return false;
            }
            $delete = parent::delete($dados['id']);
            if(!$delete){
                $this->setError('Falha ao deletar o registro. Erro: 160920201123.');
                return false;
            }
        
            $delete_calc = DB::delete('DELETE from tbl_calc_orcamento where id = ? and tbl_origem = ?', [$dados['id_calc'], $this->getModelEntity()->getTable()]);
            if($delete_calc === false){
                $this->setError('Falha ao deletar o registro. Erro: 160920201124.');
                return false;
            }
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            $this->setError('Erro ao deletar registro. Erro: 160920201125.'.$e);
            return false;
        }
        return true;
    }
}  