<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\NaturezaEvento;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoBeneficio extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Beneficio';

   protected $form_rules=[   
                           'evento_id'=>'required',//|unique:tbl_beneficio,evento_id
                           'vlr_movto'=>'required'
                         ];

    protected $rules_msg=[
                          'evento_id.required'=>'O campo Evento é obrigatório',
                          //'evento_id.unique'=>'Evento já foi cadastrado',
                          'vlr_movto.required'=>'O campo Valor Movimento é obrigatório',
                        ];  

    public function update(array $data,$id,$attribute="id"){

        //$this->form_rules['evento_id'].=','.$id;
        
        monetarioVirgula($data['vlr_movto']);
        monetarioVirgula($data['vlr_maximo']);
        monetarioVirgula($data['salario_corte']);
        monetarioVirgula($data['valor_deducao']);

        
        return parent::update($data,$id,$attribute);            
    }
    public function listarAll(){
      $tbl_natureza_eventos = new NaturezaEvento();
      $tbl_evento = new Eventos();
      $tbl_cta = new ContaContabil();
      $tbl_usuario = new Usuario();

      $tbl_beneficio = $this;
      $dados = $this->getModelEntity()
      ->leftJoin($tbl_natureza_eventos->getTable(), $this->getModelEntity()->getColunaAlias('evento_id'), '=', DB::raw("{$tbl_natureza_eventos->getColunaAlias('eventos_id')} and 
      {$this->getModelEntity()->getColunaAlias('cta_ct_id')} = {$tbl_natureza_eventos->getColunaAlias('cta_contabil_id')} "
      ))
     
      //->leftJoin($tbl_evento->getTable(), $tbl_natureza_eventos->getColunaAlias('eventos_id'), $tbl_evento->getColunaAlias('id'))

      ->leftJoin($tbl_evento->getTable(), $tbl_beneficio->getModelEntity()->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))

      //->leftJoin($tbl_cta->getTable(), $tbl_natureza_eventos->getColunaAlias('cta_contabil_id'), $tbl_cta->getColunaAlias('id'))

      ->leftJoin($tbl_cta->getTable(), $tbl_beneficio->getModelEntity()->getColunaAlias('cta_ct_id'), $tbl_cta->getColunaAlias('id'))

      ->leftJoin(
        DB::raw("{$tbl_usuario->getTable()} as usuario1"),
        DB::raw("usuario1.id"),
        DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
      )
      ->leftJoin(
        DB::raw("{$tbl_usuario->getTable()} as usuario2"),
        $this->getModelEntity()->getColunaAlias('updated_by'),
        DB::raw("usuario2.id")
      )

      ->select(
        $tbl_beneficio->getModelEntity()->getColunaAlias('id'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('cta_ct_id'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('evento_id'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('tipo_calc'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('vlr_movto'),

        $tbl_beneficio->getModelEntity()->getColunaAlias('created_at'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('created_by'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('updated_at'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('updated_by'),

        $tbl_beneficio->getModelEntity()->getColunaAlias('exclusivo_admissao'),
        DB::raw("CASE {$tbl_beneficio->getModelEntity()->getColunaAlias('exclusivo_admissao')} 
                WHEN 1 THEN 'Sim'
                WHEN 0 THEN 'Não'
                ELSE '-'
                END as des_exclusivo_admissao"),
        $tbl_beneficio->getModelEntity()->getColunaAlias('ativo'),
        DB::raw("CASE {$tbl_beneficio->getModelEntity()->getColunaAlias('ativo')} 
                WHEN 1 THEN 'Sim'
                WHEN 0 THEN 'Não'
                END as des_ativo"),
        $tbl_beneficio->getModelEntity()->getColunaAlias('vlr_maximo'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('origem_beneficio'),
        DB::raw("CASE {$tbl_beneficio->getModelEntity()->getColunaAlias('origem_beneficio')} 
                WHEN 1 THEN 'Sim'
                WHEN 0 THEN 'Não'
                ELSE '-'
                END as des_origem_beneficio"),
        $tbl_beneficio->getModelEntity()->getColunaAlias('formula'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('empresa_id'),
        $tbl_beneficio->getModelEntity()->getColunaAlias('valor_deducao'),
        // DB::raw("CASE
        //     WHEN {$tbl_beneficio->getModelEntity()->getColunaAlias('grade_maximo')} is null THEN '-'
        //     ELSE {$tbl_beneficio->getModelEntity()->getColunaAlias('grade_maximo')} END as grade_maximo_desc
        // "),
        $tbl_beneficio->getModelEntity()->getColunaAlias('grade_maximo'),
        $tbl_evento->getColunaAlias('cdn_event'),
        $tbl_evento->getColunaAlias('multiplica'),
        $tbl_evento->getColunaAlias('salario_corte'),
        $tbl_evento->getColunaAlias('inc_liquido'),
        $tbl_evento->getColunaAlias('des_event'),
        $tbl_cta->getColunaAlias('cod_cta_ctbl'),
        $tbl_cta->getColunaAlias('desc_cta_ctbl'),
        DB::raw("IIF({$tbl_beneficio->getModelEntity()->getColunaAlias('ativo')} = 1, 'Sim', 'Não') as des_ativo"),
        DB::raw("CASE {$tbl_beneficio->getModelEntity()->getColunaAlias('tipo_calc')} 
                WHEN 1 THEN '1 - Por hora'
                WHEN 2 THEN '2 - Proporcional'
                WHEN 3 THEN '3 - Fixo'
                WHEN 4 THEN '4 - Dias trabalhados'
                END as des_tipo_calc"),
        DB::raw("{$tbl_natureza_eventos->getColunaAlias('id')} as natureza_evento_id"),

        $tbl_beneficio->getModelEntity()->getColunaAlias('tipo_acesso'),

        DB::raw("CASE {$tbl_beneficio->getModelEntity()->getColunaAlias('tipo_acesso')} 
                WHEN 1 THEN '1 - Todos Funcionários'
                WHEN 2 THEN '2 - Por Lotação e Cargo'
                WHEN 3 THEN '3 - Individual'
                END as des_tipo_acesso"),
        
        $tbl_natureza_eventos->getColunaAlias('cdn_event'),

        DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
        DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
        
        DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
        DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
      )
      //->where($tbl_evento->getColunaAlias('tipo_evento_id'),'=',5)
      ->orderBy($tbl_beneficio->getModelEntity()->getColunaAlias('id'),'asc')
      ->get()->toArray();

      $data = [];
      for($i = 0; $i < count($dados); $i++){
      
        $data[$i] = array_merge($dados[$i],array("description_evento"=>$dados[$i]['cdn_event'].' - '.$dados[$i]['des_event']));
        $data[$i] = array_merge($data[$i],array("description_cta"=>$data[$i]['cod_cta_ctbl'].' - '.$data[$i]['desc_cta_ctbl']));
        $data[$i] = array_merge($data[$i],array("description"=>$data[$i]['cod_cta_ctbl'].' - '.$data[$i]['desc_cta_ctbl'].' - '.$dados[$i]['cdn_event'].' - '.$data[$i]['des_event']));
        $data[$i] = array_merge($data[$i],array("description_natureza"=>$data[$i]['cod_cta_ctbl'].' - '.$data[$i]['desc_cta_ctbl']));

        $data[$i]['valor_deducao_'] = $data[$i]['valor_deducao'] == null ? '0,00' : number_format($data[$i]['valor_deducao'],6,',','.');
        $data[$i]['valor_deducao_'] = formataMonetarioQuatro($data[$i]['valor_deducao_']);
        
        $data[$i]['vlr_movto_'] = $data[$i]['vlr_movto'] == null ? '0,00' : number_format($data[$i]['vlr_movto'],6,',','.');
        
        $data[$i]['vlr_movto_'] = formataMonetarioQuatro($data[$i]['vlr_movto_']);
        $data[$i]['vlr_maximo_'] = $data[$i]['vlr_maximo'] == null ? '0,00' : number_format($data[$i]['vlr_maximo'],6,',','.');
        
        $data[$i]['vlr_maximo_'] = formataMonetarioQuatro($data[$i]['vlr_maximo_']);
        $data[$i]['salario_corte_'] = $data[$i]['salario_corte'] == null ? '0,00' : number_format($data[$i]['salario_corte'],2,',','.');
        
      }
      return $data;
    }
    public function listarBeneficio(){
      $dados=null;
      $evento = new RepoEventos();
      $data=$evento->listarEventos();
      $y=0;
      for($i=0;$i<count($data);$i++){
        if($data[$i]['tipo_evento_id']=='5'){
          $dados[$y]=$data[$i];
          $y=$y+1;
        }
      }
      return $dados;
    }
    public function inserir($dados){
      
      $select = $this->getModelEntity()->select()->where([
        [$this->getModelEntity()->getColunaAlias('evento_id'),'=',$dados['evento_id']],
        [$this->getModelEntity()->getColunaAlias('cta_ct_id'),'=',$dados['cta_ct_id']],
        
      ])->get()->toArray();

      if(count($select)>0){
        $this->setError('Registro já existente.<br>Erro: 050520201544');
        return false;
      }
      $inserir = $this->create($dados);

      if(!$inserir){
        $this->setError('Falha ao inserir registro.<br>Erro: 050520201550');
        return false;
      }
      return true;
    }
    public function deletar($data){
      
      //Define o máximo de orçamentos que serão exibidos caso esse benefício esteja em uso
      $qtd_orcamentos_existentes_show = 5;
      $tbl_orc_beneficio = new OrcBeneficio();
      $tbl_orcamento = new Orcamento();
      
      $select = $this->getModelEntity()
      ->leftJoin($tbl_orc_beneficio->getTable(), $this->getModelEntity()->getColunaAlias('id'), $tbl_orc_beneficio->getColunaAlias('beneficio_id'))
      ->leftJoin($tbl_orcamento->getTable(), $tbl_orc_beneficio->getColunaAlias('orcamento_id'), $tbl_orcamento->getColunaAlias('id'))

      ->select(
        $this->getModelEntity()->getColunaAlias('id'),
        DB::raw("{$tbl_orc_beneficio->getColunaAlias('id')} as orc_beneficio_id"),
        $tbl_orcamento->getColunaAlias('status_orc'),
        $tbl_orcamento->getColunaAlias('descricao_orc'),
        $tbl_orcamento->getColunaAlias('ano')
        
      )
      ->where([
        [$tbl_orc_beneficio->getColunaAlias('beneficio_id'),'=',$data['id']],
        [$tbl_orcamento->getColunaAlias('status_orc'),'<>',12]
      ])
      ->get()->toArray();

        
        if(count($select) > 0){
          $erro = count($select) == 1 ? 'Esse benefício não pode ser excluído pois está sendo utilizado no orçamento ' . $select[0]['descricao_orc'] . ' - ' . $select[0]['ano'] : 'Esse benefício não pode ser excluído pois está sendo utilizado nos orçamentos: <br>';

          if(count($select) > 1){
            for ($i=0; $i < count($select); $i++) { 
              if($qtd_orcamentos_existentes_show == 0){
                $erro = 'Esse benefício não pode ser excluído pois já está sendo utilizado em algum orçamento.';
                break;
              }
              $erro = $erro . $select[$i]['descricao_orc'] . ' - ' . $select[$i]['ano'] . '<br>';
              if($i == $qtd_orcamentos_existentes_show - 1){
                $erro = $erro . ' E outros ' . (count($select) - $qtd_orcamentos_existentes_show);
                break;
              }
            }{
            }
          }


          $this->setError($erro);
          return false;
        }
        $deletar = $this->delete($data['id']);
        if(!$deletar){
          $this->setError('Falha ao deletar registro');
          return false;
        }
        return true;
    }
}

