<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Beneficio;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoBeneficioLotacaoCargo extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\BeneficioLotacaoCargo';

    protected $form_rules=[];

    protected $rules_msg=[];

    public function listarToCadAut($orc_id){

        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_lotacao = new Lotacao();
        $tbl_beneficio = new Beneficio();
        $tbl_orc_beneficio = new OrcBeneficio();
        $tbl_cargo = new Cargo();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_evento = new Eventos();

        $select = $this->getModelEntity()
        
        ->join($tbl_orc_lotacao->getTable(), $this->getModelEntity()->getColunaAlias('lotacao_id'), $tbl_orc_lotacao->getColunaAlias('lotacao_id'))

        ->join($tbl_beneficio->getTable(), $this->getModelEntity()->getColunaAlias('beneficio_id'), $tbl_beneficio->getColunaAlias('id'))

        ->join($tbl_evento->getTable(), $tbl_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))

        ->join($tbl_orc_beneficio->getTable(), $this->getModelEntity()->getColunaAlias('beneficio_id'), $tbl_orc_beneficio->getColunaAlias('beneficio_id'))

        ->join($tbl_orc_cargo->getTable(), $this->getModelEntity()->getColunaAlias('cargo_id'), $tbl_orc_cargo->getColunaAlias('cargo_id'))

        ->select(
            DB::raw("{$tbl_orc_lotacao->getColunaAlias('id')} as orc_lotacao_id"),
            DB::raw("{$tbl_orc_cargo->getColunaAlias('id')} as orc_cargo_id"),
            DB::raw("{$tbl_orc_lotacao->getColunaAlias('cc_custo_id')} as ccusto_id"),
            DB::raw("{$tbl_orc_beneficio->getColunaAlias('id')} as orc_beneficio_id"),
            $this->getModelEntity()->getColunaAlias('lotacao_id'),
            $tbl_evento->getColunaAlias('multiplica'),
            $tbl_beneficio->getColunaAlias('tipo_calc'),
            $tbl_beneficio->getColunaAlias('vlr_movto'),
            $tbl_beneficio->getColunaAlias('formula'),
            $tbl_beneficio->getColunaAlias('empresa_id'),
            $tbl_beneficio->getColunaAlias('cta_ct_id'),
            $tbl_beneficio->getColunaAlias('vlr_maximo'),
            $tbl_beneficio->getColunaAlias('ativo')

        )->where([
            [$tbl_orc_beneficio->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_orc_cargo->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_orc_lotacao->getColunaAlias('orcamento_id'),'=',$orc_id]
        ])
        //->toSql();
        ->get()
        ->toArray();
        
        return $select;
    }
}