<?php

namespace App\Modules\Natureza51\Repositories;
use App\modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\CadastroParametros;
use App\Modules\Natureza51\Entities\OrcParametros;
use App\Modules\Natureza51\Entities\ParametrosOptions;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Facades\DB;

class RepoCadastroParametros extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\CadastroParametros';
	protected $form_rules=[ 
		'cod_parametro'     => 'required|max:50',
		'descricao'         => 'required|max:300',
		'valor_default'     => 'required|max:500', 
		'tipo_dados'		=> 'required|integer|min:1',
		'tipo_parametro'    => 'required|integer|min:1',  
		// 'tipo_dados'		=> 'required|min:1',
		// 'tipo_parametro'    => 'required|min:1',                          
		// 'tipo_resposta'     => 'required|integer|min:1|max:3',
		// 'dica'              => 'max:250'
		// 'tipo_parametro'    => 'required|integer|min:1|max:4', 
	];

	protected $rules_msg=[ 
		'cod_parametro.required'    	=> 'O campo Código é obrigatório!',
		'cod_parametro.max'    		=> 'O campo Código deve possuir no máximo 50 caracteres!',
		'descricao.required'      	=> 'O campo Descrição é obrigatório!',   
		'descricao.max'      		=> 'O campo Descrição deve possuir no máximo 300 caracteres!',
		'valor_default.required'    => 'O campo Valor Padrão é obrigatório!',   
		'valor_default.max'         => 'O campo Valor Padrão deve possuir no máximo 500 caracteres!',
		'tipo_dados.required'       => 'O campo Tipo de dados é obrigatório!', 
		'tipo_dados.integer'     	=> 'O campo Tipo de dados deve ser um inteiro!', 
		'tipo_dados.min'          	=> 'O campo Tipo de dados deve ser um inteiro maior que 1!',  
		'tipo_parametro.required'   => 'O campo Tipo do parâmetro é obrigatório!', 
		'tipo_parametro.integer'    => 'O campo Tipo do parâmetro deve ser um inteiro!', 
		'tipo_parametro.min'        => 'O campo Tipo do parâmetro deve ser um inteiro maior que 1!', 
		
		// 'tipo_resposta.integer'          => 'O campo Tipo da resposta deve ser um inteiro!', 
		// 'tipo_resposta.required'     => 'O campo Tipo da resposta é obrigatório!', 
		// 'dica.max'                   	=> 'O campo Dica deve possuir no máximo 250 caracteres!'
		// 'tipo_parametro.required'        => 'O campo Tipo do parâmetro é obrigatório!', 
		// 'tipo_parametro.max'         => 'O campo Tipo do parâmetro deve ser um inteiro menor que 4!', 

	];


	public function listarParametros (){
		$parametrosOptions = new ParametrosOptions;
		$tbl_usuario = new Usuario();
		
		$tableOptions = $parametrosOptions->getTable();
		$data = $this->getModelEntity()
		->with([
			'getParametrosOptions'=>function($query){

			}
		])
		->join('tblg_param_tipo',$this->getModelEntity()->getTable().'.tipo_parametro', '=', 'tblg_param_tipo.id')
		->join('tblg_param_tipo_dados',$this->getModelEntity()->getTable().'.tipo_dados', '=', 'tblg_param_tipo_dados.id')
		->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
         )
         ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
         )
		->select('tblg_parametros.*','tblg_param_tipo.tipo as Parametro','tblg_param_tipo_dados.descricao as Dados',
			DB::raw("CASE WHEN tblg_parametros.created_at IS NOT NULL THEN format(tblg_parametros.created_at, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
			DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

			DB::raw("CASE WHEN tblg_parametros.updated_at IS NOT NULL THEN format(tblg_parametros.updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
			DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
		)
		->get();
		
		return $this->tratarOptions($data);
	}

	public function tratarOptions($data){
        $retorno = [];
			foreach ($data as $param) {
					$lista = [];
					foreach ($param['getParametrosOptions'] as $option) {                        
						array_push($lista,$option['opcao']);
                    }			
                    $param['lista']	= implode(';', $lista);
                    unset($param['getParametrosOptions']);

                    if($param['tipo_dados'] == 8){
                        $param['valor_default'] = $param['valor_default'] == 1 ? true : false;
                    }

                    array_push($retorno,$param);
            }            
        return $retorno;
	}

	public function listarParametrosbyTipo($tipo){
		$data = $this->getModelEntity()
		->with([
			'getParametrosOptions'=>function($query){

			}
		])
		->join('tblg_param_tipo',$this->getModelEntity()->getTable().'.tipo_parametro', '=', 'tblg_param_tipo.id')
		->join('tblg_param_tipo_dados',$this->getModelEntity()->getTable().'.tipo_dados', '=', 'tblg_param_tipo_dados.id')
		->select('tblg_parametros.*','tblg_param_tipo.tipo as Parametro','tblg_param_tipo_dados.descricao as Dados')
		->where('tipo_parametro', $tipo)
		->get();
		return $this->tratarOptions($data);
	}

	public function salvarParametros($parametros){
		$table = $this->getModelEntity()->getTable();

		$cases = [];
		$ids = [];
		$params = [];
		unset($parametros['_token']);

		foreach ($parametros as $tipo) {
			foreach ($tipo['parametros'] as $parametro) {

				if($parametro['tipo_dados'] == 8){					
					$parametro['valor_default'] = $parametro['valor_default'] == true ? 1 : 0;
				}

				$id = (int) $parametro['id'];
				$cases[] = "WHEN {$id} then '".$parametro['valor_default']."'";
				$params[] = $parametro['valor_default'];
				$ids[] = $id;
			}
		}

		$ids = implode(',', $ids);
		$cases = implode(' ', $cases);
		return DB::update("UPDATE {$table} SET valor_default = CASE id {$cases} END WHERE id in ({$ids})", $params);
	}

	public function saveLista($data){
		$deletedRows = ParametrosOptions::where('parametro_id', $data['id'])->delete();
		$options = explode(';',$data['lista']);
		$data_insert = [];
		// dd($data);
		$cod_opcao = 0;
		foreach ($options as $option) {
			$data_aux = [
				'opcao'=>$option,
				'parametro_id'=>$data['id'],
				'cod_opcao'=>$cod_opcao
			];
			array_push($data_insert, $data_aux);
			$cod_opcao++;
		}
		$result = ParametrosOptions::insert($data_insert);
		if(!$result){
			// $this->setError()
			return false;
		}

		return true;
		
	}

	
	#Override
	public function create(array $data) {
		if($data['tipo_dados'] != 10){
			$insert = parent::create($data);
			if($insert){
				return $this->insereEmOrc($data, $insert->id);
			}
        	return $insert;
		}
		else{
			$result = parent::create($data);
			if(!$result){
				return false;
			}
			else{
				$this->insereEmOrc($data, $result->id);
				$data['id'] = $result->id;
				return $this->saveLista($data);
			}
		}
	}

	#Override
    public function update(array $data, $id, $attribute="id") {
		if($data['tipo_dados'] != 10){
        	return parent::update($data, $id, $attribute);
		}
		if(!parent::update($data, $id, $attribute)){
			return false;
		}
		return $this->saveLista($data);

    }

	public function insereEmOrc($data, $id){
		// listo todos os orcs
		// coloco em cada um
		// podemos ver se existe antes
		// usar valor padrão
		if($data['tipo_parametro'] != 1){
			return true;
		}
		$orc_param = new RepoOrcParametros();
		$orcs = DB::select("SELECT id from tbl_orcamento where status_orc != 12");
		
		foreach($orcs as $value){
			
			$existe = $orc_param->getModelEntity()->select()->where([
				['parametro_id', '=', $id],
				['orcamento_id', '=', $value->id]
			])->get()->toArray();

			if(count($existe) == 0){
				$dados = array('parametro_id'=>$id, 'orcamento_id'=>$value->id, 'valor_parametro'=>$data['valor_default'], 'user_id'=>$this->fillCriadoPor(), 'empresa_id'=>$this->fillCodEmpresa(), 'created_at'=>$this->fillCriadoEm(), 'created_by'=>$this->fillCriadoPor());

				try{
					$insert = $orc_param->create($dados);
					if(!$insert){
						return false;
					}
				}
				catch(\Exception $e){
					dd($e->getMessage());
					return false;
				}
			}
		}
		return true;
	}
}
