<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Cargo;
use DB;
use Carbon\Carbon;
class RepoCargo extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Cargo'; 
    protected $form_rules=[
                           
                           'cod_cargo_basic'=>'required | unique:tbl_cargo,cod_cargo_basic',
                           'des_cargo_basic'=>'required|string|max:40|min:1',
                           'salario'=>'required',
                          //  'salario_medio'=>'required', 
                           'salario_min'=>'required', 
                           'salario_max'=>'required'

                         ];
    protected $rules_msg=[
                          'des_cargo_basic.required'=>'O campo Descrição Cargo é obrigatório',
                          'des_cargo_basic.max'=>'O campo nome aceita até 40 caracteres',
                          'cod_cargo_basic.required'=>'O campo Código Cargo é obrigatório',
                          'cod_cargo_basic.unique'=>'Cód. Cargo já cadastrado',
                          'salario.required'=>'O campo nome é obrigatório',
                          'salario_medio.required'=>'O campo salário médio é obrigatório',
                          'salario_min.required'=>'O campo salário médio é obrigatório', 
                          'salario_max.required'=>'O campo salário máximo é obrigatório'
                        ];  

  public function getCargoByGrade($grades){

    return Cargo::select(DB::raw('LEFT(cod_cargo_basic, 2) as grade_salarial, id+null as parent'),'cod_cargo_basic','des_cargo_basic','salario','id')->where(function ($query) use($grades) {
      for ($i = 0; $i < count($grades)-1; $i++){
         $query->orwhere('cod_cargo_basic', 'like',  $grades[$i].'%');
      }      
    })->get()->toArray();
  } 
  public function listarCargos(){
    $data = $this->getModelEntity()->select()->get()->toArray();
    for($i = 0; $i < count($data); $i++){
      $data[$i]['ponto'] = number_format($data[$i]['ponto'], 0, '', '.');
      $data[$i]['nivel'] = number_format($data[$i]['nivel'], 0, '', '.');
      $dados[$i]=array_merge($data[$i],array(
          "description"=>$data[$i]['cod_cargo_basic'].' - '.$data[$i]['des_cargo_basic'],
          "salario_medio_format"=> formataMonetarioQuatro(number_format($data[$i]['salario'], 4, ',', '.')),//number_format($data[$i]['salario'], 4, ',', '.'),
          "salario_inicial_format"=> number_format($data[$i]['salario_min'], 2, ',', '.'),
          "salario_final_format"=> number_format($data[$i]['salario_max'], 2, ',', '.'),
          "nivel_format"=> number_format($data[$i]['nivel'], 0, '', '.'),
          "ponto_format"=> number_format($data[$i]['ponto'], 0, '', '.'), 
          "data_salario_format"=> Carbon::parse($data[$i]['data_salario'])->format('d/m/Y'),
          "salario_"=>number_format($data[$i]['salario'],2,',','.'),
          
        ));



      // "created_by_nome" => 'created_by' != null ? $this->getNomeByUsuario($record['created_by']): ' - ',
      // "updated_by_nome" = 'updated_by' != null ? $this->getNomeByUsuario($record['updated_by']): ' - ',
      // "description_created_at" = 'created_at' != null ? $this->formataData($record, 'created_at') : '-',
      // "description_updated_at" = 'updated_at' != null ? $this->formataData($record, 'updated_at') : '-',
     
      // unset($dados[$i]['created_at']);
      // unset($dados[$i]['created_by']);
      // unset($dados[$i]['updated_at']);
      // unset($dados[$i]['updated_by']);
      // unset($dados[$i]['user_id']);
      // unset($dados[$i]['cod_cargo_erp']);
      // unset($dados[$i]['empresa_id']);
    }
    return $dados;
  }
  public function update(array $data,$id,$attribute="id"){

    $this->form_rules['cod_cargo_basic'].=','.$id;
    return parent::update($data,$id,$attribute);

  }


  public function formataData($array, $label){
    $data = $array[$label];
    $ano = substr($data, 0, 4);
    $meses = substr($data, 5, 2);
    $dia = substr($data, 8, 2);
    $data = $dia.'/'.$meses.'/'.$ano;
    return $data;
}   


  

}
