<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoCcustoLotacao extends RepositoryNat51{
    protected $model_name_space='App\Modules\Natureza51\Entities\CcustoLotacao';
    protected $form_rules=[
        'lotacao_id'=>'required',
        'ccusto_id'=>'required'
    ];
    protected $rules_msg=[
        'lotacao_id.required'=>'O campo Lotação é obrigatório',
        'ccusto_id.required'=>'O campo C. Custo é obrigatório'
    ];
    public function listar(){
        $a = $this->allWith([
            'getLotacao'=>function($query){},
            'getCcusto'=>function($query){}
        ])
        ->toArray();
        
        for($i=0;$i<count($a);$i++){
            $a[$i]['des_unid_lotac']=$a[$i]['get_lotacao']['unid_lotac']. ' - ' .$a[$i]['get_lotacao']['des_unid_lotac'];
            $a[$i]['des_ccusto']=$a[$i]['get_ccusto']['cod_ccusto']. ' - ' .$a[$i]['get_ccusto']['des_ccusto'];
            // $a[$i]['created_by_nome'] = $a[$i]['created_by'] != null ? $this->getNomeByUsuario($a[$i]['created_by']): ' - ';
            // $a[$i]['updated_by_nome'] = $a[$i]['updated_by'] != null ? $this->getNomeByUsuario($a[$i]['updated_by']): ' - ';
            $a[$i]['description_created_at'] = $a[$i]['created_at'] != null ? $this->formataData($a[$i], 'created_at') : '-';
            $a[$i]['description_updated_at'] = $a[$i]['updated_at'] != null ? $this->formataData($a[$i], 'updated_at') : '-';
    
            // dd($a[$i]['des_ccusto'], $a[$i]['get_ccusto']);

            unset($a[$i]['get_lotacao']);
            unset($a[$i]['get_ccusto']); 
        }
    // dd("paaaaaaaaaaaaaaaaa", $a);
        return $a;
    }
    public function inserirCcustoLotacao($dados){ 
        
        unset($dados['campos_old']);
        
        $select = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$dados['lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$dados['ccusto_id']],
            [$this->getModelEntity()->getColunaAlias('estrutura_plano_lotac_id'),'=',$dados['estrutura_plano_lotac_id']]
        ])->get()->toArray();

        if(count($select) > 0){
            $this->setError('Registro já existente.<br>Erro: 270520201124');
            return false;
        }else{
            $inserir = $this->create($dados);
            if(!$inserir){
                $this->setError('Falha ao inserir registro.<br>Erro: 270520201125');
                return false;
            }
            return true;
        }
    }
    public function updateCcustoLotacao($dados){
        
        if( ($dados['lotacao_id'] == $dados['campos_old']['lotacao_id_old']) && ($dados['ccusto_id'] == $dados['campos_old']['ccusto_id_old']) ){
            if(( $dados['estrutura_plano_lotac_id'] === true && $dados['estrutura_plano_lotac_id'] == $dados['campos_old']['estrutura_plano_lotac_id_old'] )){
                unset($dados['campos_old']);
                $update_old = $this->update($dados, $dados['id']);
                if(!$update_old){
                    $this->setError('Falha ao atulizar registro.<br>Erro: 270520201156');
                    return false;
                }
            }
            else{
                unset($dados['campos_old']);
                $update_old = $this->update($dados, $dados['id']);
                if(!$update_old){
                    $this->setError('Falha ao atulizar registro.<br>Erro: 270520201435');
                    return false;
                }
            }
            
            return true;
        }else{
            $select = $this->getModelEntity()->select()->where([
                [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$dados['lotacao_id']],
                [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$dados['ccusto_id']],
                [$this->getModelEntity()->getColunaAlias('estrutura_plano_lotac_id'),'=',$dados['estrutura_plano_lotac_id']]
            ])->get()->toArray();

            if(count($select) > 0){
                $this->setError('Registro já existente.<br>Erro: 27052020153');
                return false;
            }
            else{
                $update = $this->update($dados,$dados['id']);
                if(!$update){
                    $this->setError('Falha ao atualizar registro.<br>Erro: 27052020155');
                    return false;
                }
                return true;
            }
        }
    }


     public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }


}