<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use Illuminate\Support\Facades\DB;

class RepoConsultasOrcamento extends RepoOrcamento
{
    use \App\Core\Traits\ParamTrait;
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';

    public function __construct(){
        parent::__construct();
    }

    public function listarOrc(){
        $data_user = $this->getUserFromCurrentGuard();
        
        $orc = new Orcamento();
        $select = $orc->select()->where([
            [$orc->getColunaAlias('status_orc'), '!=', 12]

            ])->orderBy('id','DESC');
        
        if ($data_user->tipo != 3) {
            $select->where([                
                ['mostrar_orcamento', '=', 0]
            ]);
        }       
        
        return $select->get()->toArray();
    }
}