<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoContaContabil extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\ContaContabil';
    protected $form_rules=[
              
              'cod_cta_ctbl'=>'required|unique:tbl_cta_contabil,cod_cta_ctbl',
              'desc_cta_ctbl'=>'required',
              'tipo_des'=>'required',
              'ccusto'=>'required',
              
    ];

     protected $rules_msg=[            
              
              'cod_cta_ctbl.required'=>'O campo código conta contábil é obrigatório',
              'cod_cta_ctbl.unique'=>'Cod. Conta já foi cadastrado',
              'desc_cta_ctbl.required'=>'O campo descrição conta contabil é obrigatório',
              'tipo_des.required'=>'O campo tipo descrição é obrigatório',
              'ccusto.required'=>'O campo centro de custo é obrigatório'
              
      ]; 
      
      public function update(array $data,$id,$attribute="id"){

        $this->form_rules['cod_cta_ctbl'].=','.$id;
        return parent::update($data,$id,$attribute);
                      
    }
    public function listarAll(){

        $tbl_usuario = new Usuario();
        // $select = $this->getModelEntity()->select()->where($this->getModelEntity()->getColunaAlias('cod_cta_ctbl'),'like','51%')
        // ->orderBy($this->getModelEntity()->getColunaAlias('sequencia_execucao'),'asc')
        // ->get()->toArray();
        $entity = $this->getModelEntity();

        $select = $this->getModelEntity()
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $this->getModelEntity()->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )
            ->select(
                $entity->getColunaAlias('id'),
                $entity->getColunaAlias('empresa_id'),
                $entity->getColunaAlias('cod_cta_ctbl'),
                $entity->getColunaAlias('desc_cta_ctbl'),
                $entity->getColunaAlias('tipo_des'),
                $entity->getColunaAlias('ccusto'),
                $entity->getColunaAlias('origem'),
                $entity->getColunaAlias('sequencia_execucao'),
                
                DB::raw("CONCAT({$entity->getColunaAlias('cod_cta_ctbl')}, ' - ', {$entity->getColunaAlias('desc_cta_ctbl')}) as description"),

                DB::raw("IIF(tipo_des = 1, 'Sim', 'Não') as desc_tipo_des"),
                DB::raw("IIF(ccusto = 1, 'Sim', 'Não') as desc_ccusto"),

                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
                DB::raw("CASE WHEN {$entity->getColunaAlias('created_at')} IS NOT NULL THEN format({$entity->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
                DB::raw("CASE WHEN {$entity->getColunaAlias('updated_at')} IS NOT NULL THEN format({$entity->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),

                DB::raw("CASE WHEN {$entity->getColunaAlias('origem')} = 1 THEN 'Sistema'
                WHEN {$entity->getColunaAlias('origem')} = 0 THEN 'ERP' ELSE '-' END as origem_des")
            )
            ->where($this->getModelEntity()->getColunaAlias('cod_cta_ctbl'),'like','51%')
            ->orderBy($this->getModelEntity()->getColunaAlias('sequencia_execucao'),'asc')
        ->get()->toArray();

        //$dados = [];

        /*for($i = 0; $i < count($select); $i++){
            $dados[$i]=array_merge($select[$i],array("description"=>$select[$i]['cod_cta_ctbl'].' - '.$select[$i]['desc_cta_ctbl']));
            $dados[$i]['desc_tipo_des'] = $dados[$i]['tipo_des']==1 ? 'Sim' : 'Não';
            $dados[$i]['desc_ccusto'] = $dados[$i]['ccusto']==1 ? 'Sim' : 'Não';
            // $dados[$i]['created_by_nome'] =  $dados[$i]['created_by'] != null ? $this->getNomeByUsuario($dados[$i]['created_by']): ' - ';
            // $dados[$i]['updated_by_nome'] =  $dados[$i]['updated_by'] != null ? $this->getNomeByUsuario($dados[$i]['updated_by']): ' - ';
            // $dados[$i]['description_created_at'] =  $dados[$i]['created_at'] != null ? $this->formataData($dados[$i]['created_at']) : '-';
            // $dados[$i]['description_updated_at'] =  $dados[$i]['updated_at'] != null ? $this->formataData($dados[$i]['updated_at']) : '-';
            // unset($dados[$i]['created_at']);
            // unset($dados[$i]['created_by']);
            // unset($dados[$i]['updated_at']);
            // unset($dados[$i]['updated_by']);
            // unset($dados[$i]['user_id']);
        }*/

        return $select;
    }
    public function listarOrderBy(){
        $select = $this->getModelEntity()->select()->where($this->getModelEntity()->getColunaAlias('cod_cta_ctbl'),'like','51%')
        ->orderBy($this->getModelEntity()->getColunaAlias('sequencia_execucao'),'asc')
        ->get()->toArray();
        
        for($i = 0; $i < count($select); $i++){
            $select[$i] = array_merge($select[$i],array("description" => $select[$i]['cod_cta_ctbl'].' - '.$select[$i]['desc_cta_ctbl']));
            $select[$i]['desc_tipo_des'] = $select[$i]['tipo_des']==1 ? 'Sim' : 'Não';
            $select[$i]['desc_ccusto'] = $select[$i]['ccusto']==1 ? 'Sim' : 'Não';
            $select[$i]['sequencia_execucao'] = $select[$i]['sequencia_execucao'] == null ? 0 : $select[$i]['sequencia_execucao'];
        }

        return $select;
    }
    public function inserirSequenciaExecucao($dados){
        unset($dados['_token']);
        
        for($i = 0; $i < count($dados); $i++){
            
            unset($dados[$i]['desc_tipo_des']);
            unset($dados[$i]['description']);
            unset($dados[$i]['desc_ccusto']);
            $data = $dados[$i];
            unset($dados[$i]['id']);
            $sequencia = Arr::only($dados[$i],'sequencia_execucao');
            $update = $this->getModelEntity()->where('id',$data['id'])->update($sequencia);
            if(!$update){
                $this->setError("Falha ao inserir a sêquencia de numero ".($i+1));
                return false;
                
            }
        }
        return true;
    }

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
}
