<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\DefinirSenha;
use Illuminate\Validation\Rule;
use Illuminate\Contracts\Validation\Factory;
use Illuminate\Http\Request;
use Illuminate\Validation\Validator;

use Carbon\Carbon;
use DB;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;

class RepoDefinirSenha extends RepositoryNat51
{
    use \App\Core\Traits\ParamTrait;

    protected $model_name_space='App\Modules\Natureza51\Entities\DefinirSenha';
    protected $form_rules=[
        'email'=>'required',
        'hash'=>'required',
        'data_vencimento'=>'required',
        'created_at'=>'required',
        'senha_definida'=>'required'
    ];

    protected $rules_msg=[
        'email.required'=>'O campo Email é obrigatório',
        'hash.required'=>'O campo hash é obrigatório',
        'data_vencimento.required'=>'O campo data vencimento é obrigatório',
        'created_at.required'=>'O campo created at é obrigatório',
        'senha_definida.required'=>'O campo senha definida é obrigatório'
    ];
    
    public function enviarEmailDefinirSenha($dados){
        $hash = md5($dados->email.date('dmYHisu'));
        $base_link = $this->getParamValue($this->getCodLinkDefinirSenha());
        
        $email_md5 = base64_encode($dados->email);

        $link = $base_link.'/'.$hash;

        $data_create=[
            'email' => $dados->email,
            'hash' => $hash,
            'data_vencimento' =>Carbon::now()->addHours(4)->format('ymd H:i:s'),
            'senha_definida' => 0
        ];

        $create = $this->create($data_create);

        if(!$create){
            return $create;
        }

        $repoEnviarEmail = new RepoEnviarEmail();
        $repoEnviarEmail->definirSenha($link, $dados->nome, $dados->email);

        return true;
    }

    public function updateSituacao($newSituacao, $email){
		$atualizar = DB::update("update tbl_definir_senha set senha_definida = ? where email = ?", [$newSituacao, $email]);
		return is_numeric($atualizar) ? true : false ;
    }

}