<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Despesas;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Validation\Rule;
use Illuminate\Contracts\Validation\Factory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\Validator;

class RepoDespesas extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Despesas';
    protected $form_rules=[
        'origem_despesa'=>'required',
        'descricao'=>'required',
        'valor_referencia'=>'required',
        // 'evento_id'=>'unique:tbl_despesas,evento_id',
        // 'cta_contabil_id'=>'unique:tbl_despesas,cta_contabil_id' 
    ];
    protected $rules_msg=[
        'origem_despesa.required'=>'O campo Origem Despesa é obrigatório',
        'origem_despesa.unique'=>'Ja cadastrado',
        'descricao.required'=>'O campo Descrição é obrigatório',
        'valor_referencia'=>'O campo Valor de Referencia é obrigatório',

    ];
    public function listar(){
        // $a=$this->allWith([
        //     'getContaContabil'=>function($query){

        //     },
        //     'getEvento'=>function($query){

        //     },
        // ])->toArray();

        $tbl_usuario = new Usuario();
        $tbl_ctactb = new ContaContabil();
        $tbl_evento = new Eventos();
        $entity = $this->getModelEntity();

        $a = $this->getModelEntity()
            ->leftJoin($tbl_ctactb->getTable(), $entity->getColunaAlias('cta_contabil_id'), $tbl_ctactb->getColunaAlias('id'))
            ->leftJoin($tbl_evento->getTable(), $entity->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
             )
             ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $this->getModelEntity()->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
             )
        ->select(
            $entity->getColunaAlias('id'),
            $entity->getColunaAlias('origem_despesa'),
            $entity->getColunaAlias('cta_contabil_id'),
            $entity->getColunaAlias('evento_id'),
            $entity->getColunaAlias('descricao'),
            DB::raw("format({$entity->getColunaAlias('valor_referencia')}, 'g', 'de-de') as valor_referencia"),
            $entity->getColunaAlias('empresa_id'),
            
            $tbl_ctactb->getColunaAlias('desc_cta_ctbl'),
            $tbl_ctactb->getColunaAlias('cod_cta_ctbl'),
            DB::raw("CONCAT({$tbl_ctactb->getColunaAlias('cod_cta_ctbl')}, ' - ', {$tbl_ctactb->getColunaAlias('desc_cta_ctbl')}) as des_cta_ctb"),
            DB::raw("CONCAT({$tbl_ctactb->getColunaAlias('cod_cta_ctbl')}, ' - ', {$tbl_ctactb->getColunaAlias('desc_cta_ctbl')}) as conta_contabil"),
            
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_evento->getColunaAlias('cdn_event'),
            DB::raw("CONCAT({$tbl_evento->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')}) as desc_evento"),
            DB::raw("CONCAT({$tbl_evento->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')}) as evento"),

            DB::raw("IIF({$entity->getColunaAlias('origem_despesa')} = 1, 'Evento', 'Conta Contábil') as des_origem_despesa"),
            
            DB::raw("CASE
                WHEN {$entity->getColunaAlias('evento_id')} IS NULL THEN CONCAT({$entity->getColunaAlias('descricao')}, ' - ', {$tbl_ctactb->getColunaAlias('cod_cta_ctbl')}, ' - ', {$tbl_ctactb->getColunaAlias('desc_cta_ctbl')})
                ELSE CONCAT({$entity->getColunaAlias('descricao')}, ' - ', {$tbl_ctactb->getColunaAlias('cod_cta_ctbl')}, ' - ', {$tbl_ctactb->getColunaAlias('desc_cta_ctbl')}, ' - ', {$tbl_evento->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')})
                END as description
            "),
                
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            $entity->getColunaAlias('created_by'),
            $entity->getColunaAlias('created_at'),
            $entity->getColunaAlias('updated_by'),
            $entity->getColunaAlias('updated_at'),

            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )->get()->toArray();
            
        // for($i=0; $i<count($a); $i++){
        //     $a[$i]['desc_cta_ctbl'] = $a[$i]['get_conta_contabil']['desc_cta_ctbl'];
        //     $a[$i]['cod_cta_ctbl'] = $a[$i]['get_conta_contabil']['cod_cta_ctbl'];
        //     $a[$i]['des_cta_ctb'] = $a[$i]['cod_cta_ctbl'].' - '.$a[$i]['get_conta_contabil']['desc_cta_ctbl'];

        //     $a[$i]['des_event']=$a[$i]['get_evento']['des_event'];
        //     $a[$i]['cdn_event']=$a[$i]['get_evento']['cdn_event'];
        //     $a[$i]['desc_evento'] = $a[$i]['cdn_event'].' - '.$a[$i]['get_evento']['des_event'];
        //     $a[$i]['conta_contabil']=$a[$i]['get_conta_contabil']['cod_cta_ctbl']. ' - '.$a[$i]['get_conta_contabil']['desc_cta_ctbl'];
        //     $a[$i]['evento']=$a[$i]['get_evento']['cdn_event']. ' - '.$a[$i]['get_evento']['des_event'];
        //     $a[$i]['valor_referencia'] = number_format($a[$i]['valor_referencia'],4,',','.');
        //     unset($a[$i]['get_conta_contabil']);
        //     unset($a[$i]['get_evento']);
        // }
        //$dados = [];
        // for($i = 0 ; $i < count($a); $i++){

        //     $a[$i]['des_origem_despesa'] = $a[$i]['origem_despesa'] == 1 ? 'Evento' : 'Conta contábil';

        //     // if($a[$i]['origem_despesa'] == 1){
        //     //     $dados[$i] = array_merge($a[$i],array("description"=>$a[$i]['descricao'].' - '.$a[$i]['des_event'].' - '.$a));
        //     // }else{
        //     //     $dados[$i] = array_merge($a[$i],array("description"=>$a[$i]['descricao'].' - '.$a[$i]['desc_cta_ctbl']));
        //     // }
        //     if(!$a[$i]['evento_id']){
        //         $dados[$i] = array_merge($a[$i],array("description"=>$a[$i]['descricao'].' - '. $a[$i]['conta_contabil']));
        //     }
        //     else{
        //         $dados[$i] = array_merge($a[$i],array("description"=>$a[$i]['descricao'].' - '. $a[$i]['conta_contabil']. ' - '.$a[$i]['evento']));
        //     }


        // } 
        
        /*
            "id" => 20 --
            "origem_despesa" => "1" --
            "cta_contabil_id" => "1232" --
            "evento_id" => "112" -- 
            "descricao" => "importar insti" --
            "valor_referencia" => "1.500,2500" --
            "created_at" => "2020-07-20 10:34:15.000"
            "user_id" => null
            "updated_at" => null
            "empresa_id" => "2" --
            "created_by" => "10030"
            "updated_by" => null
            "desc_cta_ctbl" => "PESSOAL" --
            "cod_cta_ctbl" => "51050000" --
            "des_cta_ctb" => "51050000 - PESSOAL" --
            "des_event" => "13 Adic Avos Trab eSocial" --
            "cdn_event" => "112" --
            "desc_evento" => "112 - 13 Adic Avos Trab eSocial" --
            "conta_contabil" => "51050000 - PESSOAL" --
            "evento" => "112 - 13 Adic Avos Trab eSocial" --
            "des_origem_despesa" => "Evento" --
            "description" => "importar insti - 51050000 - PESSOAL - 112 - 13 Adic Avos Trab eSocial"
        */
        return $a;
    } 
    public function insert(Request $request){
        $array=$request->all();
        $arrayValido=$this->validaUnique($array);

        if(!$arrayValido){
            $this->setError("Registro já cadastrado. Erro: 070220201138");
            return false;
        }

        return parent::create($array);
    }
    public function update(array $data, $id, $attribute = "id")
    {
        //$dadosValido=$this->validaUnique($data);
        monetarioVirgula($data['valor_referencia']);
        // if(!$dadosValido){
        //     $this->setError("Dados já existentes ou registro não foi alterado. erro: 070220201131");
        //     return false;
        // }
        try {
           $retorno = parent::update($data, $id, $attribute);
        } catch(\Exception $e){
            if($e->errorInfo[1] == 2601){
                $this->setError("O cadastro dessa despesa já existe. warning: 050120211728 ");
                return false;
            }
            $this->setError("O cadastro não pode ser atualizado. warning: 050120211731 ");

            return false;
        }
        return $retorno;
    }

    protected function validaUniqueUpdate($data){
        $despesas=$this->getModelEntity();
        $dados_enviar=$despesas->select($despesas->getColunaAlias('id'),$despesas->getColunaALias('origem_despesa'),$despesas->getColunaAlias('evento_id'),$despesas->getColunaAlias('cta_contabil_id'))
        ->where([
            ['origem_despesa','=',$data['origem_despesa']],
            ['evento_id','=',$data['evento_id']],
            ['cta_contabil_id','=',$data['cta_contabil_id']]
            ])
        ->get();
        if($dados_enviar->count()==0){
            return false;
        }
        return true;
    }
    protected function validaUnique($data){
        $despesas=$this->getModelEntity();
        $dados_enviar=$despesas->select($despesas->getColunaALias('origem_despesa'),$despesas->getColunaAlias('evento_id'),$despesas->getColunaAlias('cta_contabil_id'))
        ->where([
            ['origem_despesa','=',$data['origem_despesa']],
            ['evento_id','=',$data['evento_id']],
            ['cta_contabil_id','=',$data['cta_contabil_id']]
            ])
        ->get();
        
        // dd($dados_enviar);
        if($dados_enviar->count()==0){
            return true;
        }
        return false;
        
    }
}