<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Endereco;
use App\Modules\Natureza51\Entities\GrupoEmpresarial;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Exception;
use Illuminate\Support\Facades\DB;

class RepoEmpresa extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Empresa';
    protected $form_rules=[
        'grupo_empresarial_id'=>'required',
        'cdn_empresa'=>'required',
        'razao'=>'required',
        'cnpj'=>'required',
        'ie'=>'required',
        'tipo_pessoa'=>'required',
        'is_matriz_filial'=>'required',
        'email'=>'required'
    ];
    protected $rules_msg=[
        //'grupo_empresarial_id.unique'=>'O grupo empresarial selecionado já foi cadastrado',
        'grupo_empresarial_id.required'=>'O campo empresarial não pode estar vazio',
        'cdn_empresa.required'=>'O campo Cod. Empresa não pode estar vazio',
        'razao.required'=>'O campo Razão Social não pode estar vazio',
        'cnpj.required'=>'O campo CNPJ não pode estar vazio',
        'ie.required'=>'O campo IE não pode estar vazio',
        'tipo_pessoa.required'=>'O campo Tipo Pessoa não pode estar vazio',
        'is_matriz_filial.required'=>'O campo Tipo Filial não pode estar vazio',
        'email.required'=>'O campo E-mail não pode estar vazio'
    ];

    public function listarAll(){
        
        $tbl_empresa = $this->getModelEntity();
        $tbl_grupo_empresarial = new GrupoEmpresarial();
        $tbl_endereco = new Endereco();
        $tbl_usuario = new Usuario();
        
        $select = $tbl_empresa
        ->leftJoin($tbl_grupo_empresarial->getTable(), $tbl_empresa->getColunaAlias('grupo_empresarial_id'), $tbl_grupo_empresarial->getColunaAlias('id'))
        ->leftJoin($tbl_endereco->getTable(), $tbl_empresa->getColunaAlias('endereco_id'), $tbl_endereco->getColunaAlias('id'))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$tbl_empresa->getColunaAlias('created_by')}")
         )
         ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_empresa->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
         )
        ->select(
        $tbl_empresa->getColunaAlias('id'),
        $tbl_empresa->getColunaAlias('grupo_empresarial_id'),
        $tbl_empresa->getColunaAlias('endereco_id'),
        $tbl_grupo_empresarial->getColunaAlias('grupo'),
        $tbl_grupo_empresarial->getColunaAlias('descricao'),
        $tbl_empresa->getColunaAlias('cdn_empresa'),
        $tbl_empresa->getColunaAlias('razao'),
        $tbl_empresa->getColunaAlias('cnpj'),
        $tbl_empresa->getColunaAlias('ie'),
        $tbl_empresa->getColunaAlias('tipo_pessoa'),
        $tbl_empresa->getColunaAlias('is_matriz_filial'),
        $tbl_empresa->getColunaAlias('id_matriz'),
        $tbl_empresa->getColunaAlias('cod_estabel_erp'),
        $tbl_empresa->getColunaAlias('email'),
        DB::raw("{$tbl_empresa->getColunaAlias('id')} as value"),
        DB::raw("CONCAT({$tbl_grupo_empresarial->getColunaAlias('grupo')}, ' - ', {$tbl_grupo_empresarial->getColunaAlias('descricao')}) as label"),

        DB::raw("CASE WHEN {$tbl_empresa->getColunaAlias('created_at')} IS NOT NULL THEN format({$tbl_empresa->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
        DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

        DB::raw("CASE WHEN {$tbl_empresa->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_empresa->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
        DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->get()->toArray();
        
        $dados = [];

        for($i = 0; $i < count($select); $i++){
            $dados[$i] = array_merge($select[$i],array("grupo_empresarial"=>$select[$i]['grupo_empresarial_id'].' - '.$select[$i]['grupo'].' - '.$select[$i]['descricao']));
            $dados[$i] = array_merge($dados[$i],array("description"=>$select[$i]['razao'].' - '.add_mask_cnpj($select[$i]['cnpj'])));
        }
        
        return $dados;
    }
    public function inserir($data){
        $select = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('grupo_empresarial_id'),'=',$data['grupo_empresarial_id']],
            //[$this->getModelEntity()->getColunaAlias('endereco_id'),'=',$data['endereco_id']],
            [$this->getModelEntity()->getColunaAlias('cdn_empresa'),'=',$data['cdn_empresa']]
        
            ])->get()->toArray();

        if(count($select)>0){
            $this->setError('Empresa já existente. Erro:160420200944');
            return false;
        }
        else{
            // DB::beginTransaction();
            // try{
                $ult_id = $this->getModelEntity()->max($this->getModelEntity()->getColunaAlias('id'));
                $data['id_matriz'] = $ult_id;
                
                $resultado = $this->create($data);
                if(!$resultado){
                    $this->setError('Falha ao inserir registro.<br> Erro:170420201027');
                    return false;
                }   
                //dd($resultado->id);
                $data['id_matriz'] = $resultado->id;
                $data['updated_at'] = null;
                $data['updated_by'] = null;
                $update_id_matriz = $this->update($data,$resultado->id);

                if(!$update_id_matriz){
                    $this->setError('Falha ao inserir registro.<br> Erro:200420201130');
            //         DB::rollBack();
                    return false;
                }
            //     DB::commit();
            // }catch(Exception $e){
            //     DB::rollBack();
            // }
            
        } 
        return true;
    }
    
    public function updateEmpresa($data){
        // $select = $this->getModelEntity()->select()->where([
        //     [$this->getModelEntity()->getColunaAlias('grupo_empresarial_id'),'=',$data['grupo_empresarial_id']],
        //     //[$this->getModelEntity()->getColunaAlias('endereco_id'),'=',$data['endereco_id']],
        //     [$this->getModelEntity()->getColunaAlias('cdn_empresa'),'=',$data['cdn_empresa']],
        //     [$this->getModelEntity()->getColunaAlias('id_matriz'),'=',$data['id_matriz']]
        
        //     ])->get()->toArray();

            
        // if(count($select)>0){
        //     $this->setError('Registro já existente ou não foi alterado. Erro:160420200944');
        //     return false;
        // }
        // else{
            $resultado = $this->update($data,$data['id']);
            if(!$resultado){
                $this->setError('Falha ao atualizar registro.<br> Erro:170420201208');
                return false;
            }
            return true;
        // }
    }
    public function listarPorCnpj($cnpj){
        
        $id_like = substr($cnpj,0,5);
        
        $select = $this->getModelEntity()->where($this->getModelEntity()->getColunaAlias('cnpj'),'like',$id_like.'%')
        ->select()
        ->get()->toArray();

        $dados = [];
        for($i=0;$i<count($select);$i++){
            $dados[$i]=array_merge($select[$i],array("description"=>$select[$i]['razao'].' - '.add_mask_cnpj($select[$i]['cnpj'])));
        }

        return $dados;
    }
    // public function deleteEmpresa($data){
    //     $result = $this->delete($data['id']);
    //     if(!$result){
    //         $this->setError('Falha ao excluir registro. Erro:200420201217');
    //         return false;
    //     }
    //     return true;
    // }
}
